<?php

class CorrettoElatedSeparatorWidget extends CorrettoElatedWidget {
	public function __construct() {
		parent::__construct(
			'eltdf_separator_widget',
			esc_html__( 'Elated Separator Widget', 'corretto' ),
			array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'corretto' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'corretto' ),
				'options' => array(
					'normal'     => esc_html__( 'Normal', 'corretto' ),
					'full-width' => esc_html__( 'Full Width', 'corretto' )
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'position',
				'title'   => esc_html__( 'Position', 'corretto' ),
				'options' => array(
					'center' => esc_html__( 'Center', 'corretto' ),
					'left'   => esc_html__( 'Left', 'corretto' ),
					'right'  => esc_html__( 'Right', 'corretto' )
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'border_style',
				'title'   => esc_html__( 'Style', 'corretto' ),
				'options' => array(
					'solid'  => esc_html__( 'Solid', 'corretto' ),
					'dashed' => esc_html__( 'Dashed', 'corretto' ),
					'dotted' => esc_html__( 'Dotted', 'corretto' )
				)
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'corretto' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'width',
				'title' => esc_html__( 'Width (px or %)', 'corretto' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'thickness',
				'title' => esc_html__( 'Thickness (px)', 'corretto' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'top_margin',
				'title' => esc_html__( 'Top Margin (px or %)', 'corretto' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'bottom_margin',
				'title' => esc_html__( 'Bottom Margin (px or %)', 'corretto' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		//prepare variables
		$params = '';
		
		//is instance empty?
		if ( is_array( $instance ) && count( $instance ) ) {
			//generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}
		}
		
		echo '<div class="widget eltdf-separator-widget">';
			echo do_shortcode( "[eltdf_separator $params]" ); // XSS OK
		echo '</div>';
	}
}