<?php

if ( ! function_exists( 'corretto_elated_get_title_types_options' ) ) {
	function corretto_elated_get_title_types_options() {
		$title_type_options = apply_filters( 'corretto_elated_title_type_global_option', $title_type_options = array() );
		
		return $title_type_options;
	}
}

if ( ! function_exists( 'corretto_elated_get_title_type_default_options' ) ) {
	function corretto_elated_get_title_type_default_options() {
		$title_type_option = apply_filters( 'corretto_elated_default_title_type_global_option', $title_type_option = '' );
		
		return $title_type_option;
	}
}

foreach ( glob( ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/options-map/*.php' ) as $options_load ) {
	include_once $options_load;
}

if ( ! function_exists('corretto_elated_title_options_map') ) {
	function corretto_elated_title_options_map() {
		$title_type_options        = corretto_elated_get_title_types_options();
		$title_type_default_option = corretto_elated_get_title_type_default_options();

		corretto_elated_add_admin_page(
			array(
				'slug' => '_title_page',
				'title' => esc_html__('Title', 'corretto'),
				'icon' => 'fa fa-list-alt'
			)
		);

		$panel_title = corretto_elated_add_admin_panel(
			array(
				'page' => '_title_page',
				'name' => 'panel_title',
				'title' => esc_html__('Title Settings', 'corretto')
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'show_title_area',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Title Area', 'corretto' ),
				'description'   => esc_html__( 'This option will enable/disable Title Area', 'corretto' ),
				'parent'        => $panel_title
			)
		);
		
			$show_title_area_container = corretto_elated_add_admin_container(
				array(
					'parent'          => $panel_title,
					'name'            => 'show_title_area_container',
					'dependency' => array(
						'show' => array(
							'show_title_area' => 'yes'
						)
					)
				)
			);
		
				corretto_elated_add_admin_field(
					array(
						'name'          => 'title_area_type',
						'type'          => 'select',
						'default_value' => $title_type_default_option,
						'label'         => esc_html__( 'Title Area Type', 'corretto' ),
						'description'   => esc_html__( 'Choose title type', 'corretto' ),
						'parent'        => $show_title_area_container,
						'options'       => $title_type_options
					)
				);
		
					corretto_elated_add_admin_field(
						array(
							'name'          => 'title_area_in_grid',
							'type'          => 'yesno',
							'default_value' => 'yes',
							'label'         => esc_html__( 'Title Area In Grid', 'corretto' ),
							'description'   => esc_html__( 'Set title area content to be in grid', 'corretto' ),
							'parent'        => $show_title_area_container
						)
					);
		
					corretto_elated_add_admin_field(
						array(
							'name'        => 'title_area_height',
							'type'        => 'text',
							'label'       => esc_html__( 'Height', 'corretto' ),
							'description' => esc_html__( 'Set a height for Title Area', 'corretto' ),
							'parent'      => $show_title_area_container,
							'args'        => array(
								'col_width' => 2,
								'suffix'    => 'px'
							)
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'name'        => 'title_area_background_color',
							'type'        => 'color',
							'label'       => esc_html__( 'Background Color', 'corretto' ),
							'description' => esc_html__( 'Choose a background color for Title Area', 'corretto' ),
							'parent'      => $show_title_area_container
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'name'        => 'title_area_background_image',
							'type'        => 'image',
							'label'       => esc_html__( 'Background Image', 'corretto' ),
							'description' => esc_html__( 'Choose an Image for Title Area', 'corretto' ),
							'parent'      => $show_title_area_container
						)
					);
		
					corretto_elated_add_admin_field(
						array(
							'name'          => 'title_area_background_image_behavior',
							'type'          => 'select',
							'default_value' => '',
							'label'         => esc_html__( 'Background Image Behavior', 'corretto' ),
							'description'   => esc_html__( 'Choose title area background image behavior', 'corretto' ),
							'parent'        => $show_title_area_container,
							'options'       => array(
								''                  => esc_html__( 'Default', 'corretto' ),
								'responsive'        => esc_html__( 'Enable Responsive Image', 'corretto' ),
								'parallax'          => esc_html__( 'Enable Parallax Image', 'corretto' ),
								'parallax-zoom-out' => esc_html__( 'Enable Parallax With Zoom Out Image', 'corretto' )
							)
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'name'          => 'title_area_vertical_alignment',
							'type'          => 'select',
							'default_value' => 'header-bottom',
							'label'         => esc_html__( 'Vertical Alignment', 'corretto' ),
							'description'   => esc_html__( 'Specify title vertical alignment', 'corretto' ),
							'parent'        => $show_title_area_container,
							'options'       => array(
								'header-bottom' => esc_html__( 'From Bottom of Header', 'corretto' ),
								'window-top'    => esc_html__( 'From Window Top', 'corretto' )
							)
						)
					);

					corretto_elated_add_admin_field(
						array(
							'name'          => 'title_area_content_vertical_alignment',
							'type'          => 'select',
							'default_value' => 'middle',
							'label'         => esc_html__( 'Title Content Vertical Alignment', 'corretto' ),
							'description'   => esc_html__( 'Set title content vertical alignment', 'corretto' ),
							'parent'        => $show_title_area_container,
							'options'       => array(
								'top' => esc_html__( 'Top', 'corretto' ),
								'middle'    => esc_html__( 'Middle', 'corretto' ),
								'bottom'    => esc_html__( 'Bottom', 'corretto' )
							)
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'name'          => 'title_area_vertical_offset',
							'type'          => 'text',
							'default_value' => '',
							'label'         => esc_html__( 'Title Vertical Offset', 'corretto' ),
							'description'   => esc_html__( 'Set title vertical offset relative to its current position', 'corretto' ),
							'parent'        => $show_title_area_container,
							'args' 			=> array(
								'col_width' => '3',
								'suffix' => 'px'
							)
						)
					);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'corretto_elated_additional_title_area_options_map', $show_title_area_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
		
		$panel_typography = corretto_elated_add_admin_panel(
			array(
				'page'  => '_title_page',
				'name'  => 'panel_title_typography',
				'title' => esc_html__( 'Typography', 'corretto' )
			)
		);
		
			corretto_elated_add_admin_section_title(
				array(
					'name'   => 'type_section_title',
					'title'  => esc_html__( 'Title', 'corretto' ),
					'parent' => $panel_typography
				)
			);
		
			$group_page_title_styles = corretto_elated_add_admin_group(
				array(
					'name'        => 'group_page_title_styles',
					'title'       => esc_html__( 'Title', 'corretto' ),
					'description' => esc_html__( 'Define styles for page title', 'corretto' ),
					'parent'      => $panel_typography
				)
			);
		
				$row_page_title_styles_1 = corretto_elated_add_admin_row(
					array(
						'name'   => 'row_page_title_styles_1',
						'parent' => $group_page_title_styles
					)
				);
		
					corretto_elated_add_admin_field(
						array(
							'name'          => 'title_area_title_tag',
							'type'          => 'selectsimple',
							'default_value' => 'h2',
							'label'         => esc_html__( 'Title Tag', 'corretto' ),
							'options'       => corretto_elated_get_title_tag(),
							'parent'        => $row_page_title_styles_1
						)
					);
		
				$row_page_title_styles_2 = corretto_elated_add_admin_row(
					array(
						'name'   => 'row_page_title_styles_2',
						'parent' => $group_page_title_styles
					)
				);
		
					corretto_elated_add_admin_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'page_title_color',
							'label'  => esc_html__( 'Text Color', 'corretto' ),
							'parent' => $row_page_title_styles_2
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'textsimple',
							'name'          => 'page_title_font_size',
							'default_value' => '',
							'label'         => esc_html__( 'Font Size', 'corretto' ),
							'parent'        => $row_page_title_styles_2,
							'args'          => array(
								'suffix' => 'px'
							)
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'textsimple',
							'name'          => 'page_title_line_height',
							'default_value' => '',
							'label'         => esc_html__( 'Line Height', 'corretto' ),
							'parent'        => $row_page_title_styles_2,
							'args'          => array(
								'suffix' => 'px'
							)
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'selectblanksimple',
							'name'          => 'page_title_text_transform',
							'default_value' => '',
							'label'         => esc_html__( 'Text Transform', 'corretto' ),
							'options'       => corretto_elated_get_text_transform_array(),
							'parent'        => $row_page_title_styles_2
						)
					);
		
				$row_page_title_styles_3 = corretto_elated_add_admin_row(
					array(
						'name'   => 'row_page_title_styles_3',
						'parent' => $group_page_title_styles,
						'next'   => true
					)
				);
		
					corretto_elated_add_admin_field(
						array(
							'type'          => 'fontsimple',
							'name'          => 'page_title_google_fonts',
							'default_value' => '-1',
							'label'         => esc_html__( 'Font Family', 'corretto' ),
							'parent'        => $row_page_title_styles_3
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'selectblanksimple',
							'name'          => 'page_title_font_style',
							'default_value' => '',
							'label'         => esc_html__( 'Font Style', 'corretto' ),
							'options'       => corretto_elated_get_font_style_array(),
							'parent'        => $row_page_title_styles_3
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'selectblanksimple',
							'name'          => 'page_title_font_weight',
							'default_value' => '',
							'label'         => esc_html__( 'Font Weight', 'corretto' ),
							'options'       => corretto_elated_get_font_weight_array(),
							'parent'        => $row_page_title_styles_3
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'textsimple',
							'name'          => 'page_title_letter_spacing',
							'default_value' => '',
							'label'         => esc_html__( 'Letter Spacing', 'corretto' ),
							'parent'        => $row_page_title_styles_3,
							'args'          => array(
								'suffix' => 'px'
							)
						)
					);
		
			corretto_elated_add_admin_section_title(
				array(
					'name'   => 'type_section_subtitle',
					'title'  => esc_html__( 'Subtitle', 'corretto' ),
					'parent' => $panel_typography
				)
			);
		
			$group_page_subtitle_styles = corretto_elated_add_admin_group(
				array(
					'name'        => 'group_page_subtitle_styles',
					'title'       => esc_html__( 'Subtitle', 'corretto' ),
					'description' => esc_html__( 'Define styles for page subtitle', 'corretto' ),
					'parent'      => $panel_typography
				)
			);
		
				$row_page_subtitle_styles_1 = corretto_elated_add_admin_row(
					array(
						'name'   => 'row_page_subtitle_styles_1',
						'parent' => $group_page_subtitle_styles
					)
				);
				
					corretto_elated_add_admin_field(
						array(
							'name' => 'title_area_subtitle_tag',
							'type' => 'selectsimple',
							'default_value' => 'h6',
							'label' => esc_html__('Subtitle Tag', 'corretto'),
							'options' => corretto_elated_get_title_tag(),
							'parent' => $row_page_subtitle_styles_1
						)
					);
		
				$row_page_subtitle_styles_2 = corretto_elated_add_admin_row(
					array(
						'name'   => 'row_page_subtitle_styles_2',
						'parent' => $group_page_subtitle_styles
					)
				);
		
					corretto_elated_add_admin_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'page_subtitle_color',
							'label'  => esc_html__( 'Text Color', 'corretto' ),
							'parent' => $row_page_subtitle_styles_2
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'textsimple',
							'name'          => 'page_subtitle_font_size',
							'default_value' => '',
							'label'         => esc_html__( 'Font Size', 'corretto' ),
							'parent'        => $row_page_subtitle_styles_2,
							'args'          => array(
								'suffix' => 'px'
							)
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'textsimple',
							'name'          => 'page_subtitle_line_height',
							'default_value' => '',
							'label'         => esc_html__( 'Line Height', 'corretto' ),
							'parent'        => $row_page_subtitle_styles_2,
							'args'          => array(
								'suffix' => 'px'
							)
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'selectblanksimple',
							'name'          => 'page_subtitle_text_transform',
							'default_value' => '',
							'label'         => esc_html__( 'Text Transform', 'corretto' ),
							'options'       => corretto_elated_get_text_transform_array(),
							'parent'        => $row_page_subtitle_styles_2
						)
					);
		
				$row_page_subtitle_styles_3 = corretto_elated_add_admin_row(
					array(
						'name'   => 'row_page_subtitle_styles_3',
						'parent' => $group_page_subtitle_styles,
						'next'   => true
					)
				);
		
					corretto_elated_add_admin_field(
						array(
							'type'          => 'fontsimple',
							'name'          => 'page_subtitle_google_fonts',
							'default_value' => '-1',
							'label'         => esc_html__( 'Font Family', 'corretto' ),
							'parent'        => $row_page_subtitle_styles_3
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'selectblanksimple',
							'name'          => 'page_subtitle_font_style',
							'default_value' => '',
							'label'         => esc_html__( 'Font Style', 'corretto' ),
							'options'       => corretto_elated_get_font_style_array(),
							'parent'        => $row_page_subtitle_styles_3
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'selectblanksimple',
							'name'          => 'page_subtitle_font_weight',
							'default_value' => '',
							'label'         => esc_html__( 'Font Weight', 'corretto' ),
							'options'       => corretto_elated_get_font_weight_array(),
							'parent'        => $row_page_subtitle_styles_3
						)
					);
					
					corretto_elated_add_admin_field(
						array(
							'type'          => 'textsimple',
							'name'          => 'page_subtitle_letter_spacing',
							'default_value' => '',
							'label'         => esc_html__( 'Letter Spacing', 'corretto' ),
							'args'          => array(
								'suffix' => 'px'
							),
							'parent'        => $row_page_subtitle_styles_3
						)
					);
		
		/***************** Additional Title Typography Layout - start *****************/
		
		do_action( 'corretto_elated_additional_title_typography_options_map', $panel_typography );
		
		/***************** Additional Title Typography Layout - end *****************/
    }

	add_action( 'corretto_elated_options_map', 'corretto_elated_title_options_map', 4);
}