<?php

if ( ! function_exists( 'corretto_elated_get_hide_dep_for_top_header_area_meta_boxes' ) ) {
	function corretto_elated_get_hide_dep_for_top_header_area_meta_boxes() {
		$hide_dep_options = apply_filters( 'corretto_elated_top_header_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'corretto_elated_header_top_area_meta_options_map' ) ) {
	function corretto_elated_header_top_area_meta_options_map( $header_meta_box ) {
		$hide_dep_options = corretto_elated_get_hide_dep_for_top_header_area_meta_boxes();
		
		$top_header_container = corretto_elated_add_admin_container_no_style(
			array(
				'type'            => 'container',
				'name'            => 'top_header_container',
				'parent'          => $header_meta_box,
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
		
		corretto_elated_add_admin_section_title(
			array(
				'parent' => $top_header_container,
				'name'   => 'top_area_style',
				'title'  => esc_html__( 'Top Area', 'corretto' )
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_top_bar_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Header Top Bar', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will show header top bar area', 'corretto' ),
				'parent'        => $top_header_container,
				'options'       => corretto_elated_get_yes_no_select_array(),
			)
		);
		
		$top_bar_container = corretto_elated_add_admin_container_no_style(
			array(
				'name'            => 'top_bar_container_no_style',
				'parent'          => $top_header_container,
				'dependency' => array(
					'show' => array(
						'eltdf_top_bar_meta' => 'yes'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_top_bar_in_grid_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Top Bar In Grid', 'corretto' ),
				'description'   => esc_html__( 'Set top bar content to be in grid', 'corretto' ),
				'parent'        => $top_bar_container,
				'default_value' => '',
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);

        corretto_elated_create_meta_box_field(
			array(
				'name'   => 'eltdf_top_bar_background_color_meta',
				'type'   => 'color',
				'label'  => esc_html__( 'Top Bar Background Color', 'corretto' ),
				'parent' => $top_bar_container
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_top_bar_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Top Bar Background Color Transparency', 'corretto' ),
				'description' => esc_html__( 'Set top bar background color transparenct. Value should be between 0 and 1', 'corretto' ),
				'parent'      => $top_bar_container,
				'args'        => array(
					'col_width' => 3
				)
			)
		);

        corretto_elated_create_meta_box_field(
            array(
                'name'          => 'eltdf_top_bar_background_image_meta',
                'type'          => 'image',
                'label'         => esc_html__( 'Top Bar Background Image', 'corretto' ),
                'description'   => esc_html__( 'Set background image for top bar', 'corretto' ),
                'parent'        => $top_bar_container,
                'default_value' => ''
            )
        );

		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_top_bar_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Top Bar Border', 'corretto' ),
				'description'   => esc_html__( 'Set border on top bar', 'corretto' ),
				'parent'        => $top_bar_container,
				'default_value' => '',
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
		$top_bar_border_container = corretto_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'top_bar_border_container',
				'parent'          => $top_bar_container,
				'dependency' => array(
					'show' => array(
						'eltdf_top_bar_border_meta' => 'yes'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_top_bar_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'corretto' ),
				'description' => esc_html__( 'Choose color for top bar border', 'corretto' ),
				'parent'      => $top_bar_border_container
			)
		);
	}
	
	add_action( 'corretto_elated_additional_header_area_meta_boxes_map', 'corretto_elated_header_top_area_meta_options_map', 10, 1 );
}