<?php

if ( ! function_exists( 'corretto_elated_header_top_bar_styles' ) ) {
	/**
	 * Generates styles for header top bar
	 */
	function corretto_elated_header_top_bar_styles() {
		$top_header_height = corretto_elated_options()->getOptionValue( 'top_bar_height' );
		
		if ( ! empty( $top_header_height ) ) {
			echo corretto_elated_dynamic_css( '.eltdf-top-bar', array( 'height' => corretto_elated_filter_px( $top_header_height ) . 'px' ) );
			echo corretto_elated_dynamic_css( '.eltdf-top-bar .eltdf-logo-wrapper a', array( 'max-height' => corretto_elated_filter_px( $top_header_height ) . 'px' ) );
		}
		
		echo corretto_elated_dynamic_css( '.eltdf-header-box .eltdf-top-bar-background', array( 'height' => corretto_elated_get_top_bar_background_height() . 'px' ) );
		
		$top_bar_container_selector = '.eltdf-top-bar > .eltdf-vertical-align-containers';
		$top_bar_container_styles   = array();
		$container_side_padding     = corretto_elated_options()->getOptionValue( 'top_bar_side_padding' );
		
		if ( $container_side_padding !== '' ) {
			if ( corretto_elated_string_ends_with( $container_side_padding, 'px' ) || corretto_elated_string_ends_with( $container_side_padding, '%' ) ) {
				$top_bar_container_styles['padding-left'] = $container_side_padding;
				$top_bar_container_styles['padding-right'] = $container_side_padding;
			} else {
				$top_bar_container_styles['padding-left'] = corretto_elated_filter_px( $container_side_padding ) . 'px';
				$top_bar_container_styles['padding-right'] = corretto_elated_filter_px( $container_side_padding ) . 'px';
			}
			
			echo corretto_elated_dynamic_css( $top_bar_container_selector, $top_bar_container_styles );
		}
		
		if ( corretto_elated_options()->getOptionValue( 'top_bar_in_grid' ) == 'yes' ) {
			$top_bar_grid_selector                = '.eltdf-top-bar .eltdf-grid .eltdf-vertical-align-containers';
			$top_bar_grid_styles                  = array();
			$top_bar_grid_background_color        = corretto_elated_options()->getOptionValue( 'top_bar_grid_background_color' );
			$top_bar_grid_background_transparency = corretto_elated_options()->getOptionValue( 'top_bar_grid_background_transparency' );
			
			if ( !empty($top_bar_grid_background_color) ) {
				$grid_background_color        = $top_bar_grid_background_color;
				$grid_background_transparency = 1;
				
				if ( $top_bar_grid_background_transparency !== '' ) {
					$grid_background_transparency = $top_bar_grid_background_transparency;
				}
				
				$grid_background_color                   = corretto_elated_rgba_color( $grid_background_color, $grid_background_transparency );
				$top_bar_grid_styles['background-color'] = $grid_background_color;
			}
			
			echo corretto_elated_dynamic_css( $top_bar_grid_selector, $top_bar_grid_styles );
		}
		
		$top_bar_styles   = array();
		$background_color = corretto_elated_options()->getOptionValue( 'top_bar_background_color' );
        $background_image = corretto_elated_options()->getOptionValue( 'top_bar_background_image' );
		$border_color     = corretto_elated_options()->getOptionValue( 'top_bar_border_color' );

		$top_bar_background_selector = array(
		  '.eltdf-header-box .eltdf-top-bar-background'
        );
		$top_bar_background_style = array();

		
		if ( $background_color !== '' ) {
			$background_transparency = 1;
			if ( corretto_elated_options()->getOptionValue( 'top_bar_background_transparency' ) !== '' ) {
				$background_transparency = corretto_elated_options()->getOptionValue( 'top_bar_background_transparency' );
			}
			
			$background_color                   = corretto_elated_rgba_color( $background_color, $background_transparency );
			$top_bar_styles['background-color'] = $background_color;
			$top_bar_background_style['background-color'] = $background_color;
		}

		if($background_image !== '' ){
            $top_bar_styles['background-image'] = 'url('.$background_image.')';
            $top_bar_background_style['background-image'] = 'url('.$background_image.')';
        }

        echo corretto_elated_dynamic_css( $top_bar_background_selector, $top_bar_background_style );

        if ( corretto_elated_options()->getOptionValue( 'top_bar_border' ) == 'yes' && $border_color != '' ) {
			$top_bar_styles['border-bottom'] = '1px solid ' . $border_color;
		}
		
		echo corretto_elated_dynamic_css( '.eltdf-top-bar', $top_bar_styles );
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_header_top_bar_styles' );
}