<?php

if ( ! function_exists( 'corretto_elated_get_hide_dep_for_header_vertical_area_options' ) ) {
	function corretto_elated_get_hide_dep_for_header_vertical_area_options() {
		$hide_dep_options = apply_filters( 'corretto_elated_header_vertical_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'corretto_elated_header_vertical_options_map' ) ) {
	function corretto_elated_header_vertical_options_map( $panel_header ) {
		$hide_dep_options = corretto_elated_get_hide_dep_for_header_vertical_area_options();
		
		$vertical_area_container = corretto_elated_add_admin_container_no_style(
			array(
				'parent'          => $panel_header,
				'name'            => 'header_vertical_area_container',
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				)
			)
		);
		
		corretto_elated_add_admin_section_title(
			array(
				'parent' => $vertical_area_container,
				'name'   => 'menu_area_style',
				'title'  => esc_html__( 'Vertical Area Style', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'        => 'vertical_header_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'corretto' ),
				'description' => esc_html__( 'Set background color for vertical menu', 'corretto' ),
				'parent'      => $vertical_area_container
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'vertical_header_background_image',
				'type'          => 'image',
				'default_value' => '',
				'label'         => esc_html__( 'Background Image', 'corretto' ),
				'description'   => esc_html__( 'Set background image for vertical menu', 'corretto' ),
				'parent'        => $vertical_area_container
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $vertical_area_container,
				'type'          => 'yesno',
				'name'          => 'vertical_header_shadow',
				'default_value' => 'no',
				'label'         => esc_html__( 'Shadow', 'corretto' ),
				'description'   => esc_html__( 'Set shadow on vertical header', 'corretto' ),
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $vertical_area_container,
				'type'          => 'yesno',
				'name'          => 'vertical_header_border',
				'default_value' => 'no',
				'label'         => esc_html__( 'Vertical Area Border', 'corretto' ),
				'description'   => esc_html__( 'Set border on vertical area', 'corretto' )
			)
		);
		
		$vertical_header_shadow_border_container = corretto_elated_add_admin_container(
			array(
				'parent'          => $vertical_area_container,
				'name'            => 'vertical_header_shadow_border_container',
				'dependency' => array(
					'hide' => array(
						'vertical_header_border'  => 'no'
					)
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $vertical_header_shadow_border_container,
				'type'          => 'color',
				'name'          => 'vertical_header_border_color',
				'default_value' => '',
				'label'         => esc_html__( 'Border Color', 'corretto' ),
				'description'   => esc_html__( 'Set border color for vertical area', 'corretto' ),
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $vertical_area_container,
				'type'          => 'yesno',
				'name'          => 'vertical_header_center_content',
				'default_value' => 'no',
				'label'         => esc_html__( 'Center Content', 'corretto' ),
				'description'   => esc_html__( 'Set content in vertical center', 'corretto' ),
			)
		);
		
		do_action( 'corretto_elated_header_vertical_area_additional_options', $panel_header );
	}
	
	add_action( 'corretto_elated_additional_header_menu_area_options_map', 'corretto_elated_header_vertical_options_map' );
}