<?php

if ( ! function_exists( 'corretto_elated_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function corretto_elated_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'corretto_elated_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'corretto_elated_header_standard_meta_map' ) ) {
	function corretto_elated_header_standard_meta_map( $parent ) {
		$hide_dep_options = corretto_elated_get_hide_dep_for_header_standard_meta_boxes();
		
		corretto_elated_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'eltdf_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'corretto' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'corretto' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'corretto' ),
					'left'   => esc_html__( 'Left', 'corretto' ),
					'right'  => esc_html__( 'Right', 'corretto' ),
					'center' => esc_html__( 'Center', 'corretto' )
				),
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'corretto_elated_additional_header_area_meta_boxes_map', 'corretto_elated_header_standard_meta_map' );
}