<?php

/*** Post Settings ***/

if ( ! function_exists( 'corretto_elated_map_post_meta' ) ) {
	function corretto_elated_map_post_meta() {
		
		$post_meta_box = corretto_elated_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Post', 'corretto' ),
				'name'  => 'post-meta'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_blog_single_sidebar_layout_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Sidebar Layout', 'corretto' ),
				'description'   => esc_html__( 'Choose a sidebar layout for Blog single page', 'corretto' ),
				'default_value' => '',
				'parent'        => $post_meta_box,
                'options'       => corretto_elated_get_custom_sidebars_options( true )
			)
		);
		
		$corretto_custom_sidebars = corretto_elated_get_custom_sidebars();
		if ( count( $corretto_custom_sidebars ) > 0 ) {
			corretto_elated_create_meta_box_field( array(
				'name'        => 'eltdf_blog_single_custom_sidebar_area_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'corretto' ),
				'description' => esc_html__( 'Choose a sidebar to display on Blog single page. Default sidebar is "Sidebar"', 'corretto' ),
				'parent'      => $post_meta_box,
				'options'     => corretto_elated_get_custom_sidebars(),
				'args' => array(
					'select2' => true
				)
			) );
		}
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_list_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Blog List Image', 'corretto' ),
				'description' => esc_html__( 'Choose an Image for displaying in blog list. If not uploaded, featured image will be shown.', 'corretto' ),
				'parent'      => $post_meta_box
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_blog_masonry_gallery_fixed_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Fixed Proportion', 'corretto' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry lists in fixed proportion', 'corretto' ),
				'default_value' => 'default',
				'parent'        => $post_meta_box,
				'options'       => array(
					'default'            => esc_html__( 'Default', 'corretto' ),
					'large-width'        => esc_html__( 'Large Width', 'corretto' ),
					'large-height'       => esc_html__( 'Large Height', 'corretto' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'corretto' )
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_blog_masonry_gallery_original_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Original Proportion', 'corretto' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry lists in original proportion', 'corretto' ),
				'default_value' => 'default',
				'parent'        => $post_meta_box,
				'options'       => array(
					'default'     => esc_html__( 'Default', 'corretto' ),
					'large-width' => esc_html__( 'Large Width', 'corretto' )
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_blog_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single post page', 'corretto' ),
				'parent'        => $post_meta_box,
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);

		do_action('corretto_elated_blog_post_meta', $post_meta_box);
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_elated_map_post_meta', 20 );
}
