<?php

if ( ! function_exists( 'corretto_elated_map_general_meta' ) ) {
	function corretto_elated_map_general_meta() {
		
		$general_meta_box = corretto_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'corretto_elated_set_scope_for_meta_boxes', array( 'page', 'post' ), 'general_meta' ),
				'title' => esc_html__( 'General', 'corretto' ),
				'name'  => 'general_meta'
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_page_slider_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Slider Shortcode', 'corretto' ),
				'description' => esc_html__( 'Paste your slider shortcode here', 'corretto' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		/***************** Content Layout - begin **********************/
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_page_content_behind_header_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Always put content behind header', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'corretto' ),
				'parent'        => $general_meta_box
			)
		);
		
		$eltdf_content_padding_group = corretto_elated_add_admin_group(
			array(
				'name'        => 'content_padding_group',
				'title'       => esc_html__( 'Content Style', 'corretto' ),
				'description' => esc_html__( 'Define styles for Content area', 'corretto' ),
				'parent'      => $general_meta_box
			)
		);
		
			$eltdf_content_padding_row = corretto_elated_add_admin_row(
				array(
					'name'   => 'eltdf_content_padding_row',
					'next'   => true,
					'parent' => $eltdf_content_padding_group
				)
			);

				corretto_elated_create_meta_box_field(
					array(
						'name'   => 'eltdf_page_content_padding',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Content Padding (e.g. 10px 5px 10px 5px)', 'corretto' ),
						'parent' => $eltdf_content_padding_row,
					)
				);

				corretto_elated_create_meta_box_field(
					array(
						'name'    => 'eltdf_page_content_padding_mobile',
						'type'    => 'textsimple',
						'label'   => esc_html__( 'Content Padding for mobile (e.g. 10px 5px 10px 5px)', 'corretto' ),
						'parent'  => $eltdf_content_padding_row,
					)
				);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_page_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Page Background Color', 'corretto' ),
				'description' => esc_html__( 'Choose background color for page content', 'corretto' ),
				'parent'      => $general_meta_box
			)
		);

		corretto_elated_create_meta_box_field(
			array(
				'type'          => 'yesno',
				'name'          => 'eltdf_disable_content_background_image_meta',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Content Background Image', 'corretto' ),
				'description'   => esc_html__( 'Disable content background image', 'corretto' ),
				'parent'        => $general_meta_box
			)
		);

		corretto_elated_create_meta_box_field(
			array(
				'type'          => 'image',
				'name'          => 'eltdf_content_background_image_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Content Background Image', 'corretto' ),
				'description'   => esc_html__( 'Choose image to use as content background image', 'corretto' ),
				'parent'        => $general_meta_box,
				'dependency'	=> array(
					'show' => array(
						'eltdf_disable_content_background_image_meta' => 'no'
					)
				)
			)
		);

		corretto_elated_create_meta_box_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_content_background_image_behavior_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Content Background Image Behavior', 'corretto' ),
				'description'   => esc_html__( 'Choose background image behavior', 'corretto' ),
				'parent'        => $general_meta_box,
				'options'		=> array(
					'' => esc_html__('Default','corretto'),
					'full-image' => esc_html__('As Full Image','corretto'),
					'pattern' => esc_html__('As Pattern','corretto'),
				),
				'dependency'	=> array(
					'show' => array(
						'eltdf_disable_content_background_image_meta' => 'no'
					)
				)
			)
		);
		
		/***************** Content Layout - end **********************/
		
		/***************** Boxed Layout - begin **********************/
		
		corretto_elated_create_meta_box_field(
			array(
				'name'    => 'eltdf_boxed_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Boxed Layout', 'corretto' ),
				'parent'  => $general_meta_box,
				'options' => corretto_elated_get_yes_no_select_array()
			)
		);
		
			$boxed_container_meta = corretto_elated_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'boxed_container_meta',
					'dependency' => array(
						'hide' => array(
							'eltdf_boxed_meta'  => array('','no')
						)
					)
				)
			);
		
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_page_background_color_in_box_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Page Background Color', 'corretto' ),
						'description' => esc_html__( 'Choose the page background color outside box', 'corretto' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_boxed_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'corretto' ),
						'description' => esc_html__( 'Choose an image to be displayed in background', 'corretto' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_boxed_pattern_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Pattern', 'corretto' ),
						'description' => esc_html__( 'Choose an image to be used as background pattern', 'corretto' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_boxed_background_image_attachment_meta',
						'type'          => 'select',
						'default_value' => 'fixed',
						'label'         => esc_html__( 'Background Image Attachment', 'corretto' ),
						'description'   => esc_html__( 'Choose background image attachment', 'corretto' ),
						'parent'        => $boxed_container_meta,
						'options'       => array(
							''       => esc_html__( 'Default', 'corretto' ),
							'fixed'  => esc_html__( 'Fixed', 'corretto' ),
							'scroll' => esc_html__( 'Scroll', 'corretto' )
						)
					)
				);
		
		/***************** Boxed Layout - end **********************/
		
		/***************** Passepartout Layout - begin **********************/
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_paspartu_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Passepartout', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'corretto' ),
				'parent'        => $general_meta_box,
				'options'       => corretto_elated_get_yes_no_select_array(),
			)
		);
		
			$paspartu_container_meta = corretto_elated_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'eltdf_paspartu_container_meta',
					'dependency' => array(
						'hide' => array(
							'eltdf_paspartu_meta'  => array('','no')
						)
					)
				)
			);
		
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_paspartu_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Passepartout Color', 'corretto' ),
						'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'corretto' ),
						'parent'      => $paspartu_container_meta
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_paspartu_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Passepartout Size', 'corretto' ),
						'description' => esc_html__( 'Enter size amount for passepartout', 'corretto' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
		
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_paspartu_responsive_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Responsive Passepartout Size', 'corretto' ),
						'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'corretto' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'eltdf_disable_top_paspartu_meta',
						'label'         => esc_html__( 'Disable Top Passepartout', 'corretto' ),
						'options'       => corretto_elated_get_yes_no_select_array(),
					)
				);
		
				corretto_elated_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'eltdf_enable_fixed_paspartu_meta',
						'label'         => esc_html__( 'Enable Fixed Passepartout', 'corretto' ),
						'description'   => esc_html__( 'Enabling this option will set fixed passepartout for your screens', 'corretto' ),
						'options'       => corretto_elated_get_yes_no_select_array(),
					)
				);
		
		/***************** Passepartout Layout - end **********************/
		
		/***************** Content Width Layout - begin **********************/
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_initial_content_width_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Initial Width of Content', 'corretto' ),
				'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'corretto' ),
				'parent'        => $general_meta_box,
				'options'       => array(
					''                => esc_html__( 'Default', 'corretto' ),
					'eltdf-grid-1100' => esc_html__( '1100px', 'corretto' ),
					'eltdf-grid-1300' => esc_html__( '1300px', 'corretto' ),
					'eltdf-grid-1200' => esc_html__( '1200px', 'corretto' ),
					'eltdf-grid-1000' => esc_html__( '1000px', 'corretto' ),
					'eltdf-grid-800'  => esc_html__( '800px', 'corretto' )
				)
			)
		);
		
		/***************** Content Width Layout - end **********************/
		
		/***************** Smooth Page Transitions Layout - begin **********************/
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_smooth_page_transitions_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Smooth Page Transitions', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'corretto' ),
				'parent'        => $general_meta_box,
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
			$page_transitions_container_meta = corretto_elated_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'page_transitions_container_meta',
					'dependency' => array(
						'hide' => array(
							'eltdf_smooth_page_transitions_meta'  => array('','no')
						)
					)
				)
			);
		
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_page_transition_preloader_meta',
						'type'        => 'select',
						'label'       => esc_html__( 'Enable Preloading Animation', 'corretto' ),
						'description' => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'corretto' ),
						'parent'      => $page_transitions_container_meta,
						'options'     => corretto_elated_get_yes_no_select_array()
					)
				);
				
				$page_transition_preloader_container_meta = corretto_elated_add_admin_container(
					array(
						'parent'          => $page_transitions_container_meta,
						'name'            => 'page_transition_preloader_container_meta',
						'dependency' => array(
							'hide' => array(
								'eltdf_page_transition_preloader_meta'  => array('','no')
							)
						)
					)
				);
				
					corretto_elated_create_meta_box_field(
						array(
							'name'   => 'eltdf_smooth_pt_bgnd_color_meta',
							'type'   => 'color',
							'label'  => esc_html__( 'Page Loader Background Color', 'corretto' ),
							'parent' => $page_transition_preloader_container_meta
						)
					);
					
					$group_pt_spinner_animation_meta = corretto_elated_add_admin_group(
						array(
							'name'        => 'group_pt_spinner_animation_meta',
							'title'       => esc_html__( 'Loader Style', 'corretto' ),
							'description' => esc_html__( 'Define styles for loader spinner animation', 'corretto' ),
							'parent'      => $page_transition_preloader_container_meta
						)
					);
					
					$row_pt_spinner_animation_meta = corretto_elated_add_admin_row(
						array(
							'name'   => 'row_pt_spinner_animation_meta',
							'parent' => $group_pt_spinner_animation_meta
						)
					);
					
					corretto_elated_create_meta_box_field(
						array(
							'type'    => 'selectsimple',
							'name'    => 'eltdf_smooth_pt_spinner_type_meta',
							'label'   => esc_html__( 'Spinner Type', 'corretto' ),
							'parent'  => $row_pt_spinner_animation_meta,
							'options' => array(
								''                      => esc_html__( 'Default', 'corretto' ),
								'image'                 => esc_html__( 'Custom Image', 'corretto' ),
								'rotate_circles'        => esc_html__( 'Rotate Circles', 'corretto' ),
								'pulse'                 => esc_html__( 'Pulse', 'corretto' ),
								'double_pulse'          => esc_html__( 'Double Pulse', 'corretto' ),
								'cube'                  => esc_html__( 'Cube', 'corretto' ),
								'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'corretto' ),
								'stripes'               => esc_html__( 'Stripes', 'corretto' ),
								'wave'                  => esc_html__( 'Wave', 'corretto' ),
								'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'corretto' ),
								'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'corretto' ),
								'atom'                  => esc_html__( 'Atom', 'corretto' ),
								'clock'                 => esc_html__( 'Clock', 'corretto' ),
								'mitosis'               => esc_html__( 'Mitosis', 'corretto' ),
								'lines'                 => esc_html__( 'Lines', 'corretto' ),
								'fussion'               => esc_html__( 'Fussion', 'corretto' ),
								'wave_circles'          => esc_html__( 'Wave Circles', 'corretto' ),
								'pulse_circles'         => esc_html__( 'Pulse Circles', 'corretto' )
							)
						)
					);
					
					corretto_elated_create_meta_box_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'eltdf_smooth_pt_spinner_color_meta',
							'label'  => esc_html__( 'Spinner Color', 'corretto' ),
							'parent' => $row_pt_spinner_animation_meta,
							'dependency'	=> array(
								'hide' => array(
									'eltdf_smooth_pt_spinner_type_meta' => 'image'
								)
							)
						)
					);

					corretto_elated_create_meta_box_field(
						array(
							'type'          => 'imagesimple',
							'name'          => 'eltdf_smooth_pt_spinner_image_meta',
							'label'         => esc_html__( 'Spinner Image', 'corretto' ),
							'parent'        => $row_pt_spinner_animation_meta,
							'dependency'	=> array(
								'show' => array(
									'eltdf_smooth_pt_spinner_type_meta' => 'image'
								)
							)
						)
					);

					corretto_elated_create_meta_box_field(
						array(
							'name'        => 'eltdf_page_transition_fadeout_meta',
							'type'        => 'select',
							'label'       => esc_html__( 'Enable Fade Out Animation', 'corretto' ),
							'description' => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'corretto' ),
							'options'     => corretto_elated_get_yes_no_select_array(),
							'parent'      => $page_transitions_container_meta
						
						)
					);
		
		/***************** Smooth Page Transitions Layout - end **********************/
		
		/***************** Comments Layout - begin **********************/
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_page_comments_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Show Comments', 'corretto' ),
				'description' => esc_html__( 'Enabling this option will show comments on your page', 'corretto' ),
				'parent'      => $general_meta_box,
				'options'     => corretto_elated_get_yes_no_select_array()
			)
		);
		
		/***************** Comments Layout - end **********************/
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_elated_map_general_meta', 10 );
}