<?php
/**
 * Product quantity inputs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/quantity-input.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! isset ( $input_id ) ) {
	$input_id = uniqid( 'quantity_' );
}

if ( $max_value && $min_value === $max_value ) { ?>
	<div class="eltdf-quantity-buttons quantity hidden">
		<input type="hidden" id="<?php echo esc_attr( $input_id ); ?>" class="qty" name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $min_value ); ?>" />
	</div>
<?php } else { ?>
	<div class="eltdf-quantity-buttons quantity">
		<label class="screen-reader-text" for="<?php echo esc_attr( $input_id ); ?>"><?php esc_html_e( 'Quantity', 'corretto' ); ?></label>
		<span class="eltdf-quantity-minus icon_minus-06"></span>
		<input
                type="text"
                id="<?php echo esc_attr( $input_id ); ?>"
                class="input-text qty text eltdf-quantity-input"
                data-step="<?php echo esc_attr( $step ); ?>"
                data-min="<?php echo esc_attr( $min_value ); ?>"
                data-max="<?php echo esc_attr( 0 < $max_value ? $max_value : '' ); ?>"
                name="<?php echo esc_attr( $input_name ); ?>"
                value="<?php echo esc_attr( $input_value ); ?>"
                title="<?php echo esc_attr_x( 'Qty', 'Product quantity input tooltip', 'corretto' ) ?>"
                size="4"
                pattern="<?php echo esc_attr( $pattern ); ?>"
                inputmode="<?php echo esc_attr( $inputmode ); ?>"
                aria-labelledby="<?php echo ! empty( $args['product_name'] ) ? sprintf( esc_attr__( '%s quantity', 'corretto' ), $args['product_name'] ) : ''; ?>" />
		<span class="eltdf-quantity-plus icon_plus"></span>
	</div>

<?php  
global $woocommerce;
if ($woocommerce->cart->cart_contents_total+$woocommerce->cart->tax_total > 0) {?>
        <div class="free-ship">
<?php _e(alg_wc_get_left_to_free_shipping(array( "content" => "Add another %amount_left_for_free_shipping% to get free shipping"),'freeship'));?>
</div>
<?php } ?>

	<?php
}
