/* WooCommerce Apple Pay Handler Version 4.7.0 Copyright (c) 2016, SkyVerge, Inc. Licensed under the GNU General Public License v3.0 http://www.gnu.org/licenses/gpl-3.0.html */(function() {  var bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };  jQuery(document).ready(function($) {    "use strict";    window.SV_WC_Apple_Pay_Handler_v5_8_1 = (function() {      function SV_WC_Apple_Pay_Handler_v5_8_1(args) {        this.get_payment_request = bind(this.get_payment_request, this);        this.reset_payment_request = bind(this.reset_payment_request, this);        this.on_cancel_payment = bind(this.on_cancel_payment, this);        this.process_authorization = bind(this.process_authorization, this);        this.on_payment_authorized = bind(this.on_payment_authorized, this);        this.on_shipping_method_selected = bind(this.on_shipping_method_selected, this);        this.on_shipping_contact_selected = bind(this.on_shipping_contact_selected, this);        this.on_payment_method_selected = bind(this.on_payment_method_selected, this);        this.validate_merchant = bind(this.validate_merchant, this);        this.on_validate_merchant = bind(this.on_validate_merchant, this);        this.init_checkout_page = bind(this.init_checkout_page, this);        this.init_cart_page = bind(this.init_cart_page, this);        this.init_product_page = bind(this.init_product_page, this);        this.gateway_id = args.gateway_id;        this.gateway_slug = args.gateway_slug;        this.merchant_id = args.merchant_id;        this.ajax_url = args.ajax_url;        this.validate_nonce = args.validate_nonce;        this.recalculate_totals_nonce = args.recalculate_totals_nonce;        this.process_nonce = args.process_nonce;        this.payment_request = args.payment_request;        this.generic_error = args.generic_error;        this.buttons = '.sv-wc-apple-pay-button';        this.terms = '.sv-wc-apple-pay-terms';      }      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.is_available = function() {        if (!window.ApplePaySession) {          return false;        }        return ApplePaySession.canMakePaymentsWithActiveCard(this.merchant_id).then((function(_this) {          return function(canMakePayments) {            return canMakePayments;          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.init = function() {        if (!this.is_available()) {          return;        }        if ($('form.cart').length) {          this.init_product_page();        } else if ($('form.woocommerce-cart-form').length) {          this.init_cart_page();        } else if ($('form.woocommerce-checkout').length) {          this.init_checkout_page();        }        if (!this.ui_element) {          return;        }        if (this.payment_request) {          $(this.buttons).show();          $(this.terms).show();        }        return $(document.body).on('click', '.sv-wc-apple-pay-button', (function(_this) {          return function(e) {            var error;            e.preventDefault();            _this.block_ui();            try {              _this.session = _this.get_new_session(_this.payment_request);              _this.session.onvalidatemerchant = function(event) {                return _this.on_validate_merchant(event);              };              _this.session.onpaymentmethodselected = function(event) {                return _this.on_payment_method_selected(event);              };              _this.session.onshippingcontactselected = function(event) {                return _this.on_shipping_contact_selected(event);              };              _this.session.onshippingmethodselected = function(event) {                return _this.on_shipping_method_selected(event);              };              _this.session.onpaymentauthorized = function(event) {                return _this.on_payment_authorized(event);              };              _this.session.oncancel = function(event) {                return _this.on_cancel_payment(event);              };              return _this.session.begin();            } catch (_error) {              error = _error;              return _this.fail_payment(error);            }          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.init_product_page = function() {        return this.ui_element = $('form.cart');      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.init_cart_page = function() {        this.ui_element = $('form.woocommerce-cart-form').parents('div.woocommerce');        return $(document.body).on('updated_cart_totals', (function(_this) {          return function() {            return _this.reset_payment_request();          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.init_checkout_page = function() {        this.ui_element = $('form.woocommerce-checkout');        this.buttons = '.sv-wc-apply-pay-checkout';        return $(document.body).on('updated_checkout', (function(_this) {          return function() {            return _this.reset_payment_request();          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.get_new_session = function(payment_request) {        return new ApplePaySession(this.get_sdk_version(), payment_request);      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.get_sdk_version = function() {        return 2;      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.on_validate_merchant = function(event) {        return this.validate_merchant(event.validationURL).then((function(_this) {          return function(merchant_session) {            merchant_session = $.parseJSON(merchant_session);            return _this.session.completeMerchantValidation(merchant_session);          };        })(this), (function(_this) {          return function(response) {            _this.session.abort();            return _this.fail_payment('Merchant could no be validated. ' + response.message);          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.validate_merchant = function(url) {        return new Promise((function(_this) {          return function(resolve, reject) {            var data;            data = {              'action': "wc_" + _this.gateway_id + "_apple_pay_validate_merchant",              'nonce': _this.validate_nonce,              'merchant_id': _this.merchant_id,              'url': url            };            return $.post(_this.ajax_url, data, function(response) {              if (response.success) {                return resolve(response.data);              } else {                return reject(response.data);              }            });          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.on_payment_method_selected = function(event) {        return new Promise((function(_this) {          return function(resolve, reject) {            var data;            data = {              'action': "wc_" + _this.gateway_id + "_apple_pay_recalculate_totals",              'nonce': _this.recalculate_totals_nonce            };            return $.post(_this.ajax_url, data, function(response) {              if (response.success) {                data = response.data;                return resolve(_this.session.completePaymentMethodSelection(data.total, data.line_items));              } else {                console.error('[Apple Pay] Error selecting a shipping contact. ' + response.data.message);                return reject(_this.session.completePaymentMethodSelection(_this.payment_request.total, _this.payment_request.lineItems));              }            });          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.on_shipping_contact_selected = function(event) {        return new Promise((function(_this) {          return function(resolve, reject) {            var data;            data = {              'action': "wc_" + _this.gateway_id + "_apple_pay_recalculate_totals",              'nonce': _this.recalculate_totals_nonce,              'contact': event.shippingContact            };            return $.post(_this.ajax_url, data, function(response) {              if (response.success) {                data = response.data;                return resolve(_this.session.completeShippingContactSelection(ApplePaySession.STATUS_SUCCESS, data.shipping_methods, data.total, data.line_items));              } else {                console.error('[Apple Pay] Error selecting a shipping contact. ' + response.data.message);                return reject(_this.session.completeShippingContactSelection(ApplePaySession.STATUS_FAILURE, [], _this.payment_request.total, _this.payment_request.lineItems));              }            });          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.on_shipping_method_selected = function(event) {        return new Promise((function(_this) {          return function(resolve, reject) {            var data;            data = {              'action': "wc_" + _this.gateway_id + "_apple_pay_recalculate_totals",              'nonce': _this.recalculate_totals_nonce,              'method': event.shippingMethod.identifier            };            return $.post(_this.ajax_url, data, function(response) {              if (response.success) {                data = response.data;                return resolve(_this.session.completeShippingMethodSelection(ApplePaySession.STATUS_SUCCESS, data.total, data.line_items));              } else {                console.error('[Apple Pay] Error selecting a shipping method. ' + response.data.message);                return reject(_this.session.completeShippingMethodSelection(ApplePaySession.STATUS_FAILURE, _this.payment_request.total, _this.payment_request.lineItems));              }            });          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.on_payment_authorized = function(event) {        return this.process_authorization(event.payment).then((function(_this) {          return function(response) {            _this.set_payment_status(true);            return _this.complete_purchase(response);          };        })(this), (function(_this) {          return function(response) {            _this.set_payment_status(false);            return _this.fail_payment('Payment could no be processed. ' + response.message);          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.process_authorization = function(payment) {        return new Promise((function(_this) {          return function(resolve, reject) {            var data;            data = {              action: "wc_" + _this.gateway_id + "_apple_pay_process_payment",              nonce: _this.process_nonce,              payment: JSON.stringify(payment)            };            return $.post(_this.ajax_url, data, function(response) {              if (response.success) {                return resolve(response.data);              } else {                return reject(response.data);              }            });          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.on_cancel_payment = function(event) {        return this.unblock_ui();      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.complete_purchase = function(response) {        return window.location = response.redirect;      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.fail_payment = function(error) {        console.error('[Apple Pay] ' + error);        this.unblock_ui();        return this.render_errors([this.generic_error]);      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.set_payment_status = function(success) {        var status;        if (success) {          status = ApplePaySession.STATUS_SUCCESS;        } else {          status = ApplePaySession.STATUS_FAILURE;        }        return this.session.completePayment(status);      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.reset_payment_request = function(data) {        if (data == null) {          data = {};        }        this.block_ui();        return this.get_payment_request(data).then((function(_this) {          return function(response) {            $(_this.buttons).show();            $(_this.terms).show();            _this.payment_request = $.parseJSON(response);            return _this.unblock_ui();          };        })(this), (function(_this) {          return function(response) {            console.error('[Apple Pay] Could not build payment request. ' + response.message);            $(_this.buttons).hide();            $(_this.terms).hide();            return _this.unblock_ui();          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.get_payment_request = function(data) {        return new Promise((function(_this) {          return function(resolve, reject) {            var base_data;            base_data = {              'action': "wc_" + _this.gateway_id + "_apple_pay_get_payment_request"            };            $.extend(data, base_data);            return $.post(_this.ajax_url, data, function(response) {              if (response.success) {                return resolve(response.data);              } else {                return reject(response.data);              }            });          };        })(this));      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.render_errors = function(errors) {        $('.woocommerce-error, .woocommerce-message').remove();        this.ui_element.prepend('<ul class="woocommerce-error"><li>' + errors.join('</li><li>') + '</li></ul>');        this.ui_element.removeClass('processing').unblock();        return $('html, body').animate({          scrollTop: this.ui_element.offset().top - 100        }, 1000);      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.block_ui = function() {        return this.ui_element.block({          message: null,          overlayCSS: {            background: '#fff',            opacity: 0.6          }        });      };      SV_WC_Apple_Pay_Handler_v5_8_1.prototype.unblock_ui = function() {        return this.ui_element.unblock();      };      return SV_WC_Apple_Pay_Handler_v5_8_1;    })();    return $(document.body).trigger('sv_wc_apple_pay_handler_v5_8_1_loaded');  });}).call(this);