<?php
if(!empty($icon_pack)){
	$icon_html = corretto_elated_icon_collections()->renderIcon($icon, $icon_pack, $params);
} else {
	$icon_html= '';
}

?>
<div class="eltdf-is-item <?php echo esc_attr($showcase_item_class); ?>">
	<?php if ($item_position == 'right' && (!empty($icon) || !empty($custom_icon))) { ?>
		<?php if (!empty($custom_icon)) : ?>
			<div class="eltdf-item-custom-icon-outer">
				<div class="eltdf-item-custom-icon-inner" <?php echo corretto_elated_get_inline_style($icon_attributes= isset($icon_attributes) ? $icon_attributes: '0'); ?>>
					<div class="eltdf-item-custom-icon">
						<?php echo wp_get_attachment_image($custom_icon, 'full'); ?>
						<?php if (!empty($custom_hover_icon)) { ?>
							<span class="eltdf-isi-hover-icon">
							<?php echo wp_get_attachment_image($custom_hover_icon, 'full'); ?>
						</span>
						<?php } ?>
					</div>
				</div>
			</div>
		<?php else: ?>
			<div class="eltdf-item-icon">
				<?php
                echo corretto_elated_get_module_part( $icon_html );
				?>
			</div>
		<?php endif; ?>
	<?php } ?>
	<div class="eltdf-is-content">
		<?php if (!empty($item_title)) { ?>
			<<?php echo esc_attr($item_title_tag); ?> class="eltdf-is-title" <?php echo corretto_elated_get_inline_style($item_title_styles); ?>>
				<?php if (!empty($item_link)) { ?><a href="<?php echo esc_url($item_link); ?>" target="<?php echo esc_attr($item_target); ?>"><?php } ?>
				<?php echo esc_html($item_title); ?>
				<?php if (!empty($item_link)) { ?></a><?php } ?>
			</<?php echo esc_attr($item_title_tag); ?>>
		<?php } ?>
		<?php if (!empty($item_text)) { ?>
			<p class="eltdf-is-text" <?php echo corretto_elated_get_inline_style($item_text_styles); ?>><?php echo esc_html($item_text); ?></p>
		<?php } ?>
	</div>
	<?php if ($item_position == 'left' && (!empty($icon) || !empty($custom_icon))) { ?>
		<?php if (!empty($custom_icon)) : ?>
			<div class="eltdf-item-custom-icon-outer">
				<div class="eltdf-item-custom-icon-inner" <?php echo corretto_elated_get_inline_style($icon_attributes= isset($icon_attributes) ? $icon_attributes: '0'); ?>>
					<div class="eltdf-item-custom-icon">
						<?php echo wp_get_attachment_image($custom_icon, 'full'); ?>
						<?php if (!empty($custom_hover_icon)) { ?>
							<span class="eltdf-isi-hover-icon">
								<?php echo wp_get_attachment_image($custom_hover_icon, 'full'); ?>
							</span>
						<?php } ?>
					</div>
				</div>
			</div>
		<?php else: ?>
			<div class="eltdf-item-icon">
				<?php
                echo corretto_elated_get_module_part( $icon_html );
				?>
			</div>
		<?php endif; ?>
	<?php } ?>
</div>