<?php

if ( ! function_exists( 'corretto_elated_dropdown_cart_icon_styles' ) ) {
	/**
	 * Generates styles for dropdown cart icon
	 */
	function corretto_elated_dropdown_cart_icon_styles() {
		$icon_color       = corretto_elated_options()->getOptionValue( 'dropdown_cart_icon_color' );
		$icon_hover_color = corretto_elated_options()->getOptionValue( 'dropdown_cart_hover_color' );
		
		if ( ! empty( $icon_color ) ) {
			echo corretto_elated_dynamic_css( '.eltdf-shopping-cart-holder .eltdf-header-cart a', array( 'color' => $icon_color ) );
		}
		
		if ( ! empty( $icon_hover_color ) ) {
			echo corretto_elated_dynamic_css( '.eltdf-shopping-cart-holder .eltdf-header-cart a:hover', array( 'color' => $icon_hover_color ) );
		}
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_dropdown_cart_icon_styles' );
}