<?php

if ( ! function_exists( 'corretto_elated_get_hide_dep_for_header_standard_options' ) ) {
	function corretto_elated_get_hide_dep_for_header_standard_options() {
		$hide_dep_options = apply_filters( 'corretto_elated_header_standard_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'corretto_elated_header_standard_map' ) ) {
	function corretto_elated_header_standard_map( $parent ) {
		$hide_dep_options = corretto_elated_get_hide_dep_for_header_standard_options();
		
		corretto_elated_add_admin_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'set_menu_area_position',
				'default_value'   => 'right',
				'label'           => esc_html__( 'Choose Menu Area Position', 'corretto' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'corretto' ),
				'options'         => array(
					'right'  => esc_html__( 'Right', 'corretto' ),
					'left'   => esc_html__( 'Left', 'corretto' ),
					'center' => esc_html__( 'Center', 'corretto' )
				),
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'corretto_elated_additional_header_menu_area_options_map', 'corretto_elated_header_standard_map' );
}