<?php

if ( ! function_exists( 'corretto_elated_get_hide_dep_for_header_logo_area_meta_boxes' ) ) {
	function corretto_elated_get_hide_dep_for_header_logo_area_meta_boxes() {
		$hide_dep_options = apply_filters( 'corretto_elated_header_logo_area_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'corretto_elated_get_hide_dep_for_header_logo_area_widgets_meta_boxes' ) ) {
	function corretto_elated_get_hide_dep_for_header_logo_area_widgets_meta_boxes() {
		$hide_dep_options = apply_filters( 'corretto_elated_header_logo_area_widgets_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'corretto_elated_header_logo_area_meta_options_map' ) ) {
	function corretto_elated_header_logo_area_meta_options_map( $header_meta_box ) {
		$hide_dep_options = corretto_elated_get_hide_dep_for_header_logo_area_meta_boxes();
		$hide_dep_widgets = corretto_elated_get_hide_dep_for_header_logo_area_widgets_meta_boxes();
		
		$logo_area_container = corretto_elated_add_admin_container_no_style(
			array(
				'type'            => 'container',
				'name'            => 'logo_area_container',
				'parent'          => $header_meta_box,
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
		
		corretto_elated_add_admin_section_title(
			array(
				'parent' => $logo_area_container,
				'name'   => 'logo_area_style',
				'title'  => esc_html__( 'Logo Area Style', 'corretto' )
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_disable_header_widget_logo_area_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Header Logo Area Widget', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will hide widget area from the logo area', 'corretto' ),
				'parent'        => $logo_area_container,
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta' => $hide_dep_widgets
					)
				)
			)
		);
		
		$corretto_custom_sidebars = corretto_elated_get_custom_sidebars();
		if ( count( $corretto_custom_sidebars ) > 0 ) {
			corretto_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_custom_logo_area_sidebar_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Custom Widget Area for Logo Area', 'corretto' ),
					'description' => esc_html__( 'Choose custom widget area to display in header logo area"', 'corretto' ),
					'parent'      => $logo_area_container,
					'options'     => $corretto_custom_sidebars,
					'dependency' => array(
						'hide' => array(
							'eltdf_header_type_meta' => $hide_dep_widgets
						)
					)
				)
			);
		}
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_logo_area_in_grid_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Logo Area In Grid', 'corretto' ),
				'description'   => esc_html__( 'Set menu area content to be in grid', 'corretto' ),
				'parent'        => $logo_area_container,
				'default_value' => '',
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
		$logo_area_in_grid_container = corretto_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'logo_area_in_grid_container',
				'parent'          => $logo_area_container,
				'dependency' => array(
					'show' => array(
						'eltdf_logo_area_in_grid_meta'  => 'yes'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_logo_area_grid_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Grid Background Color', 'corretto' ),
				'description' => esc_html__( 'Set grid background color for logo area', 'corretto' ),
				'parent'      => $logo_area_in_grid_container
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_logo_area_grid_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Grid Background Transparency', 'corretto' ),
				'description' => esc_html__( 'Set grid background transparency for logo area (0 = fully transparent, 1 = opaque)', 'corretto' ),
				'parent'      => $logo_area_in_grid_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_logo_area_in_grid_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Border', 'corretto' ),
				'description'   => esc_html__( 'Set border on grid logo area', 'corretto' ),
				'parent'        => $logo_area_in_grid_container,
				'default_value' => '',
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
		$logo_area_in_grid_border_container = corretto_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'logo_area_in_grid_border_container',
				'parent'          => $logo_area_in_grid_container,
				'dependency' => array(
					'show' => array(
						'eltdf_logo_area_in_grid_border_meta'  => 'yes'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_logo_area_in_grid_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'corretto' ),
				'description' => esc_html__( 'Set border color for grid area', 'corretto' ),
				'parent'      => $logo_area_in_grid_border_container
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_logo_area_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'corretto' ),
				'description' => esc_html__( 'Choose a background color for logo area', 'corretto' ),
				'parent'      => $logo_area_container
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_logo_area_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Transparency', 'corretto' ),
				'description' => esc_html__( 'Choose a transparency for the logo area background color (0 = fully transparent, 1 = opaque)', 'corretto' ),
				'parent'      => $logo_area_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_logo_area_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Logo Area Border', 'corretto' ),
				'description'   => esc_html__( 'Set border on logo area', 'corretto' ),
				'parent'        => $logo_area_container,
				'default_value' => '',
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
		$logo_area_border_bottom_color_container = corretto_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'logo_area_border_bottom_color_container',
				'parent'          => $logo_area_container,
				'dependency' => array(
					'show' => array(
						'eltdf_logo_area_border_meta'  => 'yes'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_logo_area_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'corretto' ),
				'description' => esc_html__( 'Choose color of header bottom border', 'corretto' ),
				'parent'      => $logo_area_border_bottom_color_container
			)
		);
		
		do_action( 'corretto_elated_header_logo_area_additional_meta_boxes_map', $logo_area_container );
	}
	
	add_action( 'corretto_elated_header_logo_area_meta_boxes_map', 'corretto_elated_header_logo_area_meta_options_map', 10, 1 );
}