<?php

if ( ! function_exists( 'corretto_elated_footer_top_general_styles' ) ) {
	/**
	 * Generates general custom styles for footer top area
	 */
	function corretto_elated_footer_top_general_styles() {
		$item_styles      = array();
		$background_color = corretto_elated_options()->getOptionValue( 'footer_top_background_color' );
		$background_image = corretto_elated_options()->getOptionValue( 'footer_top_background_image' );

		if ( ! empty( $background_color ) ) {
			$item_styles['background-color'] = $background_color;
		}

		if ( ! empty( $background_image ) ) {
			$item_styles['background-image'] = 'url(' . $background_image . ');';
			$item_styles['background-size'] = 'cover';
			$item_styles['background-position'] = 'center';
		}
		
		echo corretto_elated_dynamic_css( '.eltdf-page-footer .eltdf-footer-top-holder', $item_styles );
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_footer_top_general_styles' );
}

if ( ! function_exists( 'corretto_elated_footer_bottom_general_styles' ) ) {
	/**
	 * Generates general custom styles for footer bottom area
	 */
	function corretto_elated_footer_bottom_general_styles() {
		$item_styles      = array();
		$background_color = corretto_elated_options()->getOptionValue( 'footer_bottom_background_color' );
		
		if ( ! empty( $background_color ) ) {
			$item_styles['background-color'] = $background_color;
		}
		
		echo corretto_elated_dynamic_css( '.eltdf-page-footer .eltdf-footer-bottom-holder', $item_styles );
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_footer_bottom_general_styles' );
}