<?php

if ( ! function_exists( 'corretto_elated_map_post_video_meta' ) ) {
	function corretto_elated_map_post_video_meta() {
		$video_post_format_meta_box = corretto_elated_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'corretto' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'corretto' ),
				'description'   => esc_html__( 'Choose video type', 'corretto' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'corretto' ),
					'self'            => esc_html__( 'Self Hosted', 'corretto' )
				)
			)
		);
		
		$eltdf_video_embedded_container = corretto_elated_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'eltdf_video_embedded_container'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'corretto' ),
				'description' => esc_html__( 'Enter Video URL', 'corretto' ),
				'parent'      => $eltdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'corretto' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'corretto' ),
				'parent'      => $eltdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_video_type_meta' => 'self'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'corretto' ),
				'description' => esc_html__( 'Enter video image', 'corretto' ),
				'parent'      => $eltdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_elated_map_post_video_meta', 22 );
}