<?php
class WC_Purolator_Order {
	public function __construct() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
		add_filter( 'woocommerce_admin_order_actions', array( $this, 'add_order_actions' ), 1, 2 );
		add_action( 'woocommerce_admin_order_totals_after_shipping', array( $this, 'admin_order_totals_after_shipping' ) );
	}

	public function admin_scripts() {
		$screen_id = get_current_screen();

		if ( 'edit-shop_order' === $screen_id->id ) {
			wp_enqueue_style('purolator_css', plugins_url( 'woocommerce-shipping-purolator/assets/css/purolator.css' ), array(), WC_SHIPPING_PUROLATOR_VERSION );
		}
	}

	public function admin_order_totals_after_shipping( $order_id ){
		$the_order = wc_get_order( $order_id );

		if( stripos( ( version_compare( WC_VERSION, '3.0', '<' ) ? $the_order->shipping_method : $the_order->get_shipping_method() ), 'purolator') === FALSE )
			return;

		$puro = get_post_meta( $order_id, "_purolator", true );

		if( $puro && isset( $puro[ 'tracking_number' ] ) && !empty( $puro[ 'tracking_number' ] ) ){

			add_thickbox();

			echo('<div class="clear"></div><h4 style="padding-bottom:10px;"><a href="' . wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-get-tracking&tracking_number=' . $puro[ 'tracking_number' ] ), 'woocommerce-purolator-get-tracking' ) . '" class="track_package">' . __( 'Track Purolator package', 'woocommerce-shipping-purolator' ) . '</a></h4>');

			echo('<div class="clear"></div><h4 style="padding-bottom:10px;"><a href="' . wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-void-shipment&tracking_number=' . $puro[ 'tracking_number' ] . '&order_id=' . $order_id ), 'woocommerce-purolator-void-shipment' ) . '" class="void_shipment">' . __( 'Void Purolator shipment', 'woocommerce-shipping-purolator' ) . '</a></h4>');

		}else{

			echo('<div class="clear"></div><h4 style="padding-bottom:10px;"><a href="' . wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-get-label&order_id=' . $order_id ), 'woocommerce-purolator-get-label' ) . '" target="_blank">' . __( 'Print Purolator label', 'woocommerce-shipping-purolator' ) . '</a></h4>');

		}
	}

	public function add_order_actions( $actions, $the_order ) {
		$has_method = false;
	    $shipping_methods = $the_order->get_shipping_methods();

		if ( $shipping_methods ){
			foreach ( $shipping_methods as $shipping_method ) {
				if ( stripos( $shipping_method['method_id'], 'purolator') !== FALSE )
					$has_method = true;
			}
		}

		if ( ! $has_method ) {
			return $actions;
		}

		$order_id = version_compare( WC_VERSION, '3.0.0', '<' ) ? $the_order->id : $the_order->get_id();

		$puro = get_post_meta( $order_id, "_purolator", true );
		$label_creation_date = get_post_meta( $order_id, "_label_creation_date", true );

		if ( ! $label_creation_date ) {
			$label_creation_date = strtotime( version_compare( WC_VERSION, '3.0.0', '<' ) ? $the_order->order_date : $the_order->get_date_created() );
		}

		if ( $puro && isset( $puro[ 'tracking_number' ] ) && !empty( $puro[ 'tracking_number' ] ) ) {

			$now = time();
			$datediff = $now - $label_creation_date;

			if( floor( $datediff / ( 60 * 60 * 24 ) ) <= 2 ) {
				$actions['label'] = array(
					'url' 		=> wp_nonce_url( admin_url( 'admin-ajax.php?action=process_purolator_get_documents&order_id=' . $order_id ), 'woocommerce-purolator-get-tracking' ),
					'name' 		=> __( 'Print Purolator label', 'woocommerce-shipping-purolator' ),
					'action' 	=> 'print_label'				);
			}

			$actions['track'] = array(
				'url' 		=> wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-get-tracking&tracking_number=' . $puro[ 'tracking_number' ] ), 'woocommerce-purolator-get-tracking' ),
				'name' 		=> __( 'Track Purolator package', 'woocommerce-shipping-purolator' ),
				'action' 	=> 'track_package'			);

			$actions['void_shipment'] = array(
				'url' 		=> wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-void-shipment&height=100&width=200&tracking_number=' . $puro[ 'tracking_number' ] . '&order_id=' . $order_id ), 'woocommerce-purolator-void-shipment' ),
				'name' 		=> __( 'Void Purolator shipment', 'woocommerce-shipping-purolator' ),
				'action' 	=> 'void_shipment'			);

		}else{

			$actions['label'] = array(
				'url' 		=> wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-get-label&order_id=' . $order_id ), 'woocommerce-purolator-get-label' ),
				'name' 		=> __( 'Print Purolator label', 'woocommerce-shipping-purolator' ),
				'action' 	=> 'print_label'			);

		}

		return $actions;

	}
}

new WC_Purolator_Order();
