<?php
/**
 * WC_Shipping_Purolator class deprecated.
 *
 * This class serves only WC < 2.6 and will be removed by WC 3.1
 * @extends WC_Shipping_Method
 */
class WC_Shipping_Purolator extends WC_Shipping_Method {

	//Estimating WSDL and URL's
	public $soap_dev_location = 'https://devwebservices.purolator.com/PWS/V1/Estimating/EstimatingService.asmx';

	public $soap_prod_location = 'https://webservices.purolator.com/PWS/V1/Estimating/EstimatingService.asmx';

	public $wsdl_dev_path = 'wsdl/ws_estimate/Development/EstimatingService.wsdl';

	public $wsdl_prod_path = 'wsdl/ws_estimate/Production/EstimatingService.wsdl';

	//Availability WSDL and URL's
	public $soap_availability_dev_location = 'https://devwebservices.purolator.com/PWS/V1/ServiceAvailability/ServiceAvailabilityService.asmx';

	public $soap_availability_prod_location = 'https://webservices.purolator.com/PWS/V1/ServiceAvailability/ServiceAvailabilityService.asmx';

	public $wsdl_availability_dev_path = 'wsdl/ws_availability/Development/ServiceAvailabilityService.wsdl';

	public $wsdl_availability_prod_path = 'wsdl/ws_availability/Production/ServiceAvailabilityService.wsdl';

	//Shipment WSDL and URL's
	public $soap_shipment_dev_location = 'https://devwebservices.purolator.com/PWS/V1/Shipping/ShippingService.asmx';

	public $soap_shipment_prod_location = 'https://webservices.purolator.com/PWS/V1/Shipping/ShippingService.asmx';

	public $wsdl_shipment_dev_path = 'wsdl/ws_shipment/Development/ShippingService.wsdl';

	public $wsdl_shipment_prod_path = 'wsdl/ws_shipment/Production/ShippingService.wsdl';

	//Shipment WSDL and URL's
	public $soap_getdocuments_dev_location = 'https://devwebservices.purolator.com/PWS/V1/ShippingDocuments/ShippingDocumentsService.asmx';

	public $soap_getdocuments_prod_location = 'https://webservices.purolator.com/PWS/V1/ShippingDocuments/ShippingDocumentsService.asmx';

	public $wsdl_getdocuments_dev_path = 'wsdl/ws_getdocuments/Development/ShippingDocumentsService.wsdl';

	public $wsdl_getdocuments_prod_path = 'wsdl/ws_getdocuments/Production/ShippingDocumentsService.wsdl';

	//Tracking WSDL and URL's
	public $soap_tracking_dev_location = 'https://devwebservices.purolator.com/PWS/V1/Tracking/TrackingService.asmx';

	public $soap_tracking_prod_location = 'https://webservices.purolator.com/PWS/V1/Tracking/TrackingService.asmx';

	public $wsdl_tracking_dev_path = 'wsdl/ws_tracking/Development/TrackingService.wsdl';

	public $wsdl_tracking_prod_path = 'wsdl/ws_tracking/Production/TrackingService.wsdl';

	//Purolator URL
	public $uri = 'http://purolator.com/pws/datatypes/v1';

	public $class_path;

	private $key = '';
	private $pass = '';

	private $request;

	private $soap_extension = false;

	private $boxes;

	private $total_weight = 0;
	private $total_count = 0;
	private $pieces_information;

	public function __construct() {
		global $woocommerce;

		$this->id = 'purolator';
		$this->title = __( 'Purolator', 'woocommerce-shipping-purolator' );
		$this->method_title = __( 'Purolator', 'woocommerce-shipping-purolator' );

		$this->wsdl_dev_path = plugin_dir_path(__FILE__).$this->wsdl_dev_path;
		$this->wsdl_prod_path = plugin_dir_path(__FILE__).$this->wsdl_prod_path;

		$this->wsdl_availability_dev_path = plugin_dir_path(__FILE__).$this->wsdl_availability_dev_path;
		$this->wsdl_availability_prod_path = plugin_dir_path(__FILE__).$this->wsdl_availability_prod_path;

		// Load the form fields.
		$this->init_form_fields();

		// Load the settings.
		$this->init_settings();

		if((!isset($this->settings['origin_postalcode']) || empty($this->settings['origin_postalcode'])) && isset($this->settings['origin'])){
			$this->settings['origin_postalcode'] = $this->settings['origin'];
		}

		if( !isset($this->settings['development_key']) && isset($this->settings['production_key']) ){
			$this->settings['development_key'] = $this->settings['production_key'];
		}

		if( !isset($this->settings['development_pass']) && isset($this->settings['production_pass']) ){
			$this->settings['development_pass'] = $this->settings['production_pass'];
		}

		$this->enabled				= isset( $this->settings['enabled'] ) ? $this->settings['enabled'] : 'no';
		$this->availability			= isset( $this->settings['availability'] ) ? $this->settings['availability'] : 'all';
		$this->contact_name			= isset($this->settings['contact_name'])?$this->settings['contact_name']:'';
		$this->origin_street_number = isset($this->settings['origin_street_number'])?$this->settings['origin_street_number']:'';
		$this->origin_street_name	= isset($this->settings['origin_street_name'])?$this->settings['origin_street_name']:'';
		$this->origin_city			= isset($this->settings['origin_city'])?$this->settings['origin_city']:'';
		$this->origin_province		= isset( $this->settings['origin_province'] ) ? $this->settings['origin_province'] : $woocommerce->countries->get_base_state();
		$this->origin_postalcode	= isset($this->settings['origin_postalcode'])?$this->settings['origin_postalcode']:'';
		$this->origin_country		= $woocommerce->countries->get_base_country();
		$this->countries			= isset( $this->settings['countries'] ) ? $this->settings['countries'] : array();
		$this->country_code			= isset( $this->settings['country_code'] ) && ! empty( $this->settings['country_code'] ) ? $this->settings['country_code'] : '1';
		$this->area_code			= isset( $this->settings['area_code'] ) && ! empty( $this->settings['area_code'] ) ? $this->settings['area_code'] : '877';
		$this->phone_number			= isset( $this->settings['phone_number'] ) && ! empty( $this->settings['phone_number'] ) ? $this->settings['phone_number'] : '222-2222';
		$this->fee					= isset( $this->settings['fee'] ) ? $this->settings['fee'] : '';
		$this->fee_to_ship			= isset( $this->settings['fee_to_ship'] ) ? ($this->settings['fee_to_ship']=='yes'?true:false) : false;
		$this->production_key		= isset( $this->settings['production_key'] ) ? $this->settings['production_key'] : '';
		$this->pay_shipping_amount	= isset( $this->settings['pay_shipping_amount'] ) ? $this->settings['pay_shipping_amount'] : '';
		$this->production_pass		= isset( $this->settings['production_pass'] ) ? $this->settings['production_pass'] : '';
		$this->development_key		= isset( $this->settings['development_key'] ) ? $this->settings['development_key'] : '';
		$this->development_pass		= isset( $this->settings['development_pass'] ) ? $this->settings['development_pass'] : '';
		$this->billing_account		= isset( $this->settings['billing_account'] ) ? $this->settings['billing_account'] : '';
		$this->shipping_methods		= isset( $this->settings['shipping_methods'] ) ? $this->settings['shipping_methods'] : array();
		$this->multiple_rates		= true;
		$this->rates				= array();
		$this->debug				= isset( $this->settings['debug'] ) ? ($this->settings['debug']=='yes'?true:false) : false;
		$this->soap_method			= isset( $this->settings['soap_method'] ) ? $this->settings['soap_method'] : 'auto';
		$this->test_mode			= isset( $this->settings['test_mode'] ) ? ($this->settings['test_mode']=='yes'?true:false) : false;
		$this->show_date			= isset( $this->settings['show_date'] ) ? ($this->settings['show_date']=='yes'?true:false) : false;
		$this->declare_value		= isset($this->settings['declare_value']) ? ($this->settings['declare_value']=='yes'?true:false):true;
		$this->need_signature		= isset($this->settings['need_signature']) ? ($this->settings['need_signature']=='yes'?true:false):false;
		$this->handling_time		= isset( $this->settings['handling_time'] ) ? $this->settings['handling_time'] : '';
		$this->delivery_date_sprint	= isset( $this->settings['delivery_date_sprint'] ) ? $this->settings['delivery_date_sprint'] : '';
		$this->delivery_date_format	= isset( $this->settings['delivery_date_format'] ) ? $this->settings['delivery_date_format'] : '';
		$this->packing_method		= isset( $this->settings['packing_method'] ) ? $this->settings['packing_method'] : 'per_item';
		$this->printer_type			= isset( $this->settings['printer_type'] ) ? $this->settings['printer_type'] : 'Regular';
		$this->auto_create_label	= isset( $this->settings['auto_create_label'] ) && $this->settings['auto_create_label'] == 'yes' ? true : false;

		$this->boxes				= isset( $this->settings['boxes'] ) ? $this->settings['boxes'] : array();

		// Used for weight based packing only
		$this->max_weight = '150';

		$this->class_path = plugin_dir_path( __FILE__ );

		if( $this->test_mode ){
			$this->key							= $this->development_key;
			$this->pass							= $this->development_pass;
			$this->soap_location				= $this->soap_dev_location;
			$this->wsdl_path					= $this->wsdl_dev_path;
			$this->soap_availability_location	= $this->soap_availability_dev_location;
			$this->wsdl_availability_path		= $this->wsdl_availability_dev_path;
			$this->soap_shipment_location		= $this->soap_shipment_dev_location;
			$this->wsdl_shipment_path			= $this->wsdl_shipment_dev_path;
			$this->soap_getdocuments_location	= $this->soap_getdocuments_dev_location;
			$this->wsdl_getdocuments_path		= $this->wsdl_getdocuments_dev_path;
			$this->soap_tracking_location		= $this->soap_tracking_dev_location;
			$this->wsdl_tracking_path			= $this->wsdl_tracking_dev_path;
		}else{
			$this->key							= $this->production_key;
			$this->pass							= $this->production_pass;
			$this->soap_location				= $this->soap_prod_location;
			$this->wsdl_path					= $this->wsdl_prod_path;
			$this->soap_availability_location	= $this->soap_availability_prod_location;
			$this->wsdl_availability_path		= $this->wsdl_availability_prod_path;
			$this->soap_shipment_location		= $this->soap_shipment_prod_location;
			$this->wsdl_shipment_path			= $this->wsdl_shipment_prod_path;
			$this->soap_getdocuments_location	= $this->soap_getdocuments_prod_location;
			$this->wsdl_getdocuments_path		= $this->wsdl_getdocuments_prod_path;
			$this->soap_tracking_location		= $this->soap_tracking_prod_location;
			$this->wsdl_tracking_path			= $this->wsdl_tracking_prod_path;
		}

		// When a method has more than one cost/choice it will be in this array of titles/costs
		$this->shipping_type = array(
			"PurolatorGround"                               =>  "Purolator Ground",
			"PurolatorGroundU.S."                           =>  "Purolator Ground U.S.",
			"PurolatorExpress"                              =>  "Purolator Express",
			"PurolatorExpressU.S."                          =>  "Purolator Express U.S.",
			"PurolatorExpressInternational"                 =>  "Purolator Express International",
			"PurolatorExpressPackU.S."                      =>  "Purolator Express Pack U.S.",
			"PurolatorExpressU.S.Pack9AM"                   =>  "Purolator Express U.S.Pack 9AM",
			"PurolatorExpressU.S.Pack10:30AM"               =>  "Purolator Express U.S.Pack 10:30AM",
			"PurolatorExpress9AM"                           =>  "Purolator Express 9AM",
			"PurolatorExpress10:30AM"                       =>  "Purolator Express 10:30AM",
			"PurolatorExpressEvening"                       =>  "Purolator Express Evening",
			"PurolatorExpressEnvelope9AM"                   =>  "Purolator Express Envelope 9AM",
			"PurolatorExpressEnvelope10:30AM"               =>  "Purolator Express Envelope 10:30AM",
			"PurolatorExpressEnvelope"                      =>  "Purolator Express Envelope",
			"PurolatorExpressEnvelopeEvening"               =>  "Purolator Express Envelope Evening",
			"PurolatorExpressPack9AM"                       =>  "Purolator Express Pack 9AM",
			"PurolatorExpressPack10:30AM"                   =>  "Purolator Express Pack 10:30AM",
			"PurolatorExpressPack"                          =>  "Purolator Express Pack",
			"PurolatorExpressPackEvening"                   =>  "Purolator Express Pack Evening",
			"PurolatorExpressBox9AM"                        =>  "Purolator Express Box 9AM",
			"PurolatorExpressBox10:30AM"                    =>  "Purolator Express Box 10:30AM",
			"PurolatorExpressBox"                           =>  "Purolator Express Box",
			"PurolatorExpressBoxEvening"                    =>  "Purolator Express Box Evening",
			"PurolatorGround9AM"                            =>  "Purolator Ground 9AM",
			"PurolatorGround10:30AM"                        =>  "Purolator Ground 10:30AM",
			"PurolatorGroundEvening"                        =>  "Purolator Ground Evening",
			"PurolatorExpressU.S.9AM"                       =>  "Purolator Express U.S. 9AM",
			"PurolatorExpressU.S.10:30AM"                   =>  "Purolator Express U.S. 10:30AM",
			"PurolatorExpressU.S.12:00"                     =>  "Purolator Express U.S. 12:00",
			"PurolatorExpressEnvelopeU.S."                  =>  "Purolator Express Envelope U.S.",
			"PurolatorExpressU.S.Envelope9AM"               =>  "Purolator Express U.S. Envelope 9AM",
			"PurolatorExpressU.S.Envelope10:30AM"           =>  "Purolator Express U.S. Envelope 10:30AM",
			"PurolatorExpressU.S.Envelope12:00"             =>  "Purolator Express U.S. Envelope 12:00",
			"PurolatorExpressU.S.Pack12:00"                 =>  "Purolator Express U.S. Pack 12:00",
			"PurolatorExpressBoxU.S."                       =>  "Purolator Express Box U.S.",
			"PurolatorExpressU.S.Box9AM"                    =>  "Purolator Express U.S.Box 9AM",
			"PurolatorExpressU.S.Box10:30AM"                =>  "Purolator Express U.S.Box 10:30AM",
			"PurolatorExpressU.S.Box12:00"                  =>  "Purolator Express U.S.Box 12:00",
			"PurolatorExpressInternational9AM"              =>  "Purolator Express International 9AM",
			"PurolatorExpressInternational10:30AM"          =>  "Purolator Express International 10:30AM",
			"PurolatorExpressInternational12:00"            =>  "Purolator Express International 12:00",
			"PurolatorExpressEnvelopeInternational"         =>  "Purolator Express Envelope International",
			"PurolatorExpressInternationalEnvelope9AM"      =>  "Purolator Express International Envelope 9AM",
			"PurolatorExpressInternationalEnvelope10:30AM"  =>  "Purolator Express International Envelope 10:30AM",
			"PurolatorExpressInternationalEnvelope12:00"    =>  "Purolator Express International Envelope 12:00",
			"PurolatorExpressPackInternational"             =>  "Purolator Express Pack International",
			"PurolatorExpressInternationalPack9AM"          =>  "Purolator Express International Pack 9AM",
			"PurolatorExpressInternationalPack10:30AM"      =>  "Purolator Express International Pack 10:30AM",
			"PurolatorExpressInternationalPack12:00"        =>  "Purolator Express International Pack 12:00",
			"PurolatorExpressBoxInternational"              =>  "Purolator Express Box International",
			"PurolatorExpressInternationalBox9AM"           =>  "Purolator Express InternationalBox 9AM",
			"PurolatorExpressInternationalBox10:30AM"       =>  "Purolator Express InternationalBox 10:30AM",
			"PurolatorExpressInternationalBox12:00"         =>  "Purolator Express InternationalBox 12:00",
			"PurolatorGroundDistribution"                   =>  "Purolator Ground Distribution"
		);

		$this->form_fields['shipping_methods']['options'] = $this->shipping_type;

		if (sizeof($this->shipping_methods) == 0) {
			$this->shipping_methods = array_keys($this->shipping_type);
		}

		add_action( 'woocommerce_update_options_shipping_' . $this->id, array( &$this, 'process_admin_options' ) );

		global $wpdb;

		$wpdb->query( "DELETE FROM `$wpdb->options` WHERE `option_name` LIKE ('_transient_shipping_" . $this->id . "_%') OR `option_name` LIKE ('_transient_wc_ship_%')" );

		add_action( 'admin_notices', array( $this, 'check_notices' ) );

		add_filter( 'woocommerce_admin_order_actions', array( $this, 'add_order_actions' ), 1, 2 );

		add_action( 'woocommerce_admin_order_totals_after_shipping', array( $this, 'admin_order_totals_after_shipping' ) );
	
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );

		add_action( 'woocommerce_email_order_meta_keys', array( $this, 'email_order_meta_keys' ), 10, 2 );

		add_action( 'woocommerce_order_status_on-hold', array( $this, 'order_status_onhold' ) );

		add_action( 'woocommerce_product_data_panels', array( $this, 'product_data_panels' ) );

		add_filter( 'woocommerce_product_data_tabs', array( $this, 'product_data_tabs' ), 1 );

		if(class_exists('SoapClient') && class_exists('SoapHeader') && $this->soap_method != 'nusoap'){
			$this->soap_extension = true;
			$this->add_notice('Use native SoapHeader extension.<br />');
		}else{
			require_once('nusoap/lib/nusoap.php');
			$this->add_notice('Use nusoap extension.<br />');
		}
	}

	public function admin_scripts(){

		global $woocommerce;
		if (version_compare($woocommerce->version, '2.1.0') >= 0) {
			wp_register_style('purolator_css', plugins_url('woocommerce-shipping-purolator/assets/css/purolator.css'), array(), '1.0.1');
			wp_enqueue_style('purolator_css');
		}

		wp_register_script('purolator_writepanel', plugins_url('woocommerce-shipping-purolator/assets/js/purolator.writepanel.js'), array('jquery'));
		wp_enqueue_script('purolator_writepanel');
		echo('<script type="text/javascript">var purolabel = "' . __( 'Print Purolator label', 'woocommerce-shipping-purolator' ) . '"; var purotracking = "' . __( 'Track Purolator package', 'woocommerce-shipping-purolator' ) . '";var purovoid = "' . __( 'Void Purolator shipment', 'woocommerce-shipping-purolator' ) . '";</script>');
	}

	/**
	 * Display a notice if we don't have a origin city or province selected.
	 * @return void
	 */
	public function check_notices() {
		if ( empty( $this->origin_city ) || empty( $this->origin_province ) ) {
			$settings_url = add_query_arg(
				array(
					'page' => 'wc-settings',
					'tab' => 'shipping',
					'section' => 'wc_shipping_purolator',
				),
				admin_url( 'admin.php' )
			);

			$message = wp_kses( sprintf( __( 'You must enter your <a href="%s">origin city and province</a> before you can use Purolator shipping.' , 'woocommerce-shipping-purolator' ), esc_url( $settings_url ) ), array( 'a' => array( 'href' => array() ) ) );

			echo '<div class="updated fade"><p>' . $message . '</p></div>' . "\n";
		}
	}

	private function add_notice( $message, $notice_type = 'notice' ){
		global $woocommerce;

		if ( ! $this->debug || 'yes' !== $this->enabled || is_admin() ) {
			return false;
		}

		if ( version_compare( $woocommerce->version, '2.1.0' ) >= 0 ) {
		    wc_add_notice( $message, $notice_type );
		} else {
			switch ( $notice_type ) {
				case 'success':
					$woocommerce->add_message( $message );
					break;
				case 'error':
					$woocommerce->add_error( $message );
					break;
			}
		}

	}

	public function add_order_actions( $actions, $the_order ) {

		global $woocommerce;

		$has_method = false;
	    $shipping_methods = $the_order->get_shipping_methods();

		if ( $shipping_methods ){
			foreach ( $shipping_methods as $shipping_method ) {
				if ( stripos( $shipping_method['method_id'], 'purolator') !== FALSE )
					$has_method = true;
			}
		}

		if ( ! $has_method ) {
			return $actions;
		}

		$puro = get_post_meta( $the_order->id, "_purolator", true );
		$label_creation_date = get_post_meta( $the_order->id, "_label_creation_date", true );

		if ( ! $label_creation_date ) {
			$label_creation_date = strtotime( $the_order->order_date );
		}

		if ( $puro && isset( $puro[ 'tracking_number' ] ) && !empty( $puro[ 'tracking_number' ] ) ) {

			add_thickbox();

			$now = time();
			$datediff = $now - $label_creation_date;

			if( floor( $datediff / ( 60 * 60 * 24 ) ) <= 2 )
				$actions['label'] = array(
					'url' 		=> wp_nonce_url( admin_url( 'admin-ajax.php?action=process_purolator_get_documents&order_id=' . $the_order->id ), 'woocommerce-purolator-get-tracking' ),
					'name' 		=> __( 'Print Purolator label', 'woocommerce-shipping-purolator' ),
					'action' 	=> "print_label",
					'image_url'	=> plugin_dir_url( __FILE__ ) . 'assets/images/icons/print.png'
				);

			$actions['track'] = array(
				'url' 		=> wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-get-tracking&tracking_number=' . $puro[ 'tracking_number' ] ), 'woocommerce-purolator-get-tracking' ),
				'name' 		=> __( 'Track Purolator package', 'woocommerce-shipping-purolator' ),
				'action' 	=> "track_package",
				'image_url'	=> plugin_dir_url( __FILE__ ) . 'assets/images/icons/track.png'
			);

			$actions['void_shipment'] = array(
				'url' 		=> wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-void-shipment&height=100&width=200&tracking_number=' . $puro[ 'tracking_number' ] . '&order_id=' . $the_order->id ), 'woocommerce-purolator-void-shipment' ),
				'name' 		=> __( 'Void Purolator shipment', 'woocommerce-shipping-purolator' ),
				'action' 	=> "void_shipment",
				'image_url'	=> plugin_dir_url( __FILE__ ) . 'assets/images/icons/cancel.png'
			);

		}else{

			$actions['label'] = array(
				'url' 		=> wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-get-label&order_id=' . $the_order->id ), 'woocommerce-purolator-get-label' ),
				'name' 		=> __( 'Print Purolator label', 'woocommerce-shipping-purolator' ),
				'action' 	=> "print_label",
				'image_url'	=> plugin_dir_url( __FILE__ ) . 'assets/images/icons/print.png'
			);

		}

		return $actions;

	}

	public function email_order_meta_keys( $show_fields, $sent_to_admin ) {

		if ( ! $sent_to_admin ) {
			return $show_fields;
		}

		$show_fields[] = 'Purolator Label Link';

		return $show_fields;

	}

	public function order_status_onhold( $order_id ){

		$order = wc_get_order( $order_id );

		if ( method_exists( $order, 'has_shipping_method' ) ) {

			$shipping_methods = $order->get_shipping_methods();

			$is_purolator = false;

			if ( ! $shipping_methods ) {
				return ;
			}

			foreach ( $shipping_methods as $shipping_method ) {
				if ( strpos( $shipping_method['method_id'], $this->id ) !== false ) {
					$is_purolator = true;
				}
			}

		} else {
			$is_purolator = strpos( $order->shipping_method, $this->id ) !== false;
		}

		if ( $this->auto_create_label && $is_purolator ) {

			$return = $this->process_label( $order_id );

		}

	}
	public function admin_order_totals_after_shipping( $order_id ){

		$the_order = wc_get_order( $order_id );

		if( stripos( $the_order->shipping_method, 'purolator') === FALSE )
			return;

		$puro = get_post_meta( $the_order->id, "_purolator", true );

		if( $puro && isset( $puro[ 'tracking_number' ] ) && !empty( $puro[ 'tracking_number' ] ) ){

			add_thickbox();

			echo('<div class="clear"></div><h4 style="padding-bottom:10px;"><a href="' . wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-get-tracking&tracking_number=' . $puro[ 'tracking_number' ] ), 'woocommerce-purolator-get-tracking' ) . '" class="track_package">' . __( 'Track Purolator package', 'woocommerce-shipping-purolator' ) . '</a></h4>');

			echo('<div class="clear"></div><h4 style="padding-bottom:10px;"><a href="' . wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-void-shipment&tracking_number=' . $puro[ 'tracking_number' ] . '&order_id=' . $the_order->id ), 'woocommerce-purolator-void-shipment' ) . '" class="void_shipment">' . __( 'Void Purolator shipment', 'woocommerce-shipping-purolator' ) . '</a></h4>');

		}else{

			echo('<div class="clear"></div><h4 style="padding-bottom:10px;"><a href="' . wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce-purolator-get-label&order_id=' . $the_order->id ), 'woocommerce-purolator-get-label' ) . '" target="_blank">' . __( 'Print Purolator label', 'woocommerce-shipping-purolator' ) . '</a></h4>');

		}


	}

	public function product_data_panels() {

		global $post;
		$post_id = $post->ID;

		// Export data
		$export_informations = get_post_meta( $post_id, '_export_informations', true );

		echo '<div id="export_product_data" class="panel woocommerce_options_panel">';

			echo '<div class="options_group">';

			woocommerce_wp_checkbox( array( 'id' => '_export_is_documents', 'wrapper_class' => 'show_if_simple show_if_variable', 'label' => __( 'Documents only', 'woocommerce-shipping-purolator' ), 'description' => __( 'Enable this if this product is only documents.', 'woocommerce-shipping-purolator' ) ) );

			woocommerce_wp_text_input( array( 'id' => '_export_description', 'label' => __( 'Description', 'woocommerce-shipping-purolator' ), 'placeholder' => '', 'description' => __( 'Small description of the product.', 'woocommerce-shipping-purolator' ), 'class' => 'long' ) );

			woocommerce_wp_select( array( 'id' => '_export_country_of_manufacture', 'label' => __( 'Country of manufacture', 'woocommerce-shipping-purolator' ), 'description' => __( 'Select where the product was manufactured.', 'woocommerce-shipping-purolator' ), 'class' => 'short', 'options' => WC()->countries->countries ) );

			echo '</div>';

		echo '</div>';

	}

	public function product_data_tabs( $tabs ) {

		$tabs[ 'export' ] = array(
			'label'  => __( 'Export', 'woocommerce-shipping-purolator' ),
			'target' => 'export_product_data',
			'class'  => array( 'hide_if_virtual', 'hide_if_grouped', 'hide_if_external' ),
		);

		return $tabs;

	}

	/**
	 * Initialise Gateway Settings Form Fields
	 */
	function init_form_fields() {
		global $woocommerce;

		$this->form_fields = array(
		    'enabled' => array(
				'title' => __('Enable/Disable', 'woocommerce-shipping-purolator'),
				'type' => 'checkbox',
				'label' => __('Enable Purolator', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'availability'  => array(
				'title'           => __( 'Method Availability', 'woocommerce-shipping-purolator' ),
				'type'            => 'select',
				'default'         => 'all',
				'class'           => 'availability',
				'options'         => array(
					'all'            => __( 'All Countries', 'woocommerce-shipping-purolator' ),
					'specific'       => __( 'Specific Countries', 'woocommerce-shipping-purolator' ),
				),
			),
			'countries'        => array(
				'title'           => __( 'Specific Countries', 'woocommerce-shipping-purolator' ),
				'type'            => 'multiselect',
				'class'           => 'chosen_select',
				'css'             => 'width: 450px;',
				'default'         => '',
				'options'         => $woocommerce->countries->get_allowed_countries(),
			),
			'api'           => array(
				'title'           => __( 'API Settings', 'woocommerce-shipping-purolator' ),
				'type'            => 'title',
				'description'     => __( 'Your API access details. Please contact Purolator if you have yet to receive these details from them.', 'woocommerce-shipping-purolator' ),
		    ),
		    'development_key' => array(
				'title' => __('Development Key', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'css' => 'width: 250px;',
				'description' => __('Your Development Key to retrieve shipping rates', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'development_pass' => array(
				'title' => __('Development Password', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Your Development Password to retrieve shipping rates', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'production_key' => array(
				'title' => __('Production Key', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'css' => 'width: 250px;',
				'description' => __('Your Production Key to retrieve shipping rates', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'production_pass' => array(
				'title' => __('Production Password', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Your Production Password to retrieve shipping rates', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'billing_account' => array(
				'title' => __('Billing Account Number', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Your Billing Account Number to retrieve shipping rates', 'woocommerce-shipping-purolator'),
				'default' => '9999999999'
		    ),
			'contact_section_title' => array(
				'title' => __('Contact Information', 'woocommerce-shipping-purolator'),
				'type' => 'title',
				'description' => __('Fill in your store owner contact information.', 'woocommerce-shipping-purolator'),
				'id' => 'contact_section_title'
		    ),
		    'contact_name' => array(
				'title' => __('Contact name', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Will be use as Contact name when creating / printing Purolator shipping label', 'woocommerce-shipping-purolator'),
				'default' => __('', 'woocommerce-shipping-purolator')
		    ),
		    'origin_street_number' => array(
				'title' => __('Origin street number', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Enter your origin street number.', 'woocommerce-shipping-purolator'),
				'default' => __('', 'woocommerce-shipping-purolator')
		    ),
		    'origin_street_name' => array(
				'title' => __('Origin street name', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Enter your origin street name.', 'woocommerce-shipping-purolator'),
				'default' => __('', 'woocommerce-shipping-purolator')
		    ),
		    'origin_city' => array(
				'title' => __('Origin city name', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Enter your origin city name.', 'woocommerce-shipping-purolator'),
				'default' => __('', 'woocommerce-shipping-purolator')
		    ),
		    'origin_province' => array(
				'title' => __('Origin province/state', 'woocommerce-shipping-purolator'),
				'type' => 'select',
				'default' => $woocommerce->countries->get_base_state(),
				'options' => $woocommerce->countries->states['CA']
		    ),
		    'origin_postalcode' => array(
				'title' => __('Origin Postal code', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Enter your origin postal code.', 'woocommerce-shipping-purolator'),
				'default' => __('', 'woocommerce-shipping-purolator')
		    ),
		    'country_code' => array(
				'title' => __('Country code', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Enter your country code. Ex.: 1', 'woocommerce-shipping-purolator'),
				'default' => __('', 'woocommerce-shipping-purolator')
		    ),
		    'area_code' => array(
				'title' => __('Area code', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Enter your area code. Ex.: 877', 'woocommerce-shipping-purolator'),
				'default' => __('', 'woocommerce-shipping-purolator')
		    ),
		    'phone_number' => array(
				'title' => __('Phone number', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Enter your phone number. Ex.: 1234567', 'woocommerce-shipping-purolator'),
				'default' => __('', 'woocommerce-shipping-purolator')
		    ),
			'shipment' => array(
				'title'           => __( 'Printer Settings', 'woocommerce-shipping-purolator' ),
				'type'            => 'title',
				'description'     => __( 'Set your printer settings', 'woocommerce-shipping-purolator' ),
		    ),
		    'printer_type'  => array(
				'title'           => __( 'Printer type', 'woocommerce-shipping-purolator' ),
				'type'            => 'select',
				'default'         => '',
				'class'           => 'printer_type',
				'options'         => array(
					'Regular'	=> __( 'Default: Regular', 'woocommerce-shipping-purolator' ),
					'Thermal'	=> __( 'Thermal', 'woocommerce-shipping-purolator' )
				),
			),
		    'packing_section_title' => array(
				'title' => __('Packing Information', 'woocommerce-shipping-purolator'),
				'type' => 'title',
				'description' => __('Fill in your desired packing information.', 'woocommerce-shipping-purolator'),
				'id' => 'packing_section_title'
		    ),
			'packing_method'  => array(
				'title'           => __( 'Parcel Packing Method', 'woocommerce-shipping-purolator' ),
				'type'            => 'select',
				'default'         => '',
				'class'           => 'packing_method',
				'options'         => array(
					'per_item'       => __( 'Default: Pack items individually', 'woocommerce-shipping-purolator' ),
					'weight'         => __( 'Weight of all items', 'woocommerce-shipping-purolator' ),
					'box_packing'    => __( 'Recommended: Pack into boxes with weights and dimensions', 'woocommerce-shipping-purolator' )
				),
			),
			'boxes'  => array(
				'type'            => 'box_packing'
			),
		    'declare_value' => array(
				'title' => __('Declare cart total', 'woocommerce-shipping-purolator'),
				'label' => __('Enable the declaration of the cart total', 'woocommerce-shipping-purolator'),
				'type' => 'checkbox',
				'description' => __('Enabling this feature will send the cart total to Purolator, it will increase the shipping cost if the total is more than 100$ CAD', 'woocommerce-shipping-purolator'),
				'default' => 'yes'
		    ),
		    'need_signature' => array(
				'title' => __('Need signature', 'woocommerce-shipping-purolator'),
				'label' => __('Enable signature requirements', 'woocommerce-shipping-purolator'),
				'type' => 'checkbox',
				'description' => __('Enabling this feature will tell Purolator to calculate the cost with a signature', 'woocommerce-shipping-purolator'),
				'default' => 'no'
		    ),
		    'handling_time' => array(
				'title' => __('Handling time', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Handling time in days. Enter a number of days.', 'woocommerce-shipping-purolator'),
				'default' => '0'
		    ),
		    'show_date' => array(
				'title' => __('Delivery date', 'woocommerce-shipping-purolator'),
				'label' => __('Enable display delivery date', 'woocommerce-shipping-purolator'),
				'type' => 'checkbox',
				'description' => __('Show the approximately delivery date based on handling time and purolator', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'delivery_date_sprint' => array(
				'title' => __('Delivery date display', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('How to show the delivery date. Ex.: Delivery date: %s', 'woocommerce-shipping-purolator'),
				'default' => '(Delivery date: %s)'
		    ),
		    'delivery_date_format' => array(
				'title' => __('Delivery date format', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Format of the delivery date. Ex.: j F Y', 'woocommerce-shipping-purolator'),
				'default' => get_option('date_format')
		    ),
		    'fee' => array(
				'title' => __('Handling Fee', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Fee excluding tax. Enter an amount, e.g. 2.50, or a percentage, e.g. 5%.', 'woocommerce-shipping-purolator'),
				'default' => '0'
		    ),
		    'fee_to_ship' => array(
				'title' => __('Apply handling fee to shipping rate.', 'woocommerce-shipping-purolator'),
				'type' => 'checkbox',
				'description' => __('Instead of applying handling fee to product value, apply it to shipping rate.', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'pay_shipping_amount' => array(
				'title' => __('Pay part of the shipping costs', 'woocommerce-shipping-purolator'),
				'type' => 'text',
				'description' => __('Enter a percentage here, it will be use to calculate what part of the shipping you pay.', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'shipping_methods' => array(
				'title' => __('Shipping Methods', 'woocommerce-shipping-purolator'),
				'type' => 'multiselect',
				'class' => 'chosen_select',
				'allbuttons' => true,
				'default' => ''
		    ),
		    'auto_create_label' => array(
				'title' => __('Auto create label', 'woocommerce-shipping-purolator'),
				'label' => __('Enable Auto Create Label mode', 'woocommerce-shipping-purolator'),
				'type' => 'checkbox',
				'description' => __('By enabling this, each time an order is received a Purolator label will be created and a link will added in the order email. Please note that the label created will be available for printing only for 48 hours due to a limitation by Purolator.', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'advanced_settings_title' => array(
				'title' => __('Developer Settings', 'woocommerce-shipping-purolator'),
				'type' => 'title',
				'description' => __('Settings for developers, which assist with testing and optimising for your server.', 'woocommerce-shipping-purolator'),
				'id' => 'advanced_settings_title'
		    ),
		    'debug' => array(
				'title' => __('Debug Mode', 'woocommerce-shipping-purolator'),
				'label' => __('Enable Debug Mode', 'woocommerce-shipping-purolator'),
				'type' => 'checkbox',
				'description' => __('Output the response from Purolator on the cart/checkout for debugging purposes.', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'test_mode' => array(
				'title' => __('Development Mode', 'woocommerce-shipping-purolator'),
				'label' => __('Enable Development Mode', 'woocommerce-shipping-purolator'),
				'type' => 'checkbox',
				'description' => __('Use of development variable for Purolator, must be enable to use your development Key and Password', 'woocommerce-shipping-purolator'),
				'default' => ''
		    ),
		    'soap_method' => array(
				'title' => __('SOAP Method', 'woocommerce-shipping-purolator'),
				'type' => 'select',
				'default' => 'auto',
				'description' => __('Do not touch this if you don\'t know what you are doing', 'woocommerce-shipping-purolator'),
				'options' => array(
				    'auto' => __('Automatic (Native SOAP first, NuSOAP fallback)', 'woocommerce-shipping-purolator'),
				    'nusoap' => __('NuSOAP', 'woocommerce-shipping-purolator')
				)
		    ),
		);
	}

	function create_soap_client($wsdl, $location, $ref = 'Shipping', $version = '1.3'){
		if($this->soap_extension){
			$client = new SoapClient($wsdl,
				array(
					'trace'			=> true,
					'location'		=> $location,
					'uri'			=> $this->uri,
					'login'			=> $this->key,
					'password'		=> html_entity_decode( $this->pass ),
					'exceptions'	=> false
				)
			);
			//Define the SOAP Envelope Headers
			$headers[] = new SoapHeader($this->uri, 'RequestContext',
				array(
					'Version'           =>  $version,
					'Language'          =>  'en',
					'GroupID'           =>  'xxx',
					'RequestReference'  =>  $ref
				)
			);
			//Apply the SOAP Header to your client
			$client->__setSoapHeaders($headers);
		}else{
			$client = new nusoap_client($wsdl, true, array(
				'trace'		=> true,
				'location'	=> $location,
				'uri'		=> $this->uri,
				'login'		=> $this->key,
				'password'	=> html_entity_decode( $this->pass ),
			));
			$client->soap_defencoding = 'UTF-8';
			$client->setCredentials($this->key, $this->pass);
			$client->setHeaders('<ns1:RequestContext><ns1:Version>'.$version.'</ns1:Version><ns1:Language>fr</ns1:Language><ns1:GroupID>xxx</ns1:GroupID><ns1:RequestReference>'.$ref.'</ns1:RequestReference></ns1:RequestContext>');
		}
		return($client);
	}

	/**
	 * Get shipping quotes based on change of shipping address
	 *
	 * @method calculate_shipping
	 * @abstract setup shipping rate for each selected shipping option
	 */
	function calculate_shipping( $package = array() ) {
		global $woocommerce;

		$this->add_notice('Enter calculate shipping function.<br />');

		$update_rates = false;
		$cart_items = $woocommerce->cart->get_cart();
		foreach ($cart_items as $id => $cart_item) {
			$cart_temp[] = $id . $cart_item['quantity'];
		}
		$cart_hash = hash('MD5', serialize($cart_temp));

		if (!$this->debug)
			$cache_data = get_transient(get_class($this));
		else
			$cache_data = '';

		if ($cache_data) {
			if ($cache_data['cart_hash'] == $cart_hash && $cache_data['shipping_data']['postalcode'] == $package['destination']['postcode'] && $cache_data['shipping_data']['State'] == $package['destination']['state'] && $cache_data['shipping_data']['Country'] == $package['destination']['country']) {
				$this->rates = $cache_data['rates'];
				$this->add_notice('Shipping update not required.<br />');
			} else {
				$this->add_notice('Shipping update required.<br />');
				$update_rates = true;
			}
		} else {
			$this->add_notice('Shipping update required.<br />');
			$update_rates = true;
		}

		//only update rates when needed
		if ($update_rates) {
			$this->add_notice('Enter update shipping.<br />');
			if ($this->get_shipping_request($package)) {
				$cache_data['shipping_data'] = array(
				    'postalcode' => $package['destination']['postcode'],
				    'State' => $package['destination']['state'],
				    'Country' => $package['destination']['country']
				);
				$cache_data['cart_hash'] = $cart_hash;
				$cache_data['rates'] = $this->rates;

				set_transient(get_class($this), $cache_data);
			}
		}
	}

	private function insert_ns( $request ){

		if( ! is_array( $request ) )
			return $request;

		$ns_request = array();

		foreach( $request as $key => $req ){

			if( is_array( $req ) ){

				$req = $this->insert_ns( $req );

			}

			$ns_request[ 'ns1:' . $key ] = $req;

		}

		return $ns_request;

	}

	/**
	 * validate_address function. Used Purolator address verification
	 *
	 * @access public
	 * @param mixed $address
	 * @return $address
	 */
	public function validate_address( $address ){
		global $woocommerce;
		$client = $this->create_soap_client($this->wsdl_availability_path, $this->soap_availability_location, 'Purolator address validation', '1.2');

		$address['postalcode'] = str_replace( ' ', '', $address['postalcode'] );

		$request = new stdClass();
		$request->Addresses = new stdClass();
		$request->Addresses->ShortAddress = new stdClass();
		$request->Addresses->ShortAddress->City = $address['city'];
		$request->Addresses->ShortAddress->Province = $address['province'];
		$request->Addresses->ShortAddress->Country = $address['country'];
		$request->Addresses->ShortAddress->PostalCode = $address['postalcode'];

		if($this->soap_extension){

			$response = $client->ValidateCityPostalCodeZip( $request );
			$response = json_decode( json_encode( $response ), true );

			$response_header = $client->__getLastResponseHeaders();
			if( strpos( $response_header, "HTTP/1.1 401 Unauthorized" ) !== false ){
				$this->add_notice( 'Unauthorized access to Purolator API, you must call Purolator to enable the ValidateAddress API. Contact Purolator Web Services: WebServices@purolator.com', 'error' );
			}

		}else{
			$client->custom_payload = '<?xml version="1.0" encoding="UTF-8"?><SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ns1="'.$this->uri.'"><SOAP-ENV:Header><ns1:RequestContext><ns1:Version>1.2</ns1:Version><ns1:Language>fr</ns1:Language><ns1:GroupID>xxx</ns1:GroupID><ns1:RequestReference>Address validation</ns1:RequestReference></ns1:RequestContext></SOAP-ENV:Header><SOAP-ENV:Body><ns1:ValidateCityPostalCodeZipRequest><ns1:Addresses><ns1:ShortAddress><ns1:City>'.$address['city'].'</ns1:City><ns1:Province>'.$address['province'].'</ns1:Province><ns1:Country>'.$address['country'].'</ns1:Country><ns1:PostalCode>'.$address['postalcode'].'</ns1:PostalCode></ns1:ShortAddress></ns1:Addresses></ns1:ValidateCityPostalCodeZipRequest></SOAP-ENV:Body></SOAP-ENV:Envelope>';

			//$request = json_decode( json_encode( array( 'ValidateCityPostalCodeZipRequest' => $request ) ), true );

			//$request = $this->insert_ns( json_decode( json_encode( array( 'ValidateCityPostalCodeZipRequest' => $request ) ), true ) );

			$response = $client->call( 'ValidateCityPostalCodeZip', $request );
		    /*
echo '<strong>Request:</strong>';
		    echo '<pre>'; print_r($client->request); echo '</pre>';
		    echo '<strong>Response:</strong>';
		    echo '<pre>'; print_r($client->response); echo '</pre>';
		    die();
*/
			$response = json_decode( json_encode( $response ), true );
		}

		if(isset($response['SuggestedAddresses']['SuggestedAddress'])){
			$address['city'] = $response['SuggestedAddresses']['SuggestedAddress']['Address']['City'];
			$address['province'] = $response['SuggestedAddresses']['SuggestedAddress']['Address']['Province'];
			$address['country'] = $response['SuggestedAddresses']['SuggestedAddress']['Address']['Country'];
			$address['postalcode'] = $response['SuggestedAddresses']['SuggestedAddress']['Address']['PostalCode'];
		}
		$client = $request = null;
		return($address);
	}

	/**
	 * Send request and retrieve the result.
	 */
	function get_shipping_request( $package ) {
		global $woocommerce;

		$this->add_notice('Enter shipping request function.<br />');

		$client = $this->create_soap_client($this->wsdl_path, $this->soap_location, 'Purolator Shipping for WooCommerce');

		$address = $this->validate_address(array('city'=>$package['destination']['city'],'province'=>$package['destination']['state'],'country'=>$package['destination']['country'],'postalcode'=>$package['destination']['postcode']));

		/* Declare new object first */
		$request = new stdClass();

		/* $request->Shipment->PackageType = "CustomerPackaging"; */
		//Populate the sender's informations
		$request->Shipment = new stdClass();
		$request->Shipment->SenderInformation = new stdClass();
		$request->Shipment->SenderInformation->Address = new stdClass();
		$request->Shipment->SenderInformation->Address->Name = $this->contact_name;
		$request->Shipment->SenderInformation->Address->StreetNumber = $this->origin_street_number;
		$request->Shipment->SenderInformation->Address->StreetName = $this->origin_street_name;
		$request->Shipment->SenderInformation->Address->City = $this->origin_city;
		$request->Shipment->SenderInformation->Address->Province = $this->origin_province;
		$request->Shipment->SenderInformation->Address->Country = "CA";
		$request->Shipment->SenderInformation->Address->PostalCode = str_replace(' ', '', $this->origin_postalcode);

		$request->Shipment->SenderInformation->Address->PhoneNumber = new stdClass();
		$request->Shipment->SenderInformation->Address->PhoneNumber->CountryCode = $this->country_code;
		$request->Shipment->SenderInformation->Address->PhoneNumber->AreaCode = $this->area_code;
		$request->Shipment->SenderInformation->Address->PhoneNumber->Phone = $this->phone_number;

		//Populate the Destination Information
		$request->Shipment->ReceiverInformation = new stdClass();
		$request->Shipment->ReceiverInformation->Address = new stdClass();
		$request->Shipment->ReceiverInformation->Address->Name = "John Doe";
		$request->Shipment->ReceiverInformation->Address->StreetNumber = "123";
		$request->Shipment->ReceiverInformation->Address->StreetName = "Lorem Ipsum";
		$request->Shipment->ReceiverInformation->Address->City = $address['city'];
		$request->Shipment->ReceiverInformation->Address->Province = $address['province'];
		$request->Shipment->ReceiverInformation->Address->Country = $address['country'];
		$request->Shipment->ReceiverInformation->Address->PostalCode = $address['postalcode'];

		$request->Shipment->ReceiverInformation->Address->PhoneNumber = new stdClass();
		$request->Shipment->ReceiverInformation->Address->PhoneNumber->CountryCode = "1";
		$request->Shipment->ReceiverInformation->Address->PhoneNumber->AreaCode = "555";
		$request->Shipment->ReceiverInformation->Address->PhoneNumber->Phone = "2222222";

		//Future Dated Shipments - YYYY-MM-DD format
		$request->Shipment->ShipmentDate = date('Y-m-d');

		$request->Shipment->PackageInformation = new stdClass();
		//Populate the Package Information
		if( strtolower($address['country']) == 'ca' ){

			$request->Shipment->PackageInformation->ServiceID = "PurolatorExpress";

		}else if( strtolower($address['country']) == 'us' ){

			$request->Shipment->PackageInformation->ServiceID = "PurolatorExpressU.S.";

		}else {

			$request->Shipment->PackageInformation->ServiceID = "PurolatorExpressInternational";

		}

		$request = $this->set_package_requests( $package, $request );

		$request->Shipment->PackageInformation->TotalWeight = new stdClass();
		$request->Shipment->PackageInformation->TotalWeight->Value = floor( $this->total_weight );
		if($request->Shipment->PackageInformation->TotalWeight->Value < 1){
			$request->Shipment->PackageInformation->TotalWeight->Value = 1;
		}
		$request->Shipment->PackageInformation->TotalWeight->WeightUnit = "lb";
		$request->Shipment->PackageInformation->TotalPieces = $this->total_count;

		if( is_array($this->pieces_information) ){
			$request->Shipment->PackageInformation->PiecesInformation = $this->pieces_information;
		}

		$i = -1;
		if( strtolower($address['country']) == 'ca' ){
			if( !isset($request->Shipment->PackageInformation->OptionsInformation) ){
				$request->Shipment->PackageInformation->OptionsInformation = new stdClass();
				$request->Shipment->PackageInformation->OptionsInformation->Options = new stdClass();
				$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair = array();
			}

			$i++;
			//OriginSignatureNotRequired
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i] = new stdClass();
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i]->ID = "OriginSignatureNotRequired";
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i]->Value = $this->need_signature?"false":"true";

			$i++;
			//Residential Signature
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i] = new stdClass();
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i]->ID = "ResidentialSignatureDomestic";
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i]->Value = $this->need_signature?"true":"false";
		}

		//Populate the Payment Information
		$request->Shipment->PaymentInformation = new stdClass();
		$request->Shipment->PaymentInformation->PaymentType = "Sender";
		$request->Shipment->PaymentInformation->RegisteredAccountNumber = $this->billing_account;
		$request->Shipment->PaymentInformation->BillingAccountNumber = $this->billing_account;

		//Populate the Pickup Information
		$request->Shipment->PickupInformation = new stdClass();
		$request->Shipment->PickupInformation->PickupType = "DropOff";
		$request->ShowAlternativeServicesIndicator = "true";

		//Check to see if Declared value is selected
		if($this->declare_value){
			if( !isset($request->Shipment->PackageInformation->OptionsInformation) ){
				$request->Shipment->PackageInformation->OptionsInformation = new stdClass();
				$request->Shipment->PackageInformation->OptionsInformation->Options = new stdClass();
				$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair = array();
			}

			$i++;
			//Declared value
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i] = new stdClass();
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i]->ID = "DeclaredValue";
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i]->Value = round( $woocommerce->cart->subtotal, 2);

		}

		$this->add_notice('Send Request: <pre class="syn-debug">' . print_r( $request, true ) . '</pre>');

		$this->make_the_call( $client, $request );

		return false;
	}

	function make_the_call( $client, $request, $i = 1 ){

		//Execute the request and capture the response
		if( $this->soap_extension ){

			$response = $client->GetFullEstimate( $request );
			$response = $this->object_to_array( $response );
			$response_header = $client->__getLastResponseHeaders();

			if( strpos( $response_header, "HTTP/1.1 401 Unauthorized" ) !== false ){

				$this->add_notice( 'Unauthorized access to Purolator API, you must call Purolator to enable the GetFullEstimate API. Contact theme here WebServices@purolator.com', 'error' );

			}

		}else{

			$client->custom_payload = $this->object_to_xml($request, $this->uri);
			$response = $client->call('GetFullEstimate', '', $this->uri);

		}

		if( ! $response ){
			$this->add_notice('Error communicating with Purolator. <pre class="syn-debug">' . print_r( $response, true ) . '</pre>' );
			return false;
		}

		if( isset( $response[ 'ShipmentEstimates' ] ) && count( $response[ 'ShipmentEstimates' ] ) > 0 ){

			foreach($response['ShipmentEstimates'] as $estimate){
				if(isset($estimate['ServiceID'])){
					$this->add_this_estimate($estimate);
				}elseif(count($estimate) > 0){
					foreach($estimate as $est){
						$this->add_this_estimate($est);
					}
				}
			}

			$this->add_notice('All was good! <pre class="syn-debug">' . print_r( $response, true ) . '</pre>');

		}else{

			if( isset( $response[ 'ResponseInformation' ] ) && isset( $response[ 'ResponseInformation' ][ 'Errors' ] ) ){

				if( isset( $response[ 'ResponseInformation' ][ 'Errors' ][ 'Error' ][ 'Code' ] ) ){

					switch( $response[ 'ResponseInformation' ][ 'Errors' ][ 'Error' ][ 'Code' ] ){

						case '1100510':
							if( $i < 2 && isset( $request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair ) && count( $request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair ) > 0 ){
								foreach( $request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair as &$option ){

									if( $option->ID == 'OriginSignatureNotRequired' ){

										$option->Value = 'true';

									}

									if( $option->ID == 'ResidentialSignatureDomestic' ){

										$option->Value = 'false';

									}

								}

								$this->make_the_call( $client, $request, $i++ );
							}
							break;

						default:
							$this->add_notice( 'Purolator error #' . $response[ 'ResponseInformation' ][ 'Errors' ][ 'Error' ][ 'Code' ] . '<br />Description: ' . $response[ 'ResponseInformation' ][ 'Errors' ][ 'Error' ][ 'Description' ] , 'error' );
							break;

					}

				}else{

					$errors = $response[ 'ResponseInformation' ][ 'Errors' ];
					if( isset( $errors[ 'Error' ] ) && is_array( $errors[ 'Error' ] ) ){
						$errors = $errors[ 'Error' ];
					}

					foreach( $errors as $error ){

						switch( $error[ 'Code' ] ){

							case '1100510':
								if( $i < 2 && isset( $request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair ) && count( $request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair ) > 0 ){
									foreach( $request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair as &$option ){

										if( $option->ID == 'OriginSignatureNotRequired' ){

											$option->Value = 'true';

										}

										if( $option->ID == 'ResidentialSignatureDomestic' ){

											$option->Value = 'false';

										}

									}

									$this->make_the_call( $client, $request, $i++ );
								}
								break;

							default:
								$this->add_notice( 'Purolator error #' . $error[ 'Code' ] . '<br />Description: ' . $error[ 'Description' ] , 'error' );
								break;

						}

						$this->add_notice( 'Purolator error #' . $error[ 'Code' ] . '<br />Description: ' . $error[ 'Description' ] , 'error' );

					}

				}

			}else{
				$this->add_notice('Purolator returned no rates - ensure you have defined product dimensions and weights.<br />'.print_r($response, true));
			}
		}

	}

	/**
	 * Send request and retrieve the result.
	 */
	function create_shipment( $order ) {
		global $woocommerce;

		$client = $this->create_soap_client($this->class_path . $this->wsdl_shipment_path, $this->soap_shipment_location, 'Purolator Shipping for WooCommerce', '1.4');

		$address = $this->validate_address( array(
			'city'       => self::get_order_prop( $order, 'shipping_city' ),
			'province'   => self::get_order_prop( $order, 'shipping_state' ),
			'country'    => self::get_order_prop( $order, 'shipping_country' ),
			'postalcode' => self::get_order_prop( $order, 'shipping_postcode' ),
		) );

		/* Declare new object first */
		$request = new stdClass();

		//Populate the sender's informations
		$request->Shipment = new stdClass();
		$request->Shipment->SenderInformation = new stdClass();
		$request->Shipment->SenderInformation->Address = new stdClass();
		$request->Shipment->SenderInformation->Address->Name = $this->contact_name;
		$request->Shipment->SenderInformation->Address->StreetNumber = $this->origin_street_number;
		$request->Shipment->SenderInformation->Address->StreetName = $this->origin_street_name;
		$request->Shipment->SenderInformation->Address->City = $this->origin_city;
		$request->Shipment->SenderInformation->Address->Province = $this->origin_province;
		$request->Shipment->SenderInformation->Address->Country = "CA";
		$request->Shipment->SenderInformation->Address->PostalCode = str_replace(' ', '', $this->origin_postalcode);

		$request->Shipment->SenderInformation->Address->PhoneNumber = new stdClass();
		$request->Shipment->SenderInformation->Address->PhoneNumber->CountryCode = $this->country_code;
		$request->Shipment->SenderInformation->Address->PhoneNumber->AreaCode = $this->area_code;
		$request->Shipment->SenderInformation->Address->PhoneNumber->Phone = $this->phone_number;

		$shipping_address = explode( ' ', self::get_order_prop( $order, 'shipping_address_1' ) . " " . self::get_order_prop( $order, 'shipping_address_2' ) );

		if( count( $shipping_address ) > 1 ){

			$street_number = array_splice( $shipping_address, 0, 1 );
			$street_number = $street_number[0];
			$street_name = implode( ' ', $shipping_address );

		}

		$phone = preg_replace( "/[^0-9]/" , "", self::get_order_prop( $order, 'billing_phone' ) );

		if( strlen( $phone ) < 10 ){

			for( $i = strlen( $phone ); $i < 10; $i++ ){

				$phone .= "0";

			}

		}

		if( strlen( $phone ) == 10 ){

			$phone = "1" . $phone;

		}

		$country_code = substr( $phone, 0, 1);
		$area_code = substr( $phone, 1, 3);
		$phone_number = substr( $phone, 4, 7);

		//Populate the Destination Information
		$request->Shipment->ReceiverInformation = new stdClass();
		$request->Shipment->ReceiverInformation->Address = new stdClass();
		$request->Shipment->ReceiverInformation->Address->Name = htmlspecialchars( substr( self::get_order_prop( $order, 'shipping_first_name' ) . " " . self::get_order_prop( $order, 'shipping_last_name' ), 0, 30) );

		if( ! empty( self::get_order_prop( $order, 'shipping_company' ) ) ) {
			$request->Shipment->ReceiverInformation->Address->Company = htmlspecialchars( substr( self::get_order_prop( $order, 'shipping_company' ), 0, 30) );
		}

		$request->Shipment->ReceiverInformation->Address->StreetNumber = $street_number;
		$request->Shipment->ReceiverInformation->Address->StreetName = htmlspecialchars($street_name);
		$request->Shipment->ReceiverInformation->Address->City = htmlspecialchars($address['city']);
		$request->Shipment->ReceiverInformation->Address->Province = htmlspecialchars($address['province']);
		$request->Shipment->ReceiverInformation->Address->Country = htmlspecialchars($address['country']);
		$request->Shipment->ReceiverInformation->Address->PostalCode = $address['postalcode'];

		$request->Shipment->ReceiverInformation->Address->PhoneNumber = new stdClass();
		$request->Shipment->ReceiverInformation->Address->PhoneNumber->CountryCode = $country_code;
		$request->Shipment->ReceiverInformation->Address->PhoneNumber->AreaCode = $area_code;
		$request->Shipment->ReceiverInformation->Address->PhoneNumber->Phone = $phone_number;

		//Future Dated Shipments - YYYY-MM-DD format
		$request->Shipment->ShipmentDate = date('Y-m-d');

		$request->Shipment->PackageInformation = new stdClass();

		if (version_compare($woocommerce->version, '2.1.0') >= 0) {
			$shipping_methods = $order->get_shipping_methods();

			if ( $shipping_methods ){
				foreach ( $shipping_methods as $shipping_method ) {
					$request->Shipment->PackageInformation->ServiceID = str_replace( "_", "", strstr( $shipping_method['method_id'], "_" ));
					break;
				}
			}
		}else{
			$request->Shipment->PackageInformation->ServiceID = str_replace( "_", "", strstr( self::get_order_prop( $order, 'shipping_method' ), "_" ));
		}

		$package = array();
		$package['contents'] = array();
		$items = $order->get_items();

		if( count( $items ) > 0 ){

			foreach( $items as $item_id => $item ){

				$package[ 'contents' ][ $item[ 'product_id' ] ] = array();
				$package[ 'contents' ][ $item[ 'product_id' ] ][ 'quantity' ] = $item[ 'qty' ];
				$package[ 'contents' ][ $item[ 'product_id' ] ][ 'data' ] = wc_get_product( $item[ 'product_id' ] );

			}

		}

		$request = $this->set_package_requests( $package, $request );

		$request->Shipment->PackageInformation->TotalWeight = new stdClass();
		$request->Shipment->PackageInformation->TotalWeight->Value = floor( $this->total_weight );
		if($request->Shipment->PackageInformation->TotalWeight->Value < 1){
			$request->Shipment->PackageInformation->TotalWeight->Value = 1;
		}
		$request->Shipment->PackageInformation->TotalWeight->WeightUnit = "lb";
		$request->Shipment->PackageInformation->TotalPieces = $this->total_count;

		if( is_array($this->pieces_information) ){
			$request->Shipment->PackageInformation->PiecesInformation = $this->pieces_information;
		}

		$i = -1;
		if( strtolower($address['country']) == 'ca' ){
			if( !isset($request->Shipment->PackageInformation->OptionsInformation) ){
				$request->Shipment->PackageInformation->OptionsInformation = new stdClass();
				$request->Shipment->PackageInformation->OptionsInformation->Options = new stdClass();
				$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair = array();
			}

			$i++;
			//OriginSignatureNotRequired
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i] = new stdClass();
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i]->ID = "OriginSignatureNotRequired";
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i]->Value = $this->need_signature?"false":"true";

			$i++;
			//Residential Signature
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i] = new stdClass();
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i]->ID = "ResidentialSignatureDomestic";
			$request->Shipment->PackageInformation->OptionsInformation->Options->OptionIDValuePair[$i]->Value = $this->need_signature?"true":"false";
		}

		if( self::get_order_prop( $order, 'shipping_country' ) != 'CA' ){
			$request->Shipment->InternationalInformation = new stdClass();
			$request->Shipment->InternationalInformation->DocumentsOnlyIndicator = 'false';

			$request->Shipment->InternationalInformation->ContentDetails = new stdClass();
		}

		//Populate the Payment Information
		$request->Shipment->PaymentInformation = new stdClass();
		$request->Shipment->PaymentInformation->PaymentType = "Sender";
		$request->Shipment->PaymentInformation->RegisteredAccountNumber = $this->billing_account;
		$request->Shipment->PaymentInformation->BillingAccountNumber = $this->billing_account;

		//Populate the Pickup Information
		$request->Shipment->PickupInformation = new stdClass();
		$request->Shipment->PickupInformation->PickupType = "DropOff";

		$request->Shipment->TrackingReferenceInformation = new stdClass();
		$request->Shipment->TrackingReferenceInformation->Reference1 = "Order #" . self::get_order_prop( $order, 'id' );

		//Define the Shipment Document Type
		$request->PrinterType = $this->printer_type;

		//Execute the request and capture the response
		if($this->soap_extension){
			$response = $client->CreateShipment($request);
			$response = $this->object_to_array($response);
		}else{
			$client->custom_payload = $this->object_to_xml($request, $this->uri, 'CreateShipmentRequest', '1.4');
			$response = $client->call('CreateShipment', '', $this->uri);
		}
		$client = $request = null;

		$return = array();
		$return[ 'shipment_pin' ] = "";
		$return[ 'pins' ] = array();
		$return[ 'errors' ] = array();

		if ( $response ) {

			if( isset( $response[ 'ResponseInformation' ] ) && isset( $response[ 'ResponseInformation' ][ 'Errors' ] ) && empty( $response[ 'ResponseInformation' ][ 'Errors' ] ) && isset( $response[ 'ShipmentPIN' ] ) && isset( $response[ 'ShipmentPIN' ][ 'Value' ] ) && isset( $response[ 'PiecePINs' ] ) ){

				$return[ 'shipment_pin' ] = $response[ 'ShipmentPIN' ][ 'Value' ];

				foreach ( $response['PiecePINs']['PIN'] as $pin ) {
					if ( isset( $pin['Value'] ) ) {
						$return['pins'][] = $pin['Value'];
					}
				}

			} else if ( isset( $response['ResponseInformation'] ) && ! empty( $response['ResponseInformation']['Errors'] ) ) {

				foreach( $response['ResponseInformation']['Errors'] as $error ){
					if ( ! is_array( $error ) ) {
						continue;
					}

					if ( ! empty( $error['Code'] ) && ! empty( $error['Description'] ) ) {
						$return['errors'][] = $error[ 'Code' ] . ': ' . $error[ 'Description' ];
					} else {
						// Puralator may returns Errors in following format:
						//
						// [Errors] => Array
						// (
						//     [Error] => Array
						//         (
						//             [0] => Array
						//                 (
						//                     [Code] => 1100219
						//                     [Description] => Street Number is invalid.
						//                     [AdditionalInformation] => Shipping Error
						//                 )
						//
						//             [1] => Array
						//                 (
						//                     [Code] => 1100576
						//                     [Description] => Street Name is a mandatory field.
						//                     [AdditionalInformation] => Shipping Error
						//                 )
						//
						//             [2] => Array
						//                 (
						//                     [Code] => 1000000
						//                     [Description] =>
						//                     [AdditionalInformation] => Shipping Error
						//                 )
						//
						//         )
						//
						// )
						foreach ( $error as $err ) {
							if ( ! empty( $err['Code'] ) && ! empty( $err['Description'] ) ) {
								$return['errors'][] = $err[ 'Code' ] . ': ' . $err[ 'Description' ];
							}
						}
					}
				}

			}

		}else{

		}

		return $return;
	}

	public function get_documents( $shipment_pin ) {
		global $woocommerce;

		$client = $this->create_soap_client($this->class_path . $this->wsdl_getdocuments_path, $this->soap_getdocuments_location, 'Purolator Shipping for WooCommerce', '1.1');

		/* Declare new object first */
		$request = new stdClass();
		$request->DocumentCriterium = new stdClass();
		$request->DocumentCriterium->DocumentCriteria = new stdClass();
		$request->DocumentCriterium->DocumentCriteria->PIN = new stdClass();
		$request->DocumentCriterium->DocumentCriteria->PIN->Value = $shipment_pin;

		$request->DocumentCriterium->DocumentCriteria->DocumentTypes = new stdClass();
		$request->DocumentCriterium->DocumentCriteria->DocumentTypes->DocumentType = "DomesticBillOfLading";

		//Execute the request and capture the response
		if($this->soap_extension){
			$response = $client->GetDocuments($request);
			$response = $this->object_to_array($response);
		}else{
			$client->custom_payload = $this->object_to_xml($request, $this->uri, 'GetDocumentsRequest', '1.1');
			$response = $client->call('GetDocuments', '', $this->uri);
		}
		$client = $request = null;

		$label_url = '';

		if( $response ){

			if( isset( $response[ 'ResponseInformation' ] ) && isset( $response[ 'ResponseInformation' ][ 'Errors' ] ) && empty( $response[ 'ResponseInformation' ][ 'Errors' ] ) ){

				$label_url = $response[ 'Documents' ][ 'Document' ][ 'DocumentDetails' ][ 'DocumentDetail' ][ 'URL' ];

			}else{

			}

		}else{

		}

		return $label_url;
	}

	public function get_tracking( $tracking_number ) {
		global $woocommerce;

		$client = $this->create_soap_client($this->class_path . $this->wsdl_tracking_path, $this->soap_tracking_location, 'Purolator Shipping for WooCommerce', '1.1');

		/* Declare new object first */
		$request = new stdClass();
		$request->PINs = new stdClass();
		$request->PINs->PIN = new stdClass();
		$request->PINs->PIN->Value = $tracking_number;

		//Execute the request and capture the response
		if($this->soap_extension){
			$response = $client->TrackPackagesByPin( $request );
			$response = $this->object_to_array( $response );
		}else{
			$client->custom_payload = $this->object_to_xml( $request, $this->uri, 'TrackPackagesByPinRequest', '1.1' );
			$response = $client->call( 'TrackPackagesByPin', '', $this->uri );
		}
		$client = $request = null;

		$label_url = '';

		$scans = array();

		if( $response ){

			if( isset( $response[ 'ResponseInformation' ] ) && isset( $response[ 'ResponseInformation' ][ 'Errors' ] ) && count( $response[ 'ResponseInformation' ][ 'Errors' ] ) <= 0 ){

				$scans = $response[ 'TrackingInformationList' ][ 'TrackingInformation' ][ 'Scans' ][ 'Scan' ];

			}else{

			}

		}else{

		}

		return $scans;
	}

	function add_this_estimate($estimate){
		global $woocommerce;
		$delivery_date = '';

		if ( is_array( $this->shipping_methods ) && array_search( $estimate[ 'ServiceID' ], $this->shipping_methods ) !== false ) {
			$cost = 0;

			if( $this->fee_to_ship ) {
				$cost = $estimate['TotalPrice'] + $this->get_fee($this->fee, $estimate['TotalPrice']);
			} else {
				$cost = $estimate['TotalPrice'] + $this->get_fee($this->fee, $woocommerce->cart->cart_contents_total);
			}

			if( ! empty( $this->pay_shipping_amount ) ){

				$cost -= ( ( intval( $this->pay_shipping_amount ) / 100 ) * $woocommerce->cart->subtotal_ex_tax );

				if( $cost < 0 )
					$cost = 0;

			}

			if($this->show_date){
				if(empty($this->delivery_date_format))
					$this->delivery_date_format = get_option('date_format');
				$ddelivery_date = intval(abs((strtotime($estimate['ShipmentDate']) - strtotime($estimate['ExpectedDeliveryDate']))/86400));
				$delivery_date = $this->addDays(time(), $ddelivery_date+$this->handling_time, array('Saturday', 'Sunday'));
				$delivery_date = mysql2date($this->delivery_date_format, date('Y-m-d', $delivery_date));
				if(empty($this->delivery_date_sprint)){
					$delivery_date = ' '.$delivery_date;
				}else{
					$delivery_date = ' '.sprintf($this->delivery_date_sprint, $delivery_date);
				}
			}
			$rate = array(
			    'id' => $this->id . "_" . $estimate['ServiceID'],
			    'label' => $this->shipping_type[$estimate['ServiceID']].$delivery_date,
			    'cost' => $cost
			);
			$this->add_rate($rate);
		}
	}

	function addDays($timestamp, $days, $skipdays=null, $skipdates=null){
		$i = 1;

		while($days >= $i){
			$timestamp = strtotime("+1 day" ,$timestamp);
			if(array_search(date("l",$timestamp), $skipdays) !== false){
				$days++;
			}
			$i++;
		}

		return $timestamp;
	}


	/**
	 * Shipping method available condition:
	 * 1. Set to yes
	 * 2. Origin country is CA
	 * 3. Dest country is in the list
	 *
	 * @global type $woocommerce
	 * @return type
	 */
	function is_available($package) {
		global $woocommerce;
		if ($this->enabled == "no")
			return false;

		if (isset($woocommerce->cart->cart_contents_total) && isset($this->min_amount) && $this->min_amount && $this->min_amount > $woocommerce->cart->cart_contents_total)
			return false;

		if (!$this->origin_postalcode):
			return false;
		endif;

		$ship_to_countries = '';

		if ($this->availability == 'specific') :
			$ship_to_countries = $this->countries;
		else :
			if (get_option('woocommerce_allowed_countries') == 'specific') :
				$ship_to_countries = get_option('woocommerce_specific_allowed_countries');
			endif;
		endif;

		if (is_array($ship_to_countries)) :
			if (!in_array($woocommerce->customer->get_shipping_country(), $ship_to_countries))
				return false;
		endif;

		return true;
	}

	function admin_options() {
		global $woocommerce;
		?>
		<h3><?php _e('Purolator', 'woocommerce-shipping-purolator'); ?></h3>
		<p><?php echo(sprintf(__('You must have a Production Key and Password to calculate Purolator Shipping, <a href="%s" target="_blank">click here</a> to register an account with Purolator.', 'woocommerce-shipping-purolator'), 'https://eship.purolator.com/site/en/createnewuser.aspx?sfopl=true')); ?></p>
		<table class="form-table">
			<?php
			// Generate the HTML For the settings form.
			$this->generate_settings_html();
			?>
		</table><!--/.form-table-->
		<?php
	}

	/**
     * get_request function.
     *
     * @access private
     * @return void
     */
    private function set_package_requests( $package, $request ) {

	    // Choose selected packing
    	switch ( $this->packing_method ) {
	    	case 'weight' :
	    		$request = $this->weight_only_shipping( $package, $request );
	    	break;
	    	case 'box_packing' :
	    		$request = $this->box_shipping( $package, $request );
	    	break;
	    	case 'per_item' :
	    	default :
	    		$request = $this->per_item_shipping( $package, $request );
	    	break;
    	}

    	return $request;
    }

    /**
     * per_item_shipping function.
     *
     * @access private
     * @param mixed $package
     * @return void
     */
    private function per_item_shipping( $package, $request ) {
	    global $woocommerce;

    	// Get weight of order
    	foreach ( $package['contents'] as $item_id => $values ) {

    		if ( ! $values['data']->needs_shipping() ) {
    			$this->add_notice( sprintf( __( 'Product # is virtual. Skipping.', 'woocommerce-shipping-purolator' ), $item_id ) );
    			continue;
    		}

    		if ( ! $values['data']->get_weight() ) {
    			$this->add_notice( sprintf( __( 'Product # is missing weight. Aborting.', 'woocommerce-shipping-purolator' ), $item_id ), 'error');
	    		return $request;
    		}

			if ( $values['data']->get_length() && $values['data']->get_height() && $values['data']->get_width() ) {

				$dimensions = array( $values['data']->get_length(), $values['data']->get_height(), $values['data']->get_width() );

				sort( $dimensions );

				$piece = new stdClass();

				$piece->Weight = new stdClass();
				$piece->Weight->Value = round(wc_get_weight( $values['data']->get_weight(), 'lbs' ), 2 );
				$piece->Weight->WeightUnit = "lb";

				if($piece->Weight->Value < 1)
					$piece->Weight->Value = 1;

				$this->total_weight += $piece->Weight->Value * $values['quantity'];

				$piece->Length = new stdClass();
				$piece->Length->Value = number_format( wc_get_dimension( $dimensions[2], 'cm' ), 2, '.', '');
				$piece->Length->DimensionUnit = "cm";

				$piece->Width = new stdClass();
				$piece->Width->Value = number_format( wc_get_dimension( $dimensions[1], 'cm' ), 2, '.', '');
				$piece->Width->DimensionUnit = "cm";

				$piece->Height = new stdClass();
				$piece->Height->Value = number_format( wc_get_dimension( $dimensions[0], 'cm' ), 2, '.', '');
				$piece->Height->DimensionUnit = "cm";

				if( !is_array($this->pieces_information) ){
					$this->pieces_information = array();
				}

				for ( $i=0; $i < $values['quantity'] ; $i++){

					$nPiece = unserialize(serialize($piece));
					$this->pieces_information[] = $nPiece;

				}

				$this->total_count += $values['quantity'];

			}

    	}

    	return $request;

    }

    /**
     * box_shipping function.
     *
     * @access private
     * @param mixed $package
     * @return void
     */
    private function box_shipping( $package, $request ) {
	    global $woocommerce;

	    $requests = array();

	    $boxpack = new WC_Boxpack();

	    // Define boxes
		foreach ( $this->boxes as $box ) {

			$newbox = $boxpack->add_box( $box['outer_length'], $box['outer_width'], $box['outer_height'], $box['box_weight'] );

			$newbox->set_inner_dimensions( $box['inner_length'], $box['inner_width'], $box['inner_height'] );

			if ( $box['max_weight'] )
				$newbox->set_max_weight( $box['max_weight'] );

		}

		// Add items
		foreach ( $package['contents'] as $item_id => $values ) {

			if ( $values['data']->get_length() && $values['data']->get_height() && $values['data']->get_width() && $values['data']->get_weight() ) {

				$dimensions = array( $values['data']->get_length(), $values['data']->get_height(), $values['data']->get_width() );

				for ( $i = 0; $i < $values['quantity']; $i ++ ) {
					$boxpack->add_item(
						wc_get_dimension( $dimensions[2], 'cm' ),
						wc_get_dimension( $dimensions[1], 'cm' ),
						wc_get_dimension( $dimensions[0], 'cm' ),
						wc_get_weight( $values['data']->get_weight(), 'lbs' ),
						$values['data']->get_price()
					);
				}

			} else {
				$this->add_notice( sprintf( __( 'Product # is missing dimensions. Aborting.', 'woocommerce-shipping-purolator' ), $item_id ) , 'error');
				return $request;
			}
		}

		// Pack it
		$boxpack->pack();

		// Get packages
		$packages = $boxpack->get_packages();

		foreach ( $packages as $package ) {

			$dimensions = array( $package->length, $package->width, $package->height );

			sort( $dimensions );

			$piece = new stdClass();

			$piece->Weight = new stdClass();
			$piece->Weight->Value = round(wc_get_weight($package->weight, 'lbs'), 2);
			$piece->Weight->WeightUnit = "lb";

			if($piece->Weight->Value < 1)
				$piece->Weight->Value = 1;

			$this->total_weight += $piece->Weight->Value;

			$piece->Length = new stdClass();
			$piece->Length->Value = number_format( wc_get_dimension( $dimensions[2], 'cm' ), 2, '.', '');
			$piece->Length->DimensionUnit = "cm";

			$piece->Width = new stdClass();
			$piece->Width->Value = number_format( wc_get_dimension( $dimensions[1], 'cm' ), 2, '.', '');
			$piece->Width->DimensionUnit = "cm";

			$piece->Height = new stdClass();
			$piece->Height->Value = number_format( wc_get_dimension( $dimensions[0], 'cm' ), 2, '.', '');
			$piece->Height->DimensionUnit = "cm";

			if( !is_array($this->pieces_information) ){
				$this->pieces_information = array();
			}

			$this->pieces_information[] = $piece;
			$this->total_count++;

		}

		return $request;

    }

    /**
     * weight_only_shipping function.
     *
     * @access privatemail
     * @param mixed $package
     * @return void
     */
	private function weight_only_shipping( $package, $request ) {

		global $woocommerce;

		// Get weight of order
		foreach ( $package['contents'] as $item_id => $values ) {

			if ( ! $values['data']->needs_shipping() ) {
				$this->add_notice( sprintf( __( 'Product # is virtual. Skipping.', 'woocommerce-shipping-purolator' ), $item_id ) );
				continue;
			}

			if ( ! $values['data']->get_weight() ) {
	    		$this->add_notice( sprintf( __( 'Product # is missing weight. Aborting.', 'woocommerce-shipping-purolator' ), $item_id ) , 'error');
	    		return $request;
			}

			$this->total_weight += wc_get_weight( $values['data']->get_weight(), 'lbs' ) * $values['quantity'];

		}

	    $this->total_weight = max( round( $this->total_weight ), 1 );
	    $this->total_count = 1;

	    return $request;

	}

	/**
     * Generate Multiselect HTML.
     *
     * @access public
     * @param mixed $key
     * @param mixed $data
     * @since 1.0.0
     * @return string
     */
    function generate_multiselect_html( $key, $data ) {
    	$html = '';

    	if ( isset( $data['title'] ) && $data['title'] != '' ) $title = $data['title']; else $title = '';
    	$data['options'] = (isset( $data['options'] )) ? (array) $data['options'] : array();
    	$data['class'] = (isset( $data['class'] )) ? $data['class'] : '';
    	$data['css'] = (isset( $data['css'] )) ? $data['css'] : '';

		$html .= '<tr valign="top">' . "\n";
			$html .= '<th scope="row" class="titledesc">';
			$html .= '<label for="' . $this->plugin_id . $this->id . '_' . $key . '">' . $title . '</label>';
			$html .= '</th>' . "\n";
			$html .= '<td class="forminp">' . "\n";
				$html .= '<fieldset><legend class="screen-reader-text"><span>' . $title . '</span></legend>' . "\n";
				$html .= '<select multiple="multiple" style="'.$data['css'].'" class="multiselect '.$data['class'].'" name="' . $this->plugin_id . $this->id . '_' . $key . '[]" id="' . $this->plugin_id . $this->id . '_' . $key . '">';

				foreach ($data['options'] as $option_key => $option_value) :
					$html .= '<option value="'.$option_key.'" ';
					if (isset($this->settings[$key]) && in_array($option_key, (array) $this->settings[$key])) $html .= 'selected="selected"';
					$html .= '>'.$option_value.'</option>';
				endforeach;

				$html .= '</select>';
				if ( ! empty($data['description'] ) ) { $html .= '<span class="description">' . esc_html( $data['description'] ) . '</span>' . "\n"; }
				if( ! empty( $data['allbuttons'] ) ) { $html .= '<br ><a class="select_all button" href="#">' . __( 'Select all', 'woocommerce-shipping-purolator' ) . '</a> <a class="select_none button" href="#">' . __( 'Select none', 'woocommerce-shipping-purolator' ) . '</a>'; }
			$html .= '</fieldset>';
			$html .= '</td>' . "\n";
		$html .= '</tr>' . "\n";

    	return $html;
    }

    /**
	 * generate_box_packing_html function.
	 *
	 * @access public
	 * @return void
	 */
	public function generate_box_packing_html() {
		ob_start();
		?>
		<tr valign="top" id="packing_options">
			<th scope="row" class="titledesc"><?php _e( 'Box Sizes', 'woocommerce-shipping-purolator' ); ?></th>
			<td class="forminp">
				<style type="text/css">
					.purolator_post_boxes td {
						vertical-align: middle;
						padding: 4px 7px;
					}
					.purolator_post_boxes td input {
						margin-right: 4px;
					}
					.purolator_post_boxes .check-column {
						vertical-align: middle;
						text-align: left;
						padding: 0 7px;
					}
				</style>
				<table class="purolator_post_boxes widefat">
					<thead>
						<tr>
							<th class="check-column"><input type="checkbox" /></th>
							<th><?php _e( 'Outer Length', 'woocommerce-shipping-purolator' ); ?></th>
							<th><?php _e( 'Outer Width', 'woocommerce-shipping-purolator' ); ?></th>
							<th><?php _e( 'Outer Height', 'woocommerce-shipping-purolator' ); ?></th>
							<th><?php _e( 'Inner Length', 'woocommerce-shipping-purolator' ); ?></th>
							<th><?php _e( 'Inner Width', 'woocommerce-shipping-purolator' ); ?></th>
							<th><?php _e( 'Inner Height', 'woocommerce-shipping-purolator' ); ?></th>
							<th><?php _e( 'Box Weight', 'woocommerce-shipping-purolator' ); ?></th>
							<th><?php _e( 'Max Weight', 'woocommerce-shipping-purolator' ); ?></th>
						</tr>
					</thead>
					<tfoot>
						<tr>
							<th colspan="3">
								<a href="#" class="button plus insert"><?php _e( 'Add Box', 'woocommerce-shipping-purolator' ); ?></a>
								<a href="#" class="button minus remove"><?php _e( 'Remove selected box(es)', 'woocommerce-shipping-purolator' ); ?></a>
							</th>
							<th colspan="6">
								<small class="description"><?php _e( 'Items will be packed into these boxes depending based on item dimensions and volume. Outer dimensions will be passed to Purolator, whereas inner dimensions will be used for packing. Items not fitting into boxes will be packed individually.', 'woocommerce-shipping-purolator' ); ?></small>
							</th>
						</tr>
					</tfoot>
					<tbody id="rates">
						<?php
							if ( $this->boxes ) {
								foreach ( $this->boxes as $key => $box ) {
									?>
									<tr>
										<td class="check-column"><input type="checkbox" /></td>
										<td><input type="text" size="5" name="boxes_outer_length[<?php echo $key; ?>]" value="<?php echo esc_attr( $box['outer_length'] ); ?>" />cm</td>
										<td><input type="text" size="5" name="boxes_outer_width[<?php echo $key; ?>]" value="<?php echo esc_attr( $box['outer_width'] ); ?>" />cm</td>
										<td><input type="text" size="5" name="boxes_outer_height[<?php echo $key; ?>]" value="<?php echo esc_attr( $box['outer_height'] ); ?>" />cm</td>
										<td><input type="text" size="5" name="boxes_inner_length[<?php echo $key; ?>]" value="<?php echo esc_attr( $box['inner_length'] ); ?>" />cm</td>
										<td><input type="text" size="5" name="boxes_inner_width[<?php echo $key; ?>]" value="<?php echo esc_attr( $box['inner_width'] ); ?>" />cm</td>
										<td><input type="text" size="5" name="boxes_inner_height[<?php echo $key; ?>]" value="<?php echo esc_attr( $box['inner_height'] ); ?>" />cm</td>
										<td><input type="text" size="5" name="boxes_box_weight[<?php echo $key; ?>]" value="<?php echo esc_attr( $box['box_weight'] ); ?>" />kg</td>
										<td><input type="text" size="5" name="boxes_max_weight[<?php echo $key; ?>]" value="<?php echo esc_attr( $box['max_weight'] ); ?>" />kg</td>
									</tr>
									<?php
								}
							}
						?>
					</tbody>
				</table>
				<script type="text/javascript">

					jQuery(window).load(function(){

						jQuery('#woocommerce_purolator_packing_method').change(function(){

							if ( jQuery(this).val() == 'box_packing' )
								jQuery('#packing_options').show();
							else
								jQuery('#packing_options').hide();

						}).change();

						jQuery('.purolator_post_boxes .insert').click( function() {
							var $tbody = jQuery('.purolator_post_boxes').find('tbody');
							var size = $tbody.find('tr').size();
							var code = '<tr class="new">\
									<td class="check-column"><input type="checkbox" /></td>\
									<td><input type="text" size="5" name="boxes_outer_length[' + size + ']" />cm</td>\
									<td><input type="text" size="5" name="boxes_outer_width[' + size + ']" />cm</td>\
									<td><input type="text" size="5" name="boxes_outer_height[' + size + ']" />cm</td>\
									<td><input type="text" size="5" name="boxes_inner_length[' + size + ']" />cm</td>\
									<td><input type="text" size="5" name="boxes_inner_width[' + size + ']" />cm</td>\
									<td><input type="text" size="5" name="boxes_inner_height[' + size + ']" />cm</td>\
									<td><input type="text" size="5" name="boxes_box_weight[' + size + ']" />kg</td>\
									<td><input type="text" size="5" name="boxes_max_weight[' + size + ']" />kg</td>\
								</tr>';

							$tbody.append( code );

							return false;
						} );

						jQuery('.purolator_post_boxes .remove').click(function() {
							var $tbody = jQuery('.purolator_post_boxes').find('tbody');

							$tbody.find('.check-column input:checked').each(function() {
								jQuery(this).closest('tr').hide().find('input').val('');
							});

							return false;
						});

					});

				</script>
			</td>
		</tr>
		<?php
		return ob_get_clean();
	}

	/**
	 * validate_box_packing_field function.
	 *
	 * @access public
	 * @param mixed $key
	 * @return void
	 */
	public function validate_box_packing_field( $key ) {

		if( !isset( $_POST['boxes_outer_length'] ) )
			return array();

		$boxes_outer_length = $_POST['boxes_outer_length'];
		$boxes_outer_width  = $_POST['boxes_outer_width'];
		$boxes_outer_height = $_POST['boxes_outer_height'];
		$boxes_inner_length = $_POST['boxes_inner_length'];
		$boxes_inner_width  = $_POST['boxes_inner_width'];
		$boxes_inner_height = $_POST['boxes_inner_height'];
		$boxes_box_weight   = $_POST['boxes_box_weight'];
		$boxes_max_weight   = $_POST['boxes_max_weight'];

		$boxes = array();

		for ( $i = 0; $i < sizeof( $boxes_outer_length ); $i ++ ) {

			if ( $boxes_outer_length[ $i ] && $boxes_outer_width[ $i ] && $boxes_outer_height[ $i ] && $boxes_inner_length[ $i ] && $boxes_inner_width[ $i ] && $boxes_inner_height[ $i ] ) {

				$boxes[] = array(
					'outer_length' => floatval( $boxes_outer_length[ $i ] ),
					'outer_width'  => floatval( $boxes_outer_width[ $i ] ),
					'outer_height' => floatval( $boxes_outer_height[ $i ] ),
					'inner_length' => floatval( $boxes_inner_length[ $i ] ),
					'inner_width'  => floatval( $boxes_inner_width[ $i ] ),
					'inner_height' => floatval( $boxes_inner_height[ $i ] ),
					'box_weight'   => floatval( $boxes_box_weight[ $i ] ),
					'max_weight'   => floatval( $boxes_max_weight[ $i ] ),
				);

			}

		}

		return $boxes;
	}

	public function object_to_xml($obj, $uri, $request = 'GetFullEstimateRequest', $version = '1.3'){
		$xml = '<?xml version="1.0" encoding="UTF-8"?>';

		$xml .= '<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ns1="'.$uri.'"><SOAP-ENV:Header><ns1:RequestContext><ns1:Version>' . $version . '</ns1:Version><ns1:Language>en</ns1:Language><ns1:GroupID>xxx</ns1:GroupID><ns1:RequestReference>Purolator Shipping for WooCommerce</ns1:RequestReference></ns1:RequestContext></SOAP-ENV:Header><SOAP-ENV:Body><ns1:' . $request . '>';
		$xml .= $this->generate_xml_from_array( $obj );
		$xml .= '</ns1:' . $request . '></SOAP-ENV:Body></SOAP-ENV:Envelope>';

		return $xml;
	}

	public function generate_xml_from_array($obj, $node_name = ''){
		$xml = '';
		$arr_names = array(
			'piecesinformation' => 'Piece'
		);
		if (is_array($obj) || is_object($obj)) {
			foreach ($obj as $key=>$value) {
				if (is_numeric($key)) {
					$key = $node_name;
				}
				if(is_array($obj) && isset($arr_names[strtolower($key)])){
					$key = $arr_names[strtolower($key)];
				}

				$xml .= ((is_array($value) && strtolower($key)=='optionidvaluepair')?'':'<ns1:' . $key . '>') . $this->generate_xml_from_array($value, $key) . ((is_array($value) && strtolower($key)=='optionidvaluepair')?'':'</ns1:' . $key . '>');
			}
		} else {
			$xml = htmlspecialchars($obj, ENT_QUOTES);
		}

		return $xml;
	}

	public function object_to_array($d) {
		if (is_object($d)) {
			// Gets the properties of the given object
			// with get_object_vars function
			$d = get_object_vars($d);
		}

		if (is_array($d)) {
			return array_map( $this->object_to_array, $d );
		}
		else {
			// Return array
			return $d;
		}
	}

	/**
	 * Get order property with compatibility check on order getter introduced
	 * in WC 3.0.
	 *
	 * @since 2.4.0
	 *
	 * @param WC_Order $order Order object.
	 * @param string   $prop  Property name.
	 *
	 * @return mixed Property value
	 */
	public static function get_order_prop( $order, $prop ) {
		$modifier = function ( $a ) {
			return $a;
		};
		switch ( $prop ) {
			case 'order_date':
				$getter = array( $order, 'get_date_created' );
				$modifier = function ( $a ) {
					return date( 'Y-m-d H:i:s', $a );
				};
				break;
			default:
				$getter = array( $order, 'get_' . $prop );
				break;
		}
		return is_callable( $getter ) ? $modifier( call_user_func( $getter ) ) : $order->{ $prop };
	}

	public function process_label( $order_id ){
		$return = array(
			'errors'	=> array(),
			'label_url'	=> ''
		);
		$puro = get_post_meta( $order_id, "_purolator", true );

		if( $puro && isset( $puro[ 'label_url' ] ) && !empty( $puro[ 'label_url' ] ) ){

			$return[ 'label_url' ] = $puro[ 'label_url' ];

		}else{

			$order = wc_get_order( $order_id );

			if( isset( $puro[ 'tracking_number' ] ) && !empty( $puro[ 'tracking_number' ] ) ){

				$shipment_pin = $puro[ 'tracking_number' ];

			}else{

				$ret = $this->create_shipment( $order );
				$shipment_pin = $ret[ 'shipment_pin' ];

			}

			if( !empty( $shipment_pin ) ){

				$return[ 'label_url' ] = $this->get_documents( $shipment_pin );

				update_post_meta( $order_id, '_purolator', array( 'tracking_number' => $shipment_pin, 'label_url' => $return[ 'label_url' ] ) );

				update_post_meta( $order_id, 'Purolator Label Link', '<a href="' . admin_url( 'admin-ajax.php' ) . '?action=process_purolator_get_documents&order_id=' . $order_id . '">Print label</a>' );

				update_post_meta( $order_id, '_label_creation_date', time() );

				update_post_meta( $order_id, '_tracking_number', $shipment_pin );

			}else if( isset( $ret ) && isset( $ret[ 'errors' ] ) && !empty( $ret[ 'errors' ] ) ){

				$return[ 'errors' ] = $ret[ 'errors' ];

			}

		}

		return $return;
	}
	/**
	 * Get and print the Purolator label
	 *
	 * @access public
	 * @return void
	 */
	public function get_label() {

		if ( !is_admin() ) die;
		if ( !current_user_can('edit_shop_orders') ) wp_die( __( 'You do not have sufficient permissions to access this page.', 'woocommerce-shipping-purolator' ) );
		if ( !check_admin_referer( 'woocommerce-purolator-get-label' )) wp_die( __( 'You have taken too long. Please go back and retry.', 'woocommerce-shipping-purolator' ) );
		$order_id = isset($_GET['order_id']) && (int) $_GET['order_id'] ? (int) $_GET['order_id'] : '';
		if (!$order_id) die;

		$return = $this->process_label( $order_id );

		if( !empty( $return[ 'errors' ] ) ){
			echo( 'An error occured:<br />' );
			echo( implode( "<br />", $return[ 'errors' ] ) );
			die();
		}else{
			wp_redirect( $return[ 'label_url' ] );
		}

	}

	public function process_documents(){

		$order_id = $_GET[ 'order_id' ];

		$puro = get_post_meta( $order_id, "_tracking_number", true );

		if ( ! class_exists( 'WC_Shipping_Purolator' ) )
			include_once( 'includes/class-wc-shipping-purolator.php' );

		if( $puro ){

			$label_url = $this->get_documents( $puro );

			if( !empty( $label_url ) ){

				wp_redirect( $label_url );

			}else{

				echo('An error as occured');
				die();

			}

		}else{

			echo('An error as occured');
			die();

		}
	}

	public function void_shipment( $tracking_number ){
		$client = $this->create_soap_client($this->class_path . $this->wsdl_shipment_path, $this->soap_shipment_location, 'Purolator Shipping for WooCommerce', '1.4');

		/* Declare new object first */
		$request = new stdClass();
		$request->PIN = new stdClass();
		$request->PIN->Value = $tracking_number;

		//Execute the request and capture the response
		if($this->soap_extension){
			$response = $client->VoidShipment( $request );
			$response = $this->object_to_array( $response );
		}else{
			$client->custom_payload = $this->object_to_xml( $request, $this->uri, 'VoidShipmentRequest', '1.4' );
			$response = $client->call( 'VoidShipment', '', $this->uri );
		}
		$client  = $request = null;

		$label_url = '';

		$shipment_voided = array();

		if( $response ){

			if( isset( $response[ 'ResponseInformation' ] ) && isset( $response[ 'ResponseInformation' ][ 'Errors' ] ) && empty( $response[ 'ResponseInformation' ][ 'Errors' ] ) ){

				$shipment_voided = array(
					'voided' => true,
					'errors' => array()
				);

			}else{

				$shipment_voided = array(
					'voided' => false,
					'errors' => array()
				);

				foreach( $response[ 'ResponseInformation' ][ 'Errors' ] as $error ){

					$shipment_voided[ 'errors' ][] = $error[ 'Description' ];

				}

			}

		}else{

		}

		return $shipment_voided;
	}
}
