<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
$plugin_name = WPF_PLUGIN_NAME;
$plugin_version = WPF_PLUGIN_VERSION;
?>
<div id="dotsstoremain">
    <div class="all-pad">
        <header class="dots-header">
            <div class="dots-logo-main">
                <img src="<?php echo esc_url(WPF_PLUGIN_URL) . 'admin/images/wizard_logo.png'; ?>">
                <span><?php esc_html_e(WPF_FREE_PLUGIN, WPF_TEXT_DOMAIN); ?> <?php echo esc_html__( $this->version, WPF_TEXT_DOMAIN); ?></span>
            </div>
            <div class="dots-header-right">
                <div class="logo-detail">
                    <strong><?php esc_html_e($plugin_name, WPF_TEXT_DOMAIN); ?> </strong>
                    <p><?php esc_html_e("Let customers narrow down the product list on the basis of their choices. It enables the store owners to add a questionnaire to the product page.", WPF_TEXT_DOMAIN); ?></p>
                </div>
                <div class="button-dots">
                    <span class="support_dotstore_image">
                        <a  target = "_blank" href="<?php echo esc_url(WPF_SUPPORT_URL); ?>" > 
                            <img src="<?php echo esc_url(WPF_PLUGIN_URL) . 'admin/images/support_new.png'; ?>">
                        </a>
                    </span>
                </div>
            </div>

            <?php
            $fee_getting_started = '';
            $current_page = filter_input(INPUT_GET,'page',FILTER_SANITIZE_STRING);
            $fee_list = isset($current_page) && 'wpf-list' === $current_page ? 'active' : '';
            $fee_add = isset($current_page) && 'wpf-add-new' === $current_page ? 'active' : '';
            if (!empty($current_page) && ('wpf-get-started' === $current_page)) {
                $fee_getting_started = 'active';
            }
            $premium_version = isset($current_page) && 'wpf-premium' === $current_page ? 'active' : '';
            $fee_information = isset($current_page) && 'wpf-information' === $current_page ? 'active' : '';

            if (isset($current_page) && 'wpf-information' === $current_page || isset($current_page) && 'wpf-get-started'  === $current_page ) {
                $fee_about = 'active';
            } else {
                $fee_about = '';
            }
            $wpf_action = filter_input(INPUT_GET,'action',FILTER_SANITIZE_STRING);
            if (!empty($wpf_action)) {
                if ('add' === $wpf_action || 'edit' === $wpf_action ) {
                    $fee_add = 'active';
                }
            }

            if (!empty($wpf_action)) {
                if ('edit' === $wpf_action && 'wpf-edit-wizard' === $current_page) {
                    $wizard_id = $_REQUEST['wrd_id'];
                    $wpfnonce = $_REQUEST['_wpnonce'];
                    $wizard_header_title = WPF_EDIT_WIZARD;
                    $wizard_header_url = home_url('/wp-admin/admin.php?page=wpf-edit-wizard&wrd_id=' . $wizard_id . '&action=edit' . '&_wpnonce=' . $wpfnonce);
                } else {
                    $wizard_header_title = WPF_ADD_NEW_WIZARD;
                    $wizard_header_url = home_url('/wp-admin/admin.php?page=wpf-add-new');
                }
            } else {
                $wizard_header_title = WPF_ADD_NEW_WIZARD;
                $wizard_header_url = home_url('/wp-admin/admin.php?page=wpf-add-new');
            }
            ?>
            <div class="dots-menu-main">
                <nav>
                    <ul>
                        <li>
                            <a class="dotstore_plugin <?php echo esc_attr($fee_list); ?>"  href="<?php echo esc_url(home_url('/wp-admin/admin.php?page=wpf-list')); ?>"><?php esc_html_e(WPF_LIST_PAGE_TITLE, WPF_TEXT_DOMAIN); ?></a>
                        </li>
                        <li>
                            <a class="dotstore_plugin <?php echo esc_attr($fee_add); ?>"  href="<?php echo esc_url($wizard_header_url); ?>"> <?php esc_html_e($wizard_header_title, WPF_TEXT_DOMAIN); ?></a>
                        </li>
                        <li>
                            <a class="dotstore_plugin"  href="javascript:void(0);" onclick="alert('Available on pro version');"><?php esc_html_e(WPF_GENERAL_SETTING_PAGE_TITLE, WPF_TEXT_DOMAIN); ?></a>
                        </li>
                        <li>
                            <a class="dotstore_plugin <?php echo esc_attr($premium_version); ?>"  href="<?php echo esc_url(home_url('/wp-admin/admin.php?page=wpf-premium')); ?>"> <?php esc_html_e(WPF_PREMIUM_VERSION, WPF_TEXT_DOMAIN); ?></a>
                        </li>
                        <li>
                            <a class="dotstore_plugin <?php echo esc_attr($fee_about); ?>"  href="<?php echo esc_url(home_url('/wp-admin/admin.php?page=wpf-get-started')); ?>"><?php esc_html_e(WPF_ABOUT_PLUGIN, WPF_TEXT_DOMAIN); ?></a>
                            <ul class="sub-menu">
                                <li><a  class="dotstore_plugin <?php echo esc_attr($fee_getting_started); ?>" href="<?php echo esc_url(home_url('/wp-admin/admin.php?page=wpf-get-started')); ?>"><?php esc_html_e(WPF_GETTING_STARTED, WPF_TEXT_DOMAIN); ?></a></li>
                                <li><a class="dotstore_plugin <?php echo esc_attr($fee_information); ?>" href="<?php echo esc_url(home_url('/wp-admin/admin.php?page=wpf-information')); ?>"><?php esc_html_e(WPF_QUICK_INFO, WPF_TEXT_DOMAIN); ?></a></li>
                            </ul>
                        </li>
                        <li>
                            <a class="dotstore_plugin"  href="#"><?php esc_html_e('Dotstore', WPF_TEXT_DOMAIN); ?></a>
                            <ul class="sub-menu">
                                <li><a target="_blank" href="<?php echo esc_url('http://www.thedotstore.com/woocommerce-plugins/'); ?>"><?php esc_html_e(WPF_WOOCOMMERCE_PLUGINS, WPF_TEXT_DOMAIN); ?></a></li>
                                <li><a target="_blank" href="<?php echo esc_url('http://www.thedotstore.com/wordpress-plugins/'); ?>"><?php esc_html_e(WPF_WORDPRESS_PLUGINS, WPF_TEXT_DOMAIN); ?></a></li><br>
                                <li><a target="_blank" href="<?php echo esc_url('https://www.thedotstore.com/support/'); ?>"><?php esc_html_e(WPF_CONTACT_SUPPORT, WPF_TEXT_DOMAIN); ?></a></li>
                            </ul>
                        </li>
                    </ul>
                </nav>
            </div>
        </header>