/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../../../node_modules/.pnpm/@automattic+format-currency@1.0.0-alpha.0/node_modules/@automattic/format-currency/dist/esm/currencies.js":
/*!*********************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@automattic+format-currency@1.0.0-alpha.0/node_modules/@automattic/format-currency/dist/esm/currencies.js ***!
  \*********************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CURRENCIES": function() { return /* binding */ CURRENCIES; },
/* harmony export */   "getCurrencyDefaults": function() { return /* binding */ getCurrencyDefaults; }
/* harmony export */ });
var CURRENCIES = {
  AED: {
    symbol: 'د.إ.‏',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  AFN: {
    symbol: '؋',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  ALL: {
    symbol: 'Lek',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  AMD: {
    symbol: '֏',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  ANG: {
    symbol: 'ƒ',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  AOA: {
    symbol: 'Kz',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  ARS: {
    symbol: '$',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  AUD: {
    symbol: 'A$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  AWG: {
    symbol: 'ƒ',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  AZN: {
    symbol: '₼',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  BAM: {
    symbol: 'КМ',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  BBD: {
    symbol: 'Bds$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  BDT: {
    symbol: '৳',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  BGN: {
    symbol: 'лв.',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  BHD: {
    symbol: 'د.ب.‏',
    grouping: ',',
    decimal: '.',
    precision: 3
  },
  BIF: {
    symbol: 'FBu',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  BMD: {
    symbol: '$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  BND: {
    symbol: '$',
    grouping: '.',
    decimal: ',',
    precision: 0
  },
  BOB: {
    symbol: 'Bs',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  BRL: {
    symbol: 'R$',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  BSD: {
    symbol: '$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  BTC: {
    symbol: 'Ƀ',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  BTN: {
    symbol: 'Nu.',
    grouping: ',',
    decimal: '.',
    precision: 1
  },
  BWP: {
    symbol: 'P',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  BYR: {
    symbol: 'р.',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  BZD: {
    symbol: 'BZ$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  CAD: {
    symbol: 'C$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  CDF: {
    symbol: 'FC',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  CHF: {
    symbol: 'CHF',
    grouping: "'",
    decimal: '.',
    precision: 2
  },
  CLP: {
    symbol: '$',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  CNY: {
    symbol: '¥',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  COP: {
    symbol: '$',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  CRC: {
    symbol: '₡',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  CUC: {
    symbol: 'CUC',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  CUP: {
    symbol: '$MN',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  CVE: {
    symbol: '$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  CZK: {
    symbol: 'Kč',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  DJF: {
    symbol: 'Fdj',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  DKK: {
    symbol: 'kr.',
    grouping: '',
    decimal: ',',
    precision: 2
  },
  DOP: {
    symbol: 'RD$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  DZD: {
    symbol: 'د.ج.‏',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  EGP: {
    symbol: 'ج.م.‏',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  ERN: {
    symbol: 'Nfk',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  ETB: {
    symbol: 'ETB',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  EUR: {
    symbol: '€',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  FJD: {
    symbol: 'FJ$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  FKP: {
    symbol: '£',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  GBP: {
    symbol: '£',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  GEL: {
    symbol: 'Lari',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  GHS: {
    symbol: '₵',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  GIP: {
    symbol: '£',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  GMD: {
    symbol: 'D',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  GNF: {
    symbol: 'FG',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  GTQ: {
    symbol: 'Q',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  GYD: {
    symbol: 'G$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  HKD: {
    symbol: 'HK$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  HNL: {
    symbol: 'L.',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  HRK: {
    symbol: 'kn',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  HTG: {
    symbol: 'G',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  HUF: {
    symbol: 'Ft',
    grouping: '.',
    decimal: ',',
    precision: 0
  },
  IDR: {
    symbol: 'Rp',
    grouping: '.',
    decimal: ',',
    precision: 0
  },
  ILS: {
    symbol: '₪',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  INR: {
    symbol: '₹',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  IQD: {
    symbol: 'د.ع.‏',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  IRR: {
    symbol: '﷼',
    grouping: ',',
    decimal: '/',
    precision: 2
  },
  ISK: {
    symbol: 'kr.',
    grouping: '.',
    decimal: ',',
    precision: 0
  },
  JMD: {
    symbol: 'J$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  JOD: {
    symbol: 'د.ا.‏',
    grouping: ',',
    decimal: '.',
    precision: 3
  },
  JPY: {
    symbol: '¥',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  KES: {
    symbol: 'S',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  KGS: {
    symbol: 'сом',
    grouping: ' ',
    decimal: '-',
    precision: 2
  },
  KHR: {
    symbol: '៛',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  KMF: {
    symbol: 'CF',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  KPW: {
    symbol: '₩',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  KRW: {
    symbol: '₩',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  KWD: {
    symbol: 'د.ك.‏',
    grouping: ',',
    decimal: '.',
    precision: 3
  },
  KYD: {
    symbol: '$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  KZT: {
    symbol: '₸',
    grouping: ' ',
    decimal: '-',
    precision: 2
  },
  LAK: {
    symbol: '₭',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  LBP: {
    symbol: 'ل.ل.‏',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  LKR: {
    symbol: '₨',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  LRD: {
    symbol: 'L$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  LSL: {
    symbol: 'M',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  LYD: {
    symbol: 'د.ل.‏',
    grouping: ',',
    decimal: '.',
    precision: 3
  },
  MAD: {
    symbol: 'د.م.‏',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  MDL: {
    symbol: 'lei',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  MGA: {
    symbol: 'Ar',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  MKD: {
    symbol: 'ден.',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  MMK: {
    symbol: 'K',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  MNT: {
    symbol: '₮',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  MOP: {
    symbol: 'MOP$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  MRO: {
    symbol: 'UM',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  MTL: {
    symbol: '₤',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  MUR: {
    symbol: '₨',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  MVR: {
    symbol: 'MVR',
    grouping: ',',
    decimal: '.',
    precision: 1
  },
  MWK: {
    symbol: 'MK',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  MXN: {
    symbol: 'MX$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  MYR: {
    symbol: 'RM',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  MZN: {
    symbol: 'MT',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  NAD: {
    symbol: 'N$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  NGN: {
    symbol: '₦',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  NIO: {
    symbol: 'C$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  NOK: {
    symbol: 'kr',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  NPR: {
    symbol: '₨',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  NZD: {
    symbol: 'NZ$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  OMR: {
    symbol: '﷼',
    grouping: ',',
    decimal: '.',
    precision: 3
  },
  PAB: {
    symbol: 'B/.',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  PEN: {
    symbol: 'S/.',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  PGK: {
    symbol: 'K',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  PHP: {
    symbol: '₱',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  PKR: {
    symbol: '₨',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  PLN: {
    symbol: 'zł',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  PYG: {
    symbol: '₲',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  QAR: {
    symbol: '﷼',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  RON: {
    symbol: 'lei',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  RSD: {
    symbol: 'Дин.',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  RUB: {
    symbol: '₽',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  RWF: {
    symbol: 'RWF',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  SAR: {
    symbol: '﷼',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SBD: {
    symbol: 'S$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SCR: {
    symbol: '₨',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SDD: {
    symbol: 'LSd',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SDG: {
    symbol: '£‏',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SEK: {
    symbol: 'kr',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SGD: {
    symbol: 'S$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SHP: {
    symbol: '£',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SLL: {
    symbol: 'Le',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SOS: {
    symbol: 'S',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SRD: {
    symbol: '$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  STD: {
    symbol: 'Db',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SVC: {
    symbol: '₡',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SYP: {
    symbol: '£',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  SZL: {
    symbol: 'E',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  THB: {
    symbol: '฿',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  TJS: {
    symbol: 'TJS',
    grouping: ' ',
    decimal: ';',
    precision: 2
  },
  TMT: {
    symbol: 'm',
    grouping: ' ',
    decimal: ',',
    precision: 0
  },
  TND: {
    symbol: 'د.ت.‏',
    grouping: ',',
    decimal: '.',
    precision: 3
  },
  TOP: {
    symbol: 'T$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  TRY: {
    symbol: 'TL',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  TTD: {
    symbol: 'TT$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  TVD: {
    symbol: '$T',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  TWD: {
    symbol: 'NT$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  TZS: {
    symbol: 'TSh',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  UAH: {
    symbol: '₴',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  UGX: {
    symbol: 'USh',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  USD: {
    symbol: '$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  UYU: {
    symbol: '$U',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  UZS: {
    symbol: 'сўм',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  VEB: {
    symbol: 'Bs.',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  VEF: {
    symbol: 'Bs. F.',
    grouping: '.',
    decimal: ',',
    precision: 2
  },
  VND: {
    symbol: '₫',
    grouping: '.',
    decimal: ',',
    precision: 1
  },
  VUV: {
    symbol: 'VT',
    grouping: ',',
    decimal: '.',
    precision: 0
  },
  WST: {
    symbol: 'WS$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  XAF: {
    symbol: 'F',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  XCD: {
    symbol: '$',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  XOF: {
    symbol: 'F',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  XPF: {
    symbol: 'F',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  YER: {
    symbol: '﷼',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  ZAR: {
    symbol: 'R',
    grouping: ' ',
    decimal: ',',
    precision: 2
  },
  ZMW: {
    symbol: 'ZK',
    grouping: ',',
    decimal: '.',
    precision: 2
  },
  WON: {
    symbol: '₩',
    grouping: ',',
    decimal: '.',
    precision: 2
  }
};
/**
 * Returns currency defaults.
 * @param   {String} code      currency code
 * @returns {?Object}          currency defaults
 */

function getCurrencyDefaults(code) {
  var defaultCurrency = {
    symbol: '$',
    grouping: ',',
    decimal: '.',
    precision: 2
  };
  return CURRENCIES[code] || defaultCurrency;
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@automattic+format-currency@1.0.0-alpha.0/node_modules/@automattic/format-currency/dist/esm/index.js":
/*!****************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@automattic+format-currency@1.0.0-alpha.0/node_modules/@automattic/format-currency/dist/esm/index.js ***!
  \****************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getCurrencyDefaults": function() { return /* reexport safe */ _currencies__WEBPACK_IMPORTED_MODULE_1__.getCurrencyDefaults; },
/* harmony export */   "CURRENCIES": function() { return /* reexport safe */ _currencies__WEBPACK_IMPORTED_MODULE_1__.CURRENCIES; },
/* harmony export */   "default": function() { return /* binding */ formatCurrency; },
/* harmony export */   "getCurrencyObject": function() { return /* binding */ getCurrencyObject; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_objectSpread__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/objectSpread */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/objectSpread.js");
/* harmony import */ var i18n_calypso__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! i18n-calypso */ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/index.js");
/* harmony import */ var _currencies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./currencies */ "../../../node_modules/.pnpm/@automattic+format-currency@1.0.0-alpha.0/node_modules/@automattic/format-currency/dist/esm/currencies.js");


/**
 * External dependencies
 */

/**
 * Internal dependencies
 */




/**
 * Formats money with a given currency code
 * @param   {Number}     number              number to format
 * @param   {String}     code                currency code e.g. 'USD'
 * @param   {Object}     options             options object
 * @param   {String}     options.decimal     decimal symbol e.g. ','
 * @param   {String}     options.grouping    thousands separator
 * @param   {Number}     options.precision   decimal digits
 * @param   {String}     options.symbol      currency symbol e.g. 'A$'
 * @returns {?String}                        A formatted string.
 */

function formatCurrency(number, code) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var currencyDefaults = (0,_currencies__WEBPACK_IMPORTED_MODULE_1__.getCurrencyDefaults)(code);

  if (!currencyDefaults || isNaN(number)) {
    return null;
  }

  var _currencyDefaults$opt = (0,_babel_runtime_helpers_objectSpread__WEBPACK_IMPORTED_MODULE_0__["default"])({}, currencyDefaults, options),
      decimal = _currencyDefaults$opt.decimal,
      grouping = _currencyDefaults$opt.grouping,
      precision = _currencyDefaults$opt.precision,
      symbol = _currencyDefaults$opt.symbol;

  var sign = number < 0 ? '-' : '';
  var value = (0,i18n_calypso__WEBPACK_IMPORTED_MODULE_2__.numberFormat)(Math.abs(number), {
    decimals: precision,
    thousandsSep: grouping,
    decPoint: decimal
  });
  return "".concat(sign).concat(symbol).concat(value);
}
/**
 * Returns a formatted price object.
 * @param   {Number}     number              number to format
 * @param   {String}     code                currency code e.g. 'USD'
 * @param   {Object}     options             options object
 * @param   {String}     options.decimal     decimal symbol e.g. ','
 * @param   {String}     options.grouping    thousands separator
 * @param   {Number}     options.precision   decimal digits
 * @param   {String}     options.symbol      currency symbol e.g. 'A$'
 * @returns {?String}                        A formatted string e.g. { symbol:'$', integer: '$99', fraction: '.99', sign: '-' }
 */

function getCurrencyObject(number, code) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var currencyDefaults = (0,_currencies__WEBPACK_IMPORTED_MODULE_1__.getCurrencyDefaults)(code);

  if (!currencyDefaults || isNaN(number)) {
    return null;
  }

  var _currencyDefaults$opt2 = (0,_babel_runtime_helpers_objectSpread__WEBPACK_IMPORTED_MODULE_0__["default"])({}, currencyDefaults, options),
      decimal = _currencyDefaults$opt2.decimal,
      grouping = _currencyDefaults$opt2.grouping,
      precision = _currencyDefaults$opt2.precision,
      symbol = _currencyDefaults$opt2.symbol;

  var sign = number < 0 ? '-' : '';
  var absNumber = Math.abs(number);
  var rawInteger = Math.floor(absNumber);
  var integer = (0,i18n_calypso__WEBPACK_IMPORTED_MODULE_2__.numberFormat)(rawInteger, {
    decimals: 0,
    thousandsSep: grouping,
    decPoint: decimal
  });
  var fraction = precision > 0 ? (0,i18n_calypso__WEBPACK_IMPORTED_MODULE_2__.numberFormat)(absNumber - rawInteger, {
    decimals: precision,
    thousandsSep: grouping,
    decPoint: decimal
  }).slice(1) : '';
  return {
    sign: sign,
    symbol: symbol,
    integer: integer,
    fraction: fraction
  };
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/defineProperty.js":
/*!***************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/defineProperty.js ***!
  \***************************************************************************************************************/
/***/ (function(module) {

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

module.exports = _defineProperty;
module.exports["default"] = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/extends.js":
/*!********************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/extends.js ***!
  \********************************************************************************************************/
/***/ (function(module) {

function _extends() {
  module.exports = _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  module.exports["default"] = module.exports, module.exports.__esModule = true;
  return _extends.apply(this, arguments);
}

module.exports = _extends;
module.exports["default"] = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "../../../node_modules/.pnpm/@tannin+compile@1.1.0/node_modules/@tannin/compile/index.js":
/*!***********************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@tannin+compile@1.1.0/node_modules/@tannin/compile/index.js ***!
  \***********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ compile; }
/* harmony export */ });
/* harmony import */ var _tannin_postfix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tannin/postfix */ "../../../node_modules/.pnpm/@tannin+postfix@1.1.0/node_modules/@tannin/postfix/index.js");
/* harmony import */ var _tannin_evaluate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @tannin/evaluate */ "../../../node_modules/.pnpm/@tannin+evaluate@1.2.0/node_modules/@tannin/evaluate/index.js");



/**
 * Given a C expression, returns a function which can be called to evaluate its
 * result.
 *
 * @example
 *
 * ```js
 * import compile from '@tannin/compile';
 *
 * const evaluate = compile( 'n > 1' );
 *
 * evaluate( { n: 2 } );
 * // ⇒ true
 * ```
 *
 * @param {string} expression C expression.
 *
 * @return {(variables?:{[variable:string]:*})=>*} Compiled evaluator.
 */
function compile( expression ) {
	var terms = (0,_tannin_postfix__WEBPACK_IMPORTED_MODULE_0__["default"])( expression );

	return function( variables ) {
		return (0,_tannin_evaluate__WEBPACK_IMPORTED_MODULE_1__["default"])( terms, variables );
	};
}


/***/ }),

/***/ "../../../node_modules/.pnpm/@tannin+evaluate@1.2.0/node_modules/@tannin/evaluate/index.js":
/*!*************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@tannin+evaluate@1.2.0/node_modules/@tannin/evaluate/index.js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ evaluate; }
/* harmony export */ });
/**
 * Operator callback functions.
 *
 * @type {Object}
 */
var OPERATORS = {
	'!': function( a ) {
		return ! a;
	},
	'*': function( a, b ) {
		return a * b;
	},
	'/': function( a, b ) {
		return a / b;
	},
	'%': function( a, b ) {
		return a % b;
	},
	'+': function( a, b ) {
		return a + b;
	},
	'-': function( a, b ) {
		return a - b;
	},
	'<': function( a, b ) {
		return a < b;
	},
	'<=': function( a, b ) {
		return a <= b;
	},
	'>': function( a, b ) {
		return a > b;
	},
	'>=': function( a, b ) {
		return a >= b;
	},
	'==': function( a, b ) {
		return a === b;
	},
	'!=': function( a, b ) {
		return a !== b;
	},
	'&&': function( a, b ) {
		return a && b;
	},
	'||': function( a, b ) {
		return a || b;
	},
	'?:': function( a, b, c ) {
		if ( a ) {
			throw b;
		}

		return c;
	},
};

/**
 * Given an array of postfix terms and operand variables, returns the result of
 * the postfix evaluation.
 *
 * @example
 *
 * ```js
 * import evaluate from '@tannin/evaluate';
 *
 * // 3 + 4 * 5 / 6 ⇒ '3 4 5 * 6 / +'
 * const terms = [ '3', '4', '5', '*', '6', '/', '+' ];
 *
 * evaluate( terms, {} );
 * // ⇒ 6.333333333333334
 * ```
 *
 * @param {string[]} postfix   Postfix terms.
 * @param {Object}   variables Operand variables.
 *
 * @return {*} Result of evaluation.
 */
function evaluate( postfix, variables ) {
	var stack = [],
		i, j, args, getOperatorResult, term, value;

	for ( i = 0; i < postfix.length; i++ ) {
		term = postfix[ i ];

		getOperatorResult = OPERATORS[ term ];
		if ( getOperatorResult ) {
			// Pop from stack by number of function arguments.
			j = getOperatorResult.length;
			args = Array( j );
			while ( j-- ) {
				args[ j ] = stack.pop();
			}

			try {
				value = getOperatorResult.apply( null, args );
			} catch ( earlyReturn ) {
				return earlyReturn;
			}
		} else if ( variables.hasOwnProperty( term ) ) {
			value = variables[ term ];
		} else {
			value = +term;
		}

		stack.push( value );
	}

	return stack[ 0 ];
}


/***/ }),

/***/ "../../../node_modules/.pnpm/@tannin+plural-forms@1.1.0/node_modules/@tannin/plural-forms/index.js":
/*!*********************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@tannin+plural-forms@1.1.0/node_modules/@tannin/plural-forms/index.js ***!
  \*********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ pluralForms; }
/* harmony export */ });
/* harmony import */ var _tannin_compile__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tannin/compile */ "../../../node_modules/.pnpm/@tannin+compile@1.1.0/node_modules/@tannin/compile/index.js");


/**
 * Given a C expression, returns a function which, when called with a value,
 * evaluates the result with the value assumed to be the "n" variable of the
 * expression. The result will be coerced to its numeric equivalent.
 *
 * @param {string} expression C expression.
 *
 * @return {Function} Evaluator function.
 */
function pluralForms( expression ) {
	var evaluate = (0,_tannin_compile__WEBPACK_IMPORTED_MODULE_0__["default"])( expression );

	return function( n ) {
		return +evaluate( { n: n } );
	};
}


/***/ }),

/***/ "../../../node_modules/.pnpm/@tannin+postfix@1.1.0/node_modules/@tannin/postfix/index.js":
/*!***********************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@tannin+postfix@1.1.0/node_modules/@tannin/postfix/index.js ***!
  \***********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ postfix; }
/* harmony export */ });
var PRECEDENCE, OPENERS, TERMINATORS, PATTERN;

/**
 * Operator precedence mapping.
 *
 * @type {Object}
 */
PRECEDENCE = {
	'(': 9,
	'!': 8,
	'*': 7,
	'/': 7,
	'%': 7,
	'+': 6,
	'-': 6,
	'<': 5,
	'<=': 5,
	'>': 5,
	'>=': 5,
	'==': 4,
	'!=': 4,
	'&&': 3,
	'||': 2,
	'?': 1,
	'?:': 1,
};

/**
 * Characters which signal pair opening, to be terminated by terminators.
 *
 * @type {string[]}
 */
OPENERS = [ '(', '?' ];

/**
 * Characters which signal pair termination, the value an array with the
 * opener as its first member. The second member is an optional operator
 * replacement to push to the stack.
 *
 * @type {string[]}
 */
TERMINATORS = {
	')': [ '(' ],
	':': [ '?', '?:' ],
};

/**
 * Pattern matching operators and openers.
 *
 * @type {RegExp}
 */
PATTERN = /<=|>=|==|!=|&&|\|\||\?:|\(|!|\*|\/|%|\+|-|<|>|\?|\)|:/;

/**
 * Given a C expression, returns the equivalent postfix (Reverse Polish)
 * notation terms as an array.
 *
 * If a postfix string is desired, simply `.join( ' ' )` the result.
 *
 * @example
 *
 * ```js
 * import postfix from '@tannin/postfix';
 *
 * postfix( 'n > 1' );
 * // ⇒ [ 'n', '1', '>' ]
 * ```
 *
 * @param {string} expression C expression.
 *
 * @return {string[]} Postfix terms.
 */
function postfix( expression ) {
	var terms = [],
		stack = [],
		match, operator, term, element;

	while ( ( match = expression.match( PATTERN ) ) ) {
		operator = match[ 0 ];

		// Term is the string preceding the operator match. It may contain
		// whitespace, and may be empty (if operator is at beginning).
		term = expression.substr( 0, match.index ).trim();
		if ( term ) {
			terms.push( term );
		}

		while ( ( element = stack.pop() ) ) {
			if ( TERMINATORS[ operator ] ) {
				if ( TERMINATORS[ operator ][ 0 ] === element ) {
					// Substitution works here under assumption that because
					// the assigned operator will no longer be a terminator, it
					// will be pushed to the stack during the condition below.
					operator = TERMINATORS[ operator ][ 1 ] || operator;
					break;
				}
			} else if ( OPENERS.indexOf( element ) >= 0 || PRECEDENCE[ element ] < PRECEDENCE[ operator ] ) {
				// Push to stack if either an opener or when pop reveals an
				// element of lower precedence.
				stack.push( element );
				break;
			}

			// For each popped from stack, push to terms.
			terms.push( element );
		}

		if ( ! TERMINATORS[ operator ] ) {
			stack.push( operator );
		}

		// Slice matched fragment from expression to continue match.
		expression = expression.substr( match.index + operator.length );
	}

	// Push remainder of operand, if exists, to terms.
	expression = expression.trim();
	if ( expression ) {
		terms.push( expression );
	}

	// Pop remaining items from stack into terms.
	return terms.concat( stack.reverse() );
}


/***/ }),

/***/ "../../../node_modules/.pnpm/@tannin+sprintf@1.2.0/node_modules/@tannin/sprintf/index.js":
/*!***********************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@tannin+sprintf@1.2.0/node_modules/@tannin/sprintf/index.js ***!
  \***********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ sprintf; }
/* harmony export */ });
/**
 * Regular expression matching format placeholder syntax.
 *
 * The pattern for matching named arguments is a naive and incomplete matcher
 * against valid JavaScript identifier names.
 *
 * via Mathias Bynens:
 *
 * >An identifier must start with $, _, or any character in the Unicode
 * >categories “Uppercase letter (Lu)”, “Lowercase letter (Ll)”, “Titlecase
 * >letter (Lt)”, “Modifier letter (Lm)”, “Other letter (Lo)”, or “Letter
 * >number (Nl)”.
 * >
 * >The rest of the string can contain the same characters, plus any U+200C zero
 * >width non-joiner characters, U+200D zero width joiner characters, and
 * >characters in the Unicode categories “Non-spacing mark (Mn)”, “Spacing
 * >combining mark (Mc)”, “Decimal digit number (Nd)”, or “Connector
 * >punctuation (Pc)”.
 *
 * If browser support is constrained to those supporting ES2015, this could be
 * made more accurate using the `u` flag:
 *
 * ```
 * /^[$_\p{L}\p{Nl}][$_\p{L}\p{Nl}\u200C\u200D\p{Mn}\p{Mc}\p{Nd}\p{Pc}]*$/u;
 * ```
 *
 * @see http://www.pixelbeat.org/programming/gcc/format_specs.html
 * @see https://mathiasbynens.be/notes/javascript-identifiers#valid-identifier-names
 *
 * @type {RegExp}
 */
var PATTERN = /%(((\d+)\$)|(\(([$_a-zA-Z][$_a-zA-Z0-9]*)\)))?[ +0#-]*\d*(\.(\d+|\*))?(ll|[lhqL])?([cduxXefgsp%])/g;
//               ▲         ▲                    ▲       ▲  ▲            ▲           ▲ type
//               │         │                    │       │  │            └ Length (unsupported)
//               │         │                    │       │  └ Precision / max width
//               │         │                    │       └ Min width (unsupported)
//               │         │                    └ Flags (unsupported)
//               └ Index   └ Name (for named arguments)

/**
 * Given a format string, returns string with arguments interpolatation.
 * Arguments can either be provided directly via function arguments spread, or
 * with an array as the second argument.
 *
 * @see https://en.wikipedia.org/wiki/Printf_format_string
 *
 * @example
 *
 * ```js
 * import sprintf from '@tannin/sprintf';
 *
 * sprintf( 'Hello %s!', 'world' );
 * // ⇒ 'Hello world!'
 * ```
 *
 * @param {string}                                   string printf format string
 * @param {...string|string[]|Object<string,string>} [args] String arguments.
 *
 * @return {string} Formatted string.
 */
function sprintf( string, args ) {
	var i;

	if ( ! Array.isArray( args ) ) {
		// Construct a copy of arguments from index one, used for replace
		// function placeholder substitution.
		args = new Array( arguments.length - 1 );
		for ( i = 1; i < arguments.length; i++ ) {
			args[ i - 1 ] = arguments[ i ];
		}
	}

	i = 1;

	return string.replace( PATTERN, function() {
		var index, name, precision, type, value;

		index = arguments[ 3 ];
		name = arguments[ 5 ];
		precision = arguments[ 7 ];
		type = arguments[ 9 ];

		// There's no placeholder substitution in the explicit "%", meaning it
		// is not necessary to increment argument index.
		if ( type === '%' ) {
			return '%';
		}

		// Asterisk precision determined by peeking / shifting next argument.
		if ( precision === '*' ) {
			precision = args[ i - 1 ];
			i++;
		}

		if ( name !== undefined ) {
			// If it's a named argument, use name.
			if ( args[ 0 ] && typeof args[ 0 ] === 'object' &&
					args[ 0 ].hasOwnProperty( name ) ) {
				value = args[ 0 ][ name ];
			}
		} else {
			// If not a positional argument, use counter value.
			if ( index === undefined ) {
				index = i;
			}

			i++;

			// Positional argument.
			value = args[ index - 1 ];
		}

		// Parse as type.
		if ( type === 'f' ) {
			value = parseFloat( value ) || 0;
		} else if ( type === 'd' ) {
			value = parseInt( value ) || 0;
		}

		// Apply precision.
		if ( precision !== undefined ) {
			if ( type === 'f' ) {
				value = value.toFixed( precision );
			} else if ( type === 's' ) {
				value = value.substr( 0, precision );
			}
		}

		// To avoid "undefined" concatenation, return empty string if no
		// placeholder substitution can be performed.
		return value !== undefined && value !== null ? value : '';
	} );
}


/***/ }),

/***/ "../../../node_modules/.pnpm/classnames@2.3.1/node_modules/classnames/index.js":
/*!*************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/classnames@2.3.1/node_modules/classnames/index.js ***!
  \*************************************************************************************/
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
  Copyright (c) 2018 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;

	function classNames() {
		var classes = [];

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (!arg) continue;

			var argType = typeof arg;

			if (argType === 'string' || argType === 'number') {
				classes.push(arg);
			} else if (Array.isArray(arg)) {
				if (arg.length) {
					var inner = classNames.apply(null, arg);
					if (inner) {
						classes.push(inner);
					}
				}
			} else if (argType === 'object') {
				if (arg.toString === Object.prototype.toString) {
					for (var key in arg) {
						if (hasOwn.call(arg, key) && arg[key]) {
							classes.push(key);
						}
					}
				} else {
					classes.push(arg.toString());
				}
			}
		}

		return classes.join(' ');
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ }),

/***/ "../../../node_modules/.pnpm/debug@4.3.1/node_modules/debug/src/browser.js":
/*!*********************************************************************************!*\
  !*** ../../../node_modules/.pnpm/debug@4.3.1/node_modules/debug/src/browser.js ***!
  \*********************************************************************************/
/***/ (function(module, exports, __webpack_require__) {

/* eslint-env browser */

/**
 * This is the web browser implementation of `debug()`.
 */

exports.formatArgs = formatArgs;
exports.save = save;
exports.load = load;
exports.useColors = useColors;
exports.storage = localstorage();
exports.destroy = (() => {
	let warned = false;

	return () => {
		if (!warned) {
			warned = true;
			console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
		}
	};
})();

/**
 * Colors.
 */

exports.colors = [
	'#0000CC',
	'#0000FF',
	'#0033CC',
	'#0033FF',
	'#0066CC',
	'#0066FF',
	'#0099CC',
	'#0099FF',
	'#00CC00',
	'#00CC33',
	'#00CC66',
	'#00CC99',
	'#00CCCC',
	'#00CCFF',
	'#3300CC',
	'#3300FF',
	'#3333CC',
	'#3333FF',
	'#3366CC',
	'#3366FF',
	'#3399CC',
	'#3399FF',
	'#33CC00',
	'#33CC33',
	'#33CC66',
	'#33CC99',
	'#33CCCC',
	'#33CCFF',
	'#6600CC',
	'#6600FF',
	'#6633CC',
	'#6633FF',
	'#66CC00',
	'#66CC33',
	'#9900CC',
	'#9900FF',
	'#9933CC',
	'#9933FF',
	'#99CC00',
	'#99CC33',
	'#CC0000',
	'#CC0033',
	'#CC0066',
	'#CC0099',
	'#CC00CC',
	'#CC00FF',
	'#CC3300',
	'#CC3333',
	'#CC3366',
	'#CC3399',
	'#CC33CC',
	'#CC33FF',
	'#CC6600',
	'#CC6633',
	'#CC9900',
	'#CC9933',
	'#CCCC00',
	'#CCCC33',
	'#FF0000',
	'#FF0033',
	'#FF0066',
	'#FF0099',
	'#FF00CC',
	'#FF00FF',
	'#FF3300',
	'#FF3333',
	'#FF3366',
	'#FF3399',
	'#FF33CC',
	'#FF33FF',
	'#FF6600',
	'#FF6633',
	'#FF9900',
	'#FF9933',
	'#FFCC00',
	'#FFCC33'
];

/**
 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
 * and the Firebug extension (any Firefox version) are known
 * to support "%c" CSS customizations.
 *
 * TODO: add a `localStorage` variable to explicitly enable/disable colors
 */

// eslint-disable-next-line complexity
function useColors() {
	// NB: In an Electron preload script, document will be defined but not fully
	// initialized. Since we know we're in Chrome, we'll just detect this case
	// explicitly
	if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
		return true;
	}

	// Internet Explorer and Edge do not support colors.
	if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
		return false;
	}

	// Is webkit? http://stackoverflow.com/a/16459606/376773
	// document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
	return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
		// Is firebug? http://stackoverflow.com/a/398120/376773
		(typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
		// Is firefox >= v31?
		// https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
		(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31) ||
		// Double check webkit in userAgent just in case we are in a worker
		(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
}

/**
 * Colorize log arguments if enabled.
 *
 * @api public
 */

function formatArgs(args) {
	args[0] = (this.useColors ? '%c' : '') +
		this.namespace +
		(this.useColors ? ' %c' : ' ') +
		args[0] +
		(this.useColors ? '%c ' : ' ') +
		'+' + module.exports.humanize(this.diff);

	if (!this.useColors) {
		return;
	}

	const c = 'color: ' + this.color;
	args.splice(1, 0, c, 'color: inherit');

	// The final "%c" is somewhat tricky, because there could be other
	// arguments passed either before or after the %c, so we need to
	// figure out the correct index to insert the CSS into
	let index = 0;
	let lastC = 0;
	args[0].replace(/%[a-zA-Z%]/g, match => {
		if (match === '%%') {
			return;
		}
		index++;
		if (match === '%c') {
			// We only are interested in the *last* %c
			// (the user may have provided their own)
			lastC = index;
		}
	});

	args.splice(lastC, 0, c);
}

/**
 * Invokes `console.debug()` when available.
 * No-op when `console.debug` is not a "function".
 * If `console.debug` is not available, falls back
 * to `console.log`.
 *
 * @api public
 */
exports.log = console.debug || console.log || (() => {});

/**
 * Save `namespaces`.
 *
 * @param {String} namespaces
 * @api private
 */
function save(namespaces) {
	try {
		if (namespaces) {
			exports.storage.setItem('debug', namespaces);
		} else {
			exports.storage.removeItem('debug');
		}
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}
}

/**
 * Load `namespaces`.
 *
 * @return {String} returns the previously persisted debug modes
 * @api private
 */
function load() {
	let r;
	try {
		r = exports.storage.getItem('debug');
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}

	// If debug isn't set in LS, and we're in Electron, try to load $DEBUG
	if (!r && typeof process !== 'undefined' && 'env' in process) {
		r = process.env.DEBUG;
	}

	return r;
}

/**
 * Localstorage attempts to return the localstorage.
 *
 * This is necessary because safari throws
 * when a user disables cookies/localstorage
 * and you attempt to access it.
 *
 * @return {LocalStorage}
 * @api private
 */

function localstorage() {
	try {
		// TVMLKit (Apple TV JS Runtime) does not have a window object, just localStorage in the global context
		// The Browser also has localStorage in the global context.
		return localStorage;
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}
}

module.exports = __webpack_require__(/*! ./common */ "../../../node_modules/.pnpm/debug@4.3.1/node_modules/debug/src/common.js")(exports);

const {formatters} = module.exports;

/**
 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
 */

formatters.j = function (v) {
	try {
		return JSON.stringify(v);
	} catch (error) {
		return '[UnexpectedJSONParseError]: ' + error.message;
	}
};


/***/ }),

/***/ "../../../node_modules/.pnpm/debug@4.3.1/node_modules/debug/src/common.js":
/*!********************************************************************************!*\
  !*** ../../../node_modules/.pnpm/debug@4.3.1/node_modules/debug/src/common.js ***!
  \********************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {


/**
 * This is the common logic for both the Node.js and web browser
 * implementations of `debug()`.
 */

function setup(env) {
	createDebug.debug = createDebug;
	createDebug.default = createDebug;
	createDebug.coerce = coerce;
	createDebug.disable = disable;
	createDebug.enable = enable;
	createDebug.enabled = enabled;
	createDebug.humanize = __webpack_require__(/*! ms */ "../../../node_modules/.pnpm/ms@2.1.2/node_modules/ms/index.js");
	createDebug.destroy = destroy;

	Object.keys(env).forEach(key => {
		createDebug[key] = env[key];
	});

	/**
	* The currently active debug mode names, and names to skip.
	*/

	createDebug.names = [];
	createDebug.skips = [];

	/**
	* Map of special "%n" handling functions, for the debug "format" argument.
	*
	* Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
	*/
	createDebug.formatters = {};

	/**
	* Selects a color for a debug namespace
	* @param {String} namespace The namespace string for the for the debug instance to be colored
	* @return {Number|String} An ANSI color code for the given namespace
	* @api private
	*/
	function selectColor(namespace) {
		let hash = 0;

		for (let i = 0; i < namespace.length; i++) {
			hash = ((hash << 5) - hash) + namespace.charCodeAt(i);
			hash |= 0; // Convert to 32bit integer
		}

		return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
	}
	createDebug.selectColor = selectColor;

	/**
	* Create a debugger with the given `namespace`.
	*
	* @param {String} namespace
	* @return {Function}
	* @api public
	*/
	function createDebug(namespace) {
		let prevTime;
		let enableOverride = null;

		function debug(...args) {
			// Disabled?
			if (!debug.enabled) {
				return;
			}

			const self = debug;

			// Set `diff` timestamp
			const curr = Number(new Date());
			const ms = curr - (prevTime || curr);
			self.diff = ms;
			self.prev = prevTime;
			self.curr = curr;
			prevTime = curr;

			args[0] = createDebug.coerce(args[0]);

			if (typeof args[0] !== 'string') {
				// Anything else let's inspect with %O
				args.unshift('%O');
			}

			// Apply any `formatters` transformations
			let index = 0;
			args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
				// If we encounter an escaped % then don't increase the array index
				if (match === '%%') {
					return '%';
				}
				index++;
				const formatter = createDebug.formatters[format];
				if (typeof formatter === 'function') {
					const val = args[index];
					match = formatter.call(self, val);

					// Now we need to remove `args[index]` since it's inlined in the `format`
					args.splice(index, 1);
					index--;
				}
				return match;
			});

			// Apply env-specific formatting (colors, etc.)
			createDebug.formatArgs.call(self, args);

			const logFn = self.log || createDebug.log;
			logFn.apply(self, args);
		}

		debug.namespace = namespace;
		debug.useColors = createDebug.useColors();
		debug.color = createDebug.selectColor(namespace);
		debug.extend = extend;
		debug.destroy = createDebug.destroy; // XXX Temporary. Will be removed in the next major release.

		Object.defineProperty(debug, 'enabled', {
			enumerable: true,
			configurable: false,
			get: () => enableOverride === null ? createDebug.enabled(namespace) : enableOverride,
			set: v => {
				enableOverride = v;
			}
		});

		// Env-specific initialization logic for debug instances
		if (typeof createDebug.init === 'function') {
			createDebug.init(debug);
		}

		return debug;
	}

	function extend(namespace, delimiter) {
		const newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
		newDebug.log = this.log;
		return newDebug;
	}

	/**
	* Enables a debug mode by namespaces. This can include modes
	* separated by a colon and wildcards.
	*
	* @param {String} namespaces
	* @api public
	*/
	function enable(namespaces) {
		createDebug.save(namespaces);

		createDebug.names = [];
		createDebug.skips = [];

		let i;
		const split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
		const len = split.length;

		for (i = 0; i < len; i++) {
			if (!split[i]) {
				// ignore empty strings
				continue;
			}

			namespaces = split[i].replace(/\*/g, '.*?');

			if (namespaces[0] === '-') {
				createDebug.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
			} else {
				createDebug.names.push(new RegExp('^' + namespaces + '$'));
			}
		}
	}

	/**
	* Disable debug output.
	*
	* @return {String} namespaces
	* @api public
	*/
	function disable() {
		const namespaces = [
			...createDebug.names.map(toNamespace),
			...createDebug.skips.map(toNamespace).map(namespace => '-' + namespace)
		].join(',');
		createDebug.enable('');
		return namespaces;
	}

	/**
	* Returns true if the given mode name is enabled, false otherwise.
	*
	* @param {String} name
	* @return {Boolean}
	* @api public
	*/
	function enabled(name) {
		if (name[name.length - 1] === '*') {
			return true;
		}

		let i;
		let len;

		for (i = 0, len = createDebug.skips.length; i < len; i++) {
			if (createDebug.skips[i].test(name)) {
				return false;
			}
		}

		for (i = 0, len = createDebug.names.length; i < len; i++) {
			if (createDebug.names[i].test(name)) {
				return true;
			}
		}

		return false;
	}

	/**
	* Convert regexp to namespace
	*
	* @param {RegExp} regxep
	* @return {String} namespace
	* @api private
	*/
	function toNamespace(regexp) {
		return regexp.toString()
			.substring(2, regexp.toString().length - 2)
			.replace(/\.\*\?$/, '*');
	}

	/**
	* Coerce `val`.
	*
	* @param {Mixed} val
	* @return {Mixed}
	* @api private
	*/
	function coerce(val) {
		if (val instanceof Error) {
			return val.stack || val.message;
		}
		return val;
	}

	/**
	* XXX DO NOT USE. This is a temporary stub function.
	* XXX It WILL be removed in the next major release.
	*/
	function destroy() {
		console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
	}

	createDebug.enable(createDebug.load());

	return createDebug;
}

module.exports = setup;


/***/ }),

/***/ "../../../node_modules/.pnpm/debug@4.3.2/node_modules/debug/src/browser.js":
/*!*********************************************************************************!*\
  !*** ../../../node_modules/.pnpm/debug@4.3.2/node_modules/debug/src/browser.js ***!
  \*********************************************************************************/
/***/ (function(module, exports, __webpack_require__) {

/* eslint-env browser */

/**
 * This is the web browser implementation of `debug()`.
 */

exports.formatArgs = formatArgs;
exports.save = save;
exports.load = load;
exports.useColors = useColors;
exports.storage = localstorage();
exports.destroy = (() => {
	let warned = false;

	return () => {
		if (!warned) {
			warned = true;
			console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
		}
	};
})();

/**
 * Colors.
 */

exports.colors = [
	'#0000CC',
	'#0000FF',
	'#0033CC',
	'#0033FF',
	'#0066CC',
	'#0066FF',
	'#0099CC',
	'#0099FF',
	'#00CC00',
	'#00CC33',
	'#00CC66',
	'#00CC99',
	'#00CCCC',
	'#00CCFF',
	'#3300CC',
	'#3300FF',
	'#3333CC',
	'#3333FF',
	'#3366CC',
	'#3366FF',
	'#3399CC',
	'#3399FF',
	'#33CC00',
	'#33CC33',
	'#33CC66',
	'#33CC99',
	'#33CCCC',
	'#33CCFF',
	'#6600CC',
	'#6600FF',
	'#6633CC',
	'#6633FF',
	'#66CC00',
	'#66CC33',
	'#9900CC',
	'#9900FF',
	'#9933CC',
	'#9933FF',
	'#99CC00',
	'#99CC33',
	'#CC0000',
	'#CC0033',
	'#CC0066',
	'#CC0099',
	'#CC00CC',
	'#CC00FF',
	'#CC3300',
	'#CC3333',
	'#CC3366',
	'#CC3399',
	'#CC33CC',
	'#CC33FF',
	'#CC6600',
	'#CC6633',
	'#CC9900',
	'#CC9933',
	'#CCCC00',
	'#CCCC33',
	'#FF0000',
	'#FF0033',
	'#FF0066',
	'#FF0099',
	'#FF00CC',
	'#FF00FF',
	'#FF3300',
	'#FF3333',
	'#FF3366',
	'#FF3399',
	'#FF33CC',
	'#FF33FF',
	'#FF6600',
	'#FF6633',
	'#FF9900',
	'#FF9933',
	'#FFCC00',
	'#FFCC33'
];

/**
 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
 * and the Firebug extension (any Firefox version) are known
 * to support "%c" CSS customizations.
 *
 * TODO: add a `localStorage` variable to explicitly enable/disable colors
 */

// eslint-disable-next-line complexity
function useColors() {
	// NB: In an Electron preload script, document will be defined but not fully
	// initialized. Since we know we're in Chrome, we'll just detect this case
	// explicitly
	if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
		return true;
	}

	// Internet Explorer and Edge do not support colors.
	if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
		return false;
	}

	// Is webkit? http://stackoverflow.com/a/16459606/376773
	// document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
	return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
		// Is firebug? http://stackoverflow.com/a/398120/376773
		(typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
		// Is firefox >= v31?
		// https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
		(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31) ||
		// Double check webkit in userAgent just in case we are in a worker
		(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
}

/**
 * Colorize log arguments if enabled.
 *
 * @api public
 */

function formatArgs(args) {
	args[0] = (this.useColors ? '%c' : '') +
		this.namespace +
		(this.useColors ? ' %c' : ' ') +
		args[0] +
		(this.useColors ? '%c ' : ' ') +
		'+' + module.exports.humanize(this.diff);

	if (!this.useColors) {
		return;
	}

	const c = 'color: ' + this.color;
	args.splice(1, 0, c, 'color: inherit');

	// The final "%c" is somewhat tricky, because there could be other
	// arguments passed either before or after the %c, so we need to
	// figure out the correct index to insert the CSS into
	let index = 0;
	let lastC = 0;
	args[0].replace(/%[a-zA-Z%]/g, match => {
		if (match === '%%') {
			return;
		}
		index++;
		if (match === '%c') {
			// We only are interested in the *last* %c
			// (the user may have provided their own)
			lastC = index;
		}
	});

	args.splice(lastC, 0, c);
}

/**
 * Invokes `console.debug()` when available.
 * No-op when `console.debug` is not a "function".
 * If `console.debug` is not available, falls back
 * to `console.log`.
 *
 * @api public
 */
exports.log = console.debug || console.log || (() => {});

/**
 * Save `namespaces`.
 *
 * @param {String} namespaces
 * @api private
 */
function save(namespaces) {
	try {
		if (namespaces) {
			exports.storage.setItem('debug', namespaces);
		} else {
			exports.storage.removeItem('debug');
		}
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}
}

/**
 * Load `namespaces`.
 *
 * @return {String} returns the previously persisted debug modes
 * @api private
 */
function load() {
	let r;
	try {
		r = exports.storage.getItem('debug');
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}

	// If debug isn't set in LS, and we're in Electron, try to load $DEBUG
	if (!r && typeof process !== 'undefined' && 'env' in process) {
		r = process.env.DEBUG;
	}

	return r;
}

/**
 * Localstorage attempts to return the localstorage.
 *
 * This is necessary because safari throws
 * when a user disables cookies/localstorage
 * and you attempt to access it.
 *
 * @return {LocalStorage}
 * @api private
 */

function localstorage() {
	try {
		// TVMLKit (Apple TV JS Runtime) does not have a window object, just localStorage in the global context
		// The Browser also has localStorage in the global context.
		return localStorage;
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}
}

module.exports = __webpack_require__(/*! ./common */ "../../../node_modules/.pnpm/debug@4.3.2/node_modules/debug/src/common.js")(exports);

const {formatters} = module.exports;

/**
 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
 */

formatters.j = function (v) {
	try {
		return JSON.stringify(v);
	} catch (error) {
		return '[UnexpectedJSONParseError]: ' + error.message;
	}
};


/***/ }),

/***/ "../../../node_modules/.pnpm/debug@4.3.2/node_modules/debug/src/common.js":
/*!********************************************************************************!*\
  !*** ../../../node_modules/.pnpm/debug@4.3.2/node_modules/debug/src/common.js ***!
  \********************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {


/**
 * This is the common logic for both the Node.js and web browser
 * implementations of `debug()`.
 */

function setup(env) {
	createDebug.debug = createDebug;
	createDebug.default = createDebug;
	createDebug.coerce = coerce;
	createDebug.disable = disable;
	createDebug.enable = enable;
	createDebug.enabled = enabled;
	createDebug.humanize = __webpack_require__(/*! ms */ "../../../node_modules/.pnpm/ms@2.1.2/node_modules/ms/index.js");
	createDebug.destroy = destroy;

	Object.keys(env).forEach(key => {
		createDebug[key] = env[key];
	});

	/**
	* The currently active debug mode names, and names to skip.
	*/

	createDebug.names = [];
	createDebug.skips = [];

	/**
	* Map of special "%n" handling functions, for the debug "format" argument.
	*
	* Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
	*/
	createDebug.formatters = {};

	/**
	* Selects a color for a debug namespace
	* @param {String} namespace The namespace string for the for the debug instance to be colored
	* @return {Number|String} An ANSI color code for the given namespace
	* @api private
	*/
	function selectColor(namespace) {
		let hash = 0;

		for (let i = 0; i < namespace.length; i++) {
			hash = ((hash << 5) - hash) + namespace.charCodeAt(i);
			hash |= 0; // Convert to 32bit integer
		}

		return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
	}
	createDebug.selectColor = selectColor;

	/**
	* Create a debugger with the given `namespace`.
	*
	* @param {String} namespace
	* @return {Function}
	* @api public
	*/
	function createDebug(namespace) {
		let prevTime;
		let enableOverride = null;
		let namespacesCache;
		let enabledCache;

		function debug(...args) {
			// Disabled?
			if (!debug.enabled) {
				return;
			}

			const self = debug;

			// Set `diff` timestamp
			const curr = Number(new Date());
			const ms = curr - (prevTime || curr);
			self.diff = ms;
			self.prev = prevTime;
			self.curr = curr;
			prevTime = curr;

			args[0] = createDebug.coerce(args[0]);

			if (typeof args[0] !== 'string') {
				// Anything else let's inspect with %O
				args.unshift('%O');
			}

			// Apply any `formatters` transformations
			let index = 0;
			args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
				// If we encounter an escaped % then don't increase the array index
				if (match === '%%') {
					return '%';
				}
				index++;
				const formatter = createDebug.formatters[format];
				if (typeof formatter === 'function') {
					const val = args[index];
					match = formatter.call(self, val);

					// Now we need to remove `args[index]` since it's inlined in the `format`
					args.splice(index, 1);
					index--;
				}
				return match;
			});

			// Apply env-specific formatting (colors, etc.)
			createDebug.formatArgs.call(self, args);

			const logFn = self.log || createDebug.log;
			logFn.apply(self, args);
		}

		debug.namespace = namespace;
		debug.useColors = createDebug.useColors();
		debug.color = createDebug.selectColor(namespace);
		debug.extend = extend;
		debug.destroy = createDebug.destroy; // XXX Temporary. Will be removed in the next major release.

		Object.defineProperty(debug, 'enabled', {
			enumerable: true,
			configurable: false,
			get: () => {
				if (enableOverride !== null) {
					return enableOverride;
				}
				if (namespacesCache !== createDebug.namespaces) {
					namespacesCache = createDebug.namespaces;
					enabledCache = createDebug.enabled(namespace);
				}

				return enabledCache;
			},
			set: v => {
				enableOverride = v;
			}
		});

		// Env-specific initialization logic for debug instances
		if (typeof createDebug.init === 'function') {
			createDebug.init(debug);
		}

		return debug;
	}

	function extend(namespace, delimiter) {
		const newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
		newDebug.log = this.log;
		return newDebug;
	}

	/**
	* Enables a debug mode by namespaces. This can include modes
	* separated by a colon and wildcards.
	*
	* @param {String} namespaces
	* @api public
	*/
	function enable(namespaces) {
		createDebug.save(namespaces);
		createDebug.namespaces = namespaces;

		createDebug.names = [];
		createDebug.skips = [];

		let i;
		const split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
		const len = split.length;

		for (i = 0; i < len; i++) {
			if (!split[i]) {
				// ignore empty strings
				continue;
			}

			namespaces = split[i].replace(/\*/g, '.*?');

			if (namespaces[0] === '-') {
				createDebug.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
			} else {
				createDebug.names.push(new RegExp('^' + namespaces + '$'));
			}
		}
	}

	/**
	* Disable debug output.
	*
	* @return {String} namespaces
	* @api public
	*/
	function disable() {
		const namespaces = [
			...createDebug.names.map(toNamespace),
			...createDebug.skips.map(toNamespace).map(namespace => '-' + namespace)
		].join(',');
		createDebug.enable('');
		return namespaces;
	}

	/**
	* Returns true if the given mode name is enabled, false otherwise.
	*
	* @param {String} name
	* @return {Boolean}
	* @api public
	*/
	function enabled(name) {
		if (name[name.length - 1] === '*') {
			return true;
		}

		let i;
		let len;

		for (i = 0, len = createDebug.skips.length; i < len; i++) {
			if (createDebug.skips[i].test(name)) {
				return false;
			}
		}

		for (i = 0, len = createDebug.names.length; i < len; i++) {
			if (createDebug.names[i].test(name)) {
				return true;
			}
		}

		return false;
	}

	/**
	* Convert regexp to namespace
	*
	* @param {RegExp} regxep
	* @return {String} namespace
	* @api private
	*/
	function toNamespace(regexp) {
		return regexp.toString()
			.substring(2, regexp.toString().length - 2)
			.replace(/\.\*\?$/, '*');
	}

	/**
	* Coerce `val`.
	*
	* @param {Mixed} val
	* @return {Mixed}
	* @api private
	*/
	function coerce(val) {
		if (val instanceof Error) {
			return val.stack || val.message;
		}
		return val;
	}

	/**
	* XXX DO NOT USE. This is a temporary stub function.
	* XXX It WILL be removed in the next major release.
	*/
	function destroy() {
		console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
	}

	createDebug.enable(createDebug.load());

	return createDebug;
}

module.exports = setup;


/***/ }),

/***/ "../../../node_modules/.pnpm/events@3.3.0/node_modules/events/events.js":
/*!******************************************************************************!*\
  !*** ../../../node_modules/.pnpm/events@3.3.0/node_modules/events/events.js ***!
  \******************************************************************************/
/***/ (function(module) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



var R = typeof Reflect === 'object' ? Reflect : null
var ReflectApply = R && typeof R.apply === 'function'
  ? R.apply
  : function ReflectApply(target, receiver, args) {
    return Function.prototype.apply.call(target, receiver, args);
  }

var ReflectOwnKeys
if (R && typeof R.ownKeys === 'function') {
  ReflectOwnKeys = R.ownKeys
} else if (Object.getOwnPropertySymbols) {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target)
      .concat(Object.getOwnPropertySymbols(target));
  };
} else {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target);
  };
}

function ProcessEmitWarning(warning) {
  if (console && console.warn) console.warn(warning);
}

var NumberIsNaN = Number.isNaN || function NumberIsNaN(value) {
  return value !== value;
}

function EventEmitter() {
  EventEmitter.init.call(this);
}
module.exports = EventEmitter;
module.exports.once = once;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.prototype._events = undefined;
EventEmitter.prototype._eventsCount = 0;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
var defaultMaxListeners = 10;

function checkListener(listener) {
  if (typeof listener !== 'function') {
    throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
  }
}

Object.defineProperty(EventEmitter, 'defaultMaxListeners', {
  enumerable: true,
  get: function() {
    return defaultMaxListeners;
  },
  set: function(arg) {
    if (typeof arg !== 'number' || arg < 0 || NumberIsNaN(arg)) {
      throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + '.');
    }
    defaultMaxListeners = arg;
  }
});

EventEmitter.init = function() {

  if (this._events === undefined ||
      this._events === Object.getPrototypeOf(this)._events) {
    this._events = Object.create(null);
    this._eventsCount = 0;
  }

  this._maxListeners = this._maxListeners || undefined;
};

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
  if (typeof n !== 'number' || n < 0 || NumberIsNaN(n)) {
    throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + '.');
  }
  this._maxListeners = n;
  return this;
};

function _getMaxListeners(that) {
  if (that._maxListeners === undefined)
    return EventEmitter.defaultMaxListeners;
  return that._maxListeners;
}

EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
  return _getMaxListeners(this);
};

EventEmitter.prototype.emit = function emit(type) {
  var args = [];
  for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
  var doError = (type === 'error');

  var events = this._events;
  if (events !== undefined)
    doError = (doError && events.error === undefined);
  else if (!doError)
    return false;

  // If there is no 'error' event listener then throw.
  if (doError) {
    var er;
    if (args.length > 0)
      er = args[0];
    if (er instanceof Error) {
      // Note: The comments on the `throw` lines are intentional, they show
      // up in Node's output if this results in an unhandled exception.
      throw er; // Unhandled 'error' event
    }
    // At least give some kind of context to the user
    var err = new Error('Unhandled error.' + (er ? ' (' + er.message + ')' : ''));
    err.context = er;
    throw err; // Unhandled 'error' event
  }

  var handler = events[type];

  if (handler === undefined)
    return false;

  if (typeof handler === 'function') {
    ReflectApply(handler, this, args);
  } else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i)
      ReflectApply(listeners[i], this, args);
  }

  return true;
};

function _addListener(target, type, listener, prepend) {
  var m;
  var events;
  var existing;

  checkListener(listener);

  events = target._events;
  if (events === undefined) {
    events = target._events = Object.create(null);
    target._eventsCount = 0;
  } else {
    // To avoid recursion in the case that type === "newListener"! Before
    // adding it to the listeners, first emit "newListener".
    if (events.newListener !== undefined) {
      target.emit('newListener', type,
                  listener.listener ? listener.listener : listener);

      // Re-assign `events` because a newListener handler could have caused the
      // this._events to be assigned to a new object
      events = target._events;
    }
    existing = events[type];
  }

  if (existing === undefined) {
    // Optimize the case of one listener. Don't need the extra array object.
    existing = events[type] = listener;
    ++target._eventsCount;
  } else {
    if (typeof existing === 'function') {
      // Adding the second element, need to change to array.
      existing = events[type] =
        prepend ? [listener, existing] : [existing, listener];
      // If we've already got an array, just append.
    } else if (prepend) {
      existing.unshift(listener);
    } else {
      existing.push(listener);
    }

    // Check for listener leak
    m = _getMaxListeners(target);
    if (m > 0 && existing.length > m && !existing.warned) {
      existing.warned = true;
      // No error code for this since it is a Warning
      // eslint-disable-next-line no-restricted-syntax
      var w = new Error('Possible EventEmitter memory leak detected. ' +
                          existing.length + ' ' + String(type) + ' listeners ' +
                          'added. Use emitter.setMaxListeners() to ' +
                          'increase limit');
      w.name = 'MaxListenersExceededWarning';
      w.emitter = target;
      w.type = type;
      w.count = existing.length;
      ProcessEmitWarning(w);
    }
  }

  return target;
}

EventEmitter.prototype.addListener = function addListener(type, listener) {
  return _addListener(this, type, listener, false);
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.prependListener =
    function prependListener(type, listener) {
      return _addListener(this, type, listener, true);
    };

function onceWrapper() {
  if (!this.fired) {
    this.target.removeListener(this.type, this.wrapFn);
    this.fired = true;
    if (arguments.length === 0)
      return this.listener.call(this.target);
    return this.listener.apply(this.target, arguments);
  }
}

function _onceWrap(target, type, listener) {
  var state = { fired: false, wrapFn: undefined, target: target, type: type, listener: listener };
  var wrapped = onceWrapper.bind(state);
  wrapped.listener = listener;
  state.wrapFn = wrapped;
  return wrapped;
}

EventEmitter.prototype.once = function once(type, listener) {
  checkListener(listener);
  this.on(type, _onceWrap(this, type, listener));
  return this;
};

EventEmitter.prototype.prependOnceListener =
    function prependOnceListener(type, listener) {
      checkListener(listener);
      this.prependListener(type, _onceWrap(this, type, listener));
      return this;
    };

// Emits a 'removeListener' event if and only if the listener was removed.
EventEmitter.prototype.removeListener =
    function removeListener(type, listener) {
      var list, events, position, i, originalListener;

      checkListener(listener);

      events = this._events;
      if (events === undefined)
        return this;

      list = events[type];
      if (list === undefined)
        return this;

      if (list === listener || list.listener === listener) {
        if (--this._eventsCount === 0)
          this._events = Object.create(null);
        else {
          delete events[type];
          if (events.removeListener)
            this.emit('removeListener', type, list.listener || listener);
        }
      } else if (typeof list !== 'function') {
        position = -1;

        for (i = list.length - 1; i >= 0; i--) {
          if (list[i] === listener || list[i].listener === listener) {
            originalListener = list[i].listener;
            position = i;
            break;
          }
        }

        if (position < 0)
          return this;

        if (position === 0)
          list.shift();
        else {
          spliceOne(list, position);
        }

        if (list.length === 1)
          events[type] = list[0];

        if (events.removeListener !== undefined)
          this.emit('removeListener', type, originalListener || listener);
      }

      return this;
    };

EventEmitter.prototype.off = EventEmitter.prototype.removeListener;

EventEmitter.prototype.removeAllListeners =
    function removeAllListeners(type) {
      var listeners, events, i;

      events = this._events;
      if (events === undefined)
        return this;

      // not listening for removeListener, no need to emit
      if (events.removeListener === undefined) {
        if (arguments.length === 0) {
          this._events = Object.create(null);
          this._eventsCount = 0;
        } else if (events[type] !== undefined) {
          if (--this._eventsCount === 0)
            this._events = Object.create(null);
          else
            delete events[type];
        }
        return this;
      }

      // emit removeListener for all listeners on all events
      if (arguments.length === 0) {
        var keys = Object.keys(events);
        var key;
        for (i = 0; i < keys.length; ++i) {
          key = keys[i];
          if (key === 'removeListener') continue;
          this.removeAllListeners(key);
        }
        this.removeAllListeners('removeListener');
        this._events = Object.create(null);
        this._eventsCount = 0;
        return this;
      }

      listeners = events[type];

      if (typeof listeners === 'function') {
        this.removeListener(type, listeners);
      } else if (listeners !== undefined) {
        // LIFO order
        for (i = listeners.length - 1; i >= 0; i--) {
          this.removeListener(type, listeners[i]);
        }
      }

      return this;
    };

function _listeners(target, type, unwrap) {
  var events = target._events;

  if (events === undefined)
    return [];

  var evlistener = events[type];
  if (evlistener === undefined)
    return [];

  if (typeof evlistener === 'function')
    return unwrap ? [evlistener.listener || evlistener] : [evlistener];

  return unwrap ?
    unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
}

EventEmitter.prototype.listeners = function listeners(type) {
  return _listeners(this, type, true);
};

EventEmitter.prototype.rawListeners = function rawListeners(type) {
  return _listeners(this, type, false);
};

EventEmitter.listenerCount = function(emitter, type) {
  if (typeof emitter.listenerCount === 'function') {
    return emitter.listenerCount(type);
  } else {
    return listenerCount.call(emitter, type);
  }
};

EventEmitter.prototype.listenerCount = listenerCount;
function listenerCount(type) {
  var events = this._events;

  if (events !== undefined) {
    var evlistener = events[type];

    if (typeof evlistener === 'function') {
      return 1;
    } else if (evlistener !== undefined) {
      return evlistener.length;
    }
  }

  return 0;
}

EventEmitter.prototype.eventNames = function eventNames() {
  return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
};

function arrayClone(arr, n) {
  var copy = new Array(n);
  for (var i = 0; i < n; ++i)
    copy[i] = arr[i];
  return copy;
}

function spliceOne(list, index) {
  for (; index + 1 < list.length; index++)
    list[index] = list[index + 1];
  list.pop();
}

function unwrapListeners(arr) {
  var ret = new Array(arr.length);
  for (var i = 0; i < ret.length; ++i) {
    ret[i] = arr[i].listener || arr[i];
  }
  return ret;
}

function once(emitter, name) {
  return new Promise(function (resolve, reject) {
    function errorListener(err) {
      emitter.removeListener(name, resolver);
      reject(err);
    }

    function resolver() {
      if (typeof emitter.removeListener === 'function') {
        emitter.removeListener('error', errorListener);
      }
      resolve([].slice.call(arguments));
    };

    eventTargetAgnosticAddListener(emitter, name, resolver, { once: true });
    if (name !== 'error') {
      addErrorHandlerIfEventEmitter(emitter, errorListener, { once: true });
    }
  });
}

function addErrorHandlerIfEventEmitter(emitter, handler, flags) {
  if (typeof emitter.on === 'function') {
    eventTargetAgnosticAddListener(emitter, 'error', handler, flags);
  }
}

function eventTargetAgnosticAddListener(emitter, name, listener, flags) {
  if (typeof emitter.on === 'function') {
    if (flags.once) {
      emitter.once(name, listener);
    } else {
      emitter.on(name, listener);
    }
  } else if (typeof emitter.addEventListener === 'function') {
    // EventTarget does not have `error` event semantics like Node
    // EventEmitters, we do not listen for `error` events here.
    emitter.addEventListener(name, function wrapListener(arg) {
      // IE does not have builtin `{ once: true }` support so we
      // have to do it manually.
      if (flags.once) {
        emitter.removeEventListener(name, wrapListener);
      }
      listener(arg);
    });
  } else {
    throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type ' + typeof emitter);
  }
}


/***/ }),

/***/ "../../../node_modules/.pnpm/fbjs@0.8.18/node_modules/fbjs/lib/emptyFunction.js":
/*!**************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/fbjs@0.8.18/node_modules/fbjs/lib/emptyFunction.js ***!
  \**************************************************************************************/
/***/ (function(module) {

"use strict";


/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 */

function makeEmptyFunction(arg) {
  return function () {
    return arg;
  };
}

/**
 * This function accepts and discards inputs; it has no side effects. This is
 * primarily useful idiomatically for overridable function endpoints which
 * always need to be callable, since JS lacks a null-call idiom ala Cocoa.
 */
var emptyFunction = function emptyFunction() {};

emptyFunction.thatReturns = makeEmptyFunction;
emptyFunction.thatReturnsFalse = makeEmptyFunction(false);
emptyFunction.thatReturnsTrue = makeEmptyFunction(true);
emptyFunction.thatReturnsNull = makeEmptyFunction(null);
emptyFunction.thatReturnsThis = function () {
  return this;
};
emptyFunction.thatReturnsArgument = function (arg) {
  return arg;
};

module.exports = emptyFunction;

/***/ }),

/***/ "../../../node_modules/.pnpm/fbjs@0.8.18/node_modules/fbjs/lib/invariant.js":
/*!**********************************************************************************!*\
  !*** ../../../node_modules/.pnpm/fbjs@0.8.18/node_modules/fbjs/lib/invariant.js ***!
  \**********************************************************************************/
/***/ (function(module) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */



/**
 * Use invariant() to assert state which your program assumes to be true.
 *
 * Provide sprintf-style format (only %s is supported) and arguments
 * to provide information about what broke and what you were
 * expecting.
 *
 * The invariant message will be stripped in production, but the invariant
 * will remain to ensure logic does not differ in production.
 */

var validateFormat = function validateFormat(format) {};

if (true) {
  validateFormat = function validateFormat(format) {
    if (format === undefined) {
      throw new Error('invariant requires an error message argument');
    }
  };
}

function invariant(condition, format, a, b, c, d, e, f) {
  validateFormat(format);

  if (!condition) {
    var error;
    if (format === undefined) {
      error = new Error('Minified exception occurred; use the non-minified dev environment ' + 'for the full error message and additional helpful warnings.');
    } else {
      var args = [a, b, c, d, e, f];
      var argIndex = 0;
      error = new Error(format.replace(/%s/g, function () {
        return args[argIndex++];
      }));
      error.name = 'Invariant Violation';
    }

    error.framesToPop = 1; // we don't care about invariant's own frame
    throw error;
  }
}

module.exports = invariant;

/***/ }),

/***/ "../../../node_modules/.pnpm/fbjs@0.8.18/node_modules/fbjs/lib/warning.js":
/*!********************************************************************************!*\
  !*** ../../../node_modules/.pnpm/fbjs@0.8.18/node_modules/fbjs/lib/warning.js ***!
  \********************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2014-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */



var emptyFunction = __webpack_require__(/*! ./emptyFunction */ "../../../node_modules/.pnpm/fbjs@0.8.18/node_modules/fbjs/lib/emptyFunction.js");

/**
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */

var warning = emptyFunction;

if (true) {
  var printWarning = function printWarning(format) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var argIndex = 0;
    var message = 'Warning: ' + format.replace(/%s/g, function () {
      return args[argIndex++];
    });
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };

  warning = function warning(condition, format) {
    if (format === undefined) {
      throw new Error('`warning(condition, format, ...args)` requires a warning ' + 'message argument');
    }

    if (format.indexOf('Failed Composite propType: ') === 0) {
      return; // Ignore CompositeComponent proptype check.
    }

    if (!condition) {
      for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
        args[_key2 - 2] = arguments[_key2];
      }

      printWarning.apply(undefined, [format].concat(args));
    }
  };
}

module.exports = warning;

/***/ }),

/***/ "../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/common.js":
/*!*****************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/common.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(/*! ./utils */ "../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/utils.js");
var assert = __webpack_require__(/*! minimalistic-assert */ "../../../node_modules/.pnpm/minimalistic-assert@1.0.1/node_modules/minimalistic-assert/index.js");

function BlockHash() {
  this.pending = null;
  this.pendingTotal = 0;
  this.blockSize = this.constructor.blockSize;
  this.outSize = this.constructor.outSize;
  this.hmacStrength = this.constructor.hmacStrength;
  this.padLength = this.constructor.padLength / 8;
  this.endian = 'big';

  this._delta8 = this.blockSize / 8;
  this._delta32 = this.blockSize / 32;
}
exports.BlockHash = BlockHash;

BlockHash.prototype.update = function update(msg, enc) {
  // Convert message to array, pad it, and join into 32bit blocks
  msg = utils.toArray(msg, enc);
  if (!this.pending)
    this.pending = msg;
  else
    this.pending = this.pending.concat(msg);
  this.pendingTotal += msg.length;

  // Enough data, try updating
  if (this.pending.length >= this._delta8) {
    msg = this.pending;

    // Process pending data in blocks
    var r = msg.length % this._delta8;
    this.pending = msg.slice(msg.length - r, msg.length);
    if (this.pending.length === 0)
      this.pending = null;

    msg = utils.join32(msg, 0, msg.length - r, this.endian);
    for (var i = 0; i < msg.length; i += this._delta32)
      this._update(msg, i, i + this._delta32);
  }

  return this;
};

BlockHash.prototype.digest = function digest(enc) {
  this.update(this._pad());
  assert(this.pending === null);

  return this._digest(enc);
};

BlockHash.prototype._pad = function pad() {
  var len = this.pendingTotal;
  var bytes = this._delta8;
  var k = bytes - ((len + this.padLength) % bytes);
  var res = new Array(k + this.padLength);
  res[0] = 0x80;
  for (var i = 1; i < k; i++)
    res[i] = 0;

  // Append length
  len <<= 3;
  if (this.endian === 'big') {
    for (var t = 8; t < this.padLength; t++)
      res[i++] = 0;

    res[i++] = 0;
    res[i++] = 0;
    res[i++] = 0;
    res[i++] = 0;
    res[i++] = (len >>> 24) & 0xff;
    res[i++] = (len >>> 16) & 0xff;
    res[i++] = (len >>> 8) & 0xff;
    res[i++] = len & 0xff;
  } else {
    res[i++] = len & 0xff;
    res[i++] = (len >>> 8) & 0xff;
    res[i++] = (len >>> 16) & 0xff;
    res[i++] = (len >>> 24) & 0xff;
    res[i++] = 0;
    res[i++] = 0;
    res[i++] = 0;
    res[i++] = 0;

    for (t = 8; t < this.padLength; t++)
      res[i++] = 0;
  }

  return res;
};


/***/ }),

/***/ "../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/sha/1.js":
/*!****************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/sha/1.js ***!
  \****************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(/*! ../utils */ "../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/utils.js");
var common = __webpack_require__(/*! ../common */ "../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/common.js");
var shaCommon = __webpack_require__(/*! ./common */ "../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/sha/common.js");

var rotl32 = utils.rotl32;
var sum32 = utils.sum32;
var sum32_5 = utils.sum32_5;
var ft_1 = shaCommon.ft_1;
var BlockHash = common.BlockHash;

var sha1_K = [
  0x5A827999, 0x6ED9EBA1,
  0x8F1BBCDC, 0xCA62C1D6
];

function SHA1() {
  if (!(this instanceof SHA1))
    return new SHA1();

  BlockHash.call(this);
  this.h = [
    0x67452301, 0xefcdab89, 0x98badcfe,
    0x10325476, 0xc3d2e1f0 ];
  this.W = new Array(80);
}

utils.inherits(SHA1, BlockHash);
module.exports = SHA1;

SHA1.blockSize = 512;
SHA1.outSize = 160;
SHA1.hmacStrength = 80;
SHA1.padLength = 64;

SHA1.prototype._update = function _update(msg, start) {
  var W = this.W;

  for (var i = 0; i < 16; i++)
    W[i] = msg[start + i];

  for(; i < W.length; i++)
    W[i] = rotl32(W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16], 1);

  var a = this.h[0];
  var b = this.h[1];
  var c = this.h[2];
  var d = this.h[3];
  var e = this.h[4];

  for (i = 0; i < W.length; i++) {
    var s = ~~(i / 20);
    var t = sum32_5(rotl32(a, 5), ft_1(s, b, c, d), e, W[i], sha1_K[s]);
    e = d;
    d = c;
    c = rotl32(b, 30);
    b = a;
    a = t;
  }

  this.h[0] = sum32(this.h[0], a);
  this.h[1] = sum32(this.h[1], b);
  this.h[2] = sum32(this.h[2], c);
  this.h[3] = sum32(this.h[3], d);
  this.h[4] = sum32(this.h[4], e);
};

SHA1.prototype._digest = function digest(enc) {
  if (enc === 'hex')
    return utils.toHex32(this.h, 'big');
  else
    return utils.split32(this.h, 'big');
};


/***/ }),

/***/ "../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/sha/common.js":
/*!*********************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/sha/common.js ***!
  \*********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(/*! ../utils */ "../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/utils.js");
var rotr32 = utils.rotr32;

function ft_1(s, x, y, z) {
  if (s === 0)
    return ch32(x, y, z);
  if (s === 1 || s === 3)
    return p32(x, y, z);
  if (s === 2)
    return maj32(x, y, z);
}
exports.ft_1 = ft_1;

function ch32(x, y, z) {
  return (x & y) ^ ((~x) & z);
}
exports.ch32 = ch32;

function maj32(x, y, z) {
  return (x & y) ^ (x & z) ^ (y & z);
}
exports.maj32 = maj32;

function p32(x, y, z) {
  return x ^ y ^ z;
}
exports.p32 = p32;

function s0_256(x) {
  return rotr32(x, 2) ^ rotr32(x, 13) ^ rotr32(x, 22);
}
exports.s0_256 = s0_256;

function s1_256(x) {
  return rotr32(x, 6) ^ rotr32(x, 11) ^ rotr32(x, 25);
}
exports.s1_256 = s1_256;

function g0_256(x) {
  return rotr32(x, 7) ^ rotr32(x, 18) ^ (x >>> 3);
}
exports.g0_256 = g0_256;

function g1_256(x) {
  return rotr32(x, 17) ^ rotr32(x, 19) ^ (x >>> 10);
}
exports.g1_256 = g1_256;


/***/ }),

/***/ "../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/utils.js":
/*!****************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/utils.js ***!
  \****************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var assert = __webpack_require__(/*! minimalistic-assert */ "../../../node_modules/.pnpm/minimalistic-assert@1.0.1/node_modules/minimalistic-assert/index.js");
var inherits = __webpack_require__(/*! inherits */ "../../../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits_browser.js");

exports.inherits = inherits;

function isSurrogatePair(msg, i) {
  if ((msg.charCodeAt(i) & 0xFC00) !== 0xD800) {
    return false;
  }
  if (i < 0 || i + 1 >= msg.length) {
    return false;
  }
  return (msg.charCodeAt(i + 1) & 0xFC00) === 0xDC00;
}

function toArray(msg, enc) {
  if (Array.isArray(msg))
    return msg.slice();
  if (!msg)
    return [];
  var res = [];
  if (typeof msg === 'string') {
    if (!enc) {
      // Inspired by stringToUtf8ByteArray() in closure-library by Google
      // https://github.com/google/closure-library/blob/8598d87242af59aac233270742c8984e2b2bdbe0/closure/goog/crypt/crypt.js#L117-L143
      // Apache License 2.0
      // https://github.com/google/closure-library/blob/master/LICENSE
      var p = 0;
      for (var i = 0; i < msg.length; i++) {
        var c = msg.charCodeAt(i);
        if (c < 128) {
          res[p++] = c;
        } else if (c < 2048) {
          res[p++] = (c >> 6) | 192;
          res[p++] = (c & 63) | 128;
        } else if (isSurrogatePair(msg, i)) {
          c = 0x10000 + ((c & 0x03FF) << 10) + (msg.charCodeAt(++i) & 0x03FF);
          res[p++] = (c >> 18) | 240;
          res[p++] = ((c >> 12) & 63) | 128;
          res[p++] = ((c >> 6) & 63) | 128;
          res[p++] = (c & 63) | 128;
        } else {
          res[p++] = (c >> 12) | 224;
          res[p++] = ((c >> 6) & 63) | 128;
          res[p++] = (c & 63) | 128;
        }
      }
    } else if (enc === 'hex') {
      msg = msg.replace(/[^a-z0-9]+/ig, '');
      if (msg.length % 2 !== 0)
        msg = '0' + msg;
      for (i = 0; i < msg.length; i += 2)
        res.push(parseInt(msg[i] + msg[i + 1], 16));
    }
  } else {
    for (i = 0; i < msg.length; i++)
      res[i] = msg[i] | 0;
  }
  return res;
}
exports.toArray = toArray;

function toHex(msg) {
  var res = '';
  for (var i = 0; i < msg.length; i++)
    res += zero2(msg[i].toString(16));
  return res;
}
exports.toHex = toHex;

function htonl(w) {
  var res = (w >>> 24) |
            ((w >>> 8) & 0xff00) |
            ((w << 8) & 0xff0000) |
            ((w & 0xff) << 24);
  return res >>> 0;
}
exports.htonl = htonl;

function toHex32(msg, endian) {
  var res = '';
  for (var i = 0; i < msg.length; i++) {
    var w = msg[i];
    if (endian === 'little')
      w = htonl(w);
    res += zero8(w.toString(16));
  }
  return res;
}
exports.toHex32 = toHex32;

function zero2(word) {
  if (word.length === 1)
    return '0' + word;
  else
    return word;
}
exports.zero2 = zero2;

function zero8(word) {
  if (word.length === 7)
    return '0' + word;
  else if (word.length === 6)
    return '00' + word;
  else if (word.length === 5)
    return '000' + word;
  else if (word.length === 4)
    return '0000' + word;
  else if (word.length === 3)
    return '00000' + word;
  else if (word.length === 2)
    return '000000' + word;
  else if (word.length === 1)
    return '0000000' + word;
  else
    return word;
}
exports.zero8 = zero8;

function join32(msg, start, end, endian) {
  var len = end - start;
  assert(len % 4 === 0);
  var res = new Array(len / 4);
  for (var i = 0, k = start; i < res.length; i++, k += 4) {
    var w;
    if (endian === 'big')
      w = (msg[k] << 24) | (msg[k + 1] << 16) | (msg[k + 2] << 8) | msg[k + 3];
    else
      w = (msg[k + 3] << 24) | (msg[k + 2] << 16) | (msg[k + 1] << 8) | msg[k];
    res[i] = w >>> 0;
  }
  return res;
}
exports.join32 = join32;

function split32(msg, endian) {
  var res = new Array(msg.length * 4);
  for (var i = 0, k = 0; i < msg.length; i++, k += 4) {
    var m = msg[i];
    if (endian === 'big') {
      res[k] = m >>> 24;
      res[k + 1] = (m >>> 16) & 0xff;
      res[k + 2] = (m >>> 8) & 0xff;
      res[k + 3] = m & 0xff;
    } else {
      res[k + 3] = m >>> 24;
      res[k + 2] = (m >>> 16) & 0xff;
      res[k + 1] = (m >>> 8) & 0xff;
      res[k] = m & 0xff;
    }
  }
  return res;
}
exports.split32 = split32;

function rotr32(w, b) {
  return (w >>> b) | (w << (32 - b));
}
exports.rotr32 = rotr32;

function rotl32(w, b) {
  return (w << b) | (w >>> (32 - b));
}
exports.rotl32 = rotl32;

function sum32(a, b) {
  return (a + b) >>> 0;
}
exports.sum32 = sum32;

function sum32_3(a, b, c) {
  return (a + b + c) >>> 0;
}
exports.sum32_3 = sum32_3;

function sum32_4(a, b, c, d) {
  return (a + b + c + d) >>> 0;
}
exports.sum32_4 = sum32_4;

function sum32_5(a, b, c, d, e) {
  return (a + b + c + d + e) >>> 0;
}
exports.sum32_5 = sum32_5;

function sum64(buf, pos, ah, al) {
  var bh = buf[pos];
  var bl = buf[pos + 1];

  var lo = (al + bl) >>> 0;
  var hi = (lo < al ? 1 : 0) + ah + bh;
  buf[pos] = hi >>> 0;
  buf[pos + 1] = lo;
}
exports.sum64 = sum64;

function sum64_hi(ah, al, bh, bl) {
  var lo = (al + bl) >>> 0;
  var hi = (lo < al ? 1 : 0) + ah + bh;
  return hi >>> 0;
}
exports.sum64_hi = sum64_hi;

function sum64_lo(ah, al, bh, bl) {
  var lo = al + bl;
  return lo >>> 0;
}
exports.sum64_lo = sum64_lo;

function sum64_4_hi(ah, al, bh, bl, ch, cl, dh, dl) {
  var carry = 0;
  var lo = al;
  lo = (lo + bl) >>> 0;
  carry += lo < al ? 1 : 0;
  lo = (lo + cl) >>> 0;
  carry += lo < cl ? 1 : 0;
  lo = (lo + dl) >>> 0;
  carry += lo < dl ? 1 : 0;

  var hi = ah + bh + ch + dh + carry;
  return hi >>> 0;
}
exports.sum64_4_hi = sum64_4_hi;

function sum64_4_lo(ah, al, bh, bl, ch, cl, dh, dl) {
  var lo = al + bl + cl + dl;
  return lo >>> 0;
}
exports.sum64_4_lo = sum64_4_lo;

function sum64_5_hi(ah, al, bh, bl, ch, cl, dh, dl, eh, el) {
  var carry = 0;
  var lo = al;
  lo = (lo + bl) >>> 0;
  carry += lo < al ? 1 : 0;
  lo = (lo + cl) >>> 0;
  carry += lo < cl ? 1 : 0;
  lo = (lo + dl) >>> 0;
  carry += lo < dl ? 1 : 0;
  lo = (lo + el) >>> 0;
  carry += lo < el ? 1 : 0;

  var hi = ah + bh + ch + dh + eh + carry;
  return hi >>> 0;
}
exports.sum64_5_hi = sum64_5_hi;

function sum64_5_lo(ah, al, bh, bl, ch, cl, dh, dl, eh, el) {
  var lo = al + bl + cl + dl + el;

  return lo >>> 0;
}
exports.sum64_5_lo = sum64_5_lo;

function rotr64_hi(ah, al, num) {
  var r = (al << (32 - num)) | (ah >>> num);
  return r >>> 0;
}
exports.rotr64_hi = rotr64_hi;

function rotr64_lo(ah, al, num) {
  var r = (ah << (32 - num)) | (al >>> num);
  return r >>> 0;
}
exports.rotr64_lo = rotr64_lo;

function shr64_hi(ah, al, num) {
  return ah >>> num;
}
exports.shr64_hi = shr64_hi;

function shr64_lo(ah, al, num) {
  var r = (ah << (32 - num)) | (al >>> num);
  return r >>> 0;
}
exports.shr64_lo = shr64_lo;


/***/ }),

/***/ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/i18n.js":
/*!*************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/i18n.js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var debug__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! debug */ "../../../node_modules/.pnpm/debug@4.3.1/node_modules/debug/src/browser.js");
/* harmony import */ var debug__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(debug__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var interpolate_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! interpolate-components */ "../../../node_modules/.pnpm/interpolate-components@1.1.1/node_modules/interpolate-components/lib/index.js");
/* harmony import */ var tannin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tannin */ "../../../node_modules/.pnpm/tannin@1.2.0/node_modules/tannin/index.js");
/* harmony import */ var lru__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lru */ "../../../node_modules/.pnpm/lru@3.1.0/node_modules/lru/index.js");
/* harmony import */ var lru__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lru__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var hash_js_lib_hash_sha_1__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! hash.js/lib/hash/sha/1 */ "../../../node_modules/.pnpm/hash.js@1.1.7/node_modules/hash.js/lib/hash/sha/1.js");
/* harmony import */ var hash_js_lib_hash_sha_1__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(hash_js_lib_hash_sha_1__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var events__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! events */ "../../../node_modules/.pnpm/events@3.3.0/node_modules/events/events.js");
/* harmony import */ var events__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(events__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _tannin_sprintf__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @tannin/sprintf */ "../../../node_modules/.pnpm/@tannin+sprintf@1.2.0/node_modules/@tannin/sprintf/index.js");
/* harmony import */ var _number_format__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./number-format */ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/number-format.js");



/**
 * External dependencies
 */







/**
 * Internal dependencies
 */


/**
 * Module variables
 */

var debug = debug__WEBPACK_IMPORTED_MODULE_2___default()('i18n-calypso');
/**
 * Constants
 */

var decimal_point_translation_key = 'number_format_decimals';
var thousands_sep_translation_key = 'number_format_thousands_sep';
var domain_key = 'messages';
var translationLookup = [// By default don't modify the options when looking up translations.
function (options) {
  return options;
}];
var hashCache = {}; // raise a console warning

function warn() {
  if (!I18N.throwErrors) {
    return;
  }

  if ('undefined' !== typeof window && window.console && window.console.warn) {
    window.console.warn.apply(window.console, arguments);
  }
} // turns Function.arguments into an array


function simpleArguments(args) {
  return Array.prototype.slice.call(args);
}
/**
 * Coerce the possible arguments and normalize to a single object.
 *
 * @param   {any} args - arguments passed in from `translate()`
 * @returns {object}         - a single object describing translation needs
 */


function normalizeTranslateArguments(args) {
  var original = args[0]; // warn about older deprecated syntax

  if (typeof original !== 'string' || args.length > 3 || args.length > 2 && typeof args[1] === 'object' && typeof args[2] === 'object') {
    warn('Deprecated Invocation: `translate()` accepts ( string, [string], [object] ). These arguments passed:', simpleArguments(args), '. See https://github.com/Automattic/i18n-calypso#translate-method');
  }

  if (args.length === 2 && typeof original === 'string' && typeof args[1] === 'string') {
    warn('Invalid Invocation: `translate()` requires an options object for plural translations, but passed:', simpleArguments(args));
  } // options could be in position 0, 1, or 2
  // sending options as the first object is deprecated and will raise a warning


  var options = {};

  for (var i = 0; i < args.length; i++) {
    if (typeof args[i] === 'object') {
      options = args[i];
    }
  } // `original` can be passed as first parameter or as part of the options object
  // though passing original as part of the options is a deprecated approach and will be removed


  if (typeof original === 'string') {
    options.original = original;
  } else if (typeof options.original === 'object') {
    options.plural = options.original.plural;
    options.count = options.original.count;
    options.original = options.original.single;
  }

  if (typeof args[1] === 'string') {
    options.plural = args[1];
  }

  if (typeof options.original === 'undefined') {
    throw new Error('Translate called without a `string` value as first argument.');
  }

  return options;
}
/**
 * Takes translate options object and coerces to a Tannin request to retrieve translation.
 *
 * @param   {object} tannin  - tannin data object
 * @param   {object} options - object describing translation
 * @returns {string}         - the returned translation from Tannin
 */


function getTranslationFromTannin(tannin, options) {
  return tannin.dcnpgettext(domain_key, options.context, options.original, options.plural, options.count);
}

function getTranslation(i18n, options) {
  for (var i = translationLookup.length - 1; i >= 0; i--) {
    var lookup = translationLookup[i](Object.assign({}, options)); // Only get the translation from tannin if it exists.

    if (i18n.state.locale[lookup.original]) {
      return getTranslationFromTannin(i18n.state.tannin, lookup);
    }
  }

  return null;
}

function I18N() {
  if (!(this instanceof I18N)) {
    return new I18N();
  }

  this.defaultLocaleSlug = 'en'; // Tannin always needs a plural form definition, or it fails when dealing with plurals.

  this.defaultPluralForms = function (n) {
    return n === 1 ? 0 : 1;
  };

  this.state = {
    numberFormatSettings: {},
    tannin: undefined,
    locale: undefined,
    localeSlug: undefined,
    textDirection: undefined,
    translations: lru__WEBPACK_IMPORTED_MODULE_5___default()({
      max: 100
    })
  };
  this.componentUpdateHooks = [];
  this.translateHooks = [];
  this.stateObserver = new events__WEBPACK_IMPORTED_MODULE_7__.EventEmitter(); // Because the higher-order component can wrap a ton of React components,
  // we need to bump the number of listeners to infinity and beyond
  // FIXME: still valid?

  this.stateObserver.setMaxListeners(0); // default configuration

  this.configure();
}

I18N.throwErrors = false;

I18N.prototype.on = function () {
  var _this$stateObserver;

  (_this$stateObserver = this.stateObserver).on.apply(_this$stateObserver, arguments);
};

I18N.prototype.off = function () {
  var _this$stateObserver2;

  (_this$stateObserver2 = this.stateObserver).off.apply(_this$stateObserver2, arguments);
};

I18N.prototype.emit = function () {
  var _this$stateObserver3;

  (_this$stateObserver3 = this.stateObserver).emit.apply(_this$stateObserver3, arguments);
};
/**
 * Formats numbers using locale settings and/or passed options.
 *
 * @param   {string|number}  number to format (required)
 * @param   {number|object}  options  Number of decimal places or options object (optional)
 * @returns {string}         Formatted number as string
 */


I18N.prototype.numberFormat = function (number) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var decimals = typeof options === 'number' ? options : options.decimals || 0;
  var decPoint = options.decPoint || this.state.numberFormatSettings.decimal_point || '.';
  var thousandsSep = options.thousandsSep || this.state.numberFormatSettings.thousands_sep || ',';
  return (0,_number_format__WEBPACK_IMPORTED_MODULE_9__["default"])(number, decimals, decPoint, thousandsSep);
};

I18N.prototype.configure = function (options) {
  Object.assign(this, options || {});
  this.setLocale();
};

I18N.prototype.setLocale = function (localeData) {
  var _this$state$locale$te, _this$state$locale$, _this$state$locale$$m;

  if (localeData && localeData[''] && localeData['']['key-hash']) {
    var keyHash = localeData['']['key-hash'];

    var transform = function transform(string, hashLength) {
      var lookupPrefix = hashLength === false ? '' : String(hashLength);

      if (typeof hashCache[lookupPrefix + string] !== 'undefined') {
        return hashCache[lookupPrefix + string];
      }

      var hash = hash_js_lib_hash_sha_1__WEBPACK_IMPORTED_MODULE_6___default()().update(string).digest('hex');

      if (hashLength) {
        return hashCache[lookupPrefix + string] = hash.substr(0, hashLength);
      }

      return hashCache[lookupPrefix + string] = hash;
    };

    var generateLookup = function generateLookup(hashLength) {
      return function (options) {
        if (options.context) {
          options.original = transform(options.context + String.fromCharCode(4) + options.original, hashLength);
          delete options.context;
        } else {
          options.original = transform(options.original, hashLength);
        }

        return options;
      };
    };

    if (keyHash.substr(0, 4) === 'sha1') {
      if (keyHash.length === 4) {
        translationLookup.push(generateLookup(false));
      } else {
        var variableHashLengthPos = keyHash.substr(5).indexOf('-');

        if (variableHashLengthPos < 0) {
          var hashLength = Number(keyHash.substr(5));
          translationLookup.push(generateLookup(hashLength));
        } else {
          var minHashLength = Number(keyHash.substr(5, variableHashLengthPos));
          var maxHashLength = Number(keyHash.substr(6 + variableHashLengthPos));

          for (var _hashLength = minHashLength; _hashLength <= maxHashLength; _hashLength++) {
            translationLookup.push(generateLookup(_hashLength));
          }
        }
      }
    }
  } // if localeData is not given, assumes default locale and reset


  if (!localeData || !localeData[''].localeSlug) {
    this.state.locale = {
      '': {
        localeSlug: this.defaultLocaleSlug,
        plural_forms: this.defaultPluralForms
      }
    };
  } else if (localeData[''].localeSlug === this.state.localeSlug) {
    // Exit if same data as current (comparing references only)
    if (localeData === this.state.locale) {
      return;
    } // merge new data into existing one


    Object.assign(this.state.locale, localeData);
  } else {
    this.state.locale = Object.assign({}, localeData);
  }

  this.state.localeSlug = this.state.locale[''].localeSlug; // extract the `textDirection` info (LTR or RTL) from either:
  // - the translation for the special string "ltr" (standard in Core, not present in Calypso)
  // - or the `momentjs_locale.textDirection` property present in Calypso translation files

  this.state.textDirection = ((_this$state$locale$te = this.state.locale["text direction\x04ltr"]) === null || _this$state$locale$te === void 0 ? void 0 : _this$state$locale$te[0]) || ((_this$state$locale$ = this.state.locale['']) === null || _this$state$locale$ === void 0 ? void 0 : (_this$state$locale$$m = _this$state$locale$.momentjs_locale) === null || _this$state$locale$$m === void 0 ? void 0 : _this$state$locale$$m.textDirection);
  this.state.tannin = new tannin__WEBPACK_IMPORTED_MODULE_4__["default"]((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])({}, domain_key, this.state.locale)); // Updates numberFormat preferences with settings from translations

  this.state.numberFormatSettings.decimal_point = getTranslationFromTannin(this.state.tannin, normalizeTranslateArguments([decimal_point_translation_key]));
  this.state.numberFormatSettings.thousands_sep = getTranslationFromTannin(this.state.tannin, normalizeTranslateArguments([thousands_sep_translation_key])); // If translation isn't set, define defaults.

  if (this.state.numberFormatSettings.decimal_point === decimal_point_translation_key) {
    this.state.numberFormatSettings.decimal_point = '.';
  }

  if (this.state.numberFormatSettings.thousands_sep === thousands_sep_translation_key) {
    this.state.numberFormatSettings.thousands_sep = ',';
  }

  this.stateObserver.emit('change');
};

I18N.prototype.getLocale = function () {
  return this.state.locale;
};
/**
 * Get the current locale slug.
 *
 * @returns {string} The string representing the currently loaded locale
 **/


I18N.prototype.getLocaleSlug = function () {
  return this.state.localeSlug;
};
/**
 * Get the current text direction, left-to-right (LTR) or right-to-left (RTL).
 *
 * @returns {boolean} `true` in case the current locale has RTL text direction
 */


I18N.prototype.isRtl = function () {
  return this.state.textDirection === 'rtl';
};
/**
 * Adds new translations to the locale data, overwriting any existing translations with a matching key.
 *
 * @param {object} localeData Locale data
 */


I18N.prototype.addTranslations = function (localeData) {
  for (var prop in localeData) {
    if (prop !== '') {
      this.state.tannin.data.messages[prop] = localeData[prop];
    }
  }

  this.stateObserver.emit('change');
};
/**
 * Checks whether the given original has a translation.
 *
 * @returns {boolean} whether a translation exists
 */


I18N.prototype.hasTranslation = function () {
  return !!getTranslation(this, normalizeTranslateArguments(arguments));
};
/**
 * Exposes single translation method.
 * See sibling README
 *
 * @returns {string|object} translated text or an object containing React children that can be inserted into a parent component
 */


I18N.prototype.translate = function () {
  var options = normalizeTranslateArguments(arguments);
  var translation = getTranslation(this, options);

  if (!translation) {
    // This purposefully calls tannin for a case where there is no translation,
    // so that tannin gives us the expected object with English text.
    translation = getTranslationFromTannin(this.state.tannin, options);
  } // handle any string substitution


  if (options.args) {
    var sprintfArgs = Array.isArray(options.args) ? options.args.slice(0) : [options.args];
    sprintfArgs.unshift(translation);

    try {
      translation = _tannin_sprintf__WEBPACK_IMPORTED_MODULE_8__["default"].apply(void 0, (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(sprintfArgs));
    } catch (error) {
      if (!window || !window.console) {
        return;
      }

      var errorMethod = this.throwErrors ? 'error' : 'warn';

      if (typeof error !== 'string') {
        window.console[errorMethod](error);
      } else {
        window.console[errorMethod]('i18n sprintf error:', sprintfArgs);
      }
    }
  } // interpolate any components


  if (options.components) {
    translation = (0,interpolate_components__WEBPACK_IMPORTED_MODULE_3__["default"])({
      mixedString: translation,
      components: options.components,
      throwErrors: this.throwErrors
    });
  } // run any necessary hooks


  this.translateHooks.forEach(function (hook) {
    translation = hook(translation, options);
  });
  return translation;
};
/**
 * Causes i18n to re-render all translations.
 *
 * This can be necessary if an extension makes changes that i18n is unaware of
 * and needs those changes manifested immediately (e.g. adding an important
 * translation hook, or modifying the behaviour of an existing hook).
 *
 * If at all possible, react components should try to use the more local
 * updateTranslation() function inherited from the mixin.
 */


I18N.prototype.reRenderTranslations = function () {
  debug('Re-rendering all translations due to external request');
  this.stateObserver.emit('change');
};

I18N.prototype.registerComponentUpdateHook = function (callback) {
  this.componentUpdateHooks.push(callback);
};

I18N.prototype.registerTranslateHook = function (callback) {
  this.translateHooks.push(callback);
};

/* harmony default export */ __webpack_exports__["default"] = (I18N);

/***/ }),

/***/ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/index.js":
/*!**************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/index.js ***!
  \**************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "I18N": function() { return /* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   "numberFormat": function() { return /* binding */ numberFormat; },
/* harmony export */   "translate": function() { return /* binding */ translate; },
/* harmony export */   "configure": function() { return /* binding */ configure; },
/* harmony export */   "setLocale": function() { return /* binding */ setLocale; },
/* harmony export */   "getLocale": function() { return /* binding */ getLocale; },
/* harmony export */   "getLocaleSlug": function() { return /* binding */ getLocaleSlug; },
/* harmony export */   "addTranslations": function() { return /* binding */ addTranslations; },
/* harmony export */   "reRenderTranslations": function() { return /* binding */ reRenderTranslations; },
/* harmony export */   "registerComponentUpdateHook": function() { return /* binding */ registerComponentUpdateHook; },
/* harmony export */   "registerTranslateHook": function() { return /* binding */ registerTranslateHook; },
/* harmony export */   "state": function() { return /* binding */ state; },
/* harmony export */   "stateObserver": function() { return /* binding */ stateObserver; },
/* harmony export */   "on": function() { return /* binding */ on; },
/* harmony export */   "off": function() { return /* binding */ off; },
/* harmony export */   "emit": function() { return /* binding */ emit; },
/* harmony export */   "localize": function() { return /* binding */ localize; },
/* harmony export */   "useTranslate": function() { return /* binding */ useTranslate; },
/* harmony export */   "useRtl": function() { return /* binding */ useRtl; },
/* harmony export */   "withRtl": function() { return /* binding */ withRtl; }
/* harmony export */ });
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./i18n */ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/i18n.js");
/* harmony import */ var _localize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localize */ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/localize.js");
/* harmony import */ var _use_translate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./use-translate */ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/use-translate.js");
/* harmony import */ var _rtl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./rtl */ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/rtl.js");
/**
 * Internal dependencies
 */




var i18n = new _i18n__WEBPACK_IMPORTED_MODULE_0__["default"]();

/* harmony default export */ __webpack_exports__["default"] = (i18n);
var numberFormat = i18n.numberFormat.bind(i18n);
var translate = i18n.translate.bind(i18n);
var configure = i18n.configure.bind(i18n);
var setLocale = i18n.setLocale.bind(i18n);
var getLocale = i18n.getLocale.bind(i18n);
var getLocaleSlug = i18n.getLocaleSlug.bind(i18n);
var addTranslations = i18n.addTranslations.bind(i18n);
var reRenderTranslations = i18n.reRenderTranslations.bind(i18n);
var registerComponentUpdateHook = i18n.registerComponentUpdateHook.bind(i18n);
var registerTranslateHook = i18n.registerTranslateHook.bind(i18n);
var state = i18n.state;
var stateObserver = i18n.stateObserver;
var on = i18n.on.bind(i18n);
var off = i18n.off.bind(i18n);
var emit = i18n.emit.bind(i18n);
var localize = (0,_localize__WEBPACK_IMPORTED_MODULE_1__["default"])(i18n);
var useTranslate = (0,_use_translate__WEBPACK_IMPORTED_MODULE_2__["default"])(i18n);

var _rtlFactory = (0,_rtl__WEBPACK_IMPORTED_MODULE_3__["default"])(i18n),
    useRtl = _rtlFactory.useRtl,
    withRtl = _rtlFactory.withRtl;



/***/ }),

/***/ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/localize.js":
/*!*****************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/localize.js ***!
  \*****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* export default binding */ __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/objectSpread2 */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/objectSpread2.js");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/possibleConstructorReturn.js");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js");
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/inherits.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);









/**
 * External dependencies
 */

/**
 * Localize a React component
 *
 * @param {object} i18n I18N instance to use for localization
 * @returns {Function} Component localization function
 */

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(i18n) {
  var i18nProps = {
    numberFormat: i18n.numberFormat.bind(i18n),
    translate: i18n.translate.bind(i18n)
  };
  /**
   * Localize a React component
   *
   * @param  {React.Component} ComposedComponent React component to localize
   * @returns {React.Component}                   The localized component
   */

  return function (ComposedComponent) {
    var _class, _temp;

    var componentName = ComposedComponent.displayName || ComposedComponent.name || '';
    return _temp = _class =
    /*#__PURE__*/
    function (_React$Component) {
      (0,_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6__["default"])(_class, _React$Component);

      function _class() {
        var _getPrototypeOf2;

        var _this;

        (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_1__["default"])(this, _class);

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        _this = (0,_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_3__["default"])(this, (_getPrototypeOf2 = (0,_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_4__["default"])(_class)).call.apply(_getPrototypeOf2, [this].concat(args)));

        (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__["default"])((0,_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_5__["default"])(_this), "boundForceUpdate", _this.forceUpdate.bind((0,_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_5__["default"])(_this)));

        return _this;
      }

      (0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_2__["default"])(_class, [{
        key: "componentDidMount",
        value: function componentDidMount() {
          i18n.on('change', this.boundForceUpdate);
        }
      }, {
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
          i18n.off('change', this.boundForceUpdate);
        }
      }, {
        key: "render",
        value: function render() {
          var props = (0,_babel_runtime_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({
            locale: i18n.getLocaleSlug()
          }, this.props, {}, i18nProps);

          return react__WEBPACK_IMPORTED_MODULE_8___default().createElement(ComposedComponent, props);
        }
      }]);

      return _class;
    }((react__WEBPACK_IMPORTED_MODULE_8___default().Component)), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__["default"])(_class, "displayName", 'Localized(' + componentName + ')'), _temp;
  };
}

/***/ }),

/***/ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/number-format.js":
/*!**********************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/number-format.js ***!
  \**********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ number_format; }
/* harmony export */ });
/*
 * Exposes number format capability
 *
 * @copyright Copyright (c) 2013 Kevin van Zonneveld (http://kvz.io) and Contributors (http://phpjs.org/authors).
 * @license See CREDITS.md
 * @see https://github.com/kvz/phpjs/blob/ffe1356af23a6f2512c84c954dd4e828e92579fa/functions/strings/number_format.js
 */
function toFixedFix(n, prec) {
  var k = Math.pow(10, prec);
  return '' + (Math.round(n * k) / k).toFixed(prec);
}

function number_format(number, decimals, dec_point, thousands_sep) {
  number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
  var n = !isFinite(+number) ? 0 : +number;
  var prec = !isFinite(+decimals) ? 0 : Math.abs(decimals);
  var sep = typeof thousands_sep === 'undefined' ? ',' : thousands_sep;
  var dec = typeof dec_point === 'undefined' ? '.' : dec_point;
  var s = ''; // Fix for IE parseFloat(0.55).toFixed(0) = 0;

  s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');

  if (s[0].length > 3) {
    s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
  }

  if ((s[1] || '').length < prec) {
    s[1] = s[1] || '';
    s[1] += new Array(prec - s[1].length + 1).join('0');
  }

  return s.join(dec);
}

/***/ }),

/***/ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/rtl.js":
/*!************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/rtl.js ***!
  \************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ rtlFactory; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var use_subscription__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! use-subscription */ "../../../node_modules/.pnpm/use-subscription@1.5.1_react@16.14.0/node_modules/use-subscription/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/compose */ "@wordpress/compose");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__);


/**
 * External dependencies
 */



function rtlFactory(i18n) {
  // Subscription object (adapter) for the `useSubscription` hook
  var RtlSubscription = {
    getCurrentValue: function getCurrentValue() {
      return i18n.isRtl();
    },
    subscribe: function subscribe(callback) {
      i18n.on('change', callback);
      return function () {
        return i18n.off('change', callback);
      };
    }
  };

  function useRtl() {
    return (0,use_subscription__WEBPACK_IMPORTED_MODULE_2__.useSubscription)(RtlSubscription);
  }

  var withRtl = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__.createHigherOrderComponent)(function (WrappedComponent) {
    return (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function (props, ref) {
      var isRtl = useRtl();
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(WrappedComponent, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, props, {
        isRtl: isRtl,
        ref: ref
      }));
    });
  }, 'WithRTL');
  return {
    useRtl: useRtl,
    withRtl: withRtl
  };
}

/***/ }),

/***/ "../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/use-translate.js":
/*!**********************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/i18n-calypso@4.1.0/node_modules/i18n-calypso/dist/esm/use-translate.js ***!
  \**********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* export default binding */ __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


/**
 * External dependencies
 */

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(i18n) {
  function bindTranslate() {
    var translate = i18n.translate.bind(i18n);
    Object.defineProperty(translate, 'localeSlug', {
      get: i18n.getLocaleSlug.bind(i18n)
    });
    return translate;
  }

  return function useTranslate() {
    var _React$useState = react__WEBPACK_IMPORTED_MODULE_1___default().useState(bindTranslate),
        _React$useState2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__["default"])(_React$useState, 2),
        translate = _React$useState2[0],
        setTranslate = _React$useState2[1];

    react__WEBPACK_IMPORTED_MODULE_1___default().useEffect(function () {
      var onChange = function onChange() {
        return setTranslate(bindTranslate);
      };

      i18n.on('change', onChange);
      return function () {
        return i18n.off('change', onChange);
      };
    }, []);
    return translate;
  };
}

/***/ }),

/***/ "../../../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits_browser.js":
/*!********************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits_browser.js ***!
  \********************************************************************************************/
/***/ (function(module) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
          value: ctor,
          enumerable: false,
          writable: true,
          configurable: true
        }
      })
    }
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      var TempCtor = function () {}
      TempCtor.prototype = superCtor.prototype
      ctor.prototype = new TempCtor()
      ctor.prototype.constructor = ctor
    }
  }
}


/***/ }),

/***/ "../../../node_modules/.pnpm/interpolate-components@1.1.1/node_modules/interpolate-components/lib/index.js":
/*!*****************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/interpolate-components@1.1.1/node_modules/interpolate-components/lib/index.js ***!
  \*****************************************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
	value: true
}));

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; /**
                                                                                                                                                                                                                                                                               * External Dependencies
                                                                                                                                                                                                                                                                               */


/**
 * Internal Dependencies
 */


var _react = __webpack_require__(/*! react */ "react");

var _react2 = _interopRequireDefault(_react);

var _reactAddonsCreateFragment = __webpack_require__(/*! react-addons-create-fragment */ "../../../node_modules/.pnpm/react-addons-create-fragment@15.6.2/node_modules/react-addons-create-fragment/index.js");

var _reactAddonsCreateFragment2 = _interopRequireDefault(_reactAddonsCreateFragment);

var _tokenize = __webpack_require__(/*! ./tokenize */ "../../../node_modules/.pnpm/interpolate-components@1.1.1/node_modules/interpolate-components/lib/tokenize.js");

var _tokenize2 = _interopRequireDefault(_tokenize);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var currentMixedString = void 0;

function getCloseIndex(openIndex, tokens) {
	var openToken = tokens[openIndex],
	    nestLevel = 0,
	    token,
	    i;
	for (i = openIndex + 1; i < tokens.length; i++) {
		token = tokens[i];
		if (token.value === openToken.value) {
			if (token.type === 'componentOpen') {
				nestLevel++;
				continue;
			}
			if (token.type === 'componentClose') {
				if (nestLevel === 0) {
					return i;
				}
				nestLevel--;
			}
		}
	}
	// if we get this far, there was no matching close token
	throw new Error('Missing closing component token `' + openToken.value + '`');
}

function buildChildren(tokens, components) {
	var children = [],
	    childrenObject = {},
	    openComponent,
	    clonedOpenComponent,
	    openIndex,
	    closeIndex,
	    token,
	    i,
	    grandChildTokens,
	    grandChildren,
	    siblingTokens,
	    siblings;

	for (i = 0; i < tokens.length; i++) {
		token = tokens[i];
		if (token.type === 'string') {
			children.push(token.value);
			continue;
		}
		// component node should at least be set
		if (!components.hasOwnProperty(token.value) || typeof components[token.value] === 'undefined') {
			throw new Error('Invalid interpolation, missing component node: `' + token.value + '`');
		}
		// should be either ReactElement or null (both type "object"), all other types deprecated
		if (_typeof(components[token.value]) !== 'object') {
			throw new Error('Invalid interpolation, component node must be a ReactElement or null: `' + token.value + '`', '\n> ' + currentMixedString);
		}
		// we should never see a componentClose token in this loop
		if (token.type === 'componentClose') {
			throw new Error('Missing opening component token: `' + token.value + '`');
		}
		if (token.type === 'componentOpen') {
			openComponent = components[token.value];
			openIndex = i;
			break;
		}
		// componentSelfClosing token
		children.push(components[token.value]);
		continue;
	}

	if (openComponent) {
		closeIndex = getCloseIndex(openIndex, tokens);
		grandChildTokens = tokens.slice(openIndex + 1, closeIndex);
		grandChildren = buildChildren(grandChildTokens, components);
		clonedOpenComponent = _react2.default.cloneElement(openComponent, {}, grandChildren);
		children.push(clonedOpenComponent);

		if (closeIndex < tokens.length - 1) {
			siblingTokens = tokens.slice(closeIndex + 1);
			siblings = buildChildren(siblingTokens, components);
			children = children.concat(siblings);
		}
	}

	if (children.length === 1) {
		return children[0];
	}

	children.forEach(function (child, index) {
		if (child) {
			childrenObject['interpolation-child-' + index] = child;
		}
	});

	return (0, _reactAddonsCreateFragment2.default)(childrenObject);
}

function interpolate(options) {
	var mixedString = options.mixedString,
	    components = options.components,
	    throwErrors = options.throwErrors;


	currentMixedString = mixedString;

	if (!components) {
		return mixedString;
	}

	if ((typeof components === 'undefined' ? 'undefined' : _typeof(components)) !== 'object') {
		if (throwErrors) {
			throw new Error('Interpolation Error: unable to process `' + mixedString + '` because components is not an object');
		}

		return mixedString;
	}

	var tokens = (0, _tokenize2.default)(mixedString);

	try {
		return buildChildren(tokens, components);
	} catch (error) {
		if (throwErrors) {
			throw new Error('Interpolation Error: unable to process `' + mixedString + '` because of error `' + error.message + '`');
		}

		return mixedString;
	}
};

exports["default"] = interpolate;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../../node_modules/.pnpm/interpolate-components@1.1.1/node_modules/interpolate-components/lib/tokenize.js":
/*!********************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/interpolate-components@1.1.1/node_modules/interpolate-components/lib/tokenize.js ***!
  \********************************************************************************************************************/
/***/ (function(module) {

"use strict";


function identifyToken(item) {
	// {{/example}}
	if (item.match(/^\{\{\//)) {
		return {
			type: 'componentClose',
			value: item.replace(/\W/g, '')
		};
	}
	// {{example /}}
	if (item.match(/\/\}\}$/)) {
		return {
			type: 'componentSelfClosing',
			value: item.replace(/\W/g, '')
		};
	}
	// {{example}}
	if (item.match(/^\{\{/)) {
		return {
			type: 'componentOpen',
			value: item.replace(/\W/g, '')
		};
	}
	return {
		type: 'string',
		value: item
	};
}

module.exports = function (mixedString) {
	var tokenStrings = mixedString.split(/(\{\{\/?\s*\w+\s*\/?\}\})/g); // split to components and strings
	return tokenStrings.map(identifyToken);
};
//# sourceMappingURL=tokenize.js.map

/***/ }),

/***/ "../../../node_modules/.pnpm/lru@3.1.0/node_modules/lru/index.js":
/*!***********************************************************************!*\
  !*** ../../../node_modules/.pnpm/lru@3.1.0/node_modules/lru/index.js ***!
  \***********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var events = __webpack_require__(/*! events */ "../../../node_modules/.pnpm/events@3.3.0/node_modules/events/events.js")
var inherits = __webpack_require__(/*! inherits */ "../../../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits_browser.js")

module.exports = LRU

function LRU (opts) {
  if (!(this instanceof LRU)) return new LRU(opts)
  if (typeof opts === 'number') opts = {max: opts}
  if (!opts) opts = {}
  events.EventEmitter.call(this)
  this.cache = {}
  this.head = this.tail = null
  this.length = 0
  this.max = opts.max || 1000
  this.maxAge = opts.maxAge || 0
}

inherits(LRU, events.EventEmitter)

Object.defineProperty(LRU.prototype, 'keys', {
  get: function () { return Object.keys(this.cache) }
})

LRU.prototype.clear = function () {
  this.cache = {}
  this.head = this.tail = null
  this.length = 0
}

LRU.prototype.remove = function (key) {
  if (typeof key !== 'string') key = '' + key
  if (!this.cache.hasOwnProperty(key)) return

  var element = this.cache[key]
  delete this.cache[key]
  this._unlink(key, element.prev, element.next)
  return element.value
}

LRU.prototype._unlink = function (key, prev, next) {
  this.length--

  if (this.length === 0) {
    this.head = this.tail = null
  } else {
    if (this.head === key) {
      this.head = prev
      this.cache[this.head].next = null
    } else if (this.tail === key) {
      this.tail = next
      this.cache[this.tail].prev = null
    } else {
      this.cache[prev].next = next
      this.cache[next].prev = prev
    }
  }
}

LRU.prototype.peek = function (key) {
  if (!this.cache.hasOwnProperty(key)) return

  var element = this.cache[key]

  if (!this._checkAge(key, element)) return
  return element.value
}

LRU.prototype.set = function (key, value) {
  if (typeof key !== 'string') key = '' + key

  var element

  if (this.cache.hasOwnProperty(key)) {
    element = this.cache[key]
    element.value = value
    if (this.maxAge) element.modified = Date.now()

    // If it's already the head, there's nothing more to do:
    if (key === this.head) return value
    this._unlink(key, element.prev, element.next)
  } else {
    element = {value: value, modified: 0, next: null, prev: null}
    if (this.maxAge) element.modified = Date.now()
    this.cache[key] = element

    // Eviction is only possible if the key didn't already exist:
    if (this.length === this.max) this.evict()
  }

  this.length++
  element.next = null
  element.prev = this.head

  if (this.head) this.cache[this.head].next = key
  this.head = key

  if (!this.tail) this.tail = key
  return value
}

LRU.prototype._checkAge = function (key, element) {
  if (this.maxAge && (Date.now() - element.modified) > this.maxAge) {
    this.remove(key)
    this.emit('evict', {key: key, value: element.value})
    return false
  }
  return true
}

LRU.prototype.get = function (key) {
  if (typeof key !== 'string') key = '' + key
  if (!this.cache.hasOwnProperty(key)) return

  var element = this.cache[key]

  if (!this._checkAge(key, element)) return

  if (this.head !== key) {
    if (key === this.tail) {
      this.tail = element.next
      this.cache[this.tail].prev = null
    } else {
      // Set prev.next -> element.next:
      this.cache[element.prev].next = element.next
    }

    // Set element.next.prev -> element.prev:
    this.cache[element.next].prev = element.prev

    // Element is the new head
    this.cache[this.head].next = key
    element.prev = this.head
    element.next = null
    this.head = key
  }

  return element.value
}

LRU.prototype.evict = function () {
  if (!this.tail) return
  var key = this.tail
  var value = this.remove(this.tail)
  this.emit('evict', {key: key, value: value})
}


/***/ }),

/***/ "../../js-packages/components/components/action-button/style.scss":
/*!************************************************************************!*\
  !*** ../../js-packages/components/components/action-button/style.scss ***!
  \************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/components/components/decorative-card/style.scss":
/*!**************************************************************************!*\
  !*** ../../js-packages/components/components/decorative-card/style.scss ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/components/components/pricing-card/style.scss":
/*!***********************************************************************!*\
  !*** ../../js-packages/components/components/pricing-card/style.scss ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/components/components/spinner/style.scss":
/*!******************************************************************!*\
  !*** ../../js-packages/components/components/spinner/style.scss ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/connection/components/connect-screen/layout/style.scss":
/*!********************************************************************************!*\
  !*** ../../js-packages/connection/components/connect-screen/layout/style.scss ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/connection/components/connect-screen/required-plan/style.scss":
/*!***************************************************************************************!*\
  !*** ../../js-packages/connection/components/connect-screen/required-plan/style.scss ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/connection/components/connection-status-card/style.scss":
/*!*********************************************************************************!*\
  !*** ../../js-packages/connection/components/connection-status-card/style.scss ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/connection/components/disconnect-card/style.scss":
/*!**************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-card/style.scss ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/connection/components/disconnect-dialog/style.scss":
/*!****************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-dialog/style.scss ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/connection/components/disconnect-survey/_jp-connect_disconnect-survey-card.scss":
/*!*********************************************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-survey/_jp-connect_disconnect-survey-card.scss ***!
  \*********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/idc/components/idc-screen/style.scss":
/*!**************************************************************!*\
  !*** ../../js-packages/idc/components/idc-screen/style.scss ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../js-packages/idc/components/safe-mode/style.scss":
/*!*************************************************************!*\
  !*** ../../js-packages/idc/components/safe-mode/style.scss ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./_inc/components/admin/style.scss":
/*!******************************************!*\
  !*** ./_inc/components/admin/style.scss ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./_inc/components/header/style.scss":
/*!*******************************************!*\
  !*** ./_inc/components/header/style.scss ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../../../node_modules/.pnpm/minimalistic-assert@1.0.1/node_modules/minimalistic-assert/index.js":
/*!*******************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/minimalistic-assert@1.0.1/node_modules/minimalistic-assert/index.js ***!
  \*******************************************************************************************************/
/***/ (function(module) {

module.exports = assert;

function assert(val, msg) {
  if (!val)
    throw new Error(msg || 'Assertion failed');
}

assert.equal = function assertEqual(l, r, msg) {
  if (l != r)
    throw new Error(msg || ('Assertion failed: ' + l + ' != ' + r));
};


/***/ }),

/***/ "../../../node_modules/.pnpm/ms@2.1.2/node_modules/ms/index.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/.pnpm/ms@2.1.2/node_modules/ms/index.js ***!
  \*********************************************************************/
/***/ (function(module) {

/**
 * Helpers.
 */

var s = 1000;
var m = s * 60;
var h = m * 60;
var d = h * 24;
var w = d * 7;
var y = d * 365.25;

/**
 * Parse or format the given `val`.
 *
 * Options:
 *
 *  - `long` verbose formatting [false]
 *
 * @param {String|Number} val
 * @param {Object} [options]
 * @throws {Error} throw an error if val is not a non-empty string or a number
 * @return {String|Number}
 * @api public
 */

module.exports = function(val, options) {
  options = options || {};
  var type = typeof val;
  if (type === 'string' && val.length > 0) {
    return parse(val);
  } else if (type === 'number' && isFinite(val)) {
    return options.long ? fmtLong(val) : fmtShort(val);
  }
  throw new Error(
    'val is not a non-empty string or a valid number. val=' +
      JSON.stringify(val)
  );
};

/**
 * Parse the given `str` and return milliseconds.
 *
 * @param {String} str
 * @return {Number}
 * @api private
 */

function parse(str) {
  str = String(str);
  if (str.length > 100) {
    return;
  }
  var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
    str
  );
  if (!match) {
    return;
  }
  var n = parseFloat(match[1]);
  var type = (match[2] || 'ms').toLowerCase();
  switch (type) {
    case 'years':
    case 'year':
    case 'yrs':
    case 'yr':
    case 'y':
      return n * y;
    case 'weeks':
    case 'week':
    case 'w':
      return n * w;
    case 'days':
    case 'day':
    case 'd':
      return n * d;
    case 'hours':
    case 'hour':
    case 'hrs':
    case 'hr':
    case 'h':
      return n * h;
    case 'minutes':
    case 'minute':
    case 'mins':
    case 'min':
    case 'm':
      return n * m;
    case 'seconds':
    case 'second':
    case 'secs':
    case 'sec':
    case 's':
      return n * s;
    case 'milliseconds':
    case 'millisecond':
    case 'msecs':
    case 'msec':
    case 'ms':
      return n;
    default:
      return undefined;
  }
}

/**
 * Short format for `ms`.
 *
 * @param {Number} ms
 * @return {String}
 * @api private
 */

function fmtShort(ms) {
  var msAbs = Math.abs(ms);
  if (msAbs >= d) {
    return Math.round(ms / d) + 'd';
  }
  if (msAbs >= h) {
    return Math.round(ms / h) + 'h';
  }
  if (msAbs >= m) {
    return Math.round(ms / m) + 'm';
  }
  if (msAbs >= s) {
    return Math.round(ms / s) + 's';
  }
  return ms + 'ms';
}

/**
 * Long format for `ms`.
 *
 * @param {Number} ms
 * @return {String}
 * @api private
 */

function fmtLong(ms) {
  var msAbs = Math.abs(ms);
  if (msAbs >= d) {
    return plural(ms, msAbs, d, 'day');
  }
  if (msAbs >= h) {
    return plural(ms, msAbs, h, 'hour');
  }
  if (msAbs >= m) {
    return plural(ms, msAbs, m, 'minute');
  }
  if (msAbs >= s) {
    return plural(ms, msAbs, s, 'second');
  }
  return ms + ' ms';
}

/**
 * Pluralization helper.
 */

function plural(ms, msAbs, n, name) {
  var isPlural = msAbs >= n * 1.5;
  return Math.round(ms / n) + ' ' + name + (isPlural ? 's' : '');
}


/***/ }),

/***/ "../../../node_modules/.pnpm/object-assign@4.1.1/node_modules/object-assign/index.js":
/*!*******************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/object-assign@4.1.1/node_modules/object-assign/index.js ***!
  \*******************************************************************************************/
/***/ (function(module) {

"use strict";
/*
object-assign
(c) Sindre Sorhus
@license MIT
*/


/* eslint-disable no-unused-vars */
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;

function toObject(val) {
	if (val === null || val === undefined) {
		throw new TypeError('Object.assign cannot be called with null or undefined');
	}

	return Object(val);
}

function shouldUseNative() {
	try {
		if (!Object.assign) {
			return false;
		}

		// Detect buggy property enumeration order in older V8 versions.

		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
		test1[5] = 'de';
		if (Object.getOwnPropertyNames(test1)[0] === '5') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test2 = {};
		for (var i = 0; i < 10; i++) {
			test2['_' + String.fromCharCode(i)] = i;
		}
		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
			return test2[n];
		});
		if (order2.join('') !== '0123456789') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test3 = {};
		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
			test3[letter] = letter;
		});
		if (Object.keys(Object.assign({}, test3)).join('') !==
				'abcdefghijklmnopqrst') {
			return false;
		}

		return true;
	} catch (err) {
		// We don't expect any of the above to throw, but better to be safe.
		return false;
	}
}

module.exports = shouldUseNative() ? Object.assign : function (target, source) {
	var from;
	var to = toObject(target);
	var symbols;

	for (var s = 1; s < arguments.length; s++) {
		from = Object(arguments[s]);

		for (var key in from) {
			if (hasOwnProperty.call(from, key)) {
				to[key] = from[key];
			}
		}

		if (getOwnPropertySymbols) {
			symbols = getOwnPropertySymbols(from);
			for (var i = 0; i < symbols.length; i++) {
				if (propIsEnumerable.call(from, symbols[i])) {
					to[symbols[i]] = from[symbols[i]];
				}
			}
		}
	}

	return to;
};


/***/ }),

/***/ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/checkPropTypes.js":
/*!***********************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/checkPropTypes.js ***!
  \***********************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var printWarning = function() {};

if (true) {
  var ReactPropTypesSecret = __webpack_require__(/*! ./lib/ReactPropTypesSecret */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/lib/ReactPropTypesSecret.js");
  var loggedTypeFailures = {};
  var has = Function.call.bind(Object.prototype.hasOwnProperty);

  printWarning = function(text) {
    var message = 'Warning: ' + text;
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

/**
 * Assert that the values match with the type specs.
 * Error messages are memorized and will only be shown once.
 *
 * @param {object} typeSpecs Map of name to a ReactPropType
 * @param {object} values Runtime values that need to be type-checked
 * @param {string} location e.g. "prop", "context", "child context"
 * @param {string} componentName Name of the component for error messages.
 * @param {?Function} getStack Returns the component stack.
 * @private
 */
function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
  if (true) {
    for (var typeSpecName in typeSpecs) {
      if (has(typeSpecs, typeSpecName)) {
        var error;
        // Prop type validation may throw. In case they do, we don't want to
        // fail the render phase where it didn't fail before. So we log it.
        // After these have been cleaned up, we'll let them throw.
        try {
          // This is intentionally an invariant that gets caught. It's the same
          // behavior as without this statement except with a better message.
          if (typeof typeSpecs[typeSpecName] !== 'function') {
            var err = Error(
              (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +
              'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.'
            );
            err.name = 'Invariant Violation';
            throw err;
          }
          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);
        } catch (ex) {
          error = ex;
        }
        if (error && !(error instanceof Error)) {
          printWarning(
            (componentName || 'React class') + ': type specification of ' +
            location + ' `' + typeSpecName + '` is invalid; the type checker ' +
            'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +
            'You may have forgotten to pass an argument to the type checker ' +
            'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +
            'shape all require an argument).'
          );
        }
        if (error instanceof Error && !(error.message in loggedTypeFailures)) {
          // Only monitor this failure once because there tends to be a lot of the
          // same error.
          loggedTypeFailures[error.message] = true;

          var stack = getStack ? getStack() : '';

          printWarning(
            'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')
          );
        }
      }
    }
  }
}

/**
 * Resets warning cache when testing.
 *
 * @private
 */
checkPropTypes.resetWarningCache = function() {
  if (true) {
    loggedTypeFailures = {};
  }
}

module.exports = checkPropTypes;


/***/ }),

/***/ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/factoryWithTypeCheckers.js":
/*!********************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/factoryWithTypeCheckers.js ***!
  \********************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactIs = __webpack_require__(/*! react-is */ "../../../node_modules/.pnpm/react-is@16.13.1/node_modules/react-is/index.js");
var assign = __webpack_require__(/*! object-assign */ "../../../node_modules/.pnpm/object-assign@4.1.1/node_modules/object-assign/index.js");

var ReactPropTypesSecret = __webpack_require__(/*! ./lib/ReactPropTypesSecret */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/lib/ReactPropTypesSecret.js");
var checkPropTypes = __webpack_require__(/*! ./checkPropTypes */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/checkPropTypes.js");

var has = Function.call.bind(Object.prototype.hasOwnProperty);
var printWarning = function() {};

if (true) {
  printWarning = function(text) {
    var message = 'Warning: ' + text;
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

function emptyFunctionThatReturnsNull() {
  return null;
}

module.exports = function(isValidElement, throwOnDirectAccess) {
  /* global Symbol */
  var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

  /**
   * Returns the iterator method function contained on the iterable object.
   *
   * Be sure to invoke the function with the iterable as context:
   *
   *     var iteratorFn = getIteratorFn(myIterable);
   *     if (iteratorFn) {
   *       var iterator = iteratorFn.call(myIterable);
   *       ...
   *     }
   *
   * @param {?object} maybeIterable
   * @return {?function}
   */
  function getIteratorFn(maybeIterable) {
    var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
    if (typeof iteratorFn === 'function') {
      return iteratorFn;
    }
  }

  /**
   * Collection of methods that allow declaration and validation of props that are
   * supplied to React components. Example usage:
   *
   *   var Props = require('ReactPropTypes');
   *   var MyArticle = React.createClass({
   *     propTypes: {
   *       // An optional string prop named "description".
   *       description: Props.string,
   *
   *       // A required enum prop named "category".
   *       category: Props.oneOf(['News','Photos']).isRequired,
   *
   *       // A prop named "dialog" that requires an instance of Dialog.
   *       dialog: Props.instanceOf(Dialog).isRequired
   *     },
   *     render: function() { ... }
   *   });
   *
   * A more formal specification of how these methods are used:
   *
   *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
   *   decl := ReactPropTypes.{type}(.isRequired)?
   *
   * Each and every declaration produces a function with the same signature. This
   * allows the creation of custom validation functions. For example:
   *
   *  var MyLink = React.createClass({
   *    propTypes: {
   *      // An optional string or URI prop named "href".
   *      href: function(props, propName, componentName) {
   *        var propValue = props[propName];
   *        if (propValue != null && typeof propValue !== 'string' &&
   *            !(propValue instanceof URI)) {
   *          return new Error(
   *            'Expected a string or an URI for ' + propName + ' in ' +
   *            componentName
   *          );
   *        }
   *      }
   *    },
   *    render: function() {...}
   *  });
   *
   * @internal
   */

  var ANONYMOUS = '<<anonymous>>';

  // Important!
  // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
  var ReactPropTypes = {
    array: createPrimitiveTypeChecker('array'),
    bool: createPrimitiveTypeChecker('boolean'),
    func: createPrimitiveTypeChecker('function'),
    number: createPrimitiveTypeChecker('number'),
    object: createPrimitiveTypeChecker('object'),
    string: createPrimitiveTypeChecker('string'),
    symbol: createPrimitiveTypeChecker('symbol'),

    any: createAnyTypeChecker(),
    arrayOf: createArrayOfTypeChecker,
    element: createElementTypeChecker(),
    elementType: createElementTypeTypeChecker(),
    instanceOf: createInstanceTypeChecker,
    node: createNodeChecker(),
    objectOf: createObjectOfTypeChecker,
    oneOf: createEnumTypeChecker,
    oneOfType: createUnionTypeChecker,
    shape: createShapeTypeChecker,
    exact: createStrictShapeTypeChecker,
  };

  /**
   * inlined Object.is polyfill to avoid requiring consumers ship their own
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
   */
  /*eslint-disable no-self-compare*/
  function is(x, y) {
    // SameValue algorithm
    if (x === y) {
      // Steps 1-5, 7-10
      // Steps 6.b-6.e: +0 != -0
      return x !== 0 || 1 / x === 1 / y;
    } else {
      // Step 6.a: NaN == NaN
      return x !== x && y !== y;
    }
  }
  /*eslint-enable no-self-compare*/

  /**
   * We use an Error-like object for backward compatibility as people may call
   * PropTypes directly and inspect their output. However, we don't use real
   * Errors anymore. We don't inspect their stack anyway, and creating them
   * is prohibitively expensive if they are created too often, such as what
   * happens in oneOfType() for any type before the one that matched.
   */
  function PropTypeError(message) {
    this.message = message;
    this.stack = '';
  }
  // Make `instanceof Error` still work for returned errors.
  PropTypeError.prototype = Error.prototype;

  function createChainableTypeChecker(validate) {
    if (true) {
      var manualPropTypeCallCache = {};
      var manualPropTypeWarningCount = 0;
    }
    function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
      componentName = componentName || ANONYMOUS;
      propFullName = propFullName || propName;

      if (secret !== ReactPropTypesSecret) {
        if (throwOnDirectAccess) {
          // New behavior only for users of `prop-types` package
          var err = new Error(
            'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
            'Use `PropTypes.checkPropTypes()` to call them. ' +
            'Read more at http://fb.me/use-check-prop-types'
          );
          err.name = 'Invariant Violation';
          throw err;
        } else if ( true && typeof console !== 'undefined') {
          // Old behavior for people using React.PropTypes
          var cacheKey = componentName + ':' + propName;
          if (
            !manualPropTypeCallCache[cacheKey] &&
            // Avoid spamming the console because they are often not actionable except for lib authors
            manualPropTypeWarningCount < 3
          ) {
            printWarning(
              'You are manually calling a React.PropTypes validation ' +
              'function for the `' + propFullName + '` prop on `' + componentName  + '`. This is deprecated ' +
              'and will throw in the standalone `prop-types` package. ' +
              'You may be seeing this warning due to a third-party PropTypes ' +
              'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.'
            );
            manualPropTypeCallCache[cacheKey] = true;
            manualPropTypeWarningCount++;
          }
        }
      }
      if (props[propName] == null) {
        if (isRequired) {
          if (props[propName] === null) {
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
          }
          return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
        }
        return null;
      } else {
        return validate(props, propName, componentName, location, propFullName);
      }
    }

    var chainedCheckType = checkType.bind(null, false);
    chainedCheckType.isRequired = checkType.bind(null, true);

    return chainedCheckType;
  }

  function createPrimitiveTypeChecker(expectedType) {
    function validate(props, propName, componentName, location, propFullName, secret) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== expectedType) {
        // `propValue` being instance of, say, date/regexp, pass the 'object'
        // check, but we can offer a more precise error message here rather than
        // 'of type `object`'.
        var preciseType = getPreciseType(propValue);

        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createAnyTypeChecker() {
    return createChainableTypeChecker(emptyFunctionThatReturnsNull);
  }

  function createArrayOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
      }
      var propValue = props[propName];
      if (!Array.isArray(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
      }
      for (var i = 0; i < propValue.length; i++) {
        var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret);
        if (error instanceof Error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!isValidElement(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!ReactIs.isValidElementType(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createInstanceTypeChecker(expectedClass) {
    function validate(props, propName, componentName, location, propFullName) {
      if (!(props[propName] instanceof expectedClass)) {
        var expectedClassName = expectedClass.name || ANONYMOUS;
        var actualClassName = getClassName(props[propName]);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createEnumTypeChecker(expectedValues) {
    if (!Array.isArray(expectedValues)) {
      if (true) {
        if (arguments.length > 1) {
          printWarning(
            'Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' +
            'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).'
          );
        } else {
          printWarning('Invalid argument supplied to oneOf, expected an array.');
        }
      }
      return emptyFunctionThatReturnsNull;
    }

    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      for (var i = 0; i < expectedValues.length; i++) {
        if (is(propValue, expectedValues[i])) {
          return null;
        }
      }

      var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
        var type = getPreciseType(value);
        if (type === 'symbol') {
          return String(value);
        }
        return value;
      });
      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createObjectOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
      }
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
      }
      for (var key in propValue) {
        if (has(propValue, key)) {
          var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);
          if (error instanceof Error) {
            return error;
          }
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createUnionTypeChecker(arrayOfTypeCheckers) {
    if (!Array.isArray(arrayOfTypeCheckers)) {
       true ? printWarning('Invalid argument supplied to oneOfType, expected an instance of array.') : 0;
      return emptyFunctionThatReturnsNull;
    }

    for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
      var checker = arrayOfTypeCheckers[i];
      if (typeof checker !== 'function') {
        printWarning(
          'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +
          'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.'
        );
        return emptyFunctionThatReturnsNull;
      }
    }

    function validate(props, propName, componentName, location, propFullName) {
      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret) == null) {
          return null;
        }
      }

      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createNodeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      if (!isNode(props[propName])) {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      for (var key in shapeTypes) {
        var checker = shapeTypes[key];
        if (!checker) {
          continue;
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);
        if (error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createStrictShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      // We need to check all keys in case some are required but missing from
      // props.
      var allKeys = assign({}, props[propName], shapeTypes);
      for (var key in allKeys) {
        var checker = shapeTypes[key];
        if (!checker) {
          return new PropTypeError(
            'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +
            '\nBad object: ' + JSON.stringify(props[propName], null, '  ') +
            '\nValid keys: ' +  JSON.stringify(Object.keys(shapeTypes), null, '  ')
          );
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);
        if (error) {
          return error;
        }
      }
      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function isNode(propValue) {
    switch (typeof propValue) {
      case 'number':
      case 'string':
      case 'undefined':
        return true;
      case 'boolean':
        return !propValue;
      case 'object':
        if (Array.isArray(propValue)) {
          return propValue.every(isNode);
        }
        if (propValue === null || isValidElement(propValue)) {
          return true;
        }

        var iteratorFn = getIteratorFn(propValue);
        if (iteratorFn) {
          var iterator = iteratorFn.call(propValue);
          var step;
          if (iteratorFn !== propValue.entries) {
            while (!(step = iterator.next()).done) {
              if (!isNode(step.value)) {
                return false;
              }
            }
          } else {
            // Iterator will provide entry [k,v] tuples rather than values.
            while (!(step = iterator.next()).done) {
              var entry = step.value;
              if (entry) {
                if (!isNode(entry[1])) {
                  return false;
                }
              }
            }
          }
        } else {
          return false;
        }

        return true;
      default:
        return false;
    }
  }

  function isSymbol(propType, propValue) {
    // Native Symbol.
    if (propType === 'symbol') {
      return true;
    }

    // falsy value can't be a Symbol
    if (!propValue) {
      return false;
    }

    // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
    if (propValue['@@toStringTag'] === 'Symbol') {
      return true;
    }

    // Fallback for non-spec compliant Symbols which are polyfilled.
    if (typeof Symbol === 'function' && propValue instanceof Symbol) {
      return true;
    }

    return false;
  }

  // Equivalent of `typeof` but with special handling for array and regexp.
  function getPropType(propValue) {
    var propType = typeof propValue;
    if (Array.isArray(propValue)) {
      return 'array';
    }
    if (propValue instanceof RegExp) {
      // Old webkits (at least until Android 4.0) return 'function' rather than
      // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
      // passes PropTypes.object.
      return 'object';
    }
    if (isSymbol(propType, propValue)) {
      return 'symbol';
    }
    return propType;
  }

  // This handles more types than `getPropType`. Only used for error messages.
  // See `createPrimitiveTypeChecker`.
  function getPreciseType(propValue) {
    if (typeof propValue === 'undefined' || propValue === null) {
      return '' + propValue;
    }
    var propType = getPropType(propValue);
    if (propType === 'object') {
      if (propValue instanceof Date) {
        return 'date';
      } else if (propValue instanceof RegExp) {
        return 'regexp';
      }
    }
    return propType;
  }

  // Returns a string that is postfixed to a warning about an invalid type.
  // For example, "undefined" or "of type array"
  function getPostfixForTypeWarning(value) {
    var type = getPreciseType(value);
    switch (type) {
      case 'array':
      case 'object':
        return 'an ' + type;
      case 'boolean':
      case 'date':
      case 'regexp':
        return 'a ' + type;
      default:
        return type;
    }
  }

  // Returns class name of the object, if any.
  function getClassName(propValue) {
    if (!propValue.constructor || !propValue.constructor.name) {
      return ANONYMOUS;
    }
    return propValue.constructor.name;
  }

  ReactPropTypes.checkPropTypes = checkPropTypes;
  ReactPropTypes.resetWarningCache = checkPropTypes.resetWarningCache;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};


/***/ }),

/***/ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js":
/*!**************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js ***!
  \**************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (true) {
  var ReactIs = __webpack_require__(/*! react-is */ "../../../node_modules/.pnpm/react-is@16.13.1/node_modules/react-is/index.js");

  // By explicitly using `prop-types` you are opting into new development behavior.
  // http://fb.me/prop-types-in-prod
  var throwOnDirectAccess = true;
  module.exports = __webpack_require__(/*! ./factoryWithTypeCheckers */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/factoryWithTypeCheckers.js")(ReactIs.isElement, throwOnDirectAccess);
} else {}


/***/ }),

/***/ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/lib/ReactPropTypesSecret.js":
/*!*********************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/lib/ReactPropTypesSecret.js ***!
  \*********************************************************************************************************/
/***/ (function(module) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

module.exports = ReactPropTypesSecret;


/***/ }),

/***/ "../../../node_modules/.pnpm/react-addons-create-fragment@15.6.2/node_modules/react-addons-create-fragment/index.js":
/*!**************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/react-addons-create-fragment@15.6.2/node_modules/react-addons-create-fragment/index.js ***!
  \**************************************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2015-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var React = __webpack_require__(/*! react */ "react");

var REACT_ELEMENT_TYPE =
  (typeof Symbol === 'function' && Symbol.for && Symbol.for('react.element')) ||
  0xeac7;

var emptyFunction = __webpack_require__(/*! fbjs/lib/emptyFunction */ "../../../node_modules/.pnpm/fbjs@0.8.18/node_modules/fbjs/lib/emptyFunction.js");
var invariant = __webpack_require__(/*! fbjs/lib/invariant */ "../../../node_modules/.pnpm/fbjs@0.8.18/node_modules/fbjs/lib/invariant.js");
var warning = __webpack_require__(/*! fbjs/lib/warning */ "../../../node_modules/.pnpm/fbjs@0.8.18/node_modules/fbjs/lib/warning.js");

var SEPARATOR = '.';
var SUBSEPARATOR = ':';

var didWarnAboutMaps = false;

var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

function getIteratorFn(maybeIterable) {
  var iteratorFn =
    maybeIterable &&
    ((ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL]) ||
      maybeIterable[FAUX_ITERATOR_SYMBOL]);
  if (typeof iteratorFn === 'function') {
    return iteratorFn;
  }
}

function escape(key) {
  var escapeRegex = /[=:]/g;
  var escaperLookup = {
    '=': '=0',
    ':': '=2'
  };
  var escapedString = ('' + key).replace(escapeRegex, function(match) {
    return escaperLookup[match];
  });

  return '$' + escapedString;
}

function getComponentKey(component, index) {
  // Do some typechecking here since we call this blindly. We want to ensure
  // that we don't block potential future ES APIs.
  if (component && typeof component === 'object' && component.key != null) {
    // Explicit key
    return escape(component.key);
  }
  // Implicit key determined by the index in the set
  return index.toString(36);
}

function traverseAllChildrenImpl(
  children,
  nameSoFar,
  callback,
  traverseContext
) {
  var type = typeof children;

  if (type === 'undefined' || type === 'boolean') {
    // All of the above are perceived as null.
    children = null;
  }

  if (
    children === null ||
    type === 'string' ||
    type === 'number' ||
    // The following is inlined from ReactElement. This means we can optimize
    // some checks. React Fiber also inlines this logic for similar purposes.
    (type === 'object' && children.$$typeof === REACT_ELEMENT_TYPE)
  ) {
    callback(
      traverseContext,
      children,
      // If it's the only child, treat the name as if it was wrapped in an array
      // so that it's consistent if the number of children grows.
      nameSoFar === '' ? SEPARATOR + getComponentKey(children, 0) : nameSoFar
    );
    return 1;
  }

  var child;
  var nextName;
  var subtreeCount = 0; // Count of children found in the current subtree.
  var nextNamePrefix = nameSoFar === '' ? SEPARATOR : nameSoFar + SUBSEPARATOR;

  if (Array.isArray(children)) {
    for (var i = 0; i < children.length; i++) {
      child = children[i];
      nextName = nextNamePrefix + getComponentKey(child, i);
      subtreeCount += traverseAllChildrenImpl(
        child,
        nextName,
        callback,
        traverseContext
      );
    }
  } else {
    var iteratorFn = getIteratorFn(children);
    if (iteratorFn) {
      if (true) {
        // Warn about using Maps as children
        if (iteratorFn === children.entries) {
          warning(
            didWarnAboutMaps,
            'Using Maps as children is unsupported and will likely yield ' +
              'unexpected results. Convert it to a sequence/iterable of keyed ' +
              'ReactElements instead.'
          );
          didWarnAboutMaps = true;
        }
      }

      var iterator = iteratorFn.call(children);
      var step;
      var ii = 0;
      while (!(step = iterator.next()).done) {
        child = step.value;
        nextName = nextNamePrefix + getComponentKey(child, ii++);
        subtreeCount += traverseAllChildrenImpl(
          child,
          nextName,
          callback,
          traverseContext
        );
      }
    } else if (type === 'object') {
      var addendum = '';
      if (true) {
        addendum =
          ' If you meant to render a collection of children, use an array ' +
          'instead or wrap the object using createFragment(object) from the ' +
          'React add-ons.';
      }
      var childrenString = '' + children;
      invariant(
        false,
        'Objects are not valid as a React child (found: %s).%s',
        childrenString === '[object Object]'
          ? 'object with keys {' + Object.keys(children).join(', ') + '}'
          : childrenString,
        addendum
      );
    }
  }

  return subtreeCount;
}

function traverseAllChildren(children, callback, traverseContext) {
  if (children == null) {
    return 0;
  }

  return traverseAllChildrenImpl(children, '', callback, traverseContext);
}

var userProvidedKeyEscapeRegex = /\/+/g;
function escapeUserProvidedKey(text) {
  return ('' + text).replace(userProvidedKeyEscapeRegex, '$&/');
}

function cloneAndReplaceKey(oldElement, newKey) {
  return React.cloneElement(
    oldElement,
    {key: newKey},
    oldElement.props !== undefined ? oldElement.props.children : undefined
  );
}

var DEFAULT_POOL_SIZE = 10;
var DEFAULT_POOLER = oneArgumentPooler;

var oneArgumentPooler = function(copyFieldsFrom) {
  var Klass = this;
  if (Klass.instancePool.length) {
    var instance = Klass.instancePool.pop();
    Klass.call(instance, copyFieldsFrom);
    return instance;
  } else {
    return new Klass(copyFieldsFrom);
  }
};

var addPoolingTo = function addPoolingTo(CopyConstructor, pooler) {
  // Casting as any so that flow ignores the actual implementation and trusts
  // it to match the type we declared
  var NewKlass = CopyConstructor;
  NewKlass.instancePool = [];
  NewKlass.getPooled = pooler || DEFAULT_POOLER;
  if (!NewKlass.poolSize) {
    NewKlass.poolSize = DEFAULT_POOL_SIZE;
  }
  NewKlass.release = standardReleaser;
  return NewKlass;
};

var standardReleaser = function standardReleaser(instance) {
  var Klass = this;
  invariant(
    instance instanceof Klass,
    'Trying to release an instance into a pool of a different type.'
  );
  instance.destructor();
  if (Klass.instancePool.length < Klass.poolSize) {
    Klass.instancePool.push(instance);
  }
};

var fourArgumentPooler = function fourArgumentPooler(a1, a2, a3, a4) {
  var Klass = this;
  if (Klass.instancePool.length) {
    var instance = Klass.instancePool.pop();
    Klass.call(instance, a1, a2, a3, a4);
    return instance;
  } else {
    return new Klass(a1, a2, a3, a4);
  }
};

function MapBookKeeping(mapResult, keyPrefix, mapFunction, mapContext) {
  this.result = mapResult;
  this.keyPrefix = keyPrefix;
  this.func = mapFunction;
  this.context = mapContext;
  this.count = 0;
}
MapBookKeeping.prototype.destructor = function() {
  this.result = null;
  this.keyPrefix = null;
  this.func = null;
  this.context = null;
  this.count = 0;
};
addPoolingTo(MapBookKeeping, fourArgumentPooler);

function mapSingleChildIntoContext(bookKeeping, child, childKey) {
  var result = bookKeeping.result;
  var keyPrefix = bookKeeping.keyPrefix;
  var func = bookKeeping.func;
  var context = bookKeeping.context;

  var mappedChild = func.call(context, child, bookKeeping.count++);
  if (Array.isArray(mappedChild)) {
    mapIntoWithKeyPrefixInternal(
      mappedChild,
      result,
      childKey,
      emptyFunction.thatReturnsArgument
    );
  } else if (mappedChild != null) {
    if (React.isValidElement(mappedChild)) {
      mappedChild = cloneAndReplaceKey(
        mappedChild,
        // Keep both the (mapped) and old keys if they differ, just as
        // traverseAllChildren used to do for objects as children
        keyPrefix +
          (mappedChild.key && (!child || child.key !== mappedChild.key)
            ? escapeUserProvidedKey(mappedChild.key) + '/'
            : '') +
          childKey
      );
    }
    result.push(mappedChild);
  }
}

function mapIntoWithKeyPrefixInternal(children, array, prefix, func, context) {
  var escapedPrefix = '';
  if (prefix != null) {
    escapedPrefix = escapeUserProvidedKey(prefix) + '/';
  }
  var traverseContext = MapBookKeeping.getPooled(
    array,
    escapedPrefix,
    func,
    context
  );
  traverseAllChildren(children, mapSingleChildIntoContext, traverseContext);
  MapBookKeeping.release(traverseContext);
}

var numericPropertyRegex = /^\d+$/;

var warnedAboutNumeric = false;

function createReactFragment(object) {
  if (typeof object !== 'object' || !object || Array.isArray(object)) {
    warning(
      false,
      'React.addons.createFragment only accepts a single object. Got: %s',
      object
    );
    return object;
  }
  if (React.isValidElement(object)) {
    warning(
      false,
      'React.addons.createFragment does not accept a ReactElement ' +
        'without a wrapper object.'
    );
    return object;
  }

  invariant(
    object.nodeType !== 1,
    'React.addons.createFragment(...): Encountered an invalid child; DOM ' +
      'elements are not valid children of React components.'
  );

  var result = [];

  for (var key in object) {
    if (true) {
      if (!warnedAboutNumeric && numericPropertyRegex.test(key)) {
        warning(
          false,
          'React.addons.createFragment(...): Child objects should have ' +
            'non-numeric keys so ordering is preserved.'
        );
        warnedAboutNumeric = true;
      }
    }
    mapIntoWithKeyPrefixInternal(
      object[key],
      result,
      key,
      emptyFunction.thatReturnsArgument
    );
  }

  return result;
}

module.exports = createReactFragment;


/***/ }),

/***/ "../../../node_modules/.pnpm/react-is@16.13.1/node_modules/react-is/cjs/react-is.development.js":
/*!******************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/react-is@16.13.1/node_modules/react-is/cjs/react-is.development.js ***!
  \******************************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {

"use strict";
/** @license React v16.13.1
 * react-is.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */





if (true) {
  (function() {
'use strict';

// The Symbol used to tag the ReactElement-like types. If there is no native Symbol
// nor polyfill, then a plain number is used for performance.
var hasSymbol = typeof Symbol === 'function' && Symbol.for;
var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
// (unstable) APIs that have been removed. Can we remove the symbols?

var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
var REACT_BLOCK_TYPE = hasSymbol ? Symbol.for('react.block') : 0xead9;
var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;

function isValidElementType(type) {
  return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
  type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE || type.$$typeof === REACT_BLOCK_TYPE);
}

function typeOf(object) {
  if (typeof object === 'object' && object !== null) {
    var $$typeof = object.$$typeof;

    switch ($$typeof) {
      case REACT_ELEMENT_TYPE:
        var type = object.type;

        switch (type) {
          case REACT_ASYNC_MODE_TYPE:
          case REACT_CONCURRENT_MODE_TYPE:
          case REACT_FRAGMENT_TYPE:
          case REACT_PROFILER_TYPE:
          case REACT_STRICT_MODE_TYPE:
          case REACT_SUSPENSE_TYPE:
            return type;

          default:
            var $$typeofType = type && type.$$typeof;

            switch ($$typeofType) {
              case REACT_CONTEXT_TYPE:
              case REACT_FORWARD_REF_TYPE:
              case REACT_LAZY_TYPE:
              case REACT_MEMO_TYPE:
              case REACT_PROVIDER_TYPE:
                return $$typeofType;

              default:
                return $$typeof;
            }

        }

      case REACT_PORTAL_TYPE:
        return $$typeof;
    }
  }

  return undefined;
} // AsyncMode is deprecated along with isAsyncMode

var AsyncMode = REACT_ASYNC_MODE_TYPE;
var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
var ContextConsumer = REACT_CONTEXT_TYPE;
var ContextProvider = REACT_PROVIDER_TYPE;
var Element = REACT_ELEMENT_TYPE;
var ForwardRef = REACT_FORWARD_REF_TYPE;
var Fragment = REACT_FRAGMENT_TYPE;
var Lazy = REACT_LAZY_TYPE;
var Memo = REACT_MEMO_TYPE;
var Portal = REACT_PORTAL_TYPE;
var Profiler = REACT_PROFILER_TYPE;
var StrictMode = REACT_STRICT_MODE_TYPE;
var Suspense = REACT_SUSPENSE_TYPE;
var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

function isAsyncMode(object) {
  {
    if (!hasWarnedAboutDeprecatedIsAsyncMode) {
      hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

      console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
    }
  }

  return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
}
function isConcurrentMode(object) {
  return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
}
function isContextConsumer(object) {
  return typeOf(object) === REACT_CONTEXT_TYPE;
}
function isContextProvider(object) {
  return typeOf(object) === REACT_PROVIDER_TYPE;
}
function isElement(object) {
  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
}
function isForwardRef(object) {
  return typeOf(object) === REACT_FORWARD_REF_TYPE;
}
function isFragment(object) {
  return typeOf(object) === REACT_FRAGMENT_TYPE;
}
function isLazy(object) {
  return typeOf(object) === REACT_LAZY_TYPE;
}
function isMemo(object) {
  return typeOf(object) === REACT_MEMO_TYPE;
}
function isPortal(object) {
  return typeOf(object) === REACT_PORTAL_TYPE;
}
function isProfiler(object) {
  return typeOf(object) === REACT_PROFILER_TYPE;
}
function isStrictMode(object) {
  return typeOf(object) === REACT_STRICT_MODE_TYPE;
}
function isSuspense(object) {
  return typeOf(object) === REACT_SUSPENSE_TYPE;
}

exports.AsyncMode = AsyncMode;
exports.ConcurrentMode = ConcurrentMode;
exports.ContextConsumer = ContextConsumer;
exports.ContextProvider = ContextProvider;
exports.Element = Element;
exports.ForwardRef = ForwardRef;
exports.Fragment = Fragment;
exports.Lazy = Lazy;
exports.Memo = Memo;
exports.Portal = Portal;
exports.Profiler = Profiler;
exports.StrictMode = StrictMode;
exports.Suspense = Suspense;
exports.isAsyncMode = isAsyncMode;
exports.isConcurrentMode = isConcurrentMode;
exports.isContextConsumer = isContextConsumer;
exports.isContextProvider = isContextProvider;
exports.isElement = isElement;
exports.isForwardRef = isForwardRef;
exports.isFragment = isFragment;
exports.isLazy = isLazy;
exports.isMemo = isMemo;
exports.isPortal = isPortal;
exports.isProfiler = isProfiler;
exports.isStrictMode = isStrictMode;
exports.isSuspense = isSuspense;
exports.isValidElementType = isValidElementType;
exports.typeOf = typeOf;
  })();
}


/***/ }),

/***/ "../../../node_modules/.pnpm/react-is@16.13.1/node_modules/react-is/index.js":
/*!***********************************************************************************!*\
  !*** ../../../node_modules/.pnpm/react-is@16.13.1/node_modules/react-is/index.js ***!
  \***********************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


if (false) {} else {
  module.exports = __webpack_require__(/*! ./cjs/react-is.development.js */ "../../../node_modules/.pnpm/react-is@16.13.1/node_modules/react-is/cjs/react-is.development.js");
}


/***/ }),

/***/ "../../../node_modules/.pnpm/tannin@1.2.0/node_modules/tannin/index.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/.pnpm/tannin@1.2.0/node_modules/tannin/index.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ Tannin; }
/* harmony export */ });
/* harmony import */ var _tannin_plural_forms__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tannin/plural-forms */ "../../../node_modules/.pnpm/@tannin+plural-forms@1.1.0/node_modules/@tannin/plural-forms/index.js");


/**
 * Tannin constructor options.
 *
 * @typedef {Object} TanninOptions
 *
 * @property {string}   [contextDelimiter] Joiner in string lookup with context.
 * @property {Function} [onMissingKey]     Callback to invoke when key missing.
 */

/**
 * Domain metadata.
 *
 * @typedef {Object} TanninDomainMetadata
 *
 * @property {string}            [domain]       Domain name.
 * @property {string}            [lang]         Language code.
 * @property {(string|Function)} [plural_forms] Plural forms expression or
 *                                              function evaluator.
 */

/**
 * Domain translation pair respectively representing the singular and plural
 * translation.
 *
 * @typedef {[string,string]} TanninTranslation
 */

/**
 * Locale data domain. The key is used as reference for lookup, the value an
 * array of two string entries respectively representing the singular and plural
 * translation.
 *
 * @typedef {{[key:string]:TanninDomainMetadata|TanninTranslation,'':TanninDomainMetadata|TanninTranslation}} TanninLocaleDomain
 */

/**
 * Jed-formatted locale data.
 *
 * @see http://messageformat.github.io/Jed/
 *
 * @typedef {{[domain:string]:TanninLocaleDomain}} TanninLocaleData
 */

/**
 * Default Tannin constructor options.
 *
 * @type {TanninOptions}
 */
var DEFAULT_OPTIONS = {
	contextDelimiter: '\u0004',
	onMissingKey: null,
};

/**
 * Given a specific locale data's config `plural_forms` value, returns the
 * expression.
 *
 * @example
 *
 * ```
 * getPluralExpression( 'nplurals=2; plural=(n != 1);' ) === '(n != 1)'
 * ```
 *
 * @param {string} pf Locale data plural forms.
 *
 * @return {string} Plural forms expression.
 */
function getPluralExpression( pf ) {
	var parts, i, part;

	parts = pf.split( ';' );

	for ( i = 0; i < parts.length; i++ ) {
		part = parts[ i ].trim();
		if ( part.indexOf( 'plural=' ) === 0 ) {
			return part.substr( 7 );
		}
	}
}

/**
 * Tannin constructor.
 *
 * @class
 *
 * @param {TanninLocaleData} data      Jed-formatted locale data.
 * @param {TanninOptions}    [options] Tannin options.
 */
function Tannin( data, options ) {
	var key;

	/**
	 * Jed-formatted locale data.
	 *
	 * @name Tannin#data
	 * @type {TanninLocaleData}
	 */
	this.data = data;

	/**
	 * Plural forms function cache, keyed by plural forms string.
	 *
	 * @name Tannin#pluralForms
	 * @type {Object<string,Function>}
	 */
	this.pluralForms = {};

	/**
	 * Effective options for instance, including defaults.
	 *
	 * @name Tannin#options
	 * @type {TanninOptions}
	 */
	this.options = {};

	for ( key in DEFAULT_OPTIONS ) {
		this.options[ key ] = options !== undefined && key in options
			? options[ key ]
			: DEFAULT_OPTIONS[ key ];
	}
}

/**
 * Returns the plural form index for the given domain and value.
 *
 * @param {string} domain Domain on which to calculate plural form.
 * @param {number} n      Value for which plural form is to be calculated.
 *
 * @return {number} Plural form index.
 */
Tannin.prototype.getPluralForm = function( domain, n ) {
	var getPluralForm = this.pluralForms[ domain ],
		config, plural, pf;

	if ( ! getPluralForm ) {
		config = this.data[ domain ][ '' ];

		pf = (
			config[ 'Plural-Forms' ] ||
			config[ 'plural-forms' ] ||
			// Ignore reason: As known, there's no way to document the empty
			// string property on a key to guarantee this as metadata.
			// @ts-ignore
			config.plural_forms
		);

		if ( typeof pf !== 'function' ) {
			plural = getPluralExpression(
				config[ 'Plural-Forms' ] ||
				config[ 'plural-forms' ] ||
				// Ignore reason: As known, there's no way to document the empty
				// string property on a key to guarantee this as metadata.
				// @ts-ignore
				config.plural_forms
			);

			pf = (0,_tannin_plural_forms__WEBPACK_IMPORTED_MODULE_0__["default"])( plural );
		}

		getPluralForm = this.pluralForms[ domain ] = pf;
	}

	return getPluralForm( n );
};

/**
 * Translate a string.
 *
 * @param {string}      domain   Translation domain.
 * @param {string|void} context  Context distinguishing terms of the same name.
 * @param {string}      singular Primary key for translation lookup.
 * @param {string=}     plural   Fallback value used for non-zero plural
 *                               form index.
 * @param {number=}     n        Value to use in calculating plural form.
 *
 * @return {string} Translated string.
 */
Tannin.prototype.dcnpgettext = function( domain, context, singular, plural, n ) {
	var index, key, entry;

	if ( n === undefined ) {
		// Default to singular.
		index = 0;
	} else {
		// Find index by evaluating plural form for value.
		index = this.getPluralForm( domain, n );
	}

	key = singular;

	// If provided, context is prepended to key with delimiter.
	if ( context ) {
		key = context + this.options.contextDelimiter + singular;
	}

	entry = this.data[ domain ][ key ];

	// Verify not only that entry exists, but that the intended index is within
	// range and non-empty.
	if ( entry && entry[ index ] ) {
		return entry[ index ];
	}

	if ( this.options.onMissingKey ) {
		this.options.onMissingKey( singular, domain );
	}

	// If entry not found, fall back to singular vs. plural with zero index
	// representing the singular value.
	return index === 0 ? singular : plural;
};


/***/ }),

/***/ "../../js-packages/analytics/index.jsx":
/*!*********************************************!*\
  !*** ../../js-packages/analytics/index.jsx ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var debug__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! debug */ "../../../node_modules/.pnpm/debug@4.3.2/node_modules/debug/src/browser.js");
/* harmony import */ var debug__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(debug__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/**
 * External dependencies
 */


const debug = debug__WEBPACK_IMPORTED_MODULE_0___default()('dops:analytics');

let _superProps, _user; // Load tracking scripts


window._tkq = window._tkq || [];

window.ga = window.ga || function () {
  (window.ga.q = window.ga.q || []).push(arguments);
};

window.ga.l = +new Date(); // loadScript( '//stats.wp.com/w.js?48' );
// loadScript( '//www.google-analytics.com/analytics.js' );

/**
 * Build a query string
 *
 * @param {string} group - the group
 * @param {string} name - the name
 * @returns {string} - the uricomponent
 */

function buildQuerystring(group, name) {
  let uriComponent = '';

  if ('object' === typeof group) {
    for (const key in group) {
      uriComponent += '&x_' + encodeURIComponent(key) + '=' + encodeURIComponent(group[key]);
    }

    debug('Bumping stats %o', group);
  } else {
    uriComponent = '&x_' + encodeURIComponent(group) + '=' + encodeURIComponent(name);
    debug('Bumping stat "%s" in group "%s"', name, group);
  }

  return uriComponent;
}
/**
 * Build a query string with no prefix
 *
 * @param {string} group - the group
 * @param {string} name - the name
 * @returns {string} - the uricomponent
 */


function buildQuerystringNoPrefix(group, name) {
  let uriComponent = '';

  if ('object' === typeof group) {
    for (const key in group) {
      uriComponent += '&' + encodeURIComponent(key) + '=' + encodeURIComponent(group[key]);
    }

    debug('Built stats %o', group);
  } else {
    uriComponent = '&' + encodeURIComponent(group) + '=' + encodeURIComponent(name);
    debug('Built stat "%s" in group "%s"', name, group);
  }

  return uriComponent;
}

const analytics = {
  initialize: function (userId, username, superProps) {
    analytics.setUser(userId, username);
    analytics.setSuperProps(superProps);
    analytics.identifyUser();
  },
  setGoogleAnalyticsEnabled: function (googleAnalyticsEnabled) {
    let googleAnalyticsKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    this.googleAnalyticsEnabled = googleAnalyticsEnabled;
    this.googleAnalyticsKey = googleAnalyticsKey;
  },
  setMcAnalyticsEnabled: function (mcAnalyticsEnabled) {
    this.mcAnalyticsEnabled = mcAnalyticsEnabled;
  },
  setUser: function (userId, username) {
    _user = {
      ID: userId,
      username: username
    };
  },
  setSuperProps: function (superProps) {
    _superProps = superProps;
  },
  mc: {
    bumpStat: function (group, name) {
      const uriComponent = buildQuerystring(group, name); // prints debug info

      if (this.mcAnalyticsEnabled) {
        new Image().src = document.location.protocol + '//pixel.wp.com/g.gif?v=wpcom-no-pv' + uriComponent + '&t=' + Math.random();
      }
    },
    bumpStatWithPageView: function (group, name) {
      // this function is fairly dangerous, as it bumps page views for wpcom and should only be called in very specific cases.
      const uriComponent = buildQuerystringNoPrefix(group, name); // prints debug info

      if (this.mcAnalyticsEnabled) {
        new Image().src = document.location.protocol + '//pixel.wp.com/g.gif?v=wpcom' + uriComponent + '&t=' + Math.random();
      }
    }
  },
  // pageView is a wrapper for pageview events across Tracks and GA
  pageView: {
    record: function (urlPath, pageTitle) {
      analytics.tracks.recordPageView(urlPath);
      analytics.ga.recordPageView(urlPath, pageTitle);
    }
  },
  purchase: {
    record: function (transactionId, itemName, itemId, revenue, price, qty, currency) {
      analytics.ga.recordPurchase(transactionId, itemName, itemId, revenue, price, qty, currency);
    }
  },
  tracks: {
    recordEvent: function (eventName, eventProperties) {
      eventProperties = eventProperties || {};

      if (eventName.indexOf('akismet_') !== 0 && eventName.indexOf('jetpack_') !== 0) {
        debug('- Event name must be prefixed by "akismet_" or "jetpack_"');
        return;
      }

      if (_superProps) {
        debug('- Super Props: %o', _superProps);
        eventProperties = (0,lodash__WEBPACK_IMPORTED_MODULE_1__.assign)(eventProperties, _superProps);
      }

      debug('Record event "%s" called with props %s', eventName, JSON.stringify(eventProperties));

      window._tkq.push(['recordEvent', eventName, eventProperties]);
    },
    recordJetpackClick: function (target) {
      const props = 'object' === typeof target ? target : {
        target: target
      };
      analytics.tracks.recordEvent('jetpack_wpa_click', props);
    },
    recordPageView: function (urlPath) {
      analytics.tracks.recordEvent('akismet_page_view', {
        path: urlPath
      });
    },
    setOptOut: function (isOptingOut) {
      debug('Pushing setOptOut: %o', isOptingOut);

      window._tkq.push(['setOptOut', isOptingOut]);
    }
  },
  // Google Analytics usage and event stat tracking
  ga: {
    initialized: false,
    initialize: function () {
      let parameters = {};

      if (!analytics.ga.initialized) {
        if (_user) {
          parameters = {
            userId: 'u-' + _user.ID
          };
        }

        window.ga('create', this.googleAnalyticsKey, 'auto', parameters);
        analytics.ga.initialized = true;
      }
    },
    recordPageView: function (urlPath, pageTitle) {
      analytics.ga.initialize();
      debug('Recording Page View ~ [URL: ' + urlPath + '] [Title: ' + pageTitle + ']');

      if (this.googleAnalyticsEnabled) {
        // Set the current page so all GA events are attached to it.
        window.ga('set', 'page', urlPath);
        window.ga('send', {
          hitType: 'pageview',
          page: urlPath,
          title: pageTitle
        });
      }
    },
    recordEvent: function (category, action, label, value) {
      analytics.ga.initialize();
      let debugText = 'Recording Event ~ [Category: ' + category + '] [Action: ' + action + ']';

      if ('undefined' !== typeof label) {
        debugText += ' [Option Label: ' + label + ']';
      }

      if ('undefined' !== typeof value) {
        debugText += ' [Option Value: ' + value + ']';
      }

      debug(debugText);

      if (this.googleAnalyticsEnabled) {
        window.ga('send', 'event', category, action, label, value);
      }
    },
    recordPurchase: function (transactionId, itemName, itemId, revenue, price, qty, currency) {
      window.ga('require', 'ecommerce');
      window.ga('ecommerce:addTransaction', {
        id: transactionId,
        // Transaction ID. Required.
        // 'affiliation': 'Acme Clothing',   // Affiliation or store name.
        revenue: revenue,
        // Grand Total.
        // 'tax': '1.29',                     // Tax.
        currency: currency // local currency code.

      });
      window.ga('ecommerce:addItem', {
        id: transactionId,
        // Transaction ID. Required.
        name: itemName,
        // Product name. Required.
        sku: itemId,
        // SKU/code.
        // 'category': 'Party Toys',         // Category or variation.
        price: price,
        // Unit price.
        quantity: qty // Quantity.

      });
      window.ga('ecommerce:send');
    }
  },
  identifyUser: function () {
    // Don't identify the user if we don't have one
    if (_user) {
      window._tkq.push(['identifyUser', _user.ID, _user.username]);
    }
  },
  setProperties: function (properties) {
    window._tkq.push(['setProperties', properties]);
  },
  clearedIdentity: function () {
    window._tkq.push(['clearIdentity']);
  }
};
/* harmony default export */ __webpack_exports__["default"] = (analytics);

/***/ }),

/***/ "../../js-packages/api/index.jsx":
/*!***************************************!*\
  !*** ../../js-packages/api/index.jsx ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JsonParseError": function() { return /* binding */ JsonParseError; },
/* harmony export */   "JsonParseAfterRedirectError": function() { return /* binding */ JsonParseAfterRedirectError; },
/* harmony export */   "Api404Error": function() { return /* binding */ Api404Error; },
/* harmony export */   "Api404AfterRedirectError": function() { return /* binding */ Api404AfterRedirectError; },
/* harmony export */   "FetchNetworkError": function() { return /* binding */ FetchNetworkError; }
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _automattic_jetpack_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @automattic/jetpack-config */ "../../js-packages/config/src/index.js");
/* harmony import */ var _automattic_jetpack_config__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_automattic_jetpack_config__WEBPACK_IMPORTED_MODULE_2__);
/**
 * External dependencies
 */



/**
 * Helps create new custom error classes to better notify upper layers.
 *
 * @param {string} name - the Error name that will be availble in Error.name
 * @returns {Error}      a new custom error class.
 */

function createCustomError(name) {
  class CustomError extends Error {
    constructor() {
      super(...arguments);
      this.name = name;
    }

  }

  return CustomError;
}

const JsonParseError = createCustomError('JsonParseError');
const JsonParseAfterRedirectError = createCustomError('JsonParseAfterRedirectError');
const Api404Error = createCustomError('Api404Error');
const Api404AfterRedirectError = createCustomError('Api404AfterRedirectError');
const FetchNetworkError = createCustomError('FetchNetworkError');
/**
 * Create a Jetpack Rest Api Client
 *
 * @param {string} root - The API root
 * @param {string} nonce - The API Nonce
 */

function JetpackRestApiClient(root, nonce) {
  let apiRoot = root,
      headers = {
    'X-WP-Nonce': nonce
  },
      getParams = {
    credentials: 'same-origin',
    headers
  },
      postParams = {
    method: 'post',
    credentials: 'same-origin',
    headers: (0,lodash__WEBPACK_IMPORTED_MODULE_0__.assign)({}, headers, {
      'Content-type': 'application/json'
    })
  },
      cacheBusterCallback = addCacheBuster;
  const methods = {
    setApiRoot(newRoot) {
      apiRoot = newRoot;
    },

    setApiNonce(newNonce) {
      headers = {
        'X-WP-Nonce': newNonce
      };
      getParams = {
        credentials: 'same-origin',
        headers: headers
      };
      postParams = {
        method: 'post',
        credentials: 'same-origin',
        headers: (0,lodash__WEBPACK_IMPORTED_MODULE_0__.assign)({}, headers, {
          'Content-type': 'application/json'
        })
      };
    },

    setCacheBusterCallback: callback => {
      cacheBusterCallback = callback;
    },
    registerSite: (registrationNonce, redirectUri) => {
      const params = {
        registration_nonce: registrationNonce,
        no_iframe: true
      };

      if ((0,_automattic_jetpack_config__WEBPACK_IMPORTED_MODULE_2__.jetpackConfigHas)('consumer_slug')) {
        params.plugin_slug = (0,_automattic_jetpack_config__WEBPACK_IMPORTED_MODULE_2__.jetpackConfigGet)('consumer_slug');
      }

      if (null !== redirectUri) {
        params.redirect_uri = redirectUri;
      }

      return postRequest(`${apiRoot}jetpack/v4/connection/register`, postParams, {
        body: JSON.stringify(params)
      }).then(checkStatus).then(parseJsonResponse);
    },
    fetchAuthorizationUrl: redirectUri => getRequest((0,_wordpress_url__WEBPACK_IMPORTED_MODULE_1__.addQueryArgs)(`${apiRoot}jetpack/v4/connection/authorize_url`, {
      no_iframe: '1',
      redirect_uri: redirectUri
    }), getParams).then(checkStatus).then(parseJsonResponse),
    fetchSiteConnectionData: () => getRequest(`${apiRoot}jetpack/v4/connection/data`, getParams).then(parseJsonResponse),
    fetchSiteConnectionStatus: () => getRequest(`${apiRoot}jetpack/v4/connection`, getParams).then(parseJsonResponse),
    fetchSiteConnectionTest: () => getRequest(`${apiRoot}jetpack/v4/connection/test`, getParams).then(checkStatus).then(parseJsonResponse),
    fetchUserConnectionData: () => getRequest(`${apiRoot}jetpack/v4/connection/data`, getParams).then(parseJsonResponse),
    fetchUserTrackingSettings: () => getRequest(`${apiRoot}jetpack/v4/tracking/settings`, getParams).then(checkStatus).then(parseJsonResponse),
    updateUserTrackingSettings: newSettings => postRequest(`${apiRoot}jetpack/v4/tracking/settings`, postParams, {
      body: JSON.stringify(newSettings)
    }).then(checkStatus).then(parseJsonResponse),
    disconnectSite: () => postRequest(`${apiRoot}jetpack/v4/connection`, postParams, {
      body: JSON.stringify({
        isActive: false
      })
    }).then(checkStatus).then(parseJsonResponse),
    fetchConnectUrl: () => getRequest(`${apiRoot}jetpack/v4/connection/url`, getParams).then(checkStatus).then(parseJsonResponse),
    unlinkUser: () => postRequest(`${apiRoot}jetpack/v4/connection/user`, postParams, {
      body: JSON.stringify({
        linked: false
      })
    }).then(checkStatus).then(parseJsonResponse),
    reconnect: () => postRequest(`${apiRoot}jetpack/v4/connection/reconnect`, postParams).then(checkStatus).then(parseJsonResponse),
    fetchConnectedPlugins: () => getRequest(`${apiRoot}jetpack/v4/connection/plugins`, getParams).then(checkStatus).then(parseJsonResponse),
    setHasSeenWCConnectionModal: () => postRequest(`${apiRoot}jetpack/v4/seen-wc-connection-modal`, postParams).then(checkStatus).then(parseJsonResponse),
    fetchModules: () => getRequest(`${apiRoot}jetpack/v4/module/all`, getParams).then(checkStatus).then(parseJsonResponse),
    fetchModule: slug => getRequest(`${apiRoot}jetpack/v4/module/${slug}`, getParams).then(checkStatus).then(parseJsonResponse),
    activateModule: slug => postRequest(`${apiRoot}jetpack/v4/module/${slug}/active`, postParams, {
      body: JSON.stringify({
        active: true
      })
    }).then(checkStatus).then(parseJsonResponse),
    deactivateModule: slug => postRequest(`${apiRoot}jetpack/v4/module/${slug}/active`, postParams, {
      body: JSON.stringify({
        active: false
      })
    }),
    updateModuleOptions: (slug, newOptionValues) => postRequest(`${apiRoot}jetpack/v4/module/${slug}`, postParams, {
      body: JSON.stringify(newOptionValues)
    }).then(checkStatus).then(parseJsonResponse),
    updateSettings: newOptionValues => postRequest(`${apiRoot}jetpack/v4/settings`, postParams, {
      body: JSON.stringify(newOptionValues)
    }).then(checkStatus).then(parseJsonResponse),
    getProtectCount: () => getRequest(`${apiRoot}jetpack/v4/module/protect/data`, getParams).then(checkStatus).then(parseJsonResponse),
    resetOptions: options => postRequest(`${apiRoot}jetpack/v4/options/${options}`, postParams, {
      body: JSON.stringify({
        reset: true
      })
    }).then(checkStatus).then(parseJsonResponse),
    activateVaultPress: () => postRequest(`${apiRoot}jetpack/v4/plugins`, postParams, {
      body: JSON.stringify({
        slug: 'vaultpress',
        status: 'active'
      })
    }).then(checkStatus).then(parseJsonResponse),
    getVaultPressData: () => getRequest(`${apiRoot}jetpack/v4/module/vaultpress/data`, getParams).then(checkStatus).then(parseJsonResponse),
    installPlugin: (slug, source) => {
      const props = {
        slug,
        status: 'active'
      };

      if (source) {
        props.source = source;
      }

      return postRequest(`${apiRoot}jetpack/v4/plugins`, postParams, {
        body: JSON.stringify(props)
      }).then(checkStatus).then(parseJsonResponse);
    },
    activateAkismet: () => postRequest(`${apiRoot}jetpack/v4/plugins`, postParams, {
      body: JSON.stringify({
        slug: 'akismet',
        status: 'active'
      })
    }).then(checkStatus).then(parseJsonResponse),
    getAkismetData: () => getRequest(`${apiRoot}jetpack/v4/module/akismet/data`, getParams).then(checkStatus).then(parseJsonResponse),
    checkAkismetKey: () => getRequest(`${apiRoot}jetpack/v4/module/akismet/key/check`, getParams).then(checkStatus).then(parseJsonResponse),
    checkAkismetKeyTyped: apiKey => postRequest(`${apiRoot}jetpack/v4/module/akismet/key/check`, postParams, {
      body: JSON.stringify({
        api_key: apiKey
      })
    }).then(checkStatus).then(parseJsonResponse),
    fetchStatsData: range => getRequest(statsDataUrl(range), getParams).then(checkStatus).then(parseJsonResponse).then(handleStatsResponseError),
    getPluginUpdates: () => getRequest(`${apiRoot}jetpack/v4/updates/plugins`, getParams).then(checkStatus).then(parseJsonResponse),
    getPlans: () => getRequest(`${apiRoot}jetpack/v4/plans`, getParams).then(checkStatus).then(parseJsonResponse),
    fetchSettings: () => getRequest(`${apiRoot}jetpack/v4/settings`, getParams).then(checkStatus).then(parseJsonResponse),
    updateSetting: updatedSetting => postRequest(`${apiRoot}jetpack/v4/settings`, postParams, {
      body: JSON.stringify(updatedSetting)
    }).then(checkStatus).then(parseJsonResponse),
    fetchSiteData: () => getRequest(`${apiRoot}jetpack/v4/site`, getParams).then(checkStatus).then(parseJsonResponse).then(body => JSON.parse(body.data)),
    fetchSiteFeatures: () => getRequest(`${apiRoot}jetpack/v4/site/features`, getParams).then(checkStatus).then(parseJsonResponse).then(body => JSON.parse(body.data)),
    fetchSiteProducts: () => getRequest(`${apiRoot}jetpack/v4/site/products`, getParams).then(checkStatus).then(parseJsonResponse),
    fetchSitePurchases: () => getRequest(`${apiRoot}jetpack/v4/site/purchases`, getParams).then(checkStatus).then(parseJsonResponse).then(body => JSON.parse(body.data)),
    fetchSiteBenefits: () => getRequest(`${apiRoot}jetpack/v4/site/benefits`, getParams).then(checkStatus).then(parseJsonResponse).then(body => JSON.parse(body.data)),
    fetchSetupQuestionnaire: () => getRequest(`${apiRoot}jetpack/v4/setup/questionnaire`, getParams).then(checkStatus).then(parseJsonResponse),
    fetchRecommendationsData: () => getRequest(`${apiRoot}jetpack/v4/recommendations/data`, getParams).then(checkStatus).then(parseJsonResponse),
    fetchRecommendationsProductSuggestions: () => getRequest(`${apiRoot}jetpack/v4/recommendations/product-suggestions`, getParams).then(checkStatus).then(parseJsonResponse),
    fetchRecommendationsUpsell: () => getRequest(`${apiRoot}jetpack/v4/recommendations/upsell`, getParams).then(checkStatus).then(parseJsonResponse),
    saveRecommendationsData: data => postRequest(`${apiRoot}jetpack/v4/recommendations/data`, postParams, {
      body: JSON.stringify({
        data
      })
    }).then(checkStatus),
    fetchProducts: () => getRequest(`${apiRoot}jetpack/v4/products`, getParams).then(checkStatus).then(parseJsonResponse),
    fetchRewindStatus: () => getRequest(`${apiRoot}jetpack/v4/rewind`, getParams).then(checkStatus).then(parseJsonResponse).then(body => JSON.parse(body.data)),
    fetchScanStatus: () => getRequest(`${apiRoot}jetpack/v4/scan`, getParams).then(checkStatus).then(parseJsonResponse).then(body => JSON.parse(body.data)),
    dismissJetpackNotice: notice => postRequest(`${apiRoot}jetpack/v4/notice/${notice}`, postParams, {
      body: JSON.stringify({
        dismissed: true
      })
    }).then(checkStatus).then(parseJsonResponse),
    fetchPluginsData: () => getRequest(`${apiRoot}jetpack/v4/plugins`, getParams).then(checkStatus).then(parseJsonResponse),
    fetchVerifySiteGoogleStatus: keyringId => {
      const request = keyringId !== null ? getRequest(`${apiRoot}jetpack/v4/verify-site/google/${keyringId}`, getParams) : getRequest(`${apiRoot}jetpack/v4/verify-site/google`, getParams);
      return request.then(checkStatus).then(parseJsonResponse);
    },
    verifySiteGoogle: keyringId => postRequest(`${apiRoot}jetpack/v4/verify-site/google`, postParams, {
      body: JSON.stringify({
        keyring_id: keyringId
      })
    }).then(checkStatus).then(parseJsonResponse),
    sendMobileLoginEmail: () => postRequest(`${apiRoot}jetpack/v4/mobile/send-login-email`, postParams).then(checkStatus).then(parseJsonResponse),
    submitSurvey: surveyResponse => postRequest(`${apiRoot}jetpack/v4/marketing/survey`, postParams, {
      body: JSON.stringify(surveyResponse)
    }).then(checkStatus).then(parseJsonResponse),
    saveSetupQuestionnaire: props => postRequest(`${apiRoot}jetpack/v4/setup/questionnaire`, postParams, {
      body: JSON.stringify(props)
    }).then(checkStatus).then(parseJsonResponse),
    updateLicensingError: props => postRequest(`${apiRoot}jetpack/v4/licensing/error`, postParams, {
      body: JSON.stringify(props)
    }).then(checkStatus).then(parseJsonResponse),
    updateLicenseKey: license => postRequest(`${apiRoot}jetpack/v4/licensing/set-license`, postParams, {
      body: JSON.stringify({
        license
      })
    }).then(checkStatus).then(parseJsonResponse),
    getUserLicensesCounts: () => getRequest(`${apiRoot}jetpack/v4/licensing/user/counts`, getParams).then(checkStatus).then(parseJsonResponse),
    updateLicensingActivationNoticeDismiss: lastDetachedCount => postRequest(`${apiRoot}jetpack/v4/licensing/user/activation-notice-dismiss`, postParams, {
      body: JSON.stringify({
        last_detached_count: lastDetachedCount
      })
    }).then(checkStatus).then(parseJsonResponse),
    updateRecommendationsStep: step => postRequest(`${apiRoot}jetpack/v4/recommendations/step`, postParams, {
      body: JSON.stringify({
        step
      })
    }).then(checkStatus),
    confirmIDCSafeMode: () => postRequest(`${apiRoot}jetpack/v4/identity-crisis/confirm-safe-mode`, postParams).then(checkStatus),
    startIDCFresh: redirectUri => postRequest(`${apiRoot}jetpack/v4/identity-crisis/start-fresh`, postParams, {
      body: JSON.stringify({
        redirect_uri: redirectUri
      })
    }).then(checkStatus).then(parseJsonResponse),
    migrateIDC: () => postRequest(`${apiRoot}jetpack/v4/identity-crisis/migrate`, postParams).then(checkStatus),
    attachLicenses: licenses => postRequest(`${apiRoot}jetpack/v4/licensing/attach-licenses`, postParams, {
      body: JSON.stringify({
        licenses
      })
    }).then(checkStatus).then(parseJsonResponse),
    fetchSearchPlanInfo: () => getRequest(`${apiRoot}jetpack/v4/search/plan`, getParams).then(checkStatus).then(parseJsonResponse),
    fetchSearchSettings: () => getRequest(`${apiRoot}jetpack/v4/search/settings`, getParams).then(checkStatus).then(parseJsonResponse),
    updateSearchSettings: newSettings => postRequest(`${apiRoot}jetpack/v4/search/settings`, postParams, {
      body: JSON.stringify(newSettings)
    }).then(checkStatus).then(parseJsonResponse)
  };
  /**
   * The default callback to add a cachebuster parameter to route
   *
   * @param {string} route - the route
   * @returns {string} - the route with the cachebuster appended
   */

  function addCacheBuster(route) {
    const parts = route.split('?'),
          query = parts.length > 1 ? parts[1] : '',
          args = query.length ? query.split('&') : [];
    args.push('_cacheBuster=' + new Date().getTime());
    return parts[0] + '?' + args.join('&');
  }
  /**
   * Generate a request promise for the route and params. Automatically adds a cachebuster.
   *
   * @param {string} route - the route
   * @param {object} params - the params
   * @returns {Promise<Response>} - the http request promise
   */


  function getRequest(route, params) {
    return fetch(cacheBusterCallback(route), params);
  }
  /**
   * Generate a POST request promise for the route and params. Automatically adds a cachebuster.
   *
   * @param {string} route - the route
   * @param {object} params - the params
   * @param {string} body - the body
   * @returns {Promise<Response>} - the http response promise
   */


  function postRequest(route, params, body) {
    return fetch(route, (0,lodash__WEBPACK_IMPORTED_MODULE_0__.assign)({}, params, body)).catch(catchNetworkErrors);
  }
  /**
   * Returns the stats data URL for the given date range
   *
   * @param {string} range - the range
   * @returns {string} - the stats URL
   */


  function statsDataUrl(range) {
    let url = `${apiRoot}jetpack/v4/module/stats/data`;

    if (url.indexOf('?') !== -1) {
      url = url + `&range=${encodeURIComponent(range)}`;
    } else {
      url = url + `?range=${encodeURIComponent(range)}`;
    }

    return url;
  }
  /**
   * Returns stats data if possible, otherwise an empty object
   *
   * @param {object} statsData - the stats data or error
   * @returns {object} - the handled stats data
   */


  function handleStatsResponseError(statsData) {
    // If we get a .response property, it means that .com's response is errory.
    // Probably because the site does not have stats yet.
    const responseOk = statsData.general && statsData.general.response === undefined || statsData.week && statsData.week.response === undefined || statsData.month && statsData.month.response === undefined;
    return responseOk ? statsData : {};
  }

  (0,lodash__WEBPACK_IMPORTED_MODULE_0__.assign)(this, methods);
}

const restApi = new JetpackRestApiClient();
/* harmony default export */ __webpack_exports__["default"] = (restApi);
/**
 * Check the status of the response. Throw an error if it was not OK
 *
 * @param {Response} response - the API response
 * @returns {Promise<object>} - a promise to return the parsed JSON body as an object
 */

function checkStatus(response) {
  // Regular success responses
  if (response.status >= 200 && response.status < 300) {
    return response;
  }

  if (response.status === 404) {
    return new Promise(() => {
      const err = response.redirected ? new Api404AfterRedirectError(response.redirected) : new Api404Error();
      throw err;
    });
  }

  return response.json().catch(e => catchJsonParseError(e)).then(json => {
    const error = new Error(`${json.message} (Status ${response.status})`);
    error.response = json;
    error.name = 'ApiError';
    throw error;
  });
}
/**
 * Parse the JSON response
 *
 * @param {Response} response - the response object
 * @returns {Promise<object>} - promise to return the parsed json object
 */


function parseJsonResponse(response) {
  return response.json().catch(e => catchJsonParseError(e, response.redirected, response.url));
}
/**
 * Throw appropriate exception given an API error
 *
 * @param {Error} e - the error
 * @param {boolean} redirected - are we being redirected?
 * @param {string} url - the URL that returned the error
 */


function catchJsonParseError(e, redirected, url) {
  const err = redirected ? new JsonParseAfterRedirectError(url) : new JsonParseError();
  throw err;
}
/**
 * Catches TypeError coming from the Fetch API implementation
 */


function catchNetworkErrors() {
  //Either one of:
  // * A preflight error like a redirection to an external site (which results in a CORS)
  // * A preflight error like ERR_TOO_MANY_REDIRECTS
  throw new FetchNetworkError();
}

/***/ }),

/***/ "../../js-packages/components/components/action-button/index.jsx":
/*!***********************************************************************!*\
  !*** ../../js-packages/components/components/action-button/index.jsx ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/components/components/action-button/style.scss");
/* harmony import */ var _spinner__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../spinner */ "../../js-packages/components/components/spinner/index.jsx");
/**
 * External dependencies
 */


const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__;


/**
 * Internal dependencies
 */



/**
 * The Jetpack Action button.
 *
 * This component extends the regular `Button` component and adds a `isLoading` prop that will disable and display a spinner, giving the user the feedback that some action is happening. It also provides a generic error message.
 *
 * It is useful to async actions when the user has to wait the result of a request or process.
 *
 * @param {object} props - The properties.
 * @returns {React.Component} The `ActionButton` component.
 */

const ActionButton = props => {
  const {
    label,
    onClick,
    isLoading,
    displayError,
    errorMessage
  } = props;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-action-button"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    className: "jp-action-button--button",
    label: label,
    onClick: onClick,
    isPrimary: true,
    disabled: isLoading
  }, isLoading ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_spinner__WEBPACK_IMPORTED_MODULE_5__["default"], null) : label), displayError && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
    className: "jp-action-button__error"
  }, errorMessage));
};

ActionButton.propTypes = {
  /** The button label. */
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string.isRequired),

  /** The callback to be called on click. */
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),

  /** Will disable the button and display a spinner if set to true. */
  isLoading: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),

  /** Displays an error message */
  displayError: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),

  /** The error message string */
  errorMessage: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
ActionButton.defaultProps = {
  isLoading: false,
  displayError: false,
  errorMessage: __('An error occurred. Please try again.', 'jetpack')
};
/* harmony default export */ __webpack_exports__["default"] = (ActionButton);

/***/ }),

/***/ "../../js-packages/components/components/decorative-card/index.jsx":
/*!*************************************************************************!*\
  !*** ../../js-packages/components/components/decorative-card/index.jsx ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/components/components/decorative-card/style.scss");
/**
 * External Dependencies
 */


/**
 * Internal Dependencies
 */


/**
 * A decorative card used in the disconnection flow.
 *
 * @param {object} props - The properties.
 * @returns {React.Component} - The DecorativeCard component.
 */

const DecorativeCard = props => {
  const {
    format,
    icon,
    imageUrl
  } = props;

  const renderIcon = () => {
    if (icon) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "jp-components__decorative-card__icon-container"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
        className: 'jp-components__decorative-card__icon jp-components__decorative-card__icon--' + icon
      }));
    }
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: 'jp-components__decorative-card ' + (format ? 'jp-components__decorative-card--' + format : '')
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__decorative-card__image",
    style: {
      backgroundImage: imageUrl ? `url( ${imageUrl} )` : ''
    }
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__decorative-card__content"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__decorative-card__lines"
  })), renderIcon());
};

DecorativeCard.propTypes = {
  /** The format of the card (horizontal or vertical) */
  format: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['horizontal', 'vertical']),

  /** An icon slug that can be used to show an icon (options are limited to what is in the stylesheet) */
  icon: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['unlink']),

  /** URL for an image to show in the card. */
  imageUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};
DecorativeCard.defaultProps = {
  format: 'horizontal'
};
/* harmony default export */ __webpack_exports__["default"] = (DecorativeCard);

/***/ }),

/***/ "../../js-packages/components/components/jetpack-logo/index.jsx":
/*!**********************************************************************!*\
  !*** ../../js-packages/components/components/jetpack-logo/index.jsx ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_extends_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/extends.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/extends.js");
/* harmony import */ var _home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_extends_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_extends_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/defineProperty.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/defineProperty.js");
/* harmony import */ var _home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! classnames */ "../../../node_modules/.pnpm/classnames@2.3.1/node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__);



/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__;

class JetpackLogo extends (react__WEBPACK_IMPORTED_MODULE_3___default().Component) {
  render() {
    const {
      logoColor,
      showText,
      className,
      ...otherProps
    } = this.props;
    const viewBox = showText ? '0 0 118 32' : '0 0 32 32';
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("svg", _home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_extends_js__WEBPACK_IMPORTED_MODULE_0___default()({
      xmlns: "http://www.w3.org/2000/svg",
      x: "0px",
      y: "0px",
      viewBox: viewBox,
      className: classnames__WEBPACK_IMPORTED_MODULE_4___default()('jetpack-logo', className),
      "aria-labelledby": "jetpack-logo-title"
    }, otherProps), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("title", {
      id: "jetpack-logo-title"
    }, __('Jetpack Logo', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("path", {
      fill: logoColor,
      d: "M16,0C7.2,0,0,7.2,0,16s7.2,16,16,16s16-7.2,16-16S24.8,0,16,0z M15,19H7l8-16V19z M17,29V13h8L17,29z"
    }), showText && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(react__WEBPACK_IMPORTED_MODULE_3__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("path", {
      d: "M41.3,26.6c-0.5-0.7-0.9-1.4-1.3-2.1c2.3-1.4,3-2.5,3-4.6V8h-3V6h6v13.4C46,22.8,45,24.8,41.3,26.6z"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("path", {
      d: "M65,18.4c0,1.1,0.8,1.3,1.4,1.3c0.5,0,2-0.2,2.6-0.4v2.1c-0.9,0.3-2.5,0.5-3.7,0.5c-1.5,0-3.2-0.5-3.2-3.1V12H60v-2h2.1V7.1 H65V10h4v2h-4V18.4z"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("path", {
      d: "M71,10h3v1.3c1.1-0.8,1.9-1.3,3.3-1.3c2.5,0,4.5,1.8,4.5,5.6s-2.2,6.3-5.8,6.3c-0.9,0-1.3-0.1-2-0.3V28h-3V10z M76.5,12.3 c-0.8,0-1.6,0.4-2.5,1.2v5.9c0.6,0.1,0.9,0.2,1.8,0.2c2,0,3.2-1.3,3.2-3.9C79,13.4,78.1,12.3,76.5,12.3z"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("path", {
      d: "M93,22h-3v-1.5c-0.9,0.7-1.9,1.5-3.5,1.5c-1.5,0-3.1-1.1-3.1-3.2c0-2.9,2.5-3.4,4.2-3.7l2.4-0.3v-0.3c0-1.5-0.5-2.3-2-2.3 c-0.7,0-2.3,0.5-3.7,1.1L84,11c1.2-0.4,3-1,4.4-1c2.7,0,4.6,1.4,4.6,4.7L93,22z M90,16.4l-2.2,0.4c-0.7,0.1-1.4,0.5-1.4,1.6 c0,0.9,0.5,1.4,1.3,1.4s1.5-0.5,2.3-1V16.4z"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("path", {
      d: "M104.5,21.3c-1.1,0.4-2.2,0.6-3.5,0.6c-4.2,0-5.9-2.4-5.9-5.9c0-3.7,2.3-6,6.1-6c1.4,0,2.3,0.2,3.2,0.5V13 c-0.8-0.3-2-0.6-3.2-0.6c-1.7,0-3.2,0.9-3.2,3.6c0,2.9,1.5,3.8,3.3,3.8c0.9,0,1.9-0.2,3.2-0.7V21.3z"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("path", {
      d: "M110,15.2c0.2-0.3,0.2-0.8,3.8-5.2h3.7l-4.6,5.7l5,6.3h-3.7l-4.2-5.8V22h-3V6h3V15.2z"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("path", {
      d: "M58.5,21.3c-1.5,0.5-2.7,0.6-4.2,0.6c-3.6,0-5.8-1.8-5.8-6c0-3.1,1.9-5.9,5.5-5.9s4.9,2.5,4.9,4.9c0,0.8,0,1.5-0.1,2h-7.3 c0.1,2.5,1.5,2.8,3.6,2.8c1.1,0,2.2-0.3,3.4-0.7C58.5,19,58.5,21.3,58.5,21.3z M56,15c0-1.4-0.5-2.9-2-2.9c-1.4,0-2.3,1.3-2.4,2.9 C51.6,15,56,15,56,15z"
    })));
  }

}

_home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_1___default()(JetpackLogo, "propTypes", {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  showText: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  logoColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string)
});

_home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_1___default()(JetpackLogo, "defaultProps", {
  className: '',
  height: 32,
  showText: true,
  logoColor: '#069e08'
});

/* harmony default export */ __webpack_exports__["default"] = (JetpackLogo);

/***/ }),

/***/ "../../js-packages/components/components/pricing-card/index.jsx":
/*!**********************************************************************!*\
  !*** ../../js-packages/components/components/pricing-card/index.jsx ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _automattic_format_currency__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @automattic/format-currency */ "../../../node_modules/.pnpm/@automattic+format-currency@1.0.0-alpha.0/node_modules/@automattic/format-currency/dist/esm/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/components/components/pricing-card/style.scss");
/**
 * External dependencies
 */





/**
 * Internal dependencies
 */

const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__;

/**
 * Whether or not to display a price's decimal part in the UI.
 * Needed as `getCurrencyObject` will always return the decimal part populated even if it
 * doesn't exist.
 *
 * @param {object} currencyObject -- A currency object returned from `getCurrencyObject`.
 * @returns {boolean} Whether or not to display the price decimal part.
 */

const showPriceDecimals = currencyObject => {
  return currencyObject.fraction.indexOf('00') === -1;
};
/**
 * The Pricing card component.
 *
 * @param {object} props -- The properties.
 * @returns {React.Component} The `PricingCard` component.
 */


const PricingCard = props => {
  const currencyObjectBefore = (0,_automattic_format_currency__WEBPACK_IMPORTED_MODULE_5__.getCurrencyObject)(props.priceBefore, props.currencyCode);
  const currencyObjectAfter = (0,_automattic_format_currency__WEBPACK_IMPORTED_MODULE_5__.getCurrencyObject)(props.priceAfter, props.currencyCode);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__pricing-card"
  }, props.icon && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__pricing-card__icon"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", {
    src: props.icon,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.sprintf)(
    /* translators: placeholder is a product name */
    __('Icon for the product %s', 'jetpack'), props.title)
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", {
    className: "jp-components__pricing-card__title"
  }, props.title), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__pricing-card__pricing"
  }, props.priceBefore !== props.priceAfter && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__pricing-card__price-before"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "jp-components__pricing-card__currency"
  }, currencyObjectBefore.symbol), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "jp-components__pricing-card__price"
  }, currencyObjectBefore.integer), showPriceDecimals(currencyObjectBefore) && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "jp-components__pricing-card__price-decimal"
  }, ' ', currencyObjectBefore.fraction), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__pricing-card__price-strikethrough"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__pricing-card__price-after"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "jp-components__pricing-card__currency"
  }, currencyObjectAfter.symbol), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "jp-components__pricing-card__price"
  }, currencyObjectAfter.integer), showPriceDecimals(currencyObjectAfter) && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "jp-components__pricing-card__price-decimal"
  }, currencyObjectAfter.fraction)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "jp-components__pricing-card__price-details"
  }, props.priceDetails)), props.children && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__pricing-card__extra-content-wrapper"
  }, props.children), props.ctaText && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__pricing-card__cta"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    className: "jp-components__pricing-card__button",
    label: props.ctaText,
    onClick: props.onCtaClick
  }, props.ctaText)), props.infoText && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components__pricing-card__info"
  }, props.infoText));
};

PricingCard.propTypes = {
  /** The Title. */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** The Icon. */
  icon: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** Price before discount. */
  priceBefore: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /** Price after discount. */
  priceAfter: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /** Price details. */
  priceDetails: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** The Currency code, eg 'USD'. */
  currencyCode: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** The CTA copy. */
  ctaText: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** The CTA callback to be called on click. */
  onCtaClick: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),

  /** Optional informative text. */
  infoText: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object)])
};
PricingCard.defaultProps = {
  currencyCode: 'USD',
  priceDetails: __('/month, paid yearly', 'jetpack')
};
/* harmony default export */ __webpack_exports__["default"] = (PricingCard);

/***/ }),

/***/ "../../js-packages/components/components/spinner/index.jsx":
/*!*****************************************************************!*\
  !*** ../../js-packages/components/components/spinner/index.jsx ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/components/components/spinner/style.scss");
/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



const Spinner = props => {
  const className = props.className + ' jp-components-spinner';
  const styleOuter = {
    width: props.size,
    height: props.size,
    fontSize: props.size,
    // allows border-width to be specified in em units
    borderTopColor: props.color
  };
  const styleInner = {
    borderTopColor: props.color,
    borderRightColor: props.color
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: className
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components-spinner__outer",
    style: styleOuter
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-components-spinner__inner",
    style: styleInner
  })));
};

Spinner.propTypes = {
  /** The spinner color. */
  color: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** CSS class names. */
  className: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** The spinner size. */
  size: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};
Spinner.defaultProps = {
  color: '#FFFFFF',
  className: '',
  size: 20
};
/* harmony default export */ __webpack_exports__["default"] = (Spinner);

/***/ }),

/***/ "../../js-packages/components/tools/jp-redirect/index.jsx":
/*!****************************************************************!*\
  !*** ../../js-packages/components/tools/jp-redirect/index.jsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ getRedirectUrl; }
/* harmony export */ });
/* global jetpack_redirects */

/**
 * Builds an URL using the jetpack.com/redirect/ service
 *
 * If source is a simple slug, it will be sent using the source query parameter. e.g. jetpack.com/redirect/?source=slug
 *
 * If source is a full URL, starting with https://, it will be sent using the url query parameter. e.g. jetpack.com/redirect/?url=https://wordpress.com
 *
 * Note: if using full URL, query parameters and anchor must be passed in args. Any querystring of url fragment in the URL will be discarded.
 *
 * @since 0.2.0
 * @param {string} source - The URL handler registered in the server or the full destination URL (starting with https://).
 * @param {object} args - Additional arguments to build the url.  This is not a complete list as any argument passed here will be sent to as a query parameter to the Redirect server. These parameters will not necessarily be passed over to the final destination URL. If you want to add a parameter to the final destination URL, use the `query` argument.
 * @param {string} args.site - URL of the current site. Will default to the value of jetpack_redirects.currentSiteRawUrl, if available. Used to fill in the `[site]` placeholder in the target.
 * @param {string} args.path - Additional path to be appended to the URL. Used to fill in the `[path]` placeholder in the target.
 * @param {string} args.query - Query parameters to be added to the final destination URL. should be in query string format (e.g. 'key=value&foo=bar').
 * @param {string} args.anchor - Anchor to be added to the URL. Must be a single string. Example: `section1`.
 * @returns {string} The redirect URL
 */
function getRedirectUrl(source) {
  let args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const queryVars = {};
  let calypsoEnv;

  if (typeof window !== 'undefined') {
    var _window$Initial_State;

    calypsoEnv = (_window$Initial_State = window.Initial_State) === null || _window$Initial_State === void 0 ? void 0 : _window$Initial_State.calypsoEnv;
  }

  if (source.search('https://') === 0) {
    const parsedUrl = new URL(source); // discard any query and fragments.

    source = `https://${parsedUrl.host}${parsedUrl.pathname}`;
    queryVars.url = encodeURIComponent(source);
  } else {
    queryVars.source = encodeURIComponent(source);
  }

  Object.keys(args).map(argName => {
    queryVars[argName] = encodeURIComponent(args[argName]);
  });

  if (!Object.keys(queryVars).includes('site') && typeof jetpack_redirects !== 'undefined' && jetpack_redirects.hasOwnProperty('currentSiteRawUrl')) {
    queryVars.site = jetpack_redirects.currentSiteRawUrl;
  }

  if (calypsoEnv) {
    queryVars.calypso_env = calypsoEnv;
  }

  const queryString = Object.keys(queryVars).map(key => key + '=' + queryVars[key]).join('&');
  return `https://jetpack.com/redirect/?` + queryString;
}

/***/ }),

/***/ "../../js-packages/config/src/index.js":
/*!*********************************************!*\
  !*** ../../js-packages/config/src/index.js ***!
  \*********************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/* eslint-disable no-console */
let jetpackConfig = {};

try {
  // Using require allows us to catch the error and provide guidance to developers, as well as test the package.
  jetpackConfig = __webpack_require__(Object(function webpackMissingModule() { var e = new Error("Cannot find module 'jetpackConfig'"); e.code = 'MODULE_NOT_FOUND'; throw e; }()));
} catch {
  console.error('jetpackConfig is missing in your webpack config file. See @automattic/jetpack-config');
  jetpackConfig = {
    missingConfig: true
  };
}

const jetpackConfigHas = key => {
  return jetpackConfig.hasOwnProperty(key);
};

const jetpackConfigGet = key => {
  if (!jetpackConfigHas(key)) {
    throw 'This app requires the "' + key + '" Jetpack Config to be defined in your webpack configuration file. See details in @automattic/jetpack-config package docs.';
  }

  return jetpackConfig[key];
}; // Note: For this cjs module to be used with named exports in an mjs context, modules.exports
// needs to contain only simple variables like `a` or `a: b`. Define anything more complex
// as a variable above, then use the variable here.
// @see https://github.com/nodejs/node/blob/master/deps/cjs-module-lexer/README.md#exports-object-assignment


module.exports = {
  jetpackConfigHas,
  jetpackConfigGet
};

/***/ }),

/***/ "../../js-packages/connection/components/connect-button/index.jsx":
/*!************************************************************************!*\
  !*** ../../js-packages/connection/components/connect-button/index.jsx ***!
  \************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/components/action-button/index.jsx");
/* harmony import */ var _connect_user__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../connect-user */ "../../js-packages/connection/components/connect-user/index.jsx");
/* harmony import */ var _state_store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../state/store */ "../../js-packages/connection/state/store.jsx");
/**
 * External dependencies
 */




const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__;


/**
 * Internal dependencies
 */



/**
 * The RNA connection component.
 *
 * @param {object} props -- The properties.
 * @returns {React.Component} The RNA connection component.
 */

const ConnectButton = props => {
  const {
    isRegistered,
    isUserConnected
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_state_store__WEBPACK_IMPORTED_MODULE_5__.STORE_ID).getConnectionStatus(), []);
  const siteIsRegistering = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_state_store__WEBPACK_IMPORTED_MODULE_5__.STORE_ID).getSiteIsRegistering(), []);
  const userIsConnecting = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_state_store__WEBPACK_IMPORTED_MODULE_5__.STORE_ID).getUserIsConnecting(), []);
  const registrationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_state_store__WEBPACK_IMPORTED_MODULE_5__.STORE_ID).getRegistrationError(), []);
  const authorizationUrl = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_state_store__WEBPACK_IMPORTED_MODULE_5__.STORE_ID).getAuthorizationUrl(), []);
  const {
    setUserIsConnecting,
    registerSite
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_state_store__WEBPACK_IMPORTED_MODULE_5__.STORE_ID);
  const {
    apiRoot,
    apiNonce,
    connectLabel,
    registrationNonce,
    redirectUri,
    from,
    autoTrigger
  } = props;
  /**
   * Initialize the REST API.
   */

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__["default"].setApiRoot(apiRoot);
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__["default"].setApiNonce(apiNonce);
  }, [apiRoot, apiNonce]);
  /**
   * Initialize the site registration process.
   */

  const handleRegisterSite = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    e && e.preventDefault();

    if (isRegistered) {
      setUserIsConnecting(true);
      return;
    }

    registerSite(registrationNonce, redirectUri);
  }, [isRegistered, registrationNonce, redirectUri, registerSite, setUserIsConnecting]);
  /**
   * Auto-trigger the flow, only do it once.
   */

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (autoTrigger && !siteIsRegistering && !userIsConnecting) {
      handleRegisterSite();
    }
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, (!isRegistered || !isUserConnected) && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_6__["default"], {
    label: connectLabel,
    onClick: handleRegisterSite,
    displayError: registrationError ? true : false,
    isLoading: siteIsRegistering || userIsConnecting
  }), userIsConnecting && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_connect_user__WEBPACK_IMPORTED_MODULE_7__["default"], {
    connectUrl: authorizationUrl,
    redirectUri: redirectUri,
    from: from
  }));
};

ConnectButton.propTypes = {
  /** The "Connect" button label. */
  connectLabel: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** API root URL. */
  apiRoot: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** API Nonce. */
  apiNonce: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** Where the connection request is coming from. */
  from: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** The redirect admin URI. */
  redirectUri: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** Registration nonce. */
  registrationNonce: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** Whether to initiate the connection process automatically upon rendering the component. */
  autoTrigger: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
};
ConnectButton.defaultProps = {
  connectLabel: __('Connect', 'jetpack'),
  redirectUri: null,
  autoTrigger: false
};
/* harmony default export */ __webpack_exports__["default"] = (ConnectButton);

/***/ }),

/***/ "../../js-packages/connection/components/connect-screen/layout/image-slider.jsx":
/*!**************************************************************************************!*\
  !*** ../../js-packages/connection/components/connect-screen/layout/image-slider.jsx ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/**
 * External dependencies
 */


/**
 * The ImageSlider component.
 *
 * @param {object} props -- The properties.
 * @param {Array} props.images -- Images to display on the right side.
 * @param {string} props.assetBaseUrl -- The assets base URL
 * @returns {React.Component} The `ImageSlider` component.
 */

const ImageSlider = props => {
  const {
    images,
    assetBaseUrl
  } = props;

  if (!images.length) {
    return null;
  }

  const imagesHTML = images.map((image, index) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), {
    key: index
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", {
    src: assetBaseUrl + image,
    alt: ""
  })));
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__connect-screen__image-slider"
  }, imagesHTML);
};

ImageSlider.propTypes = {
  images: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)).isRequired,
  assetBaseUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};
ImageSlider.defaultProps = {
  assetBaseUrl: ''
};
/* harmony default export */ __webpack_exports__["default"] = (ImageSlider);

/***/ }),

/***/ "../../js-packages/connection/components/connect-screen/layout/index.jsx":
/*!*******************************************************************************!*\
  !*** ../../js-packages/connection/components/connect-screen/layout/index.jsx ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/components/jetpack-logo/index.jsx");
/* harmony import */ var _image_slider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./image-slider */ "../../js-packages/connection/components/connect-screen/layout/image-slider.jsx");
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/connection/components/connect-screen/layout/style.scss");
/**
 * External dependencies
 */



/**
 * Internal dependencies
 */

/**
 * Internal dependencies
 */



/**
 * The Connection Screen Layout component.
 *
 * @param {object} props -- The properties.
 * @returns {React.Component} The `ConnectScreenLayout` component.
 */

const ConnectScreenLayout = props => {
  const {
    title,
    children,
    className,
    assetBaseUrl,
    images
  } = props;
  const showImageSlider = images === null || images === void 0 ? void 0 : images.length;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: 'jp-connection__connect-screen-layout' + (showImageSlider ? ' jp-connection__connect-screen-layout__two-columns' : '') + (className ? ' ' + className : '')
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__connect-screen-layout__left"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_3__["default"], null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, title), children), showImageSlider ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__connect-screen-layout__right"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_image_slider__WEBPACK_IMPORTED_MODULE_4__["default"], {
    images: images,
    assetBaseUrl: assetBaseUrl
  })) : null);
};

ConnectScreenLayout.propTypes = {
  /** The Title. */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** Class to be added to component. */
  className: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** Images to display on the right side. */
  images: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)),

  /** The assets base URL. */
  assetBaseUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};
/* harmony default export */ __webpack_exports__["default"] = (ConnectScreenLayout);

/***/ }),

/***/ "../../js-packages/connection/components/connect-screen/required-plan/index.jsx":
/*!**************************************************************************************!*\
  !*** ../../js-packages/connection/components/connect-screen/required-plan/index.jsx ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _connect_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../connect-button */ "../../js-packages/connection/components/connect-button/index.jsx");
/* harmony import */ var _visual__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./visual */ "../../js-packages/connection/components/connect-screen/required-plan/visual.jsx");
/* harmony import */ var _state_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../state/store */ "../../js-packages/connection/state/store.jsx");
/**
 * External dependencies
 */




/**
 * Internal dependencies
 */

const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__;



/**
 * The Connection Screen Visual component for consumers that require a Plan.
 *
 * @param {object} props -- The properties.
 * @returns {React.Component} The `ConnectScreenForRequiredPlan` component.
 */

const ConnectScreenRequiredPlan = props => {
  const {
    title,
    autoTrigger,
    buttonLabel,
    apiRoot,
    apiNonce,
    registrationNonce,
    from,
    redirectUri,
    children,
    priceBefore,
    priceAfter,
    pricingIcon,
    pricingTitle,
    pricingCurrencyCode
  } = props;
  const connectionStatus = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_state_store__WEBPACK_IMPORTED_MODULE_4__.STORE_ID).getConnectionStatus(), []);
  const renderConnectBtn = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((label, trigger) => {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_connect_button__WEBPACK_IMPORTED_MODULE_5__["default"], {
      autoTrigger: trigger,
      apiRoot: apiRoot,
      apiNonce: apiNonce,
      registrationNonce: registrationNonce,
      from: from,
      redirectUri: redirectUri,
      connectLabel: label
    });
  }, [apiRoot, apiNonce, registrationNonce, from, redirectUri]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_visual__WEBPACK_IMPORTED_MODULE_6__["default"], {
    title: title,
    autoTrigger: autoTrigger,
    buttonLabel: buttonLabel,
    priceBefore: priceBefore,
    priceAfter: priceAfter,
    pricingIcon: pricingIcon,
    pricingTitle: pricingTitle,
    pricingCurrencyCode: pricingCurrencyCode,
    isLoading: !connectionStatus.hasOwnProperty('isRegistered'),
    renderConnectBtn: renderConnectBtn
  }, children);
};

ConnectScreenRequiredPlan.propTypes = {
  /** The Title. */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** The Connect Button label. */
  buttonLabel: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** API root. */
  apiRoot: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** API nonce. */
  apiNonce: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** Registration nonce. */
  registrationNonce: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** Where the connection request is coming from. */
  from: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** The redirect admin URI. */
  redirectUri: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** Whether to initiate the connection process automatically upon rendering the component. */
  autoTrigger: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /** The Pricing Card Title. */
  pricingTitle: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** The Pricing Card Icon. */
  icon: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** Price before discount. */
  priceBefore: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /** Price after discount. */
  priceAfter: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /** The Currency code, eg 'USD'. */
  pricingCurrencyCode: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};
ConnectScreenRequiredPlan.defaultProps = {
  title: __('Over 5 million WordPress sites are faster and more secure', 'jetpack'),
  buttonLabel: __('Set up Jetpack', 'jetpack'),
  pricingCurrencyCode: 'USD',
  autoTrigger: false
};
/* harmony default export */ __webpack_exports__["default"] = (ConnectScreenRequiredPlan);

/***/ }),

/***/ "../../js-packages/connection/components/connect-screen/required-plan/visual.jsx":
/*!***************************************************************************************!*\
  !*** ../../js-packages/connection/components/connect-screen/required-plan/visual.jsx ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/tools/jp-redirect/index.jsx");
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/components/pricing-card/index.jsx");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _layout__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../layout */ "../../js-packages/connection/components/connect-screen/layout/index.jsx");
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/connection/components/connect-screen/required-plan/style.scss");
/**
 * External dependencies
 */



const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__;


/**
 * Internal dependencies
 */



/**
 * The Connection Screen Visual component for consumers that require a Plan.
 *
 * @param {object} props -- The properties.
 * @returns {React.Component} The `ConnectScreenRequiredPlanVisual` component.
 */

const ConnectScreenRequiredPlanVisual = props => {
  const {
    title,
    autoTrigger,
    buttonLabel,
    children,
    priceBefore,
    priceAfter,
    pricingIcon,
    pricingTitle,
    pricingCurrencyCode,
    renderConnectBtn,
    isLoading
  } = props;
  const tos = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.createInterpolateElement)(__('By clicking the button above, you agree to our <tosLink>Terms of Service</tosLink> and to <shareDetailsLink>share details</shareDetailsLink> with WordPress.com.', 'jetpack'), {
    tosLink: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
      href: (0,_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_5__["default"])('wpcom-tos'),
      rel: "noopener noreferrer",
      target: "_blank"
    }),
    shareDetailsLink: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
      href: (0,_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_5__["default"])('jetpack-support-what-data-does-jetpack-sync'),
      rel: "noopener noreferrer",
      target: "_blank"
    })
  });
  const withSubscription = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.createInterpolateElement)(__('Already have a subscription? <connectButton/> to get started.', 'jetpack'), {
    connectButton: renderConnectBtn(__('Log in', 'jetpack'), false)
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_layout__WEBPACK_IMPORTED_MODULE_6__["default"], {
    title: title,
    className: 'jp-connection__connect-screen-required-plan' + (isLoading ? ' jp-connection__connect-screen-required-plan__loading' : '')
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__connect-screen-required-plan__content"
  }, children, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__connect-screen-required-plan__pricing-card"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_7__["default"], {
    title: pricingTitle,
    icon: pricingIcon,
    priceBefore: priceBefore,
    currencyCode: pricingCurrencyCode,
    priceAfter: priceAfter,
    infoText: tos
  }, renderConnectBtn(buttonLabel, autoTrigger))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__connect-screen-required-plan__with-subscription"
  }, withSubscription)));
};

ConnectScreenRequiredPlanVisual.propTypes = {
  /** The Pricing Card Title. */
  pricingTitle: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** Price before discount. */
  priceBefore: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /** Price after discount. */
  priceAfter: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /** The Currency code, eg 'USD'. */
  pricingCurrencyCode: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** The Title. */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** The Connect Button label. */
  buttonLabel: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** Whether to initiate the connection process automatically upon rendering the component. */
  autoTrigger: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /** The Pricing Card Icon. */
  pricingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** Connect button render function */
  renderConnectBtn: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func.isRequired),

  /** Whether the connection status is still loading. */
  isLoading: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool.isRequired)
};
ConnectScreenRequiredPlanVisual.defaultProps = {
  pricingCurrencyCode: 'USD',
  autoTrigger: false
};
/* harmony default export */ __webpack_exports__["default"] = (ConnectScreenRequiredPlanVisual);

/***/ }),

/***/ "../../js-packages/connection/components/connect-user/index.jsx":
/*!**********************************************************************!*\
  !*** ../../js-packages/connection/components/connect-user/index.jsx ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/**
 * External dependencies
 */



/**
 * The user connection component.
 *
 * @param {object} props -- The properties.
 * @param {Function} props.redirectFunc -- The redirect function (`window.location.assign()` by default).
 * @param {string} props.connectUrl -- The authorization URL (no-iframe).
 * @param {string} props.redirectUri -- The redirect admin URI.
 * @param {string} props.from -- Where the connection request is coming from.
 * @returns {null} -- Nothing to return.
 */

const ConnectUser = props => {
  const {
    redirectFunc,
    connectUrl,
    redirectUri,
    from
  } = props;
  const [authorizationUrl, setAuthorizationUrl] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);

  if (connectUrl && connectUrl !== authorizationUrl) {
    setAuthorizationUrl(connectUrl);
  }
  /**
   * Fetch the authorization URL on the first render.
   * To be only run once.
   */


  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!authorizationUrl) {
      _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_2__["default"].fetchAuthorizationUrl(redirectUri).then(response => setAuthorizationUrl(response.authorizeUrl)).catch(error => {
        throw error;
      });
    }
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  if (!authorizationUrl) {
    return null;
  }

  redirectFunc(authorizationUrl + (from ? (authorizationUrl.includes('?') ? '&' : '?') + 'from=' + encodeURIComponent(from) : ''));
  return null;
};

ConnectUser.propTypes = {
  connectUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  redirectUri: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  from: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  redirectFunc: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};
ConnectUser.defaultProps = {
  redirectFunc: url => window.location.assign(url),
  redirectUri: null
};
/* harmony default export */ __webpack_exports__["default"] = (ConnectUser);

/***/ }),

/***/ "../../js-packages/connection/components/connected-plugins/index.jsx":
/*!***************************************************************************!*\
  !*** ../../js-packages/connection/components/connected-plugins/index.jsx ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _disconnect_card__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../disconnect-card */ "../../js-packages/connection/components/disconnect-card/index.jsx");
/**
 * External Dependencies
 */



/**
 * Internal Dependencies
 */

const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__;

/**
 * Render a list of connected plugins.
 *
 * @param {object} props - The properties
 * @returns {React.Component} - The ConnectedPlugins React component
 */

const ConnectedPlugins = props => {
  const {
    connectedPlugins,
    disconnectingPlugin
  } = props;
  /**
   * Add a slug property to each ConnectedPlugins object so they can be converted to an array.
   * This allows the connected plugins to be iterated over more easily for display.
   */

  const connectedPluginsArray = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    if (connectedPlugins) {
      const keys = Object.keys(connectedPlugins);
      return keys.map(key => {
        return Object.assign({
          slug: key
        }, connectedPlugins[key]);
      }).filter(plugin => {
        return disconnectingPlugin !== plugin.slug;
      });
    } // No connected plugins.


    return [];
  }, [connectedPlugins, disconnectingPlugin]);

  if (connectedPlugins && connectedPluginsArray.length > 0) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "jp-connection__disconnect-dialog__step-copy"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
      className: "jp-connection__disconnect-dialog__large-text"
    }, __('Jetpack is powering other plugins on your site. If you disconnect, these plugins will no longer work.', 'jetpack'))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "jp-connection__disconnect-card__group"
    }, connectedPluginsArray.map(plugin => {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_disconnect_card__WEBPACK_IMPORTED_MODULE_3__["default"], {
        title: plugin.name
      });
    })));
  } // Default to null if there are no connected plugins passed on the props


  return null;
};

ConnectedPlugins.PropTypes = {
  /** Plugins that are using the Jetpack connection. */
  connectedPlugins: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /** Slug of the plugin that has initiated the disconnect. */
  disconnectingPlugin: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};
/* harmony default export */ __webpack_exports__["default"] = (ConnectedPlugins);

/***/ }),

/***/ "../../js-packages/connection/components/connection-status-card/index.jsx":
/*!********************************************************************************!*\
  !*** ../../js-packages/connection/components/connection-status-card/index.jsx ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _connect_user__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../connect-user */ "../../js-packages/connection/components/connect-user/index.jsx");
/* harmony import */ var _disconnect_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../disconnect-dialog */ "../../js-packages/connection/components/disconnect-dialog/index.jsx");
/* harmony import */ var _state_store__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../state/store */ "../../js-packages/connection/state/store.jsx");
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/connection/components/connection-status-card/style.scss");
/**
 * External dependencies
 */


const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__;




/**
 * Internal dependencies
 */





/**
 * The RNA Connection Status Card component.
 *
 * @param {object}   props -- The properties.
 * @returns {React.Component} The `ConnectionStatusCard` component.
 */

const ConnectionStatusCard = props => {
  const {
    apiRoot,
    apiNonce,
    isRegistered,
    isUserConnected,
    redirectUri,
    title,
    connectionInfoText,
    onDisconnected,
    connectedPlugins,
    connectedSiteId,
    context
  } = props;
  const [isFetchingConnectionData, setIsFetchingConnectionData] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [connectedUserData, setConnectedUserData] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const [isDisconnectDialogOpen, setIsDisconnectDialogOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const userIsConnecting = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => select(_state_store__WEBPACK_IMPORTED_MODULE_7__.STORE_ID).getUserIsConnecting(), []);
  const {
    setConnectionStatus,
    setUserIsConnecting
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.useDispatch)(_state_store__WEBPACK_IMPORTED_MODULE_7__.STORE_ID);
  const avatarRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  /**
   * Initialize the REST API.
   */

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__["default"].setApiRoot(apiRoot);
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__["default"].setApiNonce(apiNonce);
  }, [apiRoot, apiNonce]);
  /**
   * Fetch the connection data on the first render.
   * To be only run once.
   */

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setIsFetchingConnectionData(true);
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__["default"].fetchSiteConnectionData().then(response => {
      var _response$currentUser, _response$currentUser2, _response$currentUser3;

      setIsFetchingConnectionData(false);
      setConnectedUserData((_response$currentUser = response.currentUser) === null || _response$currentUser === void 0 ? void 0 : _response$currentUser.wpcomUser);
      const avatar = (_response$currentUser2 = response.currentUser) === null || _response$currentUser2 === void 0 ? void 0 : (_response$currentUser3 = _response$currentUser2.wpcomUser) === null || _response$currentUser3 === void 0 ? void 0 : _response$currentUser3.avatar;

      if (avatar) {
        avatarRef.current.style.backgroundImage = `url('${avatar}')`;
      }
    }).catch(error => {
      setIsFetchingConnectionData(false);
      throw error;
    });
  }, [setIsFetchingConnectionData, setConnectedUserData]);
  /**
   * Open the Disconnect Dialog.
   */

  const openDisconnectDialog = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    e && e.preventDefault();
    setIsDisconnectDialogOpen(true);
  }, [setIsDisconnectDialogOpen]);
  /**
   * Close the Disconnect Dialog.
   */

  const closeDisconnectDialog = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    e && e.preventDefault();
    setIsDisconnectDialogOpen(false);
  }, [setIsDisconnectDialogOpen]);
  const onDisconnectedCallback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    e && e.preventDefault();
    setConnectionStatus({
      isActive: false,
      isRegistered: false,
      isUserConnected: false
    });

    if (onDisconnected && {}.toString.call(onDisconnected) === '[object Function]') {
      onDisconnected();
    }
  }, [onDisconnected, setConnectionStatus]); // Prevent component from rendering if site is not connected.

  if (!isRegistered) {
    return null;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection-status-card"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, title), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, connectionInfoText), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection-status-card--status"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection-status-card--cloud"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: 'jp-connection-status-card--line' + (isUserConnected ? '' : ' jp-connection-status-card--site-only')
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection-status-card--jetpack-logo"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection-status-card--avatar",
    ref: avatarRef
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", {
    className: "jp-connection-status-card--list"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
    className: "jp-connection-status-card--list-item-success"
  }, __('Site connected.', 'jetpack'), "\xA0", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    variant: "link",
    onClick: openDisconnectDialog,
    className: "jp-connection__disconnect-dialog__link"
  }, __('Disconnect', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_disconnect_dialog__WEBPACK_IMPORTED_MODULE_8__["default"], {
    apiRoot: apiRoot,
    apiNonce: apiNonce,
    onDisconnected: onDisconnectedCallback,
    connectedPlugins: connectedPlugins,
    connectedSiteId: connectedSiteId,
    connectedUser: connectedUserData,
    isOpen: isDisconnectDialogOpen,
    onClose: closeDisconnectDialog,
    context: context
  })), isUserConnected && !isFetchingConnectionData && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
    className: "jp-connection-status-card--list-item-success"
  }, __('Logged in as', 'jetpack'), " ", connectedUserData === null || connectedUserData === void 0 ? void 0 : connectedUserData.display_name), !isUserConnected && !isFetchingConnectionData && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
    className: "jp-connection-status-card--list-item-error"
  }, __('Your WordPress.com account is not connected.', 'jetpack'))), !isUserConnected && !isFetchingConnectionData && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    isPrimary: true,
    disabled: userIsConnecting,
    onClick: setUserIsConnecting,
    className: "jp-connection-status-card--btn-connect-user"
  }, __('Connect your WordPress.com account', 'jetpack')), userIsConnecting && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_connect_user__WEBPACK_IMPORTED_MODULE_9__["default"], {
    redirectUri: redirectUri
  }));
};

ConnectionStatusCard.propTypes = {
  /** API root URL, required. */
  apiRoot: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string.isRequired),

  /** API Nonce, required. */
  apiNonce: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string.isRequired),

  /** Whether a site level connection has already been established, required. If not, the component will not render. */
  isRegistered: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool.isRequired),

  /** Whether the current user has connected their WordPress.com account, required. */
  isUserConnected: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool.isRequired),

  /** The redirect admin URI after the user has connected their WordPress.com account. */
  redirectUri: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string.isRequired),

  /** An object of the plugins currently using the Jetpack connection. */
  connectedPlugins: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),

  /** ID of the currently connected site. */
  connectedSiteId: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),

  /** The Card title. */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),

  /** The text that will be displayed under the title, containing info how to leverage the connection. */
  connectionInfoText: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),

  /** The callback to be called upon disconnection success. */
  onDisconnected: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),

  /** The context in which this component is being used */
  context: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
ConnectionStatusCard.defaultProps = {
  title: __('Connection', 'jetpack'),
  connectionInfoText: __('Leverages the Jetpack Cloud for more features on your side.', 'jetpack')
};
/* harmony default export */ __webpack_exports__["default"] = (ConnectionStatusCard);

/***/ }),

/***/ "../../js-packages/connection/components/disconnect-card/index.jsx":
/*!*************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-card/index.jsx ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/connection/components/disconnect-card/style.scss");
/**
 * External Dependencies
 */


/**
 * Internal Dependencies
 */


/**
 * Show a card with a title, value and description.
 * Used in the disconnection flow.
 *
 * @param {object} props - The Properties.
 * @returns {React.Component} DisconnectCard - The disconnect card component.
 */

const DisconnectCard = props => {
  const {
    title,
    value,
    description
  } = props;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-card card"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-card__card-content"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
    className: "jp-connection__disconnect-card__card-headline"
  }, title), (value || description) && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-card__card-stat-block"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "jp-connection__disconnect-card__card-stat"
  }, value), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-card__card-description"
  }, description))));
};

DisconnectCard.propTypes = {
  /** The title to show on the disconnect card. */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** Optional value/ statistic to show. */
  value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string) | (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /** Description to go with the stat value. */
  description: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};
/* harmony default export */ __webpack_exports__["default"] = (DisconnectCard);

/***/ }),

/***/ "../../js-packages/connection/components/disconnect-dialog/index.jsx":
/*!***************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-dialog/index.jsx ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/* harmony import */ var _automattic_jetpack_analytics__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @automattic/jetpack-analytics */ "../../js-packages/analytics/index.jsx");
/* harmony import */ var _automattic_jetpack_config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @automattic/jetpack-config */ "../../js-packages/config/src/index.js");
/* harmony import */ var _automattic_jetpack_config__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_automattic_jetpack_config__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/connection/components/disconnect-dialog/style.scss");
/* harmony import */ var _steps_step_disconnect__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./steps/step-disconnect */ "../../js-packages/connection/components/disconnect-dialog/steps/step-disconnect.jsx");
/* harmony import */ var _steps_step_disconnect_confirm__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./steps/step-disconnect-confirm */ "../../js-packages/connection/components/disconnect-dialog/steps/step-disconnect-confirm.jsx");
/* harmony import */ var _steps_step_survey__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./steps/step-survey */ "../../js-packages/connection/components/disconnect-dialog/steps/step-survey.jsx");
/* harmony import */ var _steps_step_thank_you__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./steps/step-thank-you */ "../../js-packages/connection/components/disconnect-dialog/steps/step-thank-you.jsx");
/**
 * External dependencies
 */



const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__;




/**
 * Internal dependencies
 */






/**
 * The RNA Disconnect Dialog component.
 *
 * @param {object} props -- The properties.
 * @returns {React.Component} The `DisconnectDialog` component.
 */

const DisconnectDialog = props => {
  const [isDisconnecting, setIsDisconnecting] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [isDisconnected, setIsDisconnected] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [disconnectError, setDisconnectError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [isProvidingFeedback, setIsProvidingFeedback] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [isFeedbackProvided, setIsFeedbackProvided] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [isSubmittingFeedback, setIsSubmittingFeedback] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const {
    apiRoot,
    apiNonce,
    connectedPlugins,
    title,
    pluginScreenDisconnectCallback,
    onDisconnected,
    onError,
    disconnectStepComponent,
    context,
    connectedUser,
    connectedSiteId,
    isOpen,
    onClose
  } = props;
  let disconnectingPlugin = '';

  if ((0,_automattic_jetpack_config__WEBPACK_IMPORTED_MODULE_6__.jetpackConfigHas)('consumer_slug')) {
    disconnectingPlugin = (0,_automattic_jetpack_config__WEBPACK_IMPORTED_MODULE_6__.jetpackConfigGet)('consumer_slug');
  }

  const defaultTracksArgs = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    return {
      context: context,
      plugin: disconnectingPlugin
    };
  }, [context, disconnectingPlugin]);
  /**
   * Initialize the REST API.
   */

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__["default"].setApiRoot(apiRoot);
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__["default"].setApiNonce(apiNonce);
  }, [apiRoot, apiNonce]);
  /**
   * Initialize tracks with user data.
   * Should run when we have a connected user.
   */

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (connectedUser && connectedUser.ID && connectedUser.login) {
      _automattic_jetpack_analytics__WEBPACK_IMPORTED_MODULE_5__["default"].initialize(connectedUser.ID, connectedUser.login);
    }
  }, [connectedUser, connectedUser.ID, connectedUser.login]);
  /**
   * Run when the disconnect dialog is opened
   */

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (isOpen) {
      _automattic_jetpack_analytics__WEBPACK_IMPORTED_MODULE_5__["default"].tracks.recordEvent('jetpack_disconnect_dialog_open', defaultTracksArgs);
    }
  }, [isOpen, defaultTracksArgs]);
  /**
   * Keep track of the steps that are presented
   */

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    // Don't do anything if the dialog is not open.
    if (!isOpen) {
      return;
    }

    if (!isDisconnected) {
      _automattic_jetpack_analytics__WEBPACK_IMPORTED_MODULE_5__["default"].tracks.recordEvent('jetpack_disconnect_dialog_step', Object.assign({}, {
        step: 'disconnect'
      }, defaultTracksArgs));
    } else if (isDisconnected && !isProvidingFeedback && !isFeedbackProvided) {
      _automattic_jetpack_analytics__WEBPACK_IMPORTED_MODULE_5__["default"].tracks.recordEvent('jetpack_disconnect_dialog_step', Object.assign({}, {
        step: 'disconnect_confirm'
      }, defaultTracksArgs));
    } else if (isProvidingFeedback && !isFeedbackProvided) {
      _automattic_jetpack_analytics__WEBPACK_IMPORTED_MODULE_5__["default"].tracks.recordEvent('jetpack_disconnect_dialog_step', Object.assign({}, {
        step: 'survey'
      }, defaultTracksArgs));
    } else if (isFeedbackProvided) {
      _automattic_jetpack_analytics__WEBPACK_IMPORTED_MODULE_5__["default"].tracks.recordEvent('jetpack_disconnect_dialog_step', Object.assign({}, {
        step: 'thank_you'
      }, defaultTracksArgs));
    }
  }, [isOpen, isDisconnected, isProvidingFeedback, isFeedbackProvided, defaultTracksArgs]);
  /**
   * Disconnect the site.
   * Uses the rest API to remove the Jetpack connection.
   */

  const _disconnect = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_4__["default"].disconnectSite().then(() => {
      setIsDisconnecting(false);
      setIsDisconnected(true);
    }).catch(error => {
      setIsDisconnecting(false);
      setDisconnectError(error);

      if (onError) {
        onError(error);
      }
    });
  }, [setIsDisconnecting, setIsDisconnected, setDisconnectError, onError]);
  /**
   * Submit the optional survey following disconnection.
   */


  const _submitSurvey = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((surveyData, tracksSurveyData) => {
    // Send survey response to wpcom
    const base = 'https://public-api.wordpress.com';
    const path = '/wpcom/v2/marketing/feedback-survey';
    const method = 'POST';
    setIsSubmittingFeedback(true); // We cannot use `@wordpress/api-fetch` here since it unconditionally sends
    // the `X-WP-Nonce` header, which is disallowed by WordPress.com.
    // If the submission receives an error, there's not really anything the user is able to do to fix it.
    // In these cases, just go ahead and show the last survey step.

    fetch(base + path, {
      method: method,
      headers: {
        'Content-Type': 'application/json',
        Accept: 'application/json'
      },
      body: JSON.stringify(surveyData)
    }).then(result => result.json()).then(jsonResponse => {
      // response received
      if (true === jsonResponse.success) {
        // Send a tracks event for survey submission.
        _automattic_jetpack_analytics__WEBPACK_IMPORTED_MODULE_5__["default"].tracks.recordEvent('jetpack_disconnect_survey_submit', tracksSurveyData);
        setIsFeedbackProvided(true);
        setIsSubmittingFeedback(false);
      } else {
        throw new Error('Survey endpoint returned error code ' + jsonResponse.code);
      }
    }).catch(error => {
      _automattic_jetpack_analytics__WEBPACK_IMPORTED_MODULE_5__["default"].tracks.recordEvent('jetpack_disconnect_survey_error', Object.assign({}, {
        error: error.message
      }, tracksSurveyData));
      setIsFeedbackProvided(true);
      setIsSubmittingFeedback(false);
    });
  }, [setIsSubmittingFeedback, setIsFeedbackProvided]);
  /**
   * Disconnect - Triggered upon clicking the 'Disconnect' button.
   */


  const handleDisconnect = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    e && e.preventDefault();
    setDisconnectError(false);
    setIsDisconnecting(true); // Detect the plugin context, where the plugin needs to be deactivated.

    if (context === 'plugins') {
      // Use a callback function to handle deactivating the plugin.
      // This should effectively short-circuit the disconnect flow by redirecting to deactivate the plugin.
      if (pluginScreenDisconnectCallback) {
        pluginScreenDisconnectCallback(e);
      } // Do not disconnect if context is the plugin screen, the plugin deactivation routine will handle disconnection.


      return;
    } // Default to making the disconnect API call here.


    _disconnect();
  }, [setDisconnectError, setIsDisconnecting, pluginScreenDisconnectCallback, context, _disconnect]);
  /**
   * Do we have the necessary data to be able to submit a survey?
   * Need to have the ID of the connected user and the ID of the connected site.
   */

  const canProvideFeedback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    return connectedUser.ID && connectedSiteId;
  }, [connectedUser, connectedSiteId]);
  /**
   * Submit Survey - triggered by clicking on the "Submit Feedback" button.
   * Assembles the survey response.
   */

  const handleSubmitSurvey = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((surveyAnswerId, surveyAnswerText, e) => {
    e && e.preventDefault(); // We do not have the information needed to record the response.
    // return early and move to the last step in the flow anyway.

    if (!canProvideFeedback()) {
      setIsFeedbackProvided(true);
      return;
    } // Format the survey data for submission.


    const surveyData = {
      site_id: connectedSiteId,
      user_id: connectedUser.ID,
      survey_id: 'jetpack-plugin-disconnect',
      survey_responses: {
        'why-cancel': {
          response: surveyAnswerId,
          text: surveyAnswerText ? surveyAnswerText : null
        }
      }
    }; // Additional data for analytics to see where disconnections happened from.

    const tracksSurveyData = Object.assign({}, defaultTracksArgs, {
      disconnect_reason: surveyAnswerId
    });

    _submitSurvey(surveyData, tracksSurveyData);
  }, [_submitSurvey, setIsFeedbackProvided, canProvideFeedback, connectedSiteId, connectedUser, defaultTracksArgs]);
  /**
   * Close modal and fire 'onDisconnected' callback if exists.
   * Triggered upon clicking the 'Back To WordPress' button.
   */

  const backToWordpress = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    e && e.preventDefault();

    if (onDisconnected) {
      onDisconnected();
    }

    onClose();
  }, [onDisconnected, onClose]);
  /**
   * Update the local state to show the survey step.
   */

  const handleProvideFeedback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    e && e.preventDefault();
    setIsProvidingFeedback(true);
  }, [setIsProvidingFeedback]);
  /**
   * Determine what step to show based on the current state
   *
   * @returns { React.Component } - component for current step
   */

  const getCurrentStep = () => {
    if (!isDisconnected) {
      // Disconnection screen.
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_steps_step_disconnect__WEBPACK_IMPORTED_MODULE_8__["default"], {
        title: title,
        connectedPlugins: connectedPlugins // Component that renders as part of the disconnect step, if passed.
        ,
        disconnectStepComponent: disconnectStepComponent,
        isDisconnecting: isDisconnecting,
        closeModal: onClose,
        onDisconnect: handleDisconnect,
        disconnectError: disconnectError,
        context: context // Where is the modal showing? ( most important for when it loads on the plugins page )
        ,
        disconnectingPlugin: disconnectingPlugin // Which plugin is initiating the disconnect.

      });
    } else if (isDisconnected && !isProvidingFeedback && !isFeedbackProvided) {
      // Confirm the disconnection, ask user about providing feedback.
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_steps_step_disconnect_confirm__WEBPACK_IMPORTED_MODULE_9__["default"], {
        canProvideFeedback: canProvideFeedback(),
        onProvideFeedback: handleProvideFeedback,
        onExit: backToWordpress
      });
    } else if (isProvidingFeedback && !isFeedbackProvided) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_steps_step_survey__WEBPACK_IMPORTED_MODULE_10__["default"], {
        isSubmittingFeedback: isSubmittingFeedback,
        onFeedBackProvided: handleSubmitSurvey,
        onExit: backToWordpress
      });
    } else if (isFeedbackProvided) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_steps_step_thank_you__WEBPACK_IMPORTED_MODULE_11__["default"], {
        onExit: backToWordpress
      });
    }
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, isOpen && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Modal, {
    title: "",
    contentLabel: title,
    aria: {
      labelledby: 'jp-connection__disconnect-dialog__heading'
    },
    onRequestClose: onClose,
    shouldCloseOnClickOutside: false,
    shouldCloseOnEsc: false,
    isDismissible: false,
    className: 'jp-connection__disconnect-dialog' + (isDisconnected ? ' jp-connection__disconnect-dialog__success' : '')
  }, getCurrentStep()));
};

DisconnectDialog.propTypes = {
  /** API root URL, required. */
  apiRoot: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** API Nonce, required. */
  apiNonce: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /** The modal title. */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** The callback to be called upon disconnection success. */
  onDisconnected: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),

  /** The callback to be called upon disconnection failure. */
  onError: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),

  /** The context in which this component is being used. */
  context: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /** Plugins that are using the Jetpack connection. */
  connectedPlugins: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /** Callback function that is called just before the request to disconnect is made when the context is "plugins". */
  pluginScreenDisconnectCallback: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),

  /** A component to render as part of the disconnect step. */
  disconnectStepComponent: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().element),

  /** An object representing the connected user. */
  connectedUser: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /** ID of the currently connected site. */
  connectedSiteId: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /** Whether or not the dialog modal should be open. */
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /** Callback function for when the modal closes. */
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};
DisconnectDialog.defaultProps = {
  title: __('Are you sure you want to disconnect?', 'jetpack'),
  context: 'jetpack-dashboard',
  connectedUser: {} // Pass empty object to avoid undefined errors.

};
/* harmony default export */ __webpack_exports__["default"] = (DisconnectDialog);

/***/ }),

/***/ "../../js-packages/connection/components/disconnect-dialog/steps/step-disconnect-confirm.jsx":
/*!***************************************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-dialog/steps/step-disconnect-confirm.jsx ***!
  \***************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/components/decorative-card/index.jsx");
/* harmony import */ var _images_disconnect_confirm_jpg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../images/disconnect-confirm.jpg */ "../../js-packages/connection/components/disconnect-dialog/images/disconnect-confirm.jpg");
/**
 * External Dependencies
 */


/**
 * Internal Dependencies
 */



const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__;



/**
 * Shows the step that confirms the site has been disconnected, asks if user would like to provide feedback.
 * Will only show option to provide feedback if the canProvideFeedback prop is true.
 *
 * @param {object} props - The properties.
 * @returns {React.Component} - StepDisconnectConfirm Component
 */

const StepDisconnectConfirm = props => {
  const {
    onExit,
    canProvideFeedback,
    onProvideFeedback
  } = props;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-dialog__content"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_5__["default"], {
    icon: "unlink",
    imageUrl: _images_disconnect_confirm_jpg__WEBPACK_IMPORTED_MODULE_6__
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-dialog__step-copy jp-connection__disconnect-dialog__step-copy--narrow"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createInterpolateElement)(__('Jetpack has been <br/>successfully disconnected.', 'jetpack'), {
    br: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("br", null)
  })), canProvideFeedback && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, __('We’re sorry to see you go. Here at Jetpack, we’re always striving to provide the best experience for our customers. Please take our short survey (2 minutes, promise).', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_4__.Button, {
    isPrimary: true,
    onClick: onProvideFeedback,
    className: "jp-connection__disconnect-dialog__btn-back-to-wp"
  }, __('Help us improve', 'jetpack'))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
    className: "jp-connection__disconnect-dialog__link jp-connection__disconnect-dialog__link--bold",
    href: "#",
    onClick: onExit
  }, __('No thank you', 'jetpack'))), !canProvideFeedback && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_4__.Button, {
    isPrimary: true,
    onClick: onExit,
    className: "jp-connection__disconnect-dialog__btn-back-to-wp"
  }, __('Back to my website', 'jetpack'))))));
};

StepDisconnectConfirm.PropTypes = {
  /** Callback used to close the modal. */
  onExit: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),

  /** Callback used to change the state if user would like to provide feedback. */
  onProvideFeedback: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),

  /** Does the app have the necessary information to collect a survey response? */
  canProvideFeedback: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
};
/* harmony default export */ __webpack_exports__["default"] = (StepDisconnectConfirm);

/***/ }),

/***/ "../../js-packages/connection/components/disconnect-dialog/steps/step-disconnect.jsx":
/*!*******************************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-dialog/steps/step-disconnect.jsx ***!
  \*******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/tools/jp-redirect/index.jsx");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _connected_plugins__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../connected-plugins */ "../../js-packages/connection/components/connected-plugins/index.jsx");
/**
 * External Dependencies
 */

/**
 * Internal Dependencies
 */



const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__;




/**
 * Disconnect step in disconnection flow.
 *
 * @param {object} props - The properties.
 * @returns {React.Component} - The StepDisconnect component
 */

const StepDisconnect = props => {
  const {
    title,
    isDisconnecting,
    onDisconnect,
    disconnectError,
    disconnectStepComponent,
    connectedPlugins,
    disconnectingPlugin,
    closeModal,
    context
  } = props;
  /**
   * Render the disconnect button, allows for some variance based on context.
   *
   * @returns {React.Component} - Button used for disconnect.
   */

  const renderDisconnectButton = () => {
    let buttonText = __('Disconnect', 'jetpack'); // When showing on the plugins page, this button should deactivate the plugin as well.


    if (isDisconnecting) {
      buttonText = __('Disconnecting…', 'jetpack');
    } else if (context === 'plugins') {
      buttonText = __('Disconnect and Deactivate', 'jetpack');
    }

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      isPrimary: true,
      disabled: isDisconnecting,
      onClick: onDisconnect,
      className: "jp-connection__disconnect-dialog__btn-disconnect"
    }, buttonText);
  };
  /**
   * Show some fallback output if there are no connected plugins to show and no passed disconnect component.
   * This is a more generic message about disconnecting Jetpack.
   *
   * @returns {React.ElementType} - Fallback message for when there are no connected plugins or passed components to show.
   */


  const renderFallbackOutput = () => {
    if (!connectedPlugins && !disconnectStepComponent) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "jp-connection__disconnect-dialog__step-copy"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
        className: "jp-connection__disconnect-dialog__large-text"
      }, __('Jetpack is currently powering multiple products on your site.', 'jetpack'), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("br", null), __('Once you disconnect Jetpack, these will no longer work.', 'jetpack')));
    }
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-dialog__content"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", {
    id: "jp-connection__disconnect-dialog__heading"
  }, title), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_connected_plugins__WEBPACK_IMPORTED_MODULE_5__["default"], {
    connectedPlugins: connectedPlugins,
    disconnectingPlugin: disconnectingPlugin
  }), disconnectStepComponent, renderFallbackOutput()), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-dialog__actions"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-row"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "lg-col-span-7 md-col-span-8 sm-col-span-4"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createInterpolateElement)(__('<strong>Need help?</strong> Learn more about the <jpConnectionInfoLink>Jetpack connection</jpConnectionInfoLink> or <jpSupportLink>contact Jetpack support</jpSupportLink>.', 'jetpack'), {
    strong: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("strong", null),
    jpConnectionInfoLink: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
      href: (0,_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_6__["default"])('why-the-wordpress-com-connection-is-important-for-jetpack'),
      rel: "noopener noreferrer",
      target: "_blank",
      className: "jp-connection__disconnect-dialog__link"
    }),
    jpSupportLink: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
      href: (0,_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_6__["default"])('jetpack-support'),
      rel: "noopener noreferrer",
      target: "_blank",
      className: "jp-connection__disconnect-dialog__link"
    })
  }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-dialog__button-wrap lg-col-span-5 md-col-span-8 sm-col-span-4"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    isPrimary: true,
    disabled: isDisconnecting,
    onClick: closeModal,
    className: "jp-connection__disconnect-dialog__btn-dismiss"
  }, __('Stay connected', 'jetpack')), renderDisconnectButton())), disconnectError && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
    className: "jp-connection__disconnect-dialog__error"
  }, disconnectError)));
};

StepDisconnect.propTypes = {
  /** The title to show for this section. */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),

  /** Whether or not a request to disconnect is in progress. */
  isDisconnecting: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),

  /** Callback function that is triggered by clicking the "Disconnect" button. */
  onDisconnect: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),

  /** An error that occurred during a request to disconnect. */
  disconnectError: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),

  /** A component to be rendered as part of this step */
  disconnectStepComponent: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().elementType),

  /** Plugins that are using the Jetpack connection. */
  connectedPlugins: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().array),

  /** The slug of the plugin that is initiating the disconnection. */
  disconnectingPlugin: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),

  /** Callback function that closes the modal. */
  closeModal: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),

  /** Where this modal is being rendered. */
  context: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};
/* harmony default export */ __webpack_exports__["default"] = (StepDisconnect);

/***/ }),

/***/ "../../js-packages/connection/components/disconnect-dialog/steps/step-survey.jsx":
/*!***************************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-dialog/steps/step-survey.jsx ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _disconnect_survey_jp_connect_disconnect_survey_card_scss__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../disconnect-survey/_jp-connect_disconnect-survey-card.scss */ "../../js-packages/connection/components/disconnect-survey/_jp-connect_disconnect-survey-card.scss");
/* harmony import */ var _disconnect_survey__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../disconnect-survey */ "../../js-packages/connection/components/disconnect-survey/index.jsx");
/* eslint-disable jsx-a11y/no-noninteractive-tabindex */

/**
 * External Dependencies
 */


/**
 * Internal Dependencies
 */


const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__;


/**
 * Show the survey step and allow the user to select a response.
 *
 * @param {object} props - The properties.
 * @returns {React.Component} The StepSurvey Component
 */

const StepSurvey = props => {
  const {
    onExit,
    onFeedBackProvided,
    isSubmittingFeedback
  } = props;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-dialog__content"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", null, __('Before you go, help us improve Jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
    className: "jp-connection__disconnect-dialog__large-text"
  }, __('Let us know what didn‘t work for you', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_disconnect_survey__WEBPACK_IMPORTED_MODULE_4__["default"], {
    onSubmit: onFeedBackProvided,
    isSubmittingFeedback: isSubmittingFeedback
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
    className: "jp-connection__disconnect-dialog__link jp-connection__disconnect-dialog__link--bold",
    href: "#",
    onClick: onExit
  }, __('Skip for now', 'jetpack')));
};

StepSurvey.PropTypes = {
  /** Callback function used to close the modal and leave the disconnect flow. */
  onExit: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),

  /** Callback function to handle submission of survey response. */
  onFeedBackProvided: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),

  /** If the survey feedback is currently being saved/ submitted */
  isSubmittingFeedback: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
};
/* harmony default export */ __webpack_exports__["default"] = (StepSurvey);

/***/ }),

/***/ "../../js-packages/connection/components/disconnect-dialog/steps/step-thank-you.jsx":
/*!******************************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-dialog/steps/step-thank-you.jsx ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/components/decorative-card/index.jsx");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _images_disconnect_thanks_jpg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../images/disconnect-thanks.jpg */ "../../js-packages/connection/components/disconnect-dialog/images/disconnect-thanks.jpg");
/**
 * External Dependencies
 */


/**
 * Internal Dependencies
 */



const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__;



/**
 * Show the "thank you" step following survey submission
 *
 * @param {object} props - The properties.
 * @returns {React.Component} - The StepThankYou Component
 */

const StepThankYou = props => {
  const {
    onExit
  } = props;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-dialog__content"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_5__["default"], {
    format: "vertical",
    imageUrl: _images_disconnect_thanks_jpg__WEBPACK_IMPORTED_MODULE_6__
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-dialog__copy"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", null, __('Thank you!', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
    className: "jp-connection__disconnect-dialog__large-text"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createInterpolateElement)(__('Your answer has been submitted. <br/>Thanks for your input on how we can improve Jetpack.', 'jetpack'), {
    br: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("br", null)
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    isPrimary: true,
    onClick: onExit,
    className: "jp-connection__disconnect-dialog__btn-back-to-wp"
  }, __('Back to my website', 'jetpack'))));
};

StepThankYou.PropTypes = {
  /** Callback function to close the disconnect modal. */
  onExit: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),

  /** Base URL for where webpack-ed images will be stored for the consumer of this component. */
  assetBaseUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};
/* harmony default export */ __webpack_exports__["default"] = (StepThankYou);

/***/ }),

/***/ "../../js-packages/connection/components/disconnect-survey/index.jsx":
/*!***************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-survey/index.jsx ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _survey_choice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./survey-choice */ "../../js-packages/connection/components/disconnect-survey/survey-choice.jsx");
/**
 * External Dependencies
 */


/**
 * Internal Dependencies
 */



const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__;

/**
 * Handles showing the disconnect survey.
 *
 * @param {object} props - The component props.
 * @returns {React.Component} - DisconnectSurvey component.
 */

const DisconnectSurvey = props => {
  const {
    onSubmit,
    isSubmittingFeedback
  } = props;
  const [selectedAnswer, setSelectedAnswer] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
  const [customResponse, setCustomResponse] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
  const options = [{
    id: 'troubleshooting',
    answerText: __("Troubleshooting - I'll be reconnecting afterwards.", 'jetpack')
  }, {
    id: 'not-working',
    answerText: __("I can't get it to work.", 'jetpack')
  }, {
    id: 'slowed-down-site',
    answerText: __('It slowed down my site.', 'jetpack')
  }, {
    id: 'buggy',
    answerText: __("It's buggy.", 'jetpack')
  }, {
    id: 'what-does-it-do',
    answerText: __("I don't know what it does.", 'jetpack')
  }];
  const customOption = {
    id: 'another-reason'
  };
  /**
   * Handle Submission of the survey.
   * Will send the survey response to the collection endpoint.
   */

  const handleSurveySubmit = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    const answerText = selectedAnswer === customOption.id ? customResponse : '';
    onSubmit(selectedAnswer, answerText);
  }, [onSubmit, customOption.id, customResponse, selectedAnswer]);
  /**
   * Handle input into the custom response field.
   *
   * @param {object} e - onChange event for the custom input
   */

  const handleCustomResponse = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    const value = e.target.value;
    e.stopPropagation();
    setCustomResponse(value);
  }, [setCustomResponse]);
  /**
   * Checks to see if an option is the currently selected option, returns a css class name if it matches.
   *
   * @param {string} optionId   - ID of the option to check for.
   * @returns {string} - The "selected" class if this option is currently selected.
   */

  const selectedClass = optionId => {
    if (optionId === selectedAnswer) {
      return 'jp-connect__disconnect-survey-card--selected';
    }

    return '';
  };
  /**
   * Event handler for keyboard events on the answer blocks.
   *
   * @param {string} answerId - The slug of the answer that has been selected.
   * @param {object} e - Keydown event.
   */


  const handleAnswerKeyDown = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((answerId, e) => {
    switch (e.key) {
      case 'Enter':
      case 'Space':
      case 'Spacebar':
      case ' ':
        setSelectedAnswer(answerId);
        break;
    }
  }, [setSelectedAnswer]);
  /**
   * Show all the survey options from the options array.
   *
   * @returns {React.ElementType []} - Mapped array of rendered survey options.
   */

  const renderOptions = () => {
    return options.map(option => {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_survey_choice__WEBPACK_IMPORTED_MODULE_4__["default"], {
        id: option.id,
        onClick: setSelectedAnswer,
        onKeyDown: handleAnswerKeyDown,
        className: 'card jp-connect__disconnect-survey-card ' + selectedClass(option.id)
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
        className: "jp-connect__disconnect-survey-card__answer"
      }, option.answerText));
    });
  };
  /**
   * Show the custom input survey option.
   * Contains an input field for a custom response.
   *
   * @returns {React.ElementType} - The custom survey option with an input field.
   */


  const renderCustomOption = () => {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_survey_choice__WEBPACK_IMPORTED_MODULE_4__["default"], {
      id: customOption.id,
      onClick: setSelectedAnswer,
      onKeyDown: handleAnswerKeyDown,
      className: 'card jp-connect__disconnect-survey-card ' + selectedClass(customOption.id)
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
      className: "jp-connect__disconnect-survey-card__answer"
    }, __('Other:', 'jetpack'), ' ', /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
      placeholder: __('share your experience', 'jetpack'),
      className: "jp-connect__disconnect-survey-card__input",
      type: "text",
      value: customResponse,
      onChange: handleCustomResponse,
      maxLength: 1000 // Limit response length.

    })));
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-connection__disconnect-dialog__survey"
  }, renderOptions(), renderCustomOption()), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    disabled: !selectedAnswer || isSubmittingFeedback,
    isPrimary: true,
    onClick: handleSurveySubmit,
    className: "jp-connection__disconnect-dialog__btn-back-to-wp"
  }, isSubmittingFeedback ? __('Submitting…', 'jetpack') : __('Submit Feedback', 'jetpack'))));
};

DisconnectSurvey.PropTypes = {
  /** Callback handler function for when the survey response is submitted. */
  onSubmit: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),

  /** If the survey feedback is currently being saved/ submitted */
  isSubmittingFeedback: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
};
/* harmony default export */ __webpack_exports__["default"] = (DisconnectSurvey);

/***/ }),

/***/ "../../js-packages/connection/components/disconnect-survey/survey-choice.jsx":
/*!***********************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-survey/survey-choice.jsx ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jp_connect_disconnect_survey_card_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_jp-connect_disconnect-survey-card.scss */ "../../js-packages/connection/components/disconnect-survey/_jp-connect_disconnect-survey-card.scss");
/**
 * External Dependencies
 */

/**
 * Internal Dependencies
 */


/**
 * SurveyChoice - Present one choice in the survey.
 *
 * @param {string} props.id - The ID/slug string of the survey option
 * @param {Function} props.onClick - Event handler for clicking on the survey option.
 * @param {Function} props.onKeydown - Event handler for pressing a key on the survey option.
 * @param {React.ElementType} props.children - Any passed elements as children to this component.
 * @param {string} props.className - A class name to apply to the survey choice.
 * @returns {React.Component} SurveyChoice - The SurveyChoice component.
 */

const SurveyChoice = props => {
  const {
    id,
    onClick,
    onKeyDown,
    children,
    className
  } = props;
  const handleClick = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    onClick(id);
  }, [id, onClick]);
  const handleKeyDown = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    onKeyDown(id, e);
  }, [id, onKeyDown]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    tabIndex: "0",
    role: "button",
    onClick: handleClick,
    onKeyDown: handleKeyDown,
    className: 'card jp-connect__disconnect-survey-card ' + className
  }, children);
};

/* harmony default export */ __webpack_exports__["default"] = (SurveyChoice);

/***/ }),

/***/ "../../js-packages/connection/state/actions.jsx":
/*!******************************************************!*\
  !*** ../../js-packages/connection/state/actions.jsx ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SET_CONNECTION_STATUS": function() { return /* binding */ SET_CONNECTION_STATUS; },
/* harmony export */   "SET_CONNECTION_STATUS_IS_FETCHING": function() { return /* binding */ SET_CONNECTION_STATUS_IS_FETCHING; },
/* harmony export */   "FETCH_CONNECTION_STATUS": function() { return /* binding */ FETCH_CONNECTION_STATUS; },
/* harmony export */   "SET_SITE_IS_REGISTERING": function() { return /* binding */ SET_SITE_IS_REGISTERING; },
/* harmony export */   "SET_USER_IS_CONNECTING": function() { return /* binding */ SET_USER_IS_CONNECTING; },
/* harmony export */   "SET_REGISTRATION_ERROR": function() { return /* binding */ SET_REGISTRATION_ERROR; },
/* harmony export */   "CLEAR_REGISTRATION_ERROR": function() { return /* binding */ CLEAR_REGISTRATION_ERROR; },
/* harmony export */   "REGISTER_SITE": function() { return /* binding */ REGISTER_SITE; },
/* harmony export */   "SET_AUTHORIZATION_URL": function() { return /* binding */ SET_AUTHORIZATION_URL; },
/* harmony export */   "default": function() { return /* binding */ actions; }
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./store */ "../../js-packages/connection/state/store.jsx");
/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


const SET_CONNECTION_STATUS = 'SET_CONNECTION_STATUS';
const SET_CONNECTION_STATUS_IS_FETCHING = 'SET_CONNECTION_STATUS_IS_FETCHING';
const FETCH_CONNECTION_STATUS = 'FETCH_CONNECTION_STATUS';
const SET_SITE_IS_REGISTERING = 'SET_SITE_IS_REGISTERING';
const SET_USER_IS_CONNECTING = 'SET_USER_IS_CONNECTING';
const SET_REGISTRATION_ERROR = 'SET_REGISTRATION_ERROR';
const CLEAR_REGISTRATION_ERROR = 'CLEAR_REGISTRATION_ERROR';
const REGISTER_SITE = 'REGISTER_SITE';
const SET_AUTHORIZATION_URL = 'SET_AUTHORIZATION_URL';
const connectionStatusActions = {
  setConnectionStatus: connectionStatus => {
    return {
      type: SET_CONNECTION_STATUS,
      connectionStatus
    };
  },
  setConnectionStatusIsFetching: isFetching => {
    return {
      type: SET_CONNECTION_STATUS_IS_FETCHING,
      isFetching
    };
  },
  fetchConnectionStatus: () => {
    return {
      type: FETCH_CONNECTION_STATUS
    };
  },
  setSiteIsRegistering: isRegistering => {
    return {
      type: SET_SITE_IS_REGISTERING,
      isRegistering
    };
  },
  setUserIsConnecting: isConnecting => {
    return {
      type: SET_USER_IS_CONNECTING,
      isConnecting
    };
  },
  setRegistrationError: registrationError => {
    return {
      type: SET_REGISTRATION_ERROR,
      registrationError
    };
  },
  clearRegistrationError: () => {
    return {
      type: CLEAR_REGISTRATION_ERROR
    };
  },
  setAuthorizationUrl: authorizationUrl => {
    return {
      type: SET_AUTHORIZATION_URL,
      authorizationUrl
    };
  },

  *registerSite(registrationNonce, redirectUri) {
    yield (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.dispatch)(_store__WEBPACK_IMPORTED_MODULE_2__.STORE_ID).clearRegistrationError();
    yield (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.dispatch)(_store__WEBPACK_IMPORTED_MODULE_2__.STORE_ID).setSiteIsRegistering(true);
    yield _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_1__["default"].registerSite(registrationNonce, redirectUri).then(response => {
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.dispatch)(_store__WEBPACK_IMPORTED_MODULE_2__.STORE_ID).setSiteIsRegistering(false);
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.dispatch)(_store__WEBPACK_IMPORTED_MODULE_2__.STORE_ID).setConnectionStatus({
        isRegistered: true
      });
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.dispatch)(_store__WEBPACK_IMPORTED_MODULE_2__.STORE_ID).setAuthorizationUrl(response.authorizeUrl);
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.dispatch)(_store__WEBPACK_IMPORTED_MODULE_2__.STORE_ID).setUserIsConnecting(true);
    }).catch(error => {
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.dispatch)(_store__WEBPACK_IMPORTED_MODULE_2__.STORE_ID).setSiteIsRegistering(false);
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.dispatch)(_store__WEBPACK_IMPORTED_MODULE_2__.STORE_ID).setRegistrationError(error);
    }).finally(() => {
      return {
        type: REGISTER_SITE
      };
    });
  }

};
const actions = { ...connectionStatusActions
};


/***/ }),

/***/ "../../js-packages/connection/state/controls.jsx":
/*!*******************************************************!*\
  !*** ../../js-packages/connection/state/controls.jsx ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/**
 * External dependencies
 */


const FETCH_CONNECTION_STATUS = () => {
  return new Promise((resolve, reject) => {
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_0__["default"].fetchSiteConnectionStatus().then(result => resolve(result)).catch(error => reject(error));
  });
};

/* harmony default export */ __webpack_exports__["default"] = ({
  FETCH_CONNECTION_STATUS
});

/***/ }),

/***/ "../../js-packages/connection/state/reducers.jsx":
/*!*******************************************************!*\
  !*** ../../js-packages/connection/state/reducers.jsx ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./actions */ "../../js-packages/connection/state/actions.jsx");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */



const connectionStatus = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case _actions__WEBPACK_IMPORTED_MODULE_1__.SET_CONNECTION_STATUS:
      return { ...state,
        ...action.connectionStatus
      };
  }

  return state;
};

const connectionStatusIsFetching = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case _actions__WEBPACK_IMPORTED_MODULE_1__.SET_CONNECTION_STATUS_IS_FETCHING:
      return action.isFetching;
  }

  return state;
};

const siteIsRegistering = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case _actions__WEBPACK_IMPORTED_MODULE_1__.SET_SITE_IS_REGISTERING:
      return action.isRegistering;
  }

  return state;
};

const userIsConnecting = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case _actions__WEBPACK_IMPORTED_MODULE_1__.SET_USER_IS_CONNECTING:
      return action.isConnecting;
  }

  return state;
};

const registrationError = (state, action) => {
  switch (action.type) {
    case _actions__WEBPACK_IMPORTED_MODULE_1__.CLEAR_REGISTRATION_ERROR:
      return false;

    case _actions__WEBPACK_IMPORTED_MODULE_1__.SET_REGISTRATION_ERROR:
      return action.registrationError;

    default:
      return state;
  }
};

const authorizationUrl = (state, action) => {
  switch (action.type) {
    case _actions__WEBPACK_IMPORTED_MODULE_1__.SET_AUTHORIZATION_URL:
      return action.authorizationUrl;

    default:
      return state;
  }
};

const reducers = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.combineReducers)({
  connectionStatus,
  connectionStatusIsFetching,
  siteIsRegistering,
  userIsConnecting,
  registrationError,
  authorizationUrl
});
/* harmony default export */ __webpack_exports__["default"] = (reducers);

/***/ }),

/***/ "../../js-packages/connection/state/resolvers.jsx":
/*!********************************************************!*\
  !*** ../../js-packages/connection/state/resolvers.jsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./actions */ "../../js-packages/connection/state/actions.jsx");
/**
 * Internal dependencies
 */

const connectionResolvers = {
  *getConnectionStatus() {
    yield _actions__WEBPACK_IMPORTED_MODULE_0__["default"].setConnectionStatusIsFetching(true);
    const result = yield _actions__WEBPACK_IMPORTED_MODULE_0__["default"].fetchConnectionStatus();
    yield _actions__WEBPACK_IMPORTED_MODULE_0__["default"].setConnectionStatusIsFetching(false);
    return _actions__WEBPACK_IMPORTED_MODULE_0__["default"].setConnectionStatus(result);
  }

};
/* harmony default export */ __webpack_exports__["default"] = ({ ...connectionResolvers
});

/***/ }),

/***/ "../../js-packages/connection/state/selectors.jsx":
/*!********************************************************!*\
  !*** ../../js-packages/connection/state/selectors.jsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const connectionSelectors = {
  getConnectionStatus: state => state.connectionStatus || {},
  getConnectionStatusIsFetching: state => state.connectionStatusIsFetching || false,
  getSiteIsRegistering: state => state.siteIsRegistering || false,
  getUserIsConnecting: state => state.userIsConnecting || false,
  getRegistrationError: state => state.registrationError || false,
  getAuthorizationUrl: state => state.authorizationUrl || false
};
const selectors = { ...connectionSelectors
};
/* harmony default export */ __webpack_exports__["default"] = (selectors);

/***/ }),

/***/ "../../js-packages/connection/state/store-holder.jsx":
/*!***********************************************************!*\
  !*** ../../js-packages/connection/state/store-holder.jsx ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/defineProperty.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/defineProperty.js");
/* harmony import */ var _home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);


/**
 * External dependencies
 */


class storeHolder {
  static mayBeInit(storeId, storeConfig) {
    if (null === storeHolder.store) {
      storeHolder.store = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.createReduxStore)(storeId, storeConfig);
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.register)(storeHolder.store);
      storeHolder.resolveResolvers(storeId, storeConfig.initialState);
    }
  }

  static resolveResolvers(storeId, initialState) {
    if (initialState.connectionStatus && initialState.connectionStatus.hasOwnProperty('isRegistered')) {
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.dispatch)(storeId).finishResolution('getConnectionStatus', []);
    }
  }

}

_home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_0___default()(storeHolder, "store", null);

/* harmony default export */ __webpack_exports__["default"] = (storeHolder);

/***/ }),

/***/ "../../js-packages/connection/state/store.jsx":
/*!****************************************************!*\
  !*** ../../js-packages/connection/state/store.jsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STORE_ID": function() { return /* binding */ STORE_ID; }
/* harmony export */ });
/* harmony import */ var _reducers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reducers */ "../../js-packages/connection/state/reducers.jsx");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./actions */ "../../js-packages/connection/state/actions.jsx");
/* harmony import */ var _selectors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./selectors */ "../../js-packages/connection/state/selectors.jsx");
/* harmony import */ var _store_holder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./store-holder */ "../../js-packages/connection/state/store-holder.jsx");
/* harmony import */ var _resolvers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./resolvers */ "../../js-packages/connection/state/resolvers.jsx");
/* harmony import */ var _controls__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./controls */ "../../js-packages/connection/state/controls.jsx");
/**
 * Internal dependencies
 */






const STORE_ID = 'jetpack-connection';
_store_holder__WEBPACK_IMPORTED_MODULE_0__["default"].mayBeInit(STORE_ID, {
  reducer: _reducers__WEBPACK_IMPORTED_MODULE_1__["default"],
  actions: _actions__WEBPACK_IMPORTED_MODULE_2__["default"],
  selectors: _selectors__WEBPACK_IMPORTED_MODULE_3__["default"],
  resolvers: _resolvers__WEBPACK_IMPORTED_MODULE_4__["default"],
  controls: _controls__WEBPACK_IMPORTED_MODULE_5__["default"],
  initialState: window.JP_CONNECTION_INITIAL_STATE || {}
});


/***/ }),

/***/ "../../js-packages/idc/components/card-fresh/index.jsx":
/*!*************************************************************!*\
  !*** ../../js-packages/idc/components/card-fresh/index.jsx ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/compose */ "@wordpress/compose");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/components/spinner/index.jsx");
/* harmony import */ var _state_store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../state/store */ "../../js-packages/idc/state/store.jsx");
/* harmony import */ var _tools_extract_hostname__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../tools/extract-hostname */ "../../js-packages/idc/tools/extract-hostname.jsx");
/**
 * External dependencies
 */







const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__;


/**
 * Internal dependencies
 */



/**
 * The "migrate" card.
 *
 * @param {object} props - The properties.
 * @param {string} props.wpcomHomeUrl - The original site URL.
 * @param {string} props.currentUrl - The current site URL.
 * @param {string} props.redirectUri - The redirect URI to redirect users back to after connecting.
 * @param {boolean} props.isActionInProgress - Whether there's already an action in progress.
 * @param {Function} props.setIsActionInProgress - Function to set the "action in progress" flag.
 * @returns {React.Component} The `ConnectScreen` component.
 */

const CardFresh = props => {
  const wpcomHostName = (0,_tools_extract_hostname__WEBPACK_IMPORTED_MODULE_8__["default"])(props.wpcomHomeUrl);
  const currentHostName = (0,_tools_extract_hostname__WEBPACK_IMPORTED_MODULE_8__["default"])(props.currentUrl);
  const redirectUri = props.redirectUri;
  const {
    isActionInProgress,
    setIsActionInProgress
  } = props;

  const buttonLabel = __('Create a fresh connection', 'jetpack');

  const [isStartingFresh, setIsStartingFresh] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  /**
   * Initiate the migration.
   * Placeholder for now.
   *
   * @todo Add the actual migration functionality.
   */

  const doStartFresh = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    if (!isActionInProgress) {
      setIsActionInProgress(true);
      setIsStartingFresh(true);
      _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_7__["default"].startIDCFresh(redirectUri).then(connectUrl => {
        window.location.href = connectUrl + '&from=idc-notice';
      }).catch(error => {
        setIsActionInProgress(false);
        setIsStartingFresh(false);
        throw error;
      });
    }
  }, [setIsStartingFresh, isActionInProgress, setIsActionInProgress, redirectUri]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-action-base"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-action-top"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, __('Treat each site as independent sites', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.createInterpolateElement)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.sprintf)(
  /* translators: %1$s: The current site domain name. %2$s: The original site domain name. */
  __('<hostname>%1$s</hostname> settings, stats, and subscribers will start fresh. <hostname>%2$s</hostname> will keep its data as is.', 'jetpack'), currentHostName, wpcomHostName), {
    hostname: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("strong", null)
  }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-action-bottom"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-action-sitename"
  }, wpcomHostName), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Dashicon, {
    icon: "minus",
    className: "jp-idc__idc-screen__card-action-separator"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-action-sitename"
  }, currentHostName), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    className: "jp-idc__idc-screen__card-action-button",
    label: buttonLabel,
    onClick: doStartFresh,
    disabled: isActionInProgress
  }, isStartingFresh ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_9__["default"], null) : buttonLabel)));
};

CardFresh.propTypes = {
  wpcomHomeUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  currentUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  redirectUri: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  isActionInProgress: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  setIsActionInProgress: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func.isRequired)
};
/* harmony default export */ __webpack_exports__["default"] = ((0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__.compose)([(0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.withSelect)(select => {
  return {
    isActionInProgress: select(_state_store__WEBPACK_IMPORTED_MODULE_10__.STORE_ID).getIsActionInProgress()
  };
}), (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.withDispatch)(dispatch => {
  return {
    setIsActionInProgress: dispatch(_state_store__WEBPACK_IMPORTED_MODULE_10__.STORE_ID).setIsActionInProgress
  };
})])(CardFresh));

/***/ }),

/***/ "../../js-packages/idc/components/card-migrate/index.jsx":
/*!***************************************************************!*\
  !*** ../../js-packages/idc/components/card-migrate/index.jsx ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/compose */ "@wordpress/compose");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/components/spinner/index.jsx");
/* harmony import */ var _state_store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../state/store */ "../../js-packages/idc/state/store.jsx");
/* harmony import */ var _tools_extract_hostname__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../tools/extract-hostname */ "../../js-packages/idc/tools/extract-hostname.jsx");
/**
 * External dependencies
 */







const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__;


/**
 * Internal dependencies
 */



/**
 * The "migrate" card.
 *
 * @param {object} props - The properties.
 * @param {string} props.wpcomHomeUrl - The original site URL.
 * @param {string} props.currentUrl - The current site URL.
 * @param {Function} props.onMigrated - The callback to be called when migration has completed.
 * @param {boolean} props.isActionInProgress - Whether there's already an action in progress.
 * @param {Function} props.setIsActionInProgress - Function to set the "action in progress" flag.
 * @returns {React.Component} The `ConnectScreen` component.
 */

const CardMigrate = props => {
  const wpcomHostName = (0,_tools_extract_hostname__WEBPACK_IMPORTED_MODULE_8__["default"])(props.wpcomHomeUrl);
  const currentHostName = (0,_tools_extract_hostname__WEBPACK_IMPORTED_MODULE_8__["default"])(props.currentUrl);
  const {
    isActionInProgress,
    setIsActionInProgress
  } = props;
  const {
    onMigrated
  } = props;

  const buttonLabel = __('Move your settings', 'jetpack');

  const [isMigrating, setIsMigrating] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  /**
   * Initiate the migration.
   * Placeholder for now.
   *
   * @todo Add the actual migration functionality.
   */

  const doMigrate = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    if (!isActionInProgress) {
      setIsActionInProgress(true);
      setIsMigrating(true);
      _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_7__["default"].migrateIDC().then(() => {
        setIsMigrating(false);

        if (onMigrated && {}.toString.call(onMigrated) === '[object Function]') {
          onMigrated();
        }
      }).catch(error => {
        setIsActionInProgress(false);
        setIsMigrating(false);
        throw error;
      });
    }
  }, [setIsMigrating, onMigrated, isActionInProgress, setIsActionInProgress]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-action-base"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-action-top"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, __('Move Jetpack data', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.createInterpolateElement)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.sprintf)(
  /* translators: %1$s: The current site domain name. %2$s: The original site domain name. */
  __('Move all your settings, stats and subscribers to your other <hostname>%1$s</hostname>. <hostname>%2$s</hostname> will be disconnected from Jetpack.', 'jetpack'), currentHostName, wpcomHostName), {
    hostname: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("strong", null)
  }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-action-bottom"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-action-sitename"
  }, wpcomHostName), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Dashicon, {
    icon: "arrow-down-alt",
    className: "jp-idc__idc-screen__card-action-separator"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-action-sitename"
  }, currentHostName), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    className: "jp-idc__idc-screen__card-action-button",
    label: buttonLabel,
    onClick: doMigrate,
    disabled: isActionInProgress
  }, isMigrating ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_9__["default"], null) : buttonLabel)));
};

CardMigrate.propTypes = {
  wpcomHomeUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  currentUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  onMigrated: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),
  isActionInProgress: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  setIsActionInProgress: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func.isRequired)
};
/* harmony default export */ __webpack_exports__["default"] = ((0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__.compose)([(0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.withSelect)(select => {
  return {
    isActionInProgress: select(_state_store__WEBPACK_IMPORTED_MODULE_10__.STORE_ID).getIsActionInProgress()
  };
}), (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.withDispatch)(dispatch => {
  return {
    setIsActionInProgress: dispatch(_state_store__WEBPACK_IMPORTED_MODULE_10__.STORE_ID).setIsActionInProgress
  };
})])(CardMigrate));

/***/ }),

/***/ "../../js-packages/idc/components/idc-screen/index.jsx":
/*!*************************************************************!*\
  !*** ../../js-packages/idc/components/idc-screen/index.jsx ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/components/jetpack-logo/index.jsx");
/* harmony import */ var _screen_main__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./screen-main */ "../../js-packages/idc/components/idc-screen/screen-main.jsx");
/* harmony import */ var _screen_migrated__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./screen-migrated */ "../../js-packages/idc/components/idc-screen/screen-migrated.jsx");
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/idc/components/idc-screen/style.scss");
/**
 * External dependencies
 */



const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__;


/**
 * Internal dependencies
 */




/**
 * The IDC screen component.
 *
 * @param {object} props - The properties.
 * @param {React.Component} props.logo - The screen logo, Jetpack by default.
 * @param {string} props.headerText - The header text, 'Safe Mode' by default.
 * @param {string} props.wpcomHomeUrl - The original site URL.
 * @param {string} props.currentUrl - The current site URL.
 * @param {string} props.redirectUri - The redirect URI to redirect users back to after connecting.
 * @param {string} props.apiRoot - API root URL, required.
 * @param {string} props.apiNonce - API Nonce, required.
 * @returns {React.Component} The `ConnectScreen` component.
 */

const IDCScreen = props => {
  const {
    logo,
    headerText,
    wpcomHomeUrl,
    currentUrl,
    apiNonce,
    apiRoot,
    redirectUri
  } = props;
  const [isMigrated, setIsMigrated] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const onMigrated = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    setIsMigrated(true);
  }, [setIsMigrated]);
  /**
   * Initialize the REST API.
   */

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_3__["default"].setApiRoot(apiRoot);
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_3__["default"].setApiNonce(apiNonce);
  }, [apiRoot, apiNonce]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: 'jp-idc__idc-screen' + (isMigrated ? ' jp-idc__idc-screen__success' : '')
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__header"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__logo"
  }, logo), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__logo-label"
  }, headerText)), isMigrated ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_screen_migrated__WEBPACK_IMPORTED_MODULE_5__["default"], {
    wpcomHomeUrl: wpcomHomeUrl,
    currentUrl: currentUrl
  }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_screen_main__WEBPACK_IMPORTED_MODULE_6__["default"], {
    wpcomHomeUrl: wpcomHomeUrl,
    currentUrl: currentUrl,
    onMigrated: onMigrated,
    redirectUri: redirectUri
  }));
};

IDCScreen.propTypes = {
  logo: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object.isRequired),
  headerText: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  wpcomHomeUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  currentUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  redirectUri: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  apiRoot: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  apiNonce: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired)
};
IDCScreen.defaultProps = {
  logo: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_7__["default"], {
    height: 24
  }),
  headerText: __('Safe Mode', 'jetpack')
};
/* harmony default export */ __webpack_exports__["default"] = (IDCScreen);

/***/ }),

/***/ "../../js-packages/idc/components/idc-screen/screen-main.jsx":
/*!*******************************************************************!*\
  !*** ../../js-packages/idc/components/idc-screen/screen-main.jsx ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/tools/jp-redirect/index.jsx");
/* harmony import */ var _card_migrate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../card-migrate */ "../../js-packages/idc/components/card-migrate/index.jsx");
/* harmony import */ var _card_fresh__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../card-fresh */ "../../js-packages/idc/components/card-fresh/index.jsx");
/* harmony import */ var _safe_mode__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../safe-mode */ "../../js-packages/idc/components/safe-mode/index.jsx");
/**
 * External dependencies
 */




const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__;

/**
 * Internal dependencies
 */




/**
 * Retrieve the main screen body.
 *
 * @param {object} props - The properties.
 * @param {string} props.wpcomHomeUrl - The original site URL.
 * @param {string} props.currentUrl - The current site URL.
 * @param {string} props.redirectUri - The redirect URI to redirect users back to after connecting.
 * @param {Function} props.onMigrated - The callback to be called when migration has completed.
 * @returns {React.Component} The ScreenMain component.
 */

const ScreenMain = props => {
  const {
    wpcomHomeUrl,
    currentUrl,
    onMigrated,
    redirectUri
  } = props;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, __('Safe Mode has been activated', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createInterpolateElement)(__('Your site is in Safe Mode because you have 2 Jetpack-powered sites that appear to be duplicates. ' + '2 sites that are telling Jetpack they’re the same site. <safeModeLink>Learn more about safe mode.</safeModeLink>', 'jetpack'), {
    safeModeLink: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
      href: (0,_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_4__["default"])('jetpack-support-safe-mode'),
      rel: "noopener noreferrer",
      target: "_blank"
    })
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, __('Please select an option', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__cards"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_card_migrate__WEBPACK_IMPORTED_MODULE_5__["default"], {
    wpcomHomeUrl: wpcomHomeUrl,
    currentUrl: currentUrl,
    onMigrated: onMigrated
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__cards-separator"
  }, "or"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_card_fresh__WEBPACK_IMPORTED_MODULE_6__["default"], {
    wpcomHomeUrl: wpcomHomeUrl,
    currentUrl: currentUrl,
    redirectUri: redirectUri
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_safe_mode__WEBPACK_IMPORTED_MODULE_7__["default"], null));
};

ScreenMain.propTypes = {
  wpcomHomeUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  currentUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  redirectUri: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  onMigrated: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};
/* harmony default export */ __webpack_exports__["default"] = (ScreenMain);

/***/ }),

/***/ "../../js-packages/idc/components/idc-screen/screen-migrated.jsx":
/*!***********************************************************************!*\
  !*** ../../js-packages/idc/components/idc-screen/screen-migrated.jsx ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/components/spinner/index.jsx");
/* harmony import */ var _tools_extract_hostname__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../tools/extract-hostname */ "../../js-packages/idc/tools/extract-hostname.jsx");
/**
 * External dependencies
 */





const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__;

/**
 * Internal dependencies
 */


/**
 * Retrieve the migrated screen body.
 *
 * @param {object} props - The properties.
 * @param {string} props.wpcomHomeUrl - The original site URL.
 * @param {string} props.currentUrl - The current site URL.
 * @returns {React.Component} The ScreenMigrated component.
 */

const ScreenMigrated = props => {
  const wpcomHostName = (0,_tools_extract_hostname__WEBPACK_IMPORTED_MODULE_5__["default"])(props.wpcomHomeUrl);
  const currentHostName = (0,_tools_extract_hostname__WEBPACK_IMPORTED_MODULE_5__["default"])(props.currentUrl);

  const buttonLabel = __('Got it, thanks', 'jetpack');

  const [isHandlingOk, setIsHandlingOk] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  /**
   * Handle the "Got It" click after the migration has completed.
   */

  const handleOkButton = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    if (!isHandlingOk) {
      setIsHandlingOk(true);
      window.location.reload();
    }
  }, [isHandlingOk, setIsHandlingOk]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, __('Your Jetpack settings have migrated successfully', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.createInterpolateElement)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.sprintf)(
  /* translators: %1$s: The current site domain name. */
  __('Safe Mode has been switched off for <hostname>%1$s</hostname> website and Jetpack is fully functional.', 'jetpack'), currentHostName), {
    hostname: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("strong", null)
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-migrated"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-migrated-hostname"
  }, wpcomHostName), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Dashicon, {
    icon: "arrow-down-alt",
    className: "jp-idc__idc-screen__card-migrated-separator"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Dashicon, {
    icon: "arrow-right-alt",
    className: "jp-idc__idc-screen__card-migrated-separator-wide"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__idc-screen__card-migrated-hostname"
  }, currentHostName)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    className: "jp-idc__idc-screen__card-action-button jp-idc__idc-screen__card-action-button-migrated",
    onClick: handleOkButton,
    label: buttonLabel
  }, isHandlingOk ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_6__["default"], null) : buttonLabel));
};

ScreenMigrated.propTypes = {
  wpcomHomeUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  currentUrl: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired)
};
/* harmony default export */ __webpack_exports__["default"] = (ScreenMigrated);

/***/ }),

/***/ "../../js-packages/idc/components/safe-mode/index.jsx":
/*!************************************************************!*\
  !*** ../../js-packages/idc/components/safe-mode/index.jsx ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../../node_modules/.pnpm/prop-types@15.7.2/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/compose */ "@wordpress/compose");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/* harmony import */ var _automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @automattic/jetpack-components */ "../../js-packages/components/components/spinner/index.jsx");
/* harmony import */ var _state_store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../state/store */ "../../js-packages/idc/state/store.jsx");
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./style.scss */ "../../js-packages/idc/components/safe-mode/style.scss");
/**
 * External dependencies
 */







const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__;


/**
 * Internal dependencies
 */



/**
 * Render the "Stay safe" button.
 *
 * @param {Function} callback - Button click callback.
 * @param {boolean} isDisabled - Whether the button should be disabled.
 * @returns {React.Component} - The rendered output.
 */

const renderStaySafeButton = (callback, isDisabled) => {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createInterpolateElement)(__('Or decide later and stay in <button>Safe mode</button>', 'jetpack'), {
    button: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Button, {
      label: __('Safe mode', 'jetpack'),
      variant: "link",
      onClick: callback,
      disabled: isDisabled
    })
  });
};
/**
 * Render the "staying safe" line.
 *
 * @returns {React.Component} - The rendered output.
 */


const renderStayingSafe = () => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__safe-mode__staying-safe"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_components__WEBPACK_IMPORTED_MODULE_9__["default"], {
    color: "black"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, __('Finishing setting up Safe mode…', 'jetpack')));
};

const SafeMode = props => {
  const {
    isActionInProgress,
    setIsActionInProgress
  } = props;
  const [isStayingSafe, setIsStayingSafe] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const staySafeCallback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    if (!isActionInProgress) {
      setIsStayingSafe(true);
      setIsActionInProgress(true);
      _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_7__["default"].confirmIDCSafeMode().then(() => {
        window.location.reload();
      }).catch(error => {
        setIsActionInProgress(false);
        setIsStayingSafe(false);
        throw error;
      });
    }
  }, [isActionInProgress, setIsActionInProgress]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jp-idc__safe-mode"
  }, isStayingSafe ? renderStayingSafe() : renderStaySafeButton(staySafeCallback, isActionInProgress));
};

SafeMode.propTypes = {
  /** Whether there's already an action in progress. */
  isActionInProgress: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /** Function to set the "action in progress" flag. */
  setIsActionInProgress: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func.isRequired)
};
/* harmony default export */ __webpack_exports__["default"] = ((0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_2__.compose)([(0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.withSelect)(select => {
  return {
    isActionInProgress: select(_state_store__WEBPACK_IMPORTED_MODULE_10__.STORE_ID).getIsActionInProgress()
  };
}), (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.withDispatch)(dispatch => {
  return {
    setIsActionInProgress: dispatch(_state_store__WEBPACK_IMPORTED_MODULE_10__.STORE_ID).setIsActionInProgress
  };
})])(SafeMode));

/***/ }),

/***/ "../../js-packages/idc/state/actions.jsx":
/*!***********************************************!*\
  !*** ../../js-packages/idc/state/actions.jsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SET_IS_ACTION_IN_PROGRESS": function() { return /* binding */ SET_IS_ACTION_IN_PROGRESS; },
/* harmony export */   "default": function() { return /* binding */ actions; }
/* harmony export */ });
const SET_IS_ACTION_IN_PROGRESS = 'SET_IS_ACTION_IN_PROGRESS';
const actions = {
  setIsActionInProgress: isInProgress => {
    return {
      type: SET_IS_ACTION_IN_PROGRESS,
      isInProgress
    };
  }
};


/***/ }),

/***/ "../../js-packages/idc/state/reducers.jsx":
/*!************************************************!*\
  !*** ../../js-packages/idc/state/reducers.jsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./actions */ "../../js-packages/idc/state/actions.jsx");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */



const isActionInProgress = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case _actions__WEBPACK_IMPORTED_MODULE_1__.SET_IS_ACTION_IN_PROGRESS:
      return action.isInProgress;
  }

  return state;
};

const reducers = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.combineReducers)({
  isActionInProgress
});
/* harmony default export */ __webpack_exports__["default"] = (reducers);

/***/ }),

/***/ "../../js-packages/idc/state/selectors.jsx":
/*!*************************************************!*\
  !*** ../../js-packages/idc/state/selectors.jsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const selectors = {
  getIsActionInProgress: state => state.isActionInProgress | {}
};
/* harmony default export */ __webpack_exports__["default"] = (selectors);

/***/ }),

/***/ "../../js-packages/idc/state/store-holder.jsx":
/*!****************************************************!*\
  !*** ../../js-packages/idc/state/store-holder.jsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/defineProperty.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/defineProperty.js");
/* harmony import */ var _home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);


/**
 * External dependencies
 */


class storeHolder {
  static mayBeInit(storeId, storeConfig) {
    if (null === storeHolder.store) {
      storeHolder.store = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.createReduxStore)(storeId, storeConfig);
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.register)(storeHolder.store);
    }
  }

}

_home_runner_work_jetpack_jetpack_node_modules_pnpm_babel_runtime_7_16_3_node_modules_babel_runtime_helpers_defineProperty_js__WEBPACK_IMPORTED_MODULE_0___default()(storeHolder, "store", null);

/* harmony default export */ __webpack_exports__["default"] = (storeHolder);

/***/ }),

/***/ "../../js-packages/idc/state/store.jsx":
/*!*********************************************!*\
  !*** ../../js-packages/idc/state/store.jsx ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STORE_ID": function() { return /* binding */ STORE_ID; }
/* harmony export */ });
/* harmony import */ var _reducers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reducers */ "../../js-packages/idc/state/reducers.jsx");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./actions */ "../../js-packages/idc/state/actions.jsx");
/* harmony import */ var _selectors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./selectors */ "../../js-packages/idc/state/selectors.jsx");
/* harmony import */ var _store_holder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./store-holder */ "../../js-packages/idc/state/store-holder.jsx");
/**
 * Internal dependencies
 */




const STORE_ID = 'jetpack-idc';
_store_holder__WEBPACK_IMPORTED_MODULE_0__["default"].mayBeInit(STORE_ID, {
  reducer: _reducers__WEBPACK_IMPORTED_MODULE_1__["default"],
  actions: _actions__WEBPACK_IMPORTED_MODULE_2__["default"],
  selectors: _selectors__WEBPACK_IMPORTED_MODULE_3__["default"]
});


/***/ }),

/***/ "../../js-packages/idc/tools/extract-hostname.jsx":
/*!********************************************************!*\
  !*** ../../js-packages/idc/tools/extract-hostname.jsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * Extract hostname from an URL if needed.
 *
 * @param {string} url - The URL to extract hostname from.
 * @returns {string} The hostname extracted from the URL.
 */
const extractHostname = url => /^https?:\/\//.test(url) ? new URL(url).hostname : url.replace(/\/$/, '');

/* harmony default export */ __webpack_exports__["default"] = (extractHostname);

/***/ }),

/***/ "./_inc/components/admin/index.jsx":
/*!*****************************************!*\
  !*** ./_inc/components/admin/index.jsx ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @automattic/jetpack-api */ "../../js-packages/api/index.jsx");
/* harmony import */ var _automattic_jetpack_connection__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @automattic/jetpack-connection */ "../../js-packages/connection/components/connection-status-card/index.jsx");
/* harmony import */ var _automattic_jetpack_connection__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @automattic/jetpack-connection */ "../../js-packages/connection/components/connect-screen/required-plan/index.jsx");
/* harmony import */ var _automattic_jetpack_connection__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @automattic/jetpack-connection */ "../../js-packages/connection/state/store.jsx");
/* harmony import */ var _automattic_jetpack_idc__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @automattic/jetpack-idc */ "../../js-packages/idc/components/idc-screen/index.jsx");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../store */ "./_inc/store.js");
/* harmony import */ var _header__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../header */ "./_inc/components/header/index.jsx");
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.scss */ "./_inc/components/admin/style.scss");
/**
 * External dependencies
 */



const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__;



/**
 * Internal dependencies
 */




/**
 * The Connection IU Admin App.
 *
 * @param {object} props - The properties.
 * @param {object} props.connectionStatus - The connection status object.
 * @returns {object} The Admin component.
 */

const Admin = props => {
  const APINonce = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_store__WEBPACK_IMPORTED_MODULE_4__.STORE_ID).getAPINonce(), []);
  const APIRoot = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_store__WEBPACK_IMPORTED_MODULE_4__.STORE_ID).getAPIRoot(), []);
  const registrationNonce = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_store__WEBPACK_IMPORTED_MODULE_4__.STORE_ID).getRegistrationNonce(), []);
  const IDCData = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_store__WEBPACK_IMPORTED_MODULE_4__.STORE_ID).getIDCData(), []);
  const {
    connectionStatus
  } = props;
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_3__["default"].setApiRoot(APIRoot);
    _automattic_jetpack_api__WEBPACK_IMPORTED_MODULE_3__["default"].setApiNonce(APINonce);
  }, [APIRoot, APINonce]);

  if (IDCData.hasIDC) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_idc__WEBPACK_IMPORTED_MODULE_7__["default"], {
      wpcomHomeUrl: IDCData.wpcomHomeUrl,
      currentUrl: IDCData.currentUrl,
      apiRoot: APIRoot,
      apiNonce: APINonce,
      redirectUri: IDCData.redirectUri
    });
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_header__WEBPACK_IMPORTED_MODULE_5__["default"], null), connectionStatus.isRegistered && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_connection__WEBPACK_IMPORTED_MODULE_8__["default"], {
    isRegistered: connectionStatus.isRegistered,
    isUserConnected: connectionStatus.isUserConnected,
    apiRoot: APIRoot,
    apiNonce: APINonce,
    redirectUri: "tools.php?page=wpcom-connection-manager"
  }), !connectionStatus.isRegistered && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_automattic_jetpack_connection__WEBPACK_IMPORTED_MODULE_9__["default"], {
    connectionStatus: connectionStatus,
    apiRoot: APIRoot,
    apiNonce: APINonce,
    registrationNonce: registrationNonce,
    from: "connection-ui",
    redirectUri: "tools.php?page=wpcom-connection-manager",
    pricingIcon: "data:image/svg+xml,%3Csvg width='32' height='32' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath fill-rule='evenodd' clip-rule='evenodd' d='m21.092 15.164.019-1.703v-.039c0-1.975-1.803-3.866-4.4-3.866-2.17 0-3.828 1.351-4.274 2.943l-.426 1.524-1.581-.065a2.92 2.92 0 0 0-.12-.002c-1.586 0-2.977 1.344-2.977 3.133 0 1.787 1.388 3.13 2.973 3.133H22.399c1.194 0 2.267-1.016 2.267-2.4 0-1.235-.865-2.19-1.897-2.368l-1.677-.29Zm-10.58-3.204a4.944 4.944 0 0 0-.201-.004c-2.75 0-4.978 2.298-4.978 5.133s2.229 5.133 4.978 5.133h12.088c2.357 0 4.267-1.97 4.267-4.4 0-2.18-1.538-3.99-3.556-4.339v-.06c0-3.24-2.865-5.867-6.4-5.867-2.983 0-5.49 1.871-6.199 4.404Z' fill='%23000'/%3E%3C/svg%3E",
    priceBefore: 9,
    priceAfter: 4.5,
    pricingTitle: __('Jetpack Backup', 'jetpack'),
    buttonLabel: __('Get Jetpack Backup', 'jetpack')
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, __("Secure and speed up your site for free with Jetpack's powerful WordPress tools.", 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, __('Measure your impact with beautiful stats', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, __('Speed up your site with optimized images', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, __('Protect your site against bot attacks', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, __('Get notifications if your site goes offline', 'jetpack')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, __('Enhance your site with dozens of other features', 'jetpack')))));
};

/* harmony default export */ __webpack_exports__["default"] = ((0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.withSelect)(select => {
  return {
    connectionStatus: select(_automattic_jetpack_connection__WEBPACK_IMPORTED_MODULE_10__.STORE_ID).getConnectionStatus()
  };
})(Admin));

/***/ }),

/***/ "./_inc/components/header/index.jsx":
/*!******************************************!*\
  !*** ./_inc/components/header/index.jsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./_inc/components/header/style.scss");
/**
 * External dependencies
 */


/**
 * Internal dependencies
 */

const __ = _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__;

/**
 * The Connection UI header.
 *
 * @returns {object} The header component.
 */

const Header = () => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "jetpack-cui__header"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", null, __('Connection Manager', 'jetpack')));
};

/* harmony default export */ __webpack_exports__["default"] = (Header);

/***/ }),

/***/ "./_inc/reducers/api.js":
/*!******************************!*\
  !*** ./_inc/reducers/api.js ***!
  \******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const API = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return state;
};

/* harmony default export */ __webpack_exports__["default"] = (API);

/***/ }),

/***/ "./_inc/reducers/assets.js":
/*!*********************************!*\
  !*** ./_inc/reducers/assets.js ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const assets = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return state;
};

/* harmony default export */ __webpack_exports__["default"] = (assets);

/***/ }),

/***/ "./_inc/reducers/idc.js":
/*!******************************!*\
  !*** ./_inc/reducers/idc.js ***!
  \******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const IDC = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return state;
};

/* harmony default export */ __webpack_exports__["default"] = (IDC);

/***/ }),

/***/ "./_inc/reducers/index.js":
/*!********************************!*\
  !*** ./_inc/reducers/index.js ***!
  \********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./api */ "./_inc/reducers/api.js");
/* harmony import */ var _assets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./assets */ "./_inc/reducers/assets.js");
/* harmony import */ var _idc__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./idc */ "./_inc/reducers/idc.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */




const reducer = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.combineReducers)({
  API: _api__WEBPACK_IMPORTED_MODULE_1__["default"],
  assets: _assets__WEBPACK_IMPORTED_MODULE_2__["default"],
  IDC: _idc__WEBPACK_IMPORTED_MODULE_3__["default"]
});
/* harmony default export */ __webpack_exports__["default"] = (reducer);

/***/ }),

/***/ "./_inc/selectors/api.js":
/*!*******************************!*\
  !*** ./_inc/selectors/api.js ***!
  \*******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const APISelectors = {
  getAPIRoot: state => state.API.WP_API_root || null,
  getAPINonce: state => state.API.WP_API_nonce || null,
  getRegistrationNonce: state => state.API.registrationNonce || null
};
/* harmony default export */ __webpack_exports__["default"] = (APISelectors);

/***/ }),

/***/ "./_inc/selectors/assets.js":
/*!**********************************!*\
  !*** ./_inc/selectors/assets.js ***!
  \**********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const assetsSelectors = {
  getAssetBuildUrl: state => state.assets.buildUrl || null
};
/* harmony default export */ __webpack_exports__["default"] = (assetsSelectors);

/***/ }),

/***/ "./_inc/selectors/idc.js":
/*!*******************************!*\
  !*** ./_inc/selectors/idc.js ***!
  \*******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const IDC = {
  getIDCData: state => state.IDC || {}
};
/* harmony default export */ __webpack_exports__["default"] = (IDC);

/***/ }),

/***/ "./_inc/selectors/index.js":
/*!*********************************!*\
  !*** ./_inc/selectors/index.js ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./api */ "./_inc/selectors/api.js");
/* harmony import */ var _assets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./assets */ "./_inc/selectors/assets.js");
/* harmony import */ var _idc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./idc */ "./_inc/selectors/idc.js");
/**
 * Internal dependencies
 */



const selectors = { ..._api__WEBPACK_IMPORTED_MODULE_0__["default"],
  ..._assets__WEBPACK_IMPORTED_MODULE_1__["default"],
  ..._idc__WEBPACK_IMPORTED_MODULE_2__["default"]
};
/* harmony default export */ __webpack_exports__["default"] = (selectors);

/***/ }),

/***/ "./_inc/store.js":
/*!***********************!*\
  !*** ./_inc/store.js ***!
  \***********************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STORE_ID": function() { return /* binding */ STORE_ID; },
/* harmony export */   "storeConfig": function() { return /* binding */ storeConfig; }
/* harmony export */ });
/* harmony import */ var _reducers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reducers */ "./_inc/reducers/index.js");
/* harmony import */ var _selectors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./selectors */ "./_inc/selectors/index.js");
/**
 * Internal dependencies
 */


const STORE_ID = 'jetpack-connection-ui';
const storeConfig = {
  reducer: _reducers__WEBPACK_IMPORTED_MODULE_0__["default"],
  selectors: _selectors__WEBPACK_IMPORTED_MODULE_1__["default"],
  initialState: window.CUI_INITIAL_STATE || {}
};

/***/ }),

/***/ "../../../node_modules/.pnpm/use-subscription@1.5.1_react@16.14.0/node_modules/use-subscription/cjs/use-subscription.development.js":
/*!******************************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/use-subscription@1.5.1_react@16.14.0/node_modules/use-subscription/cjs/use-subscription.development.js ***!
  \******************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
/** @license React vundefined
 * use-subscription.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



if (true) {
  (function() {
'use strict';

var _assign = __webpack_require__(/*! object-assign */ "../../../node_modules/.pnpm/object-assign@4.1.1/node_modules/object-assign/index.js");
var react = __webpack_require__(/*! react */ "react");

//
// In order to avoid removing and re-adding subscriptions each time this hook is called,
// the parameters passed to this hook should be memoized in some way–
// either by wrapping the entire params object with useMemo()
// or by wrapping the individual callbacks with useCallback().

function useSubscription(_ref) {
  var getCurrentValue = _ref.getCurrentValue,
      subscribe = _ref.subscribe;

  // Read the current value from our subscription.
  // When this value changes, we'll schedule an update with React.
  // It's important to also store the hook params so that we can check for staleness.
  // (See the comment in checkForUpdates() below for more info.)
  var _useState = react.useState(function () {
    return {
      getCurrentValue: getCurrentValue,
      subscribe: subscribe,
      value: getCurrentValue()
    };
  }),
      state = _useState[0],
      setState = _useState[1];

  var valueToReturn = state.value; // If parameters have changed since our last render, schedule an update with its current value.

  if (state.getCurrentValue !== getCurrentValue || state.subscribe !== subscribe) {
    // If the subscription has been updated, we'll schedule another update with React.
    // React will process this update immediately, so the old subscription value won't be committed.
    // It is still nice to avoid returning a mismatched value though, so let's override the return value.
    valueToReturn = getCurrentValue();
    setState({
      getCurrentValue: getCurrentValue,
      subscribe: subscribe,
      value: valueToReturn
    });
  } // Display the current value for this hook in React DevTools.


  react.useDebugValue(valueToReturn); // It is important not to subscribe while rendering because this can lead to memory leaks.
  // (Learn more at reactjs.org/docs/strict-mode.html#detecting-unexpected-side-effects)
  // Instead, we wait until the commit phase to attach our handler.
  //
  // We intentionally use a passive effect (useEffect) rather than a synchronous one (useLayoutEffect)
  // so that we don't stretch the commit phase.
  // This also has an added benefit when multiple components are subscribed to the same source:
  // It allows each of the event handlers to safely schedule work without potentially removing an another handler.
  // (Learn more at https://codesandbox.io/s/k0yvr5970o)

  react.useEffect(function () {
    var didUnsubscribe = false;

    var checkForUpdates = function () {
      // It's possible that this callback will be invoked even after being unsubscribed,
      // if it's removed as a result of a subscription event/update.
      // In this case, React will log a DEV warning about an update from an unmounted component.
      // We can avoid triggering that warning with this check.
      if (didUnsubscribe) {
        return;
      } // We use a state updater function to avoid scheduling work for a stale source.
      // However it's important to eagerly read the currently value,
      // so that all scheduled work shares the same value (in the event of multiple subscriptions).
      // This avoids visual "tearing" when a mutation happens during a (concurrent) render.


      var value = getCurrentValue();
      setState(function (prevState) {
        // Ignore values from stale sources!
        // Since we subscribe an unsubscribe in a passive effect,
        // it's possible that this callback will be invoked for a stale (previous) subscription.
        // This check avoids scheduling an update for that stale subscription.
        if (prevState.getCurrentValue !== getCurrentValue || prevState.subscribe !== subscribe) {
          return prevState;
        } // Some subscriptions will auto-invoke the handler, even if the value hasn't changed.
        // If the value hasn't changed, no update is needed.
        // Return state as-is so React can bail out and avoid an unnecessary render.


        if (prevState.value === value) {
          return prevState;
        }

        return _assign({}, prevState, {
          value: value
        });
      });
    };

    var unsubscribe = subscribe(checkForUpdates); // Because we're subscribing in a passive effect,
    // it's possible that an update has occurred between render and our effect handler.
    // Check for this and schedule an update if work has occurred.

    checkForUpdates();
    return function () {
      didUnsubscribe = true;
      unsubscribe();
    };
  }, [getCurrentValue, subscribe]); // Return the current value for our caller to use while rendering.

  return valueToReturn;
}

exports.useSubscription = useSubscription;
  })();
}


/***/ }),

/***/ "../../../node_modules/.pnpm/use-subscription@1.5.1_react@16.14.0/node_modules/use-subscription/index.js":
/*!***************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/use-subscription@1.5.1_react@16.14.0/node_modules/use-subscription/index.js ***!
  \***************************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


if (false) {} else {
  module.exports = __webpack_require__(/*! ./cjs/use-subscription.development.js */ "../../../node_modules/.pnpm/use-subscription@1.5.1_react@16.14.0/node_modules/use-subscription/cjs/use-subscription.development.js");
}


/***/ }),

/***/ "../../js-packages/connection/components/disconnect-dialog/images/disconnect-confirm.jpg":
/*!***********************************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-dialog/images/disconnect-confirm.jpg ***!
  \***********************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
module.exports = __webpack_require__.p + "images/disconnect-confirm-dc9fe8f5c68cfd1320e0.jpg";

/***/ }),

/***/ "../../js-packages/connection/components/disconnect-dialog/images/disconnect-thanks.jpg":
/*!**********************************************************************************************!*\
  !*** ../../js-packages/connection/components/disconnect-dialog/images/disconnect-thanks.jpg ***!
  \**********************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
module.exports = __webpack_require__.p + "images/disconnect-thanks-5873bfac56a9bd7322cd.jpg";

/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ (function(module) {

"use strict";
module.exports = window["React"];

/***/ }),

/***/ "react-dom":
/*!***************************!*\
  !*** external "ReactDOM" ***!
  \***************************/
/***/ (function(module) {

"use strict";
module.exports = window["ReactDOM"];

/***/ }),

/***/ "lodash":
/*!*************************!*\
  !*** external "lodash" ***!
  \*************************/
/***/ (function(module) {

"use strict";
module.exports = window["lodash"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/compose":
/*!*********************************!*\
  !*** external ["wp","compose"] ***!
  \*********************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["compose"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "@wordpress/url":
/*!*****************************!*\
  !*** external ["wp","url"] ***!
  \*****************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["url"];

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js":
/*!*********************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js ***!
  \*********************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _arrayLikeToArray; }
/* harmony export */ });
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) {
    arr2[i] = arr[i];
  }

  return arr2;
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/arrayWithHoles.js":
/*!*******************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/arrayWithHoles.js ***!
  \*******************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _arrayWithHoles; }
/* harmony export */ });
function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/arrayWithoutHoles.js":
/*!**********************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/arrayWithoutHoles.js ***!
  \**********************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _arrayWithoutHoles; }
/* harmony export */ });
/* harmony import */ var _arrayLikeToArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrayLikeToArray.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js");

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return (0,_arrayLikeToArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(arr);
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js":
/*!**************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js ***!
  \**************************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _assertThisInitialized; }
/* harmony export */ });
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/classCallCheck.js":
/*!*******************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/classCallCheck.js ***!
  \*******************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _classCallCheck; }
/* harmony export */ });
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/createClass.js":
/*!****************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/createClass.js ***!
  \****************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _createClass; }
/* harmony export */ });
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/defineProperty.js":
/*!*******************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/defineProperty.js ***!
  \*******************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _defineProperty; }
/* harmony export */ });
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/extends.js":
/*!************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/extends.js ***!
  \************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _extends; }
/* harmony export */ });
function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js":
/*!*******************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js ***!
  \*******************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _getPrototypeOf; }
/* harmony export */ });
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/inherits.js":
/*!*************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/inherits.js ***!
  \*************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _inherits; }
/* harmony export */ });
/* harmony import */ var _setPrototypeOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./setPrototypeOf.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js");

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) (0,_setPrototypeOf_js__WEBPACK_IMPORTED_MODULE_0__["default"])(subClass, superClass);
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/iterableToArray.js":
/*!********************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/iterableToArray.js ***!
  \********************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _iterableToArray; }
/* harmony export */ });
function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/iterableToArrayLimit.js":
/*!*************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/iterableToArrayLimit.js ***!
  \*************************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _iterableToArrayLimit; }
/* harmony export */ });
function _iterableToArrayLimit(arr, i) {
  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];

  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;

  var _s, _e;

  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/nonIterableRest.js":
/*!********************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/nonIterableRest.js ***!
  \********************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _nonIterableRest; }
/* harmony export */ });
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/nonIterableSpread.js":
/*!**********************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/nonIterableSpread.js ***!
  \**********************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _nonIterableSpread; }
/* harmony export */ });
function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/objectSpread.js":
/*!*****************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/objectSpread.js ***!
  \*****************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _objectSpread; }
/* harmony export */ });
/* harmony import */ var _defineProperty_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./defineProperty.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/defineProperty.js");

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? Object(arguments[i]) : {};
    var ownKeys = Object.keys(source);

    if (typeof Object.getOwnPropertySymbols === 'function') {
      ownKeys.push.apply(ownKeys, Object.getOwnPropertySymbols(source).filter(function (sym) {
        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
      }));
    }

    ownKeys.forEach(function (key) {
      (0,_defineProperty_js__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]);
    });
  }

  return target;
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/objectSpread2.js":
/*!******************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/objectSpread2.js ***!
  \******************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _objectSpread2; }
/* harmony export */ });
/* harmony import */ var _defineProperty_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./defineProperty.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/defineProperty.js");


function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);

  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);

    if (enumerableOnly) {
      symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
    }

    keys.push.apply(keys, symbols);
  }

  return keys;
}

function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};

    if (i % 2) {
      ownKeys(Object(source), true).forEach(function (key) {
        (0,_defineProperty_js__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
  }

  return target;
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/possibleConstructorReturn.js":
/*!******************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/possibleConstructorReturn.js ***!
  \******************************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _possibleConstructorReturn; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _assertThisInitialized_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./assertThisInitialized.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js");


function _possibleConstructorReturn(self, call) {
  if (call && ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(call) === "object" || typeof call === "function")) {
    return call;
  } else if (call !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }

  return (0,_assertThisInitialized_js__WEBPACK_IMPORTED_MODULE_1__["default"])(self);
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js":
/*!*******************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js ***!
  \*******************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _setPrototypeOf; }
/* harmony export */ });
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/slicedToArray.js":
/*!******************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/slicedToArray.js ***!
  \******************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _slicedToArray; }
/* harmony export */ });
/* harmony import */ var _arrayWithHoles_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrayWithHoles.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/arrayWithHoles.js");
/* harmony import */ var _iterableToArrayLimit_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./iterableToArrayLimit.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/iterableToArrayLimit.js");
/* harmony import */ var _unsupportedIterableToArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./unsupportedIterableToArray.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js");
/* harmony import */ var _nonIterableRest_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./nonIterableRest.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/nonIterableRest.js");




function _slicedToArray(arr, i) {
  return (0,_arrayWithHoles_js__WEBPACK_IMPORTED_MODULE_0__["default"])(arr) || (0,_iterableToArrayLimit_js__WEBPACK_IMPORTED_MODULE_1__["default"])(arr, i) || (0,_unsupportedIterableToArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(arr, i) || (0,_nonIterableRest_js__WEBPACK_IMPORTED_MODULE_3__["default"])();
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/toConsumableArray.js":
/*!**********************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/toConsumableArray.js ***!
  \**********************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _toConsumableArray; }
/* harmony export */ });
/* harmony import */ var _arrayWithoutHoles_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrayWithoutHoles.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/arrayWithoutHoles.js");
/* harmony import */ var _iterableToArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./iterableToArray.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/iterableToArray.js");
/* harmony import */ var _unsupportedIterableToArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./unsupportedIterableToArray.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js");
/* harmony import */ var _nonIterableSpread_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./nonIterableSpread.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/nonIterableSpread.js");




function _toConsumableArray(arr) {
  return (0,_arrayWithoutHoles_js__WEBPACK_IMPORTED_MODULE_0__["default"])(arr) || (0,_iterableToArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(arr) || (0,_unsupportedIterableToArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(arr) || (0,_nonIterableSpread_js__WEBPACK_IMPORTED_MODULE_3__["default"])();
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/typeof.js":
/*!***********************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/typeof.js ***!
  \***********************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _typeof; }
/* harmony export */ });
function _typeof(obj) {
  "@babel/helpers - typeof";

  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof(obj) {
      return typeof obj;
    };
  } else {
    _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

/***/ }),

/***/ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js":
/*!*******************************************************************************************************************************!*\
  !*** ../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js ***!
  \*******************************************************************************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ _unsupportedIterableToArray; }
/* harmony export */ });
/* harmony import */ var _arrayLikeToArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrayLikeToArray.js */ "../../../node_modules/.pnpm/@babel+runtime@7.16.3/node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js");

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return (0,_arrayLikeToArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return (0,_arrayLikeToArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(o, minLen);
}

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	!function() {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	!function() {
/******/ 		var scriptUrl;
/******/ 		if (__webpack_require__.g.importScripts) scriptUrl = __webpack_require__.g.location + "";
/******/ 		var document = __webpack_require__.g.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript)
/******/ 				scriptUrl = document.currentScript.src
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) scriptUrl = scripts[scripts.length - 1].src
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl;
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
!function() {
"use strict";
/*!************************!*\
  !*** ./_inc/admin.jsx ***!
  \************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_admin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/admin */ "./_inc/components/admin/index.jsx");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./store */ "./_inc/store.js");
/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



const store = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.createReduxStore)(_store__WEBPACK_IMPORTED_MODULE_4__.STORE_ID, _store__WEBPACK_IMPORTED_MODULE_4__.storeConfig);
(0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.register)(store);
/**
 * The initial renderer function.
 */

function render() {
  const container = document.getElementById('jetpack-connection-ui-container');

  if (null === container) {
    return;
  }

  react_dom__WEBPACK_IMPORTED_MODULE_0___default().render( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_admin__WEBPACK_IMPORTED_MODULE_3__["default"], null), container);
}

render();
}();
/******/ })()
;
//# sourceMappingURL=index.js.map