<?php

if ( ! function_exists( 'corretto_core_map_testimonials_meta' ) ) {
	function corretto_core_map_testimonials_meta() {
		$testimonial_meta_box = corretto_elated_create_meta_box(
			array(
				'scope' => array( 'testimonials' ),
				'title' => esc_html__( 'Testimonial', 'corretto-core' ),
				'name'  => 'testimonial_meta'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_testimonial_title',
				'type'        => 'text',
				'label'       => esc_html__( 'Title', 'corretto-core' ),
				'description' => esc_html__( 'Enter testimonial title', 'corretto-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_testimonial_text',
				'type'        => 'text',
				'label'       => esc_html__( 'Text', 'corretto-core' ),
				'description' => esc_html__( 'Enter testimonial text', 'corretto-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_testimonial_author',
				'type'        => 'text',
				'label'       => esc_html__( 'Author', 'corretto-core' ),
				'description' => esc_html__( 'Enter author name', 'corretto-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_testimonial_author_position',
				'type'        => 'text',
				'label'       => esc_html__( 'Author Position', 'corretto-core' ),
				'description' => esc_html__( 'Enter author job position', 'corretto-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_core_map_testimonials_meta', 95 );
}