<?php

if( !function_exists('corretto_elated_get_blog_holder_params') ) {
    /**
     * Function that generates params for holders on blog templates
     */
    function corretto_elated_get_blog_holder_params($params) {
        $params_list = array();

        $params_list['holder'] = 'eltdf-container';
        $params_list['inner'] = 'eltdf-container-inner clearfix';

        return $params_list;
    }

    add_filter( 'corretto_elated_blog_holder_params', 'corretto_elated_get_blog_holder_params' );
}

if( !function_exists('corretto_elated_get_blog_single_holder_classes') ) {
    /**
     * Function that generates blog holder classes for single blog page
     */
    function corretto_elated_get_blog_single_holder_classes($classes) {
        $sidebar_classes   = array();
        $sidebar_classes[] = 'eltdf-grid-large-gutter';
	
	    $classes = $classes . ' ' . implode(' ', $sidebar_classes);
	    
        return $classes;
    }

    add_filter( 'corretto_elated_blog_single_holder_classes', 'corretto_elated_get_blog_single_holder_classes' );
}

if( !function_exists('corretto_elated_blog_part_params') ) {
    function corretto_elated_blog_part_params($params) {

        $part_params = array();
        $part_params['title_tag'] = 'h3';
        $part_params['link_tag'] = 'h5';
        $part_params['quote_tag'] = 'h5';

        return array_merge($params, $part_params);
    }

    add_filter( 'corretto_elated_blog_part_params', 'corretto_elated_blog_part_params' );
}