<?php

if ( ! function_exists( 'corretto_elated_sidebar_options_map' ) ) {
	function corretto_elated_sidebar_options_map() {
		
		corretto_elated_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'corretto' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = corretto_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'corretto' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		corretto_elated_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'corretto' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'corretto' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => corretto_elated_get_custom_sidebars_options()
		) );
		
		$corretto_custom_sidebars = corretto_elated_get_custom_sidebars();
		if ( count( $corretto_custom_sidebars ) > 0 ) {
			corretto_elated_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'corretto' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'corretto' ),
				'parent'      => $sidebar_panel,
				'options'     => $corretto_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'corretto_elated_options_map', 'corretto_elated_sidebar_options_map', 9 );
}