<?php

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Eltdf_Clients_Boxes extends WPBakeryShortCodesContainer {}
}

if(!function_exists('corretto_core_add_clients_boxes_shortcodes')) {
	function corretto_core_add_clients_boxes_shortcodes($shortcodes_class_name) {
		$shortcodes = array(
			'CorrettoCore\CPT\Shortcodes\ClientsBoxes\ClientsBoxes',
			'CorrettoCore\CPT\Shortcodes\ClientsBoxes\ClientsBoxesItem'
		);
		
		$shortcodes_class_name = array_merge($shortcodes_class_name, $shortcodes);
		
		return $shortcodes_class_name;
	}
	
	add_filter('corretto_core_filter_add_vc_shortcode', 'corretto_core_add_clients_boxes_shortcodes');
}

if( !function_exists('corretto_core_set_clients_boxes_custom_style_for_vc_shortcodes') ) {
	/**
	 * Function that set custom css style for clients boxes shortcode
	 */
	function corretto_core_set_clients_boxes_custom_style_for_vc_shortcodes($style) {
		$current_style = '.wpb_content_element.wpb_corretto_clients_boxes_item > .wpb_element_wrapper { 
			background-color: #f4f4f4; 
		}';

		$style = $style . $current_style;

		return $style;
	}

	add_filter('corretto_core_filter_add_vc_shortcodes_custom_style', 'corretto_core_set_clients_boxes_custom_style_for_vc_shortcodes');
}

if( !function_exists('corretto_core_set_clients_boxes_icon_class_name_for_vc_shortcodes') ) {
	/**
	 * Function that set custom icon class name for clients shortcode boxes to set our icon for Visual Composer shortcodes panel
	 */
	function corretto_core_set_clients_boxes_icon_class_name_for_vc_shortcodes($shortcodes_icon_class_array) {
		$shortcodes_icon_class_array[] = '.icon-wpb-clients-boxes';
		$shortcodes_icon_class_array[] = '.icon-wpb-clients-boxes-item';

		return $shortcodes_icon_class_array;
	}

	add_filter('corretto_core_filter_add_vc_shortcodes_custom_icon_class', 'corretto_core_set_clients_boxes_icon_class_name_for_vc_shortcodes');
}